/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2400 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      Core Component Infrastructure - Dynamic Property Table management
 *
 * = FILENAME
 *      ix_cc_ipv4_prop.h
 *
 * = DESCRIPTION
 *      This file defines all data types and function prototypes required by the 
 *      IPv4 dynamic property table management module.
 *
 * = AUTHOR
 *       Govindan Nair
 *       govindan.nair@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      07/10/2002 5:30 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: ix_cc_ipv4_prop.h,v 1.3 2002/09/18 17:32:21 lbmiller Exp $
 */

#if !defined(__IX_CC_IPV4_PROP_H__)
#define __IX_CC_IPV4_PROP_H__


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */





/**
 * NAME: _ix_cc_ipv4_prop_get_port_ip_address
 *
 * DESCRIPTION: This primitive will be used to get IP address of a port
 *           .
 * 
 * @Param:  - IN arg_BladeId - blade number of ip address to be retrieved
 * @Param:  - IN arg_PortId - port number of ip address to be retrieved
 *
 * @Param:  - OUT arg_pIpAddress - IP address of given blade and port
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_INVALID_INPUT_PARAM - invalid blade/port number
 * IX_CC_ERROR_ENTRY_NOT_FOUND - no data in location
 */
ix_error _ix_cc_ipv4_get_port_ip_address(
                                        ix_uint16 arg_BladeId,
                                        ix_uint16 arg_PortId, 
                                        ix_uint32 *arg_pIpAddr
                                       );


/**
 * NAME: _ix_cc_ipv4_prop_get_port_status
 *
 * DESCRIPTION: This primitive will be used to get status of local port
 *           .
 * 
 * @Param:  - IN arg_PortId - port number of status to be retrieved
 *
 * @Param:  - OUT arg_pPortStatus - status value of given port
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_INVALID_INPUT_PARAM - invalid port number
 * 
 */
ix_error _ix_cc_ipv4_get_port_status(
                                    ix_uint16 arg_PortId, 
                                    ix_uint32* arg_pPortStatus
                                   );


/**
 * NAME: _ix_cc_ipv4_property_update_port_status
 *
 * DESCRIPTION: This primitive will be used to set status of local port
 *           .
 * 
 * @Param:  - IN arg_PortId - port number 
 *
 * @Param:  - OUT arg_pPortStatus - status value of given port
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_INVALID_INPUT_PARAM - invalid port number
 * 
 */

ix_error _ix_cc_ipv4_property_update_port_status(
                                    ix_uint16 arg_PortId, 
                                    ix_uint32 arg_PortStatus
                                   );



/**
 * NAME: _ix_cc_ipv4_property_update_ip_address
 *
 * DESCRIPTION: This primitive will be used to add/delete ip address and net mask in
 * dynamic property table and directed broadcast table
 *           .
 * 
 * @Param:  - IN arg_PropId - property id : add/delete ip address
 * @Param:  - IN arg_BladeId - blade number
 * @Param:  - IN arg_PordId - port number
 * @Param:  - IN arg_IpAddr - ip address of port
 * @Param:  - IN arg_SubnetMask - sunnet mask of port
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_INVALID_INPUT_PARAM - invalid blade/port number 
 * 
 */
ix_error _ix_cc_ipv4_property_update_ip_address(
                                               ix_uint16 arg_PropId,
                                               ix_uint16 arg_BladeId,
                                               ix_uint16 arg_PortId,
                                               ix_uint32 arg_IpAddr,
                                               ix_uint32 arg_SubnetMask
                                              );


/**
 * NAME: _ix_cc_ipv4_prop_table_lookup_ip_address
 *
 * DESCRIPTION: This primitive will be used to lookup ip address
 * in dynamic property table
 *           
 * @Param:  - IN arg_IpAddr - ip address(non zero) to be searched in table.
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_ENTRY_NOT_FOUND - no entry in table 
 * 
 */

ix_error _ix_cc_ipv4_prop_table_lookup_ip_address(ix_uint32 arg_IpAddr);


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_IPV4_PROP_H__) */
