/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2400 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      Core Component Infrastructure - Dynamic Property Table management
 *
 * = FILENAME
 *      ix_cc_ipv4_dbcast.h
 *
 * = DESCRIPTION
 *      This file defines all data types and function prototypes required by the 
 *      IPv4 source directed broadcast table management module.
 *
 * = AUTHOR
 *       Govindan Nair
 *       govindan.nair@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      07/22/2002 5:30 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: ix_cc_ipv4_dbcast.h,v 1.2 2002/09/18 17:32:21 lbmiller Exp $
 */

#if !defined(__IX_CC_IPV4_DBCAST_H__)
#define __IX_CC_IPV4_DBCAST_H__


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


#define IX_CC_IPV4_BROADCAST_FAIL 0
#define IX_CC_IPV4_BROADCAST_SUCCESS 1


/**
 * NAME: _ix_cc_ipv4_source_broadcast_store_data_in_bucket
 *
 * DESCRIPTION: This primitive will be used to add source directed broadcst address into table. 
 *           .
 * 
 * @Param:  - IN arg_pBucketAddr: starting address of a block/bucket
 * @Param:  - IN arg_IpAddr: address to be stored in free space
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_FULL - no space in bucket
 */
ix_error _ix_cc_ipv4_source_broadcast_store_data_in_bucket(ix_uint32* arg_pBucketAddr,
                                          ix_uint32 arg_IpAddr);


/**
 * NAME: _ix_cc_ipv4_source_broadcast_store_data_in_new_bucket
 *
 * DESCRIPTION: This primitive will be used to add source directed broadcst address 
 * in a new bucket. 
 *           .
 * @Param:  - IN arg_pBucketAddr: starting address of a block/bucket
 * @Param:  - IN arg_IpAddr: address to be stored in bucket
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * IX_CC_ERROR_FULL - no space in table
 * 
 */
ix_error _ix_cc_ipv4_source_broadcast_store_data_in_new_bucket(ix_uint32 *pAddr,ix_uint32 arg_IpAddr);


/**
 * NAME: _ix_cc_ipv4_source_broadcast_find_entry
 *
 * DESCRIPTION: This primitive will be used to find source directed broadcst address 
 * from table. 
 *           .
 * 
 * @Param:  - IN arg_pBucketAddr - starting address of a bucket
 * @Param:  - IN arg_IpAddr - IP address to find
 *
 * @Param:  - OUT arg_pIpAddrLocation - pointer to location of search result
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_ENTRY_NOT_FOUND - entry not found in table
 */
ix_error _ix_cc_ipv4_source_broadcast_find_entry(ix_uint32* arg_pBucketAddr,
                                ix_uint32 arg_pIpAddr,
                                ix_uint32** arg_pIpAddrLocation);


/**
 * NAME: _ix_cc_ipv4_source_broadcast_get_last_entry
 *
 * DESCRIPTION: This primitive will be used to get last source directed broadcst address
 * from a bucket. 
 * 
 * @Param:  - IN arg_pBucketAddr - starting address of a bucket
 * @Param:  - IN arg_IpAddr - IP address to find
 *
 * @Param:  - OUT arg_pIpAddrLocation - pointer to location of search result
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * IX_CC_ERROR_ENTRY_NOT_FOUND  - entry not found in bucket
 * 
 */


ix_error _ix_cc_ipv4_source_broadcast_get_last_entry(ix_uint32* arg_pBucketAddr,
                                    ix_uint32* arg_pIpAddr,
                                    ix_uint32** arg_pIpAddrLocation);




/**
 * NAME: _ix_cc_ipv4_add_source_broadcast
 *
 * DESCRIPTION: This primitive will be used to add source directed broadcst 
 * address into table. 
 *           .
 * 
 * @Param:  - IN arg_IpAddr - directed broadcast IP address to be added in table
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * IX_CC_ERROR_FULL - no space in bucket
 * 
 */
ix_error _ix_cc_ipv4_add_source_broadcast(ix_uint32 arg_IpAddr);

/**
 * NAME: _ix_cc_ipv4_delete_source_broadcast
 *
 * DESCRIPTION: This primitive will be used to add source directed broadcst address into table. 
 *           .
 * 
 * @Param:  - IN arg_IpAddr - directed broadcast address to be deleted from table
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 *IX_CC_ERROR_ENTRY_NOT_FOUND - entry not found in table 
 */
ix_error _ix_cc_ipv4_delete_source_broadcast(ix_uint32 arg_IpAddr);



/**
 * NAME: _ix_cc_ipv4_lookup_source_broadcast
 *
 * DESCRIPTION: This primitive will be used to lookup source directed broadcst address in table. 
 *           .
 * 
 * @Param:  - IN arg_IpAddr - IP address to be searched in table
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 *IX_CC_ERROR_ENTRY_NOT_FOUND - entry not found in table  
 */
ix_error _ix_cc_ipv4_lookup_source_broadcast(ix_uint32 arg_IpAddr);


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_IPV4_DBCAST_H__) */
