/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor
 *
 *
 *
 * = MODULE
 *      IPv4 Forwarder Core Component 
 *
 * = FILENAME
 *      ipv4_fwdr.h
 *
 * = DESCRIPTION
 *   This file contains the definition of forwarding function -
 *   forwarding packets coming from IPv4 Microblock and other
 *   Core Components and forwarding packets coming from Stk 
 *   Drvr Core Component   
 *
 *
 *      
 *
 * = CREATION TIME
 *      8/11/2002 9:05:42 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: ipv4_fwdr.h,v 1.7 2003/08/13 22:13:03 rranjeet Exp $
 */

#if !defined(__IPV4_FWDR_H__)
#define __IPV4_FWDR_H__
#include "ix_cc_error.h"
#include "utils.h"
#include "ip_options.h"
#include "header_validation.h"
#include "fragmentation_support.h"
#include "ix_cc.h"
#include "bindings.h"

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * Preprocessor symbol and macro definitions.
 */

/**
 * Type definitions.
 */

/**
 * Prototypes for interface functions.
 */



/**
 * NAME: _ix_cc_ipv4_forward
 *
 * DESCRIPTION:This function performs forwarding
 * of packets coming from IPv4 microblock and 
 * Core Components other than Stack Driver Core
 * Component
 * 
 *             
 * 
 * @Param:  - IN - arg_hBuffer - a buffer handle
 *  containing the packet that needs to be 
 *  forwarded  
 *		 
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error 
 *          token for failure.
 */
ix_error _ix_cc_ipv4_forward( ix_buffer_handle arg_hBuffer );


/**
 * NAME: _ix_cc_ipv4_forward_pkts_from_cc
 *
 * DESCRIPTION:This function performs forwarding
 * of packets coming from Core Components other 
 * than Stack Driver Core
 * Component
 * 
 *             
 * 
 * @Param:  - IN - arg_hBuffer - a buffer handle
 *  containing the packet that needs to be 
 *  forwarded  
 *		 
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error 
 *          token for failure.
 */
ix_error _ix_cc_ipv4_forward_pkts_from_cc( ix_buffer_handle arg_hBuffer );



/**
 * NAME: _ix_cc_ipv4_process_options
 *
 * DESCRIPTION:This function performs forwarding
 * of packets for packets with options exceptions
 * coming from IPv4 microblock
 *             
 * 
 * @Param:  - IN - arg_hBuffer - a buffer handle
 *  containing the packet that needs to be 
 *  forwarded  
 *		 
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error 
 *          token for failure.
 */
ix_error _ix_cc_ipv4_process_options( ix_buffer_handle arg_hBuffer );

/**
 * NAME: _ix_cc_ipv4_forward_pkts_from_stkdrvr
 *
 * DESCRIPTION:This function forwards the packets 
 *             received from stack driver
 *             
 *             
 * 
 * @Param:  - IN - arg_hBuffer - a buffer handle containing
 *            the packet that needs to be 
 *            forwarded  
 *		 
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token for failure.
 */
ix_error _ix_cc_ipv4_forward_pkts_from_stkdrvr(ix_buffer_handle arg_hBuffer);



/**
 * Exported variables.
 */


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IPV4_FWDR_H__) */

