/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor
 *
 *
 * = MODULE
 *      IPv4 Core Component
 *
 * = FILENAME
 *      fragmentation_support.h
 *
 * = DESCRIPTION
 *   This file contains definition of fragmentation 
 *   handling routines   
 *
 *
 *
 * = CREATION TIME
 *      8/14/2002 4:53:42 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: fragmentation_support.h,v 1.6 2002/12/13 19:45:03 rjpetri Exp $
 */

#if !defined(__FRAGMENTATION_SUPPORT_H__)
#define __FRAGMENTATION_SUPPORT_H__

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


#include "ix_cc_error.h"
#include "ix_ossl.h"
#include "ix_rm.h"
#include "ix_cc.h"
#include "cc/fragmentation/fragment.h"
#include "bindings.h"
#include "utils.h"
#include "icmp.h"



/**
 * Prototypes for interface functions.
 */

/**
 * NAME: _ix_cc_ipv4_header_get_DF
 *
 * DESCRIPTION: The value of the Don't Fragment(DF) bit in the 
 *              IP Header is passed back through arg_pDFValue.
 *               
 * 
 * @Param:  - IN arg_hBuffer - the buffer handle containing
 *             the packet with IP header 
 *            IN arg_pIpHdr - a pointer to IPv4 header
 * @Param:  - INOUT  - None
 * @Param:  - OUT - arg_pDFvalue - the value of DF bit in 
 *                                 IP header
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *          for failure.
 *          arg_pDFValue should be set accordingly on return
 */

ix_error _ix_cc_ipv4_header_get_DF(ix_buffer_handle arg_hBuffer, 
                                   ix_uint8 *arg_pIpHdr,
                                   ix_uint8 *arg_pDFValue );


/**
 * NAME: _ix_cc_ipv4_pass_packet_fragment
 *
 * DESCRIPTION: This function fragments the packet contained in
 *  buffer, and creates buffers containing fragments of the
 *  original buffer.  
 * _ix_cc_ipv4_pass_packet is then
 * called on each buffer fragment. Assumes that fragmentation 
 * is required (ie., mtu < buf_size).The buffer specified by
 * arg_hBuffer,is not deleted. It must be deleted by the caller.      
 *
 * @Param:  - IN arg_hBuffer -The buffer to forward on
 *            (with perhaps first fragmenting) 
 *            IN arg_pBufData  - A pointer to the beginning
 *                               of the buffer
 *            IN arg_BufLen  - length of the buffer   
 *            IN arg_Mtu  - MTU of the outgoing interface
 *
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *           for failure.
 *          
 */
ix_error _ix_cc_ipv4_pass_packet_fragment(ix_buffer_handle arg_hBuffer, 
					 ix_uint8 *arg_pBufData, 
                                         ix_uint16 arg_BufLen,
                                         ix_uint32 arg_Mtu 
                                        );

/**
 * NAME: _ix_cc_ipv4_pass_packet
 *
 * DESCRIPTION: This function hands the given packet off to
 *              outgoing target. The packet must be completely
 *              formed.Fragmentation will occur within this routine.
 *       
 *
 * @Param:  - IN arg_hBuffer - The buffer to forward
 *             (with perhaps first fragmenting it) 
 *            
 *
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *          for failure.
 *          
 */

ix_error _ix_cc_ipv4_pass_packet(ix_buffer_handle arg_hBuffer);


/**
 * Exported variables.
 */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__FRAGMENTATION_SUPPORT_H__) */

