/*/////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
/////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: ipv4_fwder_uc.h
//
//      Purpose: Defines constans which are of use to microengines. This 
//      file can be used by core component by enabling appropriate 
//      compilation switches 
//
/////////////////////////////////////////////////////////////////////////////
*/

#ifndef	__IPV4_FWDER_UC_H__
#define	__IPV4_FWDER_UC_H__

#ifdef USE_IMPORT_VAR

#ifdef	NEXTHOP_INFO_SRAM
  .import_var NEXTHOP_TABLE_SRAM_BASE	
#else
  .import_var NEXTHOP_TABLE_SDRAM_BASE
#endif

  /*	Trie Table is in channel 1 [31:30] at address 0 in SRAM */

  .import_var TRIE_TABLE_SRAM_BASE

  /* base for IPv4 32bit counters */

  .import_var IPV4_STATS_TABLE_BASE

  /*  Directed broadcast table base in SRAM */

  .import_var DBCAST_TABLE_SRAM_BASE

  /* control block */
#ifdef	PROCESS_CONTROL_BLOCK
    #if IS_IXPTYPE(__IXP28XX)	
		.import_var CONTROL_BLOCK_SCRATCH_BASE
	#else
        .import_var CONTROL_BLOCK_SRAM_BASE		
	#endif	// IXP2800  
#endif	/* PROCESS_CONTROL_BLOCK */

  /* indicates the blade_id of the NP */

  .import_var THIS_BLADE_ID
#else
#ifdef	MULTICAST_SUPPORT_ENABLE
#ifndef	BID_IPV4_MCAST_NEXT1
#error	"Define BID_IPV4_MCAST_NEXT1 in system level header file"
#endif

#endif	/* MULTICAST_SUPPORT_ENABLE */

/* rest defined in dl_system.h */

#endif /* USE_IMPORT_VAR */

#ifdef	MICROENGINE
#ifndef	IP_HDR_CACHE_LM
#ifndef	IP_HDR_OFFSET
#error	"IP_HDR_OFFSET not defined"
#endif
#endif	
#endif	/* MICROENGINE */

/* offsets of counters in big_endian format.*/
#define	OFFSET_PKTS_RX			0		/*	Packets Rxed */
#define	OFFSET_PKTS_FWD			4		/*	Packets Fwd	 */
#define	OFFSET_PKTS_DROP		8		/*	Packets dropped */
#define	OFFSET_PKTS_EXCP		12		/*	Packets excp */
#define	OFFSET_PKTS_BAD_HDR		16		/*	pkts bad hdr. */
#define	OFFSET_PKTS_BAD_LEN		20		/*	pkts bad total len */
#define	OFFSET_PKTS_BAD_TTL		24		/*	pkts with bad TTL */
#define	OFFSET_PKTS_NO_ROUTE	28		/* packets with no route */
#define	OFFSET_PKTS_TOO_SMALL	32		/* packets too small */


/* each port has 64 bytes to keep the stats */
#define	STATS_PER_PORT_SHF_VAL	6


/*
 * control block
 */
#define	CONTROL_BLOCK_RD_SIZE	1	/* read only 1 LW */


/*
 * nexthop information
 */

/* size of Nexthop info is 16 bytes. Here we define
 how to get byte addresses */

#ifdef COMPRESSED_NEXTHOP_INFO

/* Compressed next hop id entry for IXP2800 to 2 LW's.*/
/* The new format is
// new next_hop ID is
//
//LW 	Bits 	Size 	Field 			Description
//0 	31:16 	16 		Nexthop ID 		ID used on the Egress IXP24xx to lookup
//										the outgoing link layer information.
//0 	15:8 	8 		Fabric Port ID 	Blade ID with respect to CSIX fabric
//0 	7:0 	8 		Flags 			Flags to indicate some action for the
//		 								packet, if corresponding bit is set.
//
//1 	31:16 	16 		MTU 			Maximum Transmission Unit for out going
//										physical interface.
//1		15:8	8		Nexthop ID Type
//1 	7:0 	8		Output port ID	Port number on egress IXP2xxx. May be
//										interpreted by the application as a physical
//										or logical port number
*/
#define	NEXTHOP_INFO_SIZE_LW	2
#define	NEXTHOP_INFO_SHF_VAL	3	/* to get byte address */
#define	NEXTHOP_INFO_SRAM_REF_CNT	2
#define	NEXTHOP_INFO_DRAM_REF_CNT	1

#else	/* COMPRESSED_NEXTHOP_INFO */

#define	NEXTHOP_INFO_SIZE_LW	4
#define	NEXTHOP_INFO_SHF_VAL	4	/* to get byte address */
#define	NEXTHOP_INFO_SRAM_REF_CNT	3
#define	NEXTHOP_INFO_DRAM_REF_CNT	2

#endif	/* COMPRESSED_NEXTHOP_INFO */


#ifdef COMPRESSED_NEXTHOP_INFO

/* Compressed next hop id entry for IXP2800 to 2 LW's.*/
#define	NH_FLAGS_LW		0
#define	NH_NHID_LW		0
#define	NH_BLADE_LW		0
#define	NH_MTU_LW		1
#define NH_NHID_TYPE_LW	1
#define	NH_OUTPORT_LW	1

#define	NHID_TYPE_SHF_VAL	8

#else	/* COMPRESSED_NEXTHOP_INFO */

#define	NH_FLAGS_LW		0
#define	NH_NHID_LW		1
#define	NH_BLADE_LW		1
#define	NH_MTU_LW		2
#define	NH_OUTPORT_LW	2

#endif	/* COMPRESSED_NEXTHOP_INFO */


/*
 * Flags
 */
#define	IPV4_NH_FLAGS_START_BIT		0

#define			IPV4_NH_FLAGS_LOCAL	(IPV4_NH_FLAGS_START_BIT + 0)
#define			IPV4_NH_FLAGS_DOWN	(IPV4_NH_FLAGS_START_BIT + 1)
#define			IPV4_NH_FLAGS_DROP	(IPV4_NH_FLAGS_START_BIT + 2)
#define			IPV4_NH_FLAGS_BROADCAST	(IPV4_NH_FLAGS_START_BIT + 3)
#define			IPV4_NH_FLAGS_MULTICAST	(IPV4_NH_FLAGS_START_BIT + 4)

#define			IPV4_NH_FLAGS_LOCAL_BIT	(0x1<<IPV4_NH_FLAGS_LOCAL)
#define			IPV4_NH_FLAGS_DOWN_BIT	(0x1<<IPV4_NH_FLAGS_DOWN)
#define			IPV4_NH_FLAGS_DROP_BIT	(0x1<<IPV4_NH_FLAGS_DROP)
#define			IPV4_NH_FLAGS_BROADCAST_BIT	(0x1<<IPV4_NH_FLAGS_BROADCAST)
#define			IPV4_NH_FLAGS_MULTICAST_BIT	(0x1<<IPV4_NH_FLAGS_MULTICAST)


#define			IPV4_EXCP_BROADCAST		IPV4_EXCP_LIMITED_BROADCAST

/*
 * Flag to Enable/Disable IPV4 Counters. 
 * By default, the counters are enabled. An application has to 
 * explicitly disable counters. These counters are an extremely
 * usefuly debugging aid too.
 *
 * An application can disable the counters by defining 
 * DISABLE_IPV4_COUNTERS flag before including this file.
 */
#ifndef		DISABLE_IPV4_COUNTERS
#define		IPV4_COUNTERS
#endif
  
/*
 * Flags processing is divided into two steps. In first
 * step we filter out the packets which are to be sent to
 * local stack.
 *
 * In second step, we worry about other flags.
 */
#define		IPV4_FLAGS_MASK_FOR_STACK_VAL	\
				((IPV4_NH_FLAGS_LOCAL_BIT)		|	\
				(IPV4_NH_FLAGS_BROADCAST_BIT)	|	\
				(IPV4_NH_FLAGS_MULTICAST_BIT))


/*
 * Some internal flags here
 */

#define		SKIP_DEST_ADDR_CHECK



#endif	/*__IPV4_FWDER_UC_H__ */
