/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   sysapp_common_linux_user_mode_util.c
 *
 * Main system utility code.
 *
 * This file containes the code to initialize, shutdown and restart
 * the system application and all system components.   
 **/
/*=========================================================================*/
#define IX_ERROR_FILE_IDENT "$Id: sysapp_common_linux_user_mode_util.c,v 1.6 2003/11/25 04:58:11 ktseng Exp $"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <enpv2_types.h>
#include "sa/ix_sa_linux_kernel_module.h"


void sa_usage(void);

int main(int argc, char *argv[])
{

    int fd;
    int arg;
    int cmd;

    if (argc == 1)
    {
        sa_usage();
        exit(0);
    }

    if ((argc == 2) && !(strcmp(argv[1],"stop") == 0)) 
    {
        sa_usage();
        exit(1);
    }

    if ((argc == 3) && !(strcmp(argv[1],"start") == 0))
    {
        sa_usage();
        exit(1);
    }

    if (strcmp(argv[1],"start") == 0)
    {
        cmd = SA_START;
        arg = atoi(argv[2]);
        printf("bladeId is %d\n", arg);
    }
    else if (strcmp(argv[1],"stop") == 0)
    {
        cmd = SA_STOP;
        arg = 0;
    }

    else
    {
        printf("Unrecognized command\n");
        exit(1);
    }

    /* init and start spi3br */
    StartSpi3br();

    /* add code here to configure macs if necessary -- nizhner */
    
    /* init and start macs */
    StartMacs();
    

#if defined(IPV6_SUPPORT)
    /* Set IPv6 addresses of each port into the Linux kernel stack */
    if (cmd == SA_START)
    {
        set_ipv6_addr();
    }
#endif

    fd = open("/dev/SaUtil",O_CREAT|O_RDWR);

    ioctl(fd, cmd, arg);

    close(fd);

    return 0;
}

void sa_usage(void)
{
    printf("\nUSAGE: sa <cmd> <arg>\n\n");
    printf(" where <cmd> <args> pair can be one of the followings: \n");
    printf("  start bladeID\n");
    printf("  stop\n");
}
