/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.1 for the IXP2000 Network Processor
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      Linux kernel module file.
 *
 * = FILENAME
 *      sysapp_common_linux_kernel_module.c
 *
 * = DESCRIPTION
 *      The file defines the init and cleanup functions for Linux kernel module.
 *
 * = CREATION TIME
 *      04/26/2003
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: sysapp_common_linux_kernel_module.c,v 1.12 2003/12/12 19:49:49 ktseng Exp $
 */

#include <linux/module.h>
#include "ix_ossl.h"
#include "sa/ix_sa.h"
#include "sa/ix_sa_linux_kernel_module.h"
#include "ix_cc.h"

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)

MODULE_LICENSE("Proprietary");

int ix_sa_open( struct inode *sa_inode, struct file *sa_file); 
int ix_sa_close( struct inode *sa_inode, struct file *sa_file);
int ix_sa_ioctl( struct inode *sa_inode, struct file * sa_file, unsigned int cmd, unsigned long arg_IoctlPtr);


extern ix_error _ix_sa_entry(void *arg_bladeID);
extern ix_error ix_sa_shutdown(ix_sa_restart_override);

#if defined(IX_PLATFORM_2800)

void imi1(void);
void imi2(void);
void imi3(void);
void imi4(void);
void emi1(void);
void emi2(void);
void emi3(void);
void emi3a(void);
void emi3b(void);
void emi4(void);
void emi4(void);

#endif /* defined(IX_PLATFORM_2800) */

static struct file_operations ix_sa_fops = {
          ioctl: ix_sa_ioctl,
          open: ix_sa_open,
          release: ix_sa_close,
};      

int majorNumber = DEV_NUMBER_SAUTIL;

int init_module(void)
{

    ix_uint32 s_Result;

#ifdef IX_DEBUG
    ix_ossl_message_log("Loading sysapp_common module.\n");
#endif


    s_Result = register_chrdev(majorNumber, DEV_NAME_SAUTIL, &ix_sa_fops );
    if(s_Result == 0)
    {
        ix_ossl_message_log("UtilDrv Module is registered with major:%d\n",majorNumber);
            ix_ossl_message_log ("USAGE:\n");
            ix_ossl_message_log ("mknod /dev/%s c %d <minor>\n", DEV_NAME_SAUTIL, majorNumber);
            ix_ossl_message_log ("with different minor numbers.\n\n");
	    
        }
        else
        {
            ix_ossl_message_log( "sysapp_common module cannot be registered!!!!.\n");
            ix_ossl_message_log("Registered to number %d\n",majorNumber);
            return -1;
        }

    return 0;
}

void cleanup_module(void)
{
    ix_uint32 s_Result;

#ifdef IX_DEBUG
    ix_ossl_message_log("Unloading sysapp_common module.\n");
#endif

    s_Result = unregister_chrdev(majorNumber, DEV_NAME_SAUTIL);
    if(s_Result == 0)
    {
        ix_ossl_message_log("sysapp_common module cleaned successfully...\n");
    }
    else
    {
        ix_ossl_message_log("sysapp_common Module COULD NOT BE CLEANED UP !!!\n");
    }

    return;
}



int ix_sa_open(
    struct inode *sa_inode,
    struct file *sa_file)
{
#ifdef IX_DEBUG
    ix_ossl_message_log("ix_sa_open called.\n");
#endif
    return 0;

}




int ix_sa_close(
    struct inode *sa_inode,
    struct file *sa_file)
{
#ifdef IX_DEBUG
    ix_ossl_message_log("ix_sa_close called.\n");
#endif
    return 0;
}



int ix_sa_ioctl(
    struct inode *sa_inode,
    struct file * sa_file,
    unsigned int cmd,
    unsigned long arg_IoctlPtr)
{
    ix_uint32 s_Result;

#ifdef IX_DEBUG
    ix_ossl_message_log("ix_sa_ioctl called.\n");
#endif

    if (sa_inode == NULL)
    {
#ifdef IX_DEBUG
        ix_ossl_message_log("ix_sa_inode is NULL.\n");
#endif
        return -1;
    }
  
    if (sa_file == NULL)
    {
#ifdef IX_DEBUG
        ix_ossl_message_log("ix_sa_file is NULL.\n");
#endif
        return -1;
    }        

    switch(cmd)
    {
        case SA_START:
            s_Result = _ix_sa_entry((void *)arg_IoctlPtr);
            break;
        case SA_STOP:
            s_Result = ix_sa_shutdown(0);
            break;

#ifdef IX_PLATFORM_2800

        case SA_IMI1:
            s_Result = 0;
            imi1();
            break;

        case SA_IMI2:
            s_Result = 0;
            imi2();
            break;

        case SA_IMI3:
            s_Result = 0;
            imi3();
            break;

        case SA_IMI4:
            s_Result = 0;
            imi4();
            break;

        case SA_EMI1:
            s_Result = 0;
            emi1();
            break;

        case SA_EMI2:
            s_Result = 0;
            emi2();
            break;

        case SA_EMI3:
            s_Result = 0;
            emi3();
            break;

        case SA_EMI3A:
            s_Result = 0;
            emi3a();
            break;

        case SA_EMI3B:
            s_Result = 0;
            emi3b();
            break;

        case SA_EMI4:
            s_Result = 0;
            emi4();
            break;

#endif /* defined(IX_PLATFORM_2800) */
	   
        default:
#ifdef IX_DEBUG
            ix_ossl_message_log("Undefined ioctl command %d.\n", cmd);
#endif
            s_Result = -1;
            break;
    }

    if (s_Result != 0)
    {
#ifdef IX_DEBUG
        ix_ossl_message_log("ix_sa_ioctl failed.\n");
#endif
    }
    else
    {
#ifdef IX_DEBUG
        ix_ossl_message_log("ix_sa_ioctl succeeded.\n");
#endif
    }

    return s_Result;

}
#endif
