/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   sa_microengine.c
 *
 * Configure microengines
 *
 * This file contains code to set, load, start and stop microengines.
 **/
/*=========================================================================*/
/* $Id: sa_microengine.c,v 1.19 2003/10/01 23:09:53 ktseng Exp $ */

#include "ix_cc_error.h"
#include "ix_rm.h"
#include "ix_ossl.h"
#include "ix_cc_macros.h"
#include "sa/ix_sa_cc_list.h"
#include "sa/internal/internal_sa.h"

#ifdef IX_USE_ENV_VAR

#include "sa/internal/internal_env_data.h"

#endif

#include "cc/ix_cc_reg_util.h"



/* Defines for MCCR register */
#define PLL_25MHZ	0x0
#define PLL_50MHZ	0x5
#define PLL_104MHZ	0xA
#define PLL_125MHZ	0xF

#define MSF_CLKCFG_MEDIA	PLL_125MHZ
#define MSF_CLKCFG_SF		PLL_125MHZ

#define MSF_CLKCFG_IN		(MSF_CLKCFG_MEDIA | (MSF_CLKCFG_SF << 4))
#define MSF_CLKCFG_EG		(MSF_CLKCFG_SF | (MSF_CLKCFG_MEDIA << 4))

#define MCCR_MASK1	0x0000F0F0 /* bypass and powerdown */
#define MCCR_MASK2	0x000000F0 /* powerdown */
#define MCCR_MASK3	0x00000000

#define MAX_UOF_FILE_PATH   512
ix_uint8 g_sa_uofFileEnv[MAX_UOF_FILE_PATH];

/*  _ix_sa_set_microcode */
/*  ---------------------------------------- */
/**
 * Set the microcode image.
 *
 * Set's the microcode image so that the core components can
 * patch symbols.
 *
 * @return IX_SUCCESS upon success or an ix_error with one of the following values.
 * @retval NONE
**/
ix_error
_ix_sa_set_microcode(ix_sa_ctrl *arg_sa_ctrl)
{
    IX_ERROR_CHECK_ARG_NULL(1, arg_sa_ctrl);
    /*set variable to the microcode image*/

    /* set the image */
#ifdef IX_USE_ENV_VAR
    /* This will insert the base directory path obtained from 
     * the host's environmental variable IXA_SDK_DEV */
    strcpy(g_sa_uofFileEnv, gSAEnvData);
    strcat(g_sa_uofFileEnv, g_sa_uofFile);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
    ix_ossl_message_log("+Setting Microcode.\n  %s\n", g_sa_uofFileEnv);

#else
    printf("+Setting Microcode.\n  %s\n", g_sa_uofFileEnv);
#endif /* _IX_OS_LINUX_KERNEL */

    IX_ERROR_CR(ix_rm_ueng_set_ucode(g_sa_uofFileEnv));
#else /* IX_USE_ENV_VAR */

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
    ix_ossl_message_log("+Setting Microcode.\n  %s\n", g_sa_uofFile);

#else
    printf("+Setting Microcode.\n  %s\n", g_sa_uofFile);
#endif /* _IX_OS_LINUX_KERNEL */
    IX_ERROR_CR(ix_rm_ueng_set_ucode(g_sa_uofFile));
#endif
/*    IX_ERROR_CR(ix_rm_ueng_map_ucode((void*)g_sa_ucData,
      sizeof(g_sa_ucData));*/


    return IX_SUCCESS;
}


/*  _ix_sa_load_microcode */
/*  ---------------------------------------- */
/**
 * Load microcode.
 *
 * Load's the microcode onto the microengines.

 * @param 
 * @return IX_SUCCESS upon success or an ix_error with one of the following values.
 * @retval NONE
**/
ix_error
_ix_sa_load_microcode(void)
{
    IX_ERROR_CR(ix_rm_ueng_load());
    return IX_SUCCESS;
}



/*  _ix_sa_start_microengines */
/*  ---------------------------------------- */
/**
 * Starts microengines
 *
 * Starts microengines based on the configuration in the registry.
 *
 * @param 
 * @return IX_SUCCESS upon success or an ix_error with one of the following values.
 * @retval NONE
**/
ix_error
_ix_sa_start_microengines(ix_sa_ctrl *arg_sa_ctrl)
{
    ix_configuration_property_handle microengines_prop;
    ix_configuration_property_handle me_prop;
    ix_uint32 me_id;
    ix_uint32 context_mask;
    ix_uint32 idx = 0;
    char microengines_path[64];

    /* Validate Args */
    IX_ERROR_CHECK_ARG_NULL(1, arg_sa_ctrl);

    /* open base microengine property */
    sprintf(microengines_path, "/SystemApp/MICROENGINES");
    IX_ERROR_CR(ix_cc_reg_get_prop_from_path(microengines_path, 
                                             &microengines_prop));
    ix_rm_cp_property_get_subproperty(microengines_prop, idx,
                                      &me_prop);
    while(me_prop != 0){
        IX_ERROR_CR(ix_rm_cp_property_get_value_uint32(me_prop, &me_id));
        IX_ERROR_CR(_ix_sa_prop_get_uint_value(me_prop,
                                               "CONTEXT_MASK", &context_mask));
        IX_ERROR_CR(ix_rm_ueng_start(g_aMicroengineNumberMapping[me_id], 
                                     context_mask));

        /* This is done here so that if ANY microenges have been started
           the flag is set */
        arg_sa_ctrl->microenginesStarted = 1;
        idx++;
        ix_rm_cp_property_get_subproperty(microengines_prop, idx,
                                          &me_prop);
    }
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
    ix_ossl_message_log("STARTED All MicroEngines\n");

#else
    printf("STARTED All MicroEngines\n");
#endif
    return IX_SUCCESS;
}


/*  _ix_sa_stop_microengines */
/*  ---------------------------------------- */
/**
 * Stops microengines
 *
 * Stops microengines based on the configuration in the registry.
 *
 * @param 
 * @return IX_SUCCESS upon success or an ix_error with one of the following values.
 * @retval NONE
**/
ix_error
_ix_sa_stop_microengines(ix_sa_ctrl *arg_sa_ctrl)
{
    ix_configuration_property_handle microengines_prop;
    ix_configuration_property_handle me_prop;
    ix_uint32 me_id;

    ix_uint32 idx = 0;
    char microengines_path[64];

    /* Validate Args */
    IX_ERROR_CHECK_ARG_NULL(1, arg_sa_ctrl);
    /* open base freelist property */
    sprintf(microengines_path, "/SystemApp/MICROENGINES");
    IX_ERROR_CR(ix_cc_reg_get_prop_from_path(microengines_path, 
                                             &microengines_prop));
    ix_rm_cp_property_get_subproperty(microengines_prop, idx,
                                      &me_prop);
    while(me_prop != 0){
        IX_ERROR_CR(ix_rm_cp_property_get_value_uint32(me_prop, &me_id));
        IX_ERROR_CR(ix_rm_ueng_reset(g_aMicroengineNumberMapping[me_id],
                                     1)); /* 1 indicated reset registers */
        ix_rm_cp_property_get_subproperty(microengines_prop, idx,
                                          &me_prop);
        idx++;
    }
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
    ix_ossl_message_log("RESET All MicroEngines\n");

#else
    printf("RESET All MicroEngines\n");
#endif
    /* indicate that all microengines have been stoped */
    arg_sa_ctrl->microenginesStarted = 0;
    return IX_SUCCESS;
}
