/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   registry.c
 *
 * This file contains the code that populates the system registry
 * with the initial values specified in the config.
 *
 * internal_registry_data.h is automatically generated based on
 * the xml system configuration file.  This file, registry.c, 
 * takes that data and imports it into the system registry.
 **/
/*=========================================================================*/
#define IX_ERROR_FILE_IDENT "$Id: registry.c,v 1.13 2003/06/18 17:12:23 ktseng Exp $"


#include "ix_cc_error.h"
#include "ix_rm.h"
#include "ix_ossl.h"
#include "sa/internal/internal_sa.h"
#include "sa/internal/internal_registry.h"

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)

#ifdef EGRESS
#include "sa/internal/egress_internal_registry_data_linux.h"
#else
#ifdef INGRESS
#include "sa/internal/ingress_internal_registry_data_linux.h"
#else
#error "BUILD needs to be defined as either EGRESS or INGRESS"
#endif /* INGRESS */
#endif /* EGRESS */

#else

#include "sa/internal/internal_registry_data.h"

#endif /* (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_) */

#include "cc/ix_cc_reg_util.h"

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
extern ix_sa_registry_property gSAPropList[];
#endif



#if !defined(TESTRT)
#if defined(IX_DEBUG)
/*  _ix_sa_do_dep */
/*  ---------------------------------------- */
/**
 * DEBUG function to indent during the registy dump.
 *
 * This DEBUG function prints a certain number of spaces based
 * on the depth it is passed.  This helps decorate the registry
 * dumping process.

 * @param dep The depth to indent.
 * @return void
**/
void
_ix_sa_do_dep(int dep)
{
    int  i;
    for(i=0; i < dep; i++)
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
        ix_ossl_message_log("   ");

#else
        printf("   ");
#endif
}

/*  _ix_sa_dump_prop */
/*  ---------------------------------------- */
/**
 * DEBUG function to dump the information about a specific 
 * registy propery
 *
 * This DEBUG function is called by ix_sa_dump_reg and will print
 * the details about a specific property.
 *
 * @param arg_prop The property to dump
 * @param dep The depth of the propery in the tree.  This is used
 *  to indent the printing process.
 * @return void
**/
void
_ix_sa_dump_prop(ix_configuration_property_handle arg_prop, 
                 int dep)
{
    ix_cp_property_info info;
    char data[256];
    ix_uint32 uint_val;
    ix_uint32 size=256;
    if(arg_prop == 0)
        return;

    ix_rm_cp_property_get_info(arg_prop, &info);

    _ix_sa_do_dep(dep);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)

    ix_ossl_message_log("-----\n");
#else
    printf("-----\n");
#endif
    _ix_sa_do_dep(dep);

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
    ix_ossl_message_log("Name: %s\n", info.m_aName);

#else
    printf("Name: %s\n", info.m_aName);
#endif
    _ix_sa_do_dep(dep);

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)

    ix_ossl_message_log("Opt: %ld\n", info.m_Options);
#else
    printf("Opt: %ld\n", info.m_Options);
#endif
    switch(info.m_Options){
    case 6:
        _ix_sa_do_dep(dep);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
        ix_ossl_message_log("Type: uint32\n");

#else
        printf("Type: uint32\n");
#endif        
        ix_rm_cp_property_get_value_uint32(arg_prop, &uint_val);

        _ix_sa_do_dep(dep);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
        ix_ossl_message_log("Data: %ld\n", uint_val);

#else
        printf("Data: %ld\n", uint_val);
#endif
        break;
    case IX_CP_OPTIONS_FLAGS_DATA:
        _ix_sa_do_dep(dep);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
        ix_ossl_message_log("Type: string\n");

#else
        printf("Type: string\n");
#endif        
        ix_rm_cp_property_get_value(arg_prop, 
                                    &size, data);

        _ix_sa_do_dep(dep);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
        ix_ossl_message_log("Size: %ld\n", size);

#else
        printf("Size: %ld\n", size);
#endif
        _ix_sa_do_dep(dep);
#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
        ix_ossl_message_log("Data: %s\n", data);

#else
        printf("Data: %s\n", data);
#endif
        size=256;
        break;
    }
    
}

/*  ix_sa_dump_reg */
/*  ---------------------------------------- */
/**
 * DEBUG function used to dump the registry.
 *
 * When compiled in debug mode, dumps the entire contents of
 * the system registry.
 *
 * @param arg_prop the root of the subtree to dump.
 * @return void
**/
void
ix_sa_dump_reg(ix_configuration_property_handle arg_prop)
{
    static int dep = -1;
    int idx = 0;

    ix_configuration_property_handle subprop;

    dep++;
    while(!ix_rm_cp_property_get_subproperty(arg_prop, idx,
                                             &subprop)){
        if(subprop == 0)
            break;
        _ix_sa_dump_prop(subprop, dep);
        ix_sa_dump_reg(subprop);
        idx++;
    }
    dep--;
}
#endif /* defined(IX_DEBUG) */
#endif /* !defined(TESTRT) */


/*  _ix_sa_populate_registry */
/*  ---------------------------------------- */
/**
 * Populate the system registry.
 *
 * Populates the system registry with the configuration information
 * found in internal_registry_data.h.  
 *
 * @return IX_SUCCESS upon success or an ix_error with one of the following values.
 * @retval NONE
 *
 *
 *
**/
ix_error 
_ix_sa_populate_registry(void)
{
    ix_uint32 curitem;

    ix_configuration_property_handle parent;
    ix_configuration_property_handle cur_prop;
    ix_uint32 cur_options;

    curitem = 0;
    /* while there is a non empty entry, add to registry */
    while(gSAPropList[curitem].name[0] != 0){
        IX_ERROR_CR(ix_cc_reg_get_prop_from_path(
                        gSAPropList[curitem].parent_path, &parent));
        
        /* determine options */
        cur_options = 0;
        if(gSAPropList[curitem].hasvalue){
            if(gSAPropList[curitem].type == 1){
                cur_options = IX_CP_OPTIONS_FLAGS_DATA_UINT32;
            }else{
                cur_options = IX_CP_OPTIONS_FLAGS_DATA;
            }
        }

        /*create the new property
         */
        IX_ERROR_CR(ix_rm_cp_property_create(parent,
                                             gSAPropList[curitem].name,
                                             cur_options,
                                             &cur_prop));

        
        /* if the property has a value, add it */
        if(gSAPropList[curitem].hasvalue){
            if(gSAPropList[curitem].type == 1){
                IX_ERROR_CR(ix_rm_cp_property_set_value_uint32(
                                cur_prop,
                                gSAPropList[curitem].uint_val));
            }else{
                IX_ERROR_CR(ix_rm_cp_property_set_value(
                                cur_prop,
                                strlen(gSAPropList[curitem].value) + 1,
                                gSAPropList[curitem].value));
            }
        }
        curitem++;
    }

    return IX_SUCCESS;
}


