/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      route_config_linux_kernel_module.h
 *
 * = DESCRIPTION
 *      This file will describe the ioctl commands exported to Linux user 
 *      mode application. 
 *
 * = CHANGE HISTORY
 *      05/06/2003 - Created.
 *
 * ============================================================================
 * $Id: ix_sa_linux_kernel_module.h,v 1.4 2003/09/30 20:10:00 ktseng Exp $
 */

#if !defined(__IX_SA_LINUX_KERNEL_MODULE_H__)
#define __IX_SA_LINUX_KERNEL_MODULE_H__



/**
 * System defined include files required.
 */

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


/* defines for ioctl commands */
#define SA_START 0
#define SA_STOP  1


#ifdef IX_PLATFORM_2800

#define SA_IMI1  2
#define SA_IMI2  3
#define SA_IMI3  4
#define SA_IMI4  5
#define SA_EMI1  6
#define SA_EMI2  7
#define SA_EMI3  8
#define SA_EMI3A 9
#define SA_EMI3B 10
#define SA_EMI4  11

#endif /* IX_PLATFORM_2800 */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_SA_LINUX_KERNEL_MODULE_H__) */

