/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   bindings.h
 *
 * This file defines a list of core component function pointers.
 *
 * Defines the array of function pointers to core components.  This is
 * indexed by the configuration.
 **/
/*=========================================================================*/
/* $Id: ix_sa_cc_list.h,v 1.7 2003/09/09 22:52:32 ktseng Exp $ */

/** Ensure the file is only included once. */
#if !defined(__IX_SA_CC_LIST_H_)
#define __IX_SA_CC_LIST_H_

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

#include "ix_cc_error.h"
#include "ix_rm.h"
#include "ix_cci.h"
#include "bindings.h"

#define IX_CC_LIST_MAX_SIZE 64

extern char g_sa_uofFile[];

/**
 * This structure is used to store pointers to the init and fini functions
 * of a core component.  An array of these structures provide a table
 * that is used to start core components.  The cc handle is stored once
 * the core component has been started.
**/
typedef struct ix_s_sa_ccfunc{
    /** pointer to the cc init function */
    ix_cc_init init;
    /** pointer to the cc fini function */
    ix_cc_fini fini;
    /** cc handle for the core component */
    ix_cc_handle cc_handle[IX_CC_INSTANCE_MAX];
}ix_sa_ccfunc;

ix_error _ix_sa_cc_list(ix_sa_ccfunc *arg_pCC_List);

ix_error
_ix_sa_set_cc(ix_sa_ccfunc *arg_pCC_List, ix_uint32 arg_idx,
              ix_cc_init arg_Init, ix_cc_fini arg_Fini);


#if defined(__cplusplus)
} /* extern "C" */
#endif /* __cplusplus */
#endif /* __IX_SA_CC_LIST_H_ */
