/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a licence agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   ix_sa.h
 *
 * System application API
 **/
/*=========================================================================*/
/* $Id: ix_sa.h,v 1.2 2002/10/17 06:01:37 rjpetri Exp $ */



/** Ensure the file is only included once. */
#if !defined(__IX_SA_H_)
#define __IX_SA_H_

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/* ix_e_sa_error */
/* ------------------------ */
/** 
 * Enumeration of system application specific errors.
*/
typedef enum ix_e_sa_error
{
    /** Encountered invalid data in the system registry */
    IX_SA_ERROR_INVALID_REGISTRY_DATA = IX_ERROR_MAKE_GROUP(SA),
    /** The execution engine is invalid */
    IX_SA_ERROR_INVALID_EE,
    /** The CC_LIST is invalid */
    IX_SA_ERROR_INVALID_CC_LIST,
    /** The property type is invalid.  ie not uint32 or not string */
    IX_SA_ERROR_INVALID_PROP_TYPE,
    /** The property is not valid */
    IX_SA_ERROR_INVALID_PROP,
    /** The property failed to be added.*/
    IX_SA_ERROR_PROP_ADD_FAILED,
    /** The number of scratch rings counted in the registry does not
        match the number found during creation*/
    IX_SA_ERROR_SR_COUNT_MISMATCH,
    /** The size of the returned prop data was invalid */
    IX_SA_ERROR_INVALID_PROP_DATA_SIZE,
    /** The property data is invalid */
    IX_SA_ERROR_INVALID_PROP_DATA,
    /** The system application is already shutting down */
    IX_ERROR_SA_ALREADY_SHUTTINGDOWN
} ix_sa_error;


typedef enum
{
    IX_SA_RESTART_NO = 0
    ,IX_SA_RESTART_FORCE
    ,IX_SA_RESTART_DEFUALT
} ix_sa_restart_override;

int
ix_sa_create(ix_uint32 arg_bladeID);

ix_error 
ix_sa_shutdown(ix_sa_restart_override arg_restart);

#if defined(__cplusplus)
} /* extern "C" */
#endif /* __cplusplus */
#endif /* __IX_SA_H_ */
