/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   internal_sa.h
 *
 * Header for system application code.
 *
 * This file contains headers, structures etc that are used by the system
 * application.
 **/
/*=========================================================================*/
/* $Id: internal_sa.h,v 1.9 2003/09/15 17:23:25 ktseng Exp $ */



/** Ensure the file is only included once. */
#if !defined(__INTERNAL_SA_H__)
#define __INTERNAL_SA_H__

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

#include "ix_cc_error.h"
#include "ix_rm.h"
#include "ix_cci.h"
#include "ix_cc.h"
#include "ix_cc_properties.h"
#include "sa/ix_sa.h"



/** Maximum number of execution engines */
#define IX_SA_MAX_EE 64

/** Maximum number of freelists
 *
 * This value can be changed without problem.
 * an array is used to allow for easy structure
 * copying.
 */
#define IX_SA_MAX_FREELISTS 64



/* ix_sa_ctrl */
/* ------------------------ */
/** 
 * Control structure containing state for the system application.
*/
typedef struct ix_s_sa_ctrl
{
    /** indicates whether microengines have been started or not */
    ix_uint8 microenginesStarted; 

    /** handle of freelist */
    ix_buffer_free_list_handle freelist[IX_SA_MAX_FREELISTS+1];

    /** number of channels containing freelists */
    ix_uint16 freelistChannelCount;

    /** handle of msg freelist */
    ix_buffer_free_list_handle hMsg_Freelist;

    /** Size of message buffers */
    ix_uint32 msg_Buff_Size;

    /** number of scratch rings */
    ix_uint32 numScratchRings; 
    /** array of scratch rings, indexed by ID */
    ix_hw_ring_handle *aScratchRings; 

    /** the struct passed to all core components 
     *  containing initial values for all properties */
    ix_cc_init_context  init_state;

    /* default execution engine */
    ix_exe_handle def_ee_handle;

    /* array of execution engines */
    ix_exe_handle ee_handles[IX_SA_MAX_EE];
} ix_sa_ctrl;


/* If user hooks are enabled, the hook is called otherwise
 * IX_SUCCESS is substituted allowing for passing of the error
 * macro when hooks are disabled */
#ifdef IX_SA_ENABLE_HOOKS
#define _IX_SA_HOOK(_hook) _hook
#else
#define _IX_SA_HOOK(_hook) IX_SUCCESS
#endif

/*#if defined(_IX_SA_DEBUG_TRACE)*/
#define DCT printf("%s: %d\n", __FILE__, __LINE__)
/*#else
#define DCT
#endif   */

/* Allocates freelists.  (see source for details) */
ix_error _ix_sa_alloc_freelists(ix_sa_ctrl *sa_ctrl);

/* Deletes freelists (See Source for details) */
ix_error _ix_sa_delete_freelists(ix_sa_ctrl *arg_sa_ctrl);

/* Allocate scratch rings based on the registry. (see source)*/
ix_error _ix_sa_create_scratch_rings(ix_sa_ctrl *sa_ctrl);

/* Delete scratch rings */
ix_error _ix_sa_delete_scratch_rings(ix_sa_ctrl *arg_sa_ctrl);

/* Retrieves a uint value from a property with error checking 
* (see source)*/
ix_error 
_ix_sa_prop_get_uint_value(ix_configuration_property_handle arg_parent,
                                    char *arg_name,
                                    ix_uint32 *arg_value);
/* Retrieves a string value from a property with error checking
 * (see source)*/
ix_error
_ix_sa_prop_get_string_value(ix_configuration_property_handle arg_parent,
                             char *arg_name,
                             char **arg_value);

/* Set microcode image (see source) */
ix_error _ix_sa_set_microcode(ix_sa_ctrl *arg_sa_ctrl);

/* Load microcode (see source) */
ix_error _ix_sa_load_microcode(void);

/* Start microengines (see source) */
ix_error _ix_sa_start_microengines(ix_sa_ctrl *sa_ctrl);

/* Stop microengines (see source) */
ix_error _ix_sa_stop_microengines(ix_sa_ctrl *sa_ctrl);

/* Initialize the media */
ix_error
_ix_sa_media_reset(void);

/* Creates the default execution engine (see source) */
ix_error _ix_sa_create_default_engine(ix_sa_ctrl *sa_ctrl);

/* Deletes default execution engine (see source) */
ix_error _ix_sa_delete_default_engine(ix_sa_ctrl *arg_sa_ctrl);

/* Load system properties for each port and store in linked list*/
ix_error _ix_sa_load_props(ix_sa_ctrl *arg_sa_ctrl, ix_uint32 arg_bladeID);

/* Delete all entries in the properties linked list*/
ix_error _ix_sa_delete_props(ix_sa_ctrl *arg_sa_ctrl);

/*  _ix_sa_create_execution_engines */
/*  ---------------------------------------- */
/**
 * Create execution engines. (SEE SOURCE FILE)
 */
ix_error _ix_sa_create_execution_engines(ix_sa_ctrl *arg_sa_ctrl);

/* Shutdown all execution engines */
ix_error _ix_sa_delete_execution_engines(ix_sa_ctrl *arg_sa_ctrl);

#if defined(__cplusplus)
} /* extern "C" */
#endif /* __cplusplus */
#endif /*__INTERNAL_SA_H__*/
