/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   internal_registry.h
 *
 * Header for registry population code
 *
 * This file contains headers, structures etc that are used to populate the
 * system registry at start-up.  
 **/
/*=========================================================================*/
/* $Id: internal_registry.h,v 1.6 2003/09/09 22:55:56 ktseng Exp $ */



/** Ensure the file is only included once. */
#if !defined(__INTERNAL_REGISTRY_H_)
#define __INTERNAL_REGISTRY_H_

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

#include "ix_cc_error.h"
#include "ix_rm.h"
#include "ix_ossl.h"

/** Max Name Size */
#define IX_SA_REG_MAX_NAME_SIZE         IX_CP_MAX_PROPERTY_NAME_LENGTH
/** Max Value Size 
 * The rm value is internal (why?) */
#define IX_SA_REG_MAX_VALUE_SIZE        128UL
/** Max Path Size  */
#define IX_SA_REG_MAX_PATH_SIZE         ((IX_SA_REG_MAX_NAME_SIZE + 1) * 16)

/*  ix_sa_registry_property */
/*  ---------------------------------------- */
/**
 * This structure defines each property to add to the registry.
 * The data for each instance of this structure is defined in 
 * internal_registry_data.h.
 */
typedef struct ix_s_sa_registry_property{
    /** Path to this properties parent */
    char parent_path[IX_SA_REG_MAX_PATH_SIZE];
    /** Name of this property */
    char name[IX_SA_REG_MAX_NAME_SIZE];
    /** Does this property contain data */
    ix_uint8  hasvalue;
    /** The type of data */
    ix_uint8  type;
    /** The value if type is uint */
    ix_uint32 uint_val;
    /** The value if the type is string */
    char value[IX_SA_REG_MAX_VALUE_SIZE];
} ix_sa_registry_property;



/*  _ix_sa_populate_registry */
/*  ---------------------------------------- */
/**
 * Populate registry. (SEE SOURCE FILE)
 */
ix_error _ix_sa_populate_registry(void);


#if defined(__cplusplus)
} /* extern "C" */
#endif /* __cplusplus */
#endif /* __INTERNAL_REGISTRY_H_ */
