/******************************************************************************
 *
 *	spi3br_vxworks.h
 *	----------------
 *	Header file for SPI-3 bridge vxworks device driver
 *
 ******************************************************************************
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/
#ifndef __SPI3BR_VXWORKS_H__
#define __SPI3BR_VXWORKS_H__

#include "enpv2_types.h"
#include "spi3br_defs.h"



/******************************************************************************
 *	DATA TYPES
 ******************************************************************************/
typedef int SPI3BR_STATUS;

typedef int SPI3BR_HANDLE;

typedef struct
{
	UINT8	port;
	UINT8	val;
}
SPI3BR_CHAN_CFG;


/******************************************************************************
 *	RETURN STATUS DEFINITIONS
 ******************************************************************************/
#define SPI3BR_SUCCESS								0
#define SPI3BR_INVALID_USR_HANDLER					1
#define SPI3BR_INSUFFICIENT_RESOURCES				2
#define SPI3BR_DEVICE_NOT_FOUND						3
#define SPI3BR_INVALID_OPERATION					4
#define SPI3BR_INVALID_ARG							5



/******************************************************************************
 *	IOCTL COMMANDS
 ******************************************************************************/
#define SPI3BR_IOCTL_GET_CHIP_ID					0
#define SPI3BR_IOCTL_GET_CHIP_REV					1
#define SPI3BR_IOCTL_RESET_GLOBAL					2
#define SPI3BR_IOCTL_RESET_LOGIC					3
#define SPI3BR_IOCTL_SET_INT_EN						4
#define	SPI3BR_IOCTL_CLR_INT_EN						5
#define SPI3BR_IOCTL_GET_INT_EN						6
#define SPI3BR_IOCTL_GET_INT_STTS					7
#define SPI3BR_IOCTL_SET_PORT_EN					8
#define SPI3BR_IOCTL_GET_PORT_EN					9
#define SPI3BR_IOCTL_SET_BURST_SIZE					10
#define SPI3BR_IOCTL_GET_BURST_SIZE					11
#define SPI3BR_IOCTL_SET_PORT_PAUS					12
#define SPI3BR_IOCTL_CLR_PORT_PAUS					13
#define SPI3BR_IOCTL_GET_PORT_PAUS					14
#define SPI3BR_IOCTL_GET_PORT_PAUSD					15
#define SPI3BR_IOCTL_SET_RX_FIFO_CTL				16
#define SPI3BR_IOCTL_GET_RX_FIFO_CTL				17
#define SPI3BR_IOCTL_SET_TX_FIFO_CTL				18
#define SPI3BR_IOCTL_GET_TX_FIFO_CTL				19
#define SPI3BR_IOCTL_DBG_SET_LOOPBACK_MODE			20
#define SPI3BR_IOCTL_DBG_CLR_LOOPBACK_MODE			21
#define SPI3BR_IOCTL_DBG_SET_REG					22
#define SPI3BR_IOCTL_DBG_GET_REG					23


/******************************************************************************
 *	API
 ******************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

SPI3BR_STATUS spi3brModuleStart( void );

SPI3BR_STATUS spi3brModuleStop( void );

SPI3BR_STATUS spi3brDeviceOpen( SPI3BR_HANDLE *handle );

SPI3BR_STATUS spi3brDeviceClose( SPI3BR_HANDLE handle );

SPI3BR_STATUS spi3brInstallUserHandler( SPI3BR_HANDLE handle, void *usrCtxt,
					void (*usrHandler)(void *usrCtxt, UINT16 intEvents) );

SPI3BR_STATUS spi3brRemoveUserHandler( SPI3BR_HANDLE handle );

SPI3BR_STATUS spi3brDeviceIoctl( SPI3BR_HANDLE handle, int cmd, void *arg );

#ifdef __cplusplus
}
#endif



#endif /*__SPI3BR_VXWORKS_H__*/
