/******************************************************************************
 *
 * spi3br.h
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/
#ifndef __SPI3BR_H__
#define __SPI3BR_H__

#include "enpv2_types.h"

#define SPI3BR_PHY_BASE		   0xc5000000
#define SPI3BR_REG_BANK_SIZE    0x400000
#define SLOWPORT_PHY_BASE	   0xc0080000
#define SLOWPORT_REG_BANK_SIZE 0x1000

/******************************************************************************
 *
 *								REGISTER ADDRESSES
 *
 ******************************************************************************/
#define SPI3BR_REG_IDLO				0x00
#define SPI3BR_REG_IDHI				0x01
#define SPI3BR_REG_RID				0x02
#define SPI3BR_REG_RESET				0x03
#define SPI3BR_REG_INTREN0			0x04
#define SPI3BR_REG_INTREN1			0x05
#define SPI3BR_REG_INTRSTAT0			0x06
#define SPI3BR_REG_INTRSTAT1			0x07
#define SPI3BR_REG_PORTEN			0x08
#define SPI3BR_REG_BURST_SIZE		0x09
#define SPI3BR_REG_PORTPAUS			0x0a
#define SPI3BR_REG_PORTPAUSD			0x0b
#define SPI3BR_REG_RSVD_0C			0x0c
#define SPI3BR_REG_RSVD_0D			0x0d
#define SPI3BR_REG_RSVD_0E			0x0d
#define SPI3BR_REG_RSVD_0F			0x0f
#define SPI3BR_REG_PHY0RX			0x10
#define SPI3BR_REG_PHY1RX			0x11
#define SPI3BR_REG_PHY0TX			0x12
#define SPI3BR_REG_PHY1TX			0x13
#define SPI3BR_REG_RSVD_14			0x14
#define SPI3BR_REG_IXPRX_CNTR_HI		0x15
#define SPI3BR_REG_PHY0RX_CNTR_HI	0x16
#define SPI3BR_REG_PHY1RX_CNTR_HI	0x17
#define SPI3BR_REG_IXPRX_CNTR		0x18
#define SPI3BR_REG_PHY0RX_CNTR		0x19
#define SPI3BR_REG_PHY1RX_CNTR		0x1a
#define SPI3BR_REG_IXPTX_CNTR		0x1b
#define SPI3BR_REG_PHY0TX_CNTR		0x1c
#define SPI3BR_REG_PHY1TX_CNTR		0x1d
#define SPI3BR_REG_DEBUG0			0x1e
#define SPI3BR_REG_DEBUG1			0x1f


/******************************************************************************
 *
 *								REGISTER DEFINITIONS
 *
 ******************************************************************************/
/*----------------------------------------------------------------------------*/
/*	0x00	IDLO */
/*----------------------------------------------------------------------------*/
#define SPI3BR_IDLO_VAL		0x31

/*----------------------------------------------------------------------------*/
/*	0x01	IDHI */
/*----------------------------------------------------------------------------*/
#define SPI3BR_IDHI_VAL		0x13

/*----------------------------------------------------------------------------*/
/*	0x02	REVID */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x03	RESET CONTROL REG */
/*----------------------------------------------------------------------------*/
#define SPI3BR_LOGIC_RESET		0x01
#define SPI3BR_GLOBAL_RESET		0x02

/*----------------------------------------------------------------------------*/
/*	0x04	INTREN0 */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_CH1_TX_OVRFLW_INTEN	0x80
#define SPI3BR_PHY1_CH0_TX_OVRFLW_INTEN	0x40
#define SPI3BR_PHY0_CH1_TX_OVERFW_INTEN	0x20
#define SPI3BR_PHY0_CH0_TX_OVERFW_INTEN	0x10
#define SPI3BR_PHY1_CH1_RX_OVRFLW_INTEN	0x08
#define SPI3BR_PHY1_CH0_RX_OVRFLW_INTEN	0x04
#define SPI3BR_PHY0_CH1_RX_OVERFW_INTEN	0x02
#define SPI3BR_PHY0_CH0_RX_OVERFW_INTEN	0x01

/*----------------------------------------------------------------------------*/
/*	0x05	INTREN1 */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_RX_PARITY_INTEN		0x04
#define SPI3BR_PHY0_RX_PARITY_INTEN		0x02
#define SPI3BR_IXP_TX_PARITY_INTEN		0x01

/*----------------------------------------------------------------------------*/
/*	0x06	INTERRUPT STATUS 0 */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_CH1_TX_OVRFLW_INT	0x80
#define SPI3BR_PHY1_CH0_TX_OVRFLW_INT	0x40
#define SPI3BR_PHY0_CH1_TX_OVERFW_INT	0x20
#define SPI3BR_PHY0_CH0_TX_OVERFW_INT	0x10
#define SPI3BR_PHY1_CH1_RX_OVRFLW_INT	0x08
#define SPI3BR_PHY1_CH0_RX_OVRFLW_INT	0x04
#define SPI3BR_PHY0_CH1_RX_OVERFW_INT	0x02
#define SPI3BR_PHY0_CH0_RX_OVERFW_INT	0x01

/*----------------------------------------------------------------------------*/
/*	0x07	INTERRUPT STATUS 1 */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_RX_PARITY_INT		0x04
#define SPI3BR_PHY0_RX_PARITY_INT		0x02
#define SPI3BR_IXP_TX_PARITY_INT			0x01

/*----------------------------------------------------------------------------*/
/*	0x08	PORT ENABLE */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_CH1_TXEN				0x80
#define SPI3BR_PHY1_CH0_TXEN				0x40
#define SPI3BR_PHY0_CH1_TXEN				0x20
#define SPI3BR_PHY0_CH0_TXEN				0x10
#define SPI3BR_PHY1_CH1_RXEN				0x08
#define SPI3BR_PHY1_CH0_RXEN				0x04
#define SPI3BR_PHY0_CH1_RXEN				0x02
#define SPI3BR_PHY0_CH0_RXEN				0x01

/*----------------------------------------------------------------------------*/
/*	0x09	BURST SIZE */
/*----------------------------------------------------------------------------*/
#define SPI3BR_BURST_SIZE_64				0x0
#define SPI3BR_BURST_SIZE_128			0x1
#define SPI3BR_BURST_SIZE_256			0x2

/*----------------------------------------------------------------------------*/
/*	0x0a	PORT PAUSE */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_CH1_PAUS				0x08
#define SPI3BR_PHY1_CH0_PAUS				0x04
#define SPI3BR_PHY0_CH1_PAUS				0x02
#define SPI3BR_PHY0_CH0_PAUS				0x01

/*----------------------------------------------------------------------------*/
/*	0x0b	PORT PAUSED */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY1_CH1_PAUSD			0x08
#define SPI3BR_PHY1_CH0_PAUSD			0x04
#define SPI3BR_PHY0_CH1_PAUSD			0x02
#define SPI3BR_PHY0_CH0_PAUSD			0x01

/*----------------------------------------------------------------------------*/
/*	0x10	PHY0 RX FIFO CONTROL */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x11	PHY1 RX FIFO CONTROL */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x12	PHY0 TX FIFO CONTROL */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x13	PHY1 TX FIFO CONTROL */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x1f	DEBUG1 */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PHY_LOOPBACK_ENABLE		0x40
#define SPI3BR_PHY1_TPRTY_FORCE			0x20
#define SPI3BR_PHY0_TPRTY_FORCE			0x10
#define SPI3BR_IXP_RPRTY_FORCE			0x08



/******************************************************************************
 *
 *							API PARAMETER DEFINITIONS
 *
 ******************************************************************************/
/*----------------------------------------------------------------------------*/
/*	DEVICE ID */
/*----------------------------------------------------------------------------*/
#define SPI3BR_DEVICE_ID					0x1331

/*----------------------------------------------------------------------------*/
/*	INTERRUPT MASK BITS */
/*----------------------------------------------------------------------------*/
#define SPI3BR_IRQ_PHY0_CH0_RX_OVERFW	0x0001
#define SPI3BR_IRQ_PHY0_CH1_RX_OVERFW	0x0002
#define SPI3BR_IRQ_PHY1_CH0_RX_OVRFLW	0x0004
#define SPI3BR_IRQ_PHY1_CH1_RX_OVRFLW	0x0008
#define SPI3BR_IRQ_PHY0_CH0_TX_OVERFW	0x0010
#define SPI3BR_IRQ_PHY0_CH1_TX_OVERFW	0x0020
#define SPI3BR_IRQ_PHY1_CH0_TX_OVRFLW	0x0040
#define SPI3BR_IRQ_PHY1_CH1_TX_OVRFLW	0x0080
#define SPI3BR_IRQ_IXP_TX_PARITY			0x0100
#define SPI3BR_IRQ_PHY0_RX_PARITY		0x0200
#define SPI3BR_IRQ_PHY1_RX_PARITY		0x0400
#define SPI3BR_IRQ_ALL					0x07FF

/*----------------------------------------------------------------------------*/
/*	PORT MODES */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PORTMODE_OFF				0x0
#define SPI3BR_PORTMODE_RXONLY			0x1
#define SPI3BR_PORTMODE_TXONLY			0x2
#define SPI3BR_PORTMODE_RXANDTX			0x3


/*----------------------------------------------------------------------------*/
/*	BURST SIZES */
/*----------------------------------------------------------------------------*/
#define SPI3BR_BURSTSIZE_64				0x0
#define SPI3BR_BURSTSIZE_128				0x1
#define SPI3BR_BURSTSIZE_256				0x2


/*----------------------------------------------------------------------------*/
/*	PORTMASK BITS */
/*----------------------------------------------------------------------------*/
#define SPI3BR_PORTMASK_0				0x01
#define SPI3BR_PORTMASK_1				0x02
#define SPI3BR_PORTMASK_2				0x04
#define SPI3BR_PORTMASK_3				0x08
#define SPI3BR_PORTMASK_ALL				0x0F


/*----------------------------------------------------------------------------*/
/*	FIFO THRESHOLD VALUES */
/*----------------------------------------------------------------------------*/
#define SPI3BR_RX_THSHLD_0				0x0
#define SPI3BR_RX_THSHLD_64				0x1
#define SPI3BR_RX_THSHLD_128				0x2
#define SPI3BR_RX_THSHLD_256				0x3

#define SPI3BR_TX_THSHLD_0				0x0
#define SPI3BR_TX_THSHLD_64				0x1
#define SPI3BR_TX_THSHLD_128				0x2
#define SPI3BR_TX_THSHLD_256				0x3


/*----------------------------------------------------------------------------*/
/*	DBG PARITY TYPES */
/*----------------------------------------------------------------------------*/
#define SPI3BR_DBG_IXP_RPRTY				0x0
#define SPI3BR_DBG_PHY0_TPRTY			0x1
#define SPI3BR_DBG_PHY1_TPRTY			0x2



/******************************************************************************
 *
 *										API
 *
 ******************************************************************************/
UINT8
spi3brRead( UINT8 *p, UINT8 reg );

void
spi3brWrite( UINT8 *p, UINT8 reg, UINT8 data );

UINT16
spi3brGetChipID( UINT8 *p );

UINT8
spi3brGetChipRev( UINT8 *p );

void
spi3brResetGlobal( UINT8 *p );

void
spi3brResetLogic( UINT8 *p );

void
spi3brSetIE( UINT8 *p, UINT16 mask );

void
spi3brClrIE( UINT8 *p, UINT16 mask );

UINT16
spi3brGetIE( UINT8 *p );

UINT16
spi3brGetIV( UINT8 *p );

void
spi3brClrIV( UINT8 *p, UINT16 mask );

void
spi3brSetPortEnable(UINT8 *p, UINT8 port, UINT8 mode );

void
spi3brSetPortEnableAll( UINT8 *p, UINT8 mode );

UINT8
spi3brGetPortEnable( UINT8 *p, UINT8 port );

void
spi3brSetBurstSize( UINT8 *p, UINT8 val );

UINT8
spi3brGetBurstSize( UINT8 *p );

void
spi3brSetPortPaus( UINT8 *p, UINT8 port );

void
spi3brSetPortPausAll( UINT8 *p );

void
spi3brClrPortPaus( UINT8 *p, UINT8 port );

void
spi3brClrPortPausAll( UINT8 *p );

UINT8
spi3brGetPortPaus( UINT8 *p, UINT8 port );

UINT8
spi3brGetPortPausAll( UINT8 *p );

UINT8
spi3brGetPortPausd( UINT8 *p, UINT8 port );

UINT8
spi3brGetPortPausdAll( UINT8 *p );

void
spi3brSetPortRxThshld( UINT8 *p, UINT8 port, UINT8 thshld );

void
spi3brSetPortRxThshldAll( UINT8 *p, UINT8 thshld );

UINT8
spi3brGetPortRxThshld( UINT8 *p, UINT8 port );

void
spi3brSetPortTxThshld( UINT8 *p, UINT8 port, UINT8 thshld );

void
spi3brSetPortTxThshldAll( UINT8 *p, UINT8 thshld );

UINT8
spi3brGetPortTxThshld( UINT8 *p, UINT8 port );

UINT16
spi3brGetIXPRxCount(UINT8 *p);

UINT16
spi3brGetPhy0RxCount(UINT8 *p);

UINT16
spi3brGetPhy1RxCount(UINT8 *p);

UINT8
spi3brGetIXPTxCount(UINT8 *p);

UINT8
spi3brGetPhy0TxCount(UINT8 *p);

UINT8
spi3brGetPhy1TxCount(UINT8 *p);

void
spi3brDbgSetIrq( UINT8 *p, UINT16 mask );

void
spi3brDbgClrIrq( UINT8 *p, UINT16 mask );

void
spi3brDbgSetLoopback( UINT8 *p );

void
spi3brDbgClrLoopback( UINT8 *p );

void
spi3brDbgSetParityErr( UINT8 *p, UINT8 type );

void
spi3brDbgClrParityErr( UINT8 *p, UINT8 type );

void
spi3brShow(UINT8 *p);

void
spi3brInit( UINT8 *p );

#endif /*__SPI3BR_H__*/
