/******************************************************************************
 *
 *	spi3br_linux.h
 *	-------------
 *	Header file for SPI-3 bridge linux device driver
 *
 ******************************************************************************
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/

#ifndef __SPI3BR_LINUX_H__
#define __SPI3BR_LINUX_H__

#include "enpv2_types.h"

#define READ_BYTE(addr) *((char *)(((void *)(addr))))
#define READ_LWORD(addr) *((unsigned int *)(((void *)(addr))))
#define WRITE_LWORD(addr, val) *((volatile unsigned int *)(((void *)(addr)))) = (val)

/******************************************************************************
 *	DATA TYPES
 ******************************************************************************/
typedef int SPI3BR_STATUS;

typedef int SPI3BR_HANDLE;

typedef struct
{
	UINT8	port;
	UINT8	val;
}
SPI3BR_CHAN_CFG;


/******************************************************************************
 *	RETURN STATUS DEFINITIONS
 ******************************************************************************/
#define SPI3BR_SUCCESS								0
#define SPI3BR_INVALID_USR_HANDLER					1
#define SPI3BR_INSUFFICIENT_RESOURCES				2
#define SPI3BR_DEVICE_NOT_FOUND						3
#define SPI3BR_INVALID_OPERATION					4
#define SPI3BR_INVALID_ARG							5

/*
 *	IOCTL Data structures
 */

typedef struct
{
	UINT8	idlo;
	UINT8	idhi;
	UINT8	rev;
	UINT8	reset;
	UINT8	intren0;
	UINT8	intren1;
	UINT8	intrstat0;
	UINT8	intrstat1;
	UINT8	porten;
	UINT8	burstsize;
	UINT8	portpaus;
	UINT8	portpausd;
	UINT8	rsvd_0c;
	UINT8	rsvd_0d;
	UINT8	rsvd_0e;
	UINT8	rsve_0f;
	UINT8	phy0rx;
	UINT8	phy1rx;
	UINT8	phy0tx;
	UINT8	phy1tx;
	UINT8	rsvd_14;
	UINT8	ixprxcnthi;
	UINT8	phy0rxcnthi;
	UINT8	phy1rxcnthi;
	UINT8	ixprxcnt;
	UINT8	phy0rxcnt;
	UINT8	phy1rxcnt;
	UINT8	ixptxcnt;
	UINT8	phy0txcnt;
	UINT8	phy1txcnt;
	UINT8	debug0;
	UINT8	debug1;
}
SPI3BR_REGS;



/*
 *	IOCTL COMMAND DEFINITIONS
 *
 */

#define SPI3BR_IOCTL_MAGIC                         0xAD


#define SPI3BR_IOCTL_GET_CHIP_ID					_IOR(SPI3BR_IOCTL_MAGIC, 0, UINT16)
#define SPI3BR_IOCTL_GET_CHIP_REV					_IOR(SPI3BR_IOCTL_MAGIC, 1, UINT16)
#define SPI3BR_IOCTL_RESET_GLOBAL					_IO(SPI3BR_IOCTL_MAGIC, 2)
#define SPI3BR_IOCTL_RESET_LOGIC					_IO(SPI3BR_IOCTL_MAGIC, 3)
#define SPI3BR_IOCTL_SET_INT_EN						_IOR(SPI3BR_IOCTL_MAGIC, 4, UINT16)
#define	SPI3BR_IOCTL_CLR_INT_EN						_IOR(SPI3BR_IOCTL_MAGIC, 5, UINT16)
#define SPI3BR_IOCTL_GET_INT_EN						_IOR(SPI3BR_IOCTL_MAGIC, 6, UINT16)
#define SPI3BR_IOCTL_GET_INT_STTS					_IOR(SPI3BR_IOCTL_MAGIC, 7, UINT16)
#define SPI3BR_IOCTL_SET_PORT_EN					_IOR(SPI3BR_IOCTL_MAGIC, 8, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_GET_PORT_EN					_IOR(SPI3BR_IOCTL_MAGIC, 9, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_SET_BURST_SIZE					_IOR(SPI3BR_IOCTL_MAGIC, 10, UINT8)
#define SPI3BR_IOCTL_GET_BURST_SIZE					_IOR(SPI3BR_IOCTL_MAGIC, 11, UINT8)
#define SPI3BR_IOCTL_SET_PORT_PAUS					_IOR(SPI3BR_IOCTL_MAGIC, 12, UINT8)
#define SPI3BR_IOCTL_CLR_PORT_PAUS					_IOR(SPI3BR_IOCTL_MAGIC, 13, UINT8)
#define SPI3BR_IOCTL_GET_PORT_PAUS					_IOR(SPI3BR_IOCTL_MAGIC, 14, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_GET_PORT_PAUSD					_IOR(SPI3BR_IOCTL_MAGIC, 15, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_SET_RX_FIFO_CTL				_IOR(SPI3BR_IOCTL_MAGIC, 16, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_GET_RX_FIFO_CTL				_IOR(SPI3BR_IOCTL_MAGIC, 17, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_SET_TX_FIFO_CTL				_IOR(SPI3BR_IOCTL_MAGIC, 18, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_GET_TX_FIFO_CTL				_IOR(SPI3BR_IOCTL_MAGIC, 19, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_DBG_SET_LOOPBACK_MODE			_IO(SPI3BR_IOCTL_MAGIC, 20)
#define SPI3BR_IOCTL_DBG_CLR_LOOPBACK_MODE			_IO(SPI3BR_IOCTL_MAGIC, 21)
#define SPI3BR_IOCTL_DBG_SET_REG					_IOR(SPI3BR_IOCTL_MAGIC, 22, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_DBG_GET_REG					_IOR(SPI3BR_IOCTL_MAGIC, 23, SPI3BR_CHAN_CFG)
#define SPI3BR_IOCTL_DBG_DUMP						_IO(SPI3BR_IOCTL_MAGIC, 24)



#endif /*__SPI3BR_LINUX_H__*/
