/******************************************************************************
 *
 *	pm3386_vxworks.h
 *	----------------
 *	Header file for pm3386 vxworks device driver API.  
 *
 ******************************************************************************
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/
#ifndef __PM3386_VXWORKS_H__
#define __PM3386_VXWORKS_H__

#include "enpv2_types.h"
#include "pm3386_defs.h"


/******************************************************************************
 *	API DEFINITIONS
 ******************************************************************************/
/* return status definitions */
#define	PM3386_SUCCESS					0
#define PM3386_INVALID_ARG				1
#define PM3386_DEVICE_NOT_FOUND			2
#define PM3386_INSUFFICIENT_RESOURCES	3
#define PM3386_INVALID_OPERATION		4

/* devices availabe for open */
#define PM3386_DEV0						0
#define PM3386_DEV1						1

/* IOCTL Commands */
#define PM3386_IOCTL_DEV_GET_ID									0
#define PM3386_IOCTL_DEV_GET_REV								1
#define PM3386_IOCTL_DEV_RESET									2
#define PM3386_IOCTL_DEV_GET_INT_STTS							3
#define PM3386_IOCTL_DEV_GET_DEV_STTS							4
#define PM3386_IOCTL_DEV_GET_ROOL_STTS							5
#define PM3386_IOCTL_DEV_GET_DOOL_STTS							6
#define PM3386_IOCTL_PL3IP_SET_EQ_MODE							11
#define PM3386_IOCTL_PL3IP_GET_EQ_MODE							12
#define PM3386_IOCTL_PL3IP_SET_PMODE							13
#define PM3386_IOCTL_PL3IP_GET_PMODE							14
#define PM3386_IOCTL_PL3IP_SET_EQ_TSHLD							15
#define PM3386_IOCTL_PL3IP_GET_EQ_TSHLD							16
#define PM3386_IOCTL_PL3IP_SET_EQ_DIFF							17
#define PM3386_IOCTL_PL3IP_GET_EQ_DIFF							18
#define PM3386_IOCTL_PL3IP_SET_CHAN_HI_WATER					19
#define PM3386_IOCTL_PL3IP_GET_CHAN_HI_WATER					20
#define PM3386_IOCTL_PL3IP_SET_CHAN_LO_WATER					21
#define PM3386_IOCTL_PL3IP_GET_CHAN_LO_WATER					22
#define PM3386_IOCTL_PL3IP_SET_CHAN_PKT_BURST					23
#define PM3386_IOCTL_PL3IP_GET_CHAN_PKT_BURST					24
#define PM3386_IOCTL_PL3EP_SET_CHAN_FIFO_RSV					28
#define PM3386_IOCTL_PL3EP_GET_CHAN_FIFO_RSV					29
#define PM3386_IOCTL_PL3EP_SET_CHAN_MIN_FRAME					30
#define PM3386_IOCTL_PL3EP_GET_CHAN_MIN_FRAME					31
#define PM3386_IOCTL_EGMAC_SET_L32B								33
#define PM3386_IOCTL_EGMAC_GET_L32B								34
#define PM3386_IOCTL_EGMAC_SET_L10B								35
#define PM3386_IOCTL_EGMAC_GET_L10B								36
#define PM3386_IOCTL_EGMAC_SET_PADEN							37
#define PM3386_IOCTL_EGMAC_GET_PADEN							38
#define PM3386_IOCTL_EGMAC_SET_CRCEN							39
#define PM3386_IOCTL_EGMAC_GET_CRCEN							40
#define PM3386_IOCTL_EGMAC_SET_FCTX								41
#define PM3386_IOCTL_EGMAC_GET_FCTX								42
#define PM3386_IOCTL_EGMAC_SET_FCRX								43
#define PM3386_IOCTL_EGMAC_GET_FCRX								44
#define PM3386_IOCTL_EGMAC_SET_LONGP							45
#define PM3386_IOCTL_EGMAC_GET_LONGP							46
#define PM3386_IOCTL_EGMAC_SET_RXEN								47
#define PM3386_IOCTL_EGMAC_GET_RXEN								48
#define PM3386_IOCTL_EGMAC_SET_TXEN								49
#define PM3386_IOCTL_EGMAC_GET_TXEN								50
#define PM3386_IOCTL_EGMAC_SET_IPG								51
#define PM3386_IOCTL_EGMAC_GET_IPG								52
#define PM3386_IOCTL_EGMAC_SET_STN_ADDR							54
#define PM3386_IOCTL_EGMAC_GET_STN_ADDR							55
#define PM3386_IOCTL_EGMAC_SET_MAX_RX_FRAME						56
#define PM3386_IOCTL_EGMAC_GET_MAX_RX_FRAME						57
#define PM3386_IOCTL_EGMAC_RESTART_AN							58
#define PM3386_IOCTL_EGMAC_SET_AN_EN							59
#define PM3386_IOCTL_EGMAC_GET_AN_EN							60
#define PM3386_IOCTL_EGMAC_GET_AN_STTS							61
#define PM3386_IOCTL_EGMAC_SET_AN_ADV_LO						62
#define PM3386_IOCTL_EGMAC_GET_AN_ADV_LO						63
#define PM3386_IOCTL_EGMAC_SET_AN_ADV_HI						64
#define PM3386_IOCTL_EGMAC_GET_AN_ADV_HI						65
#define PM3386_IOCTL_EGMAC_GET_AN_LINK_LO						66
#define PM3386_IOCTL_EGMAC_GET_AN_LINK_HI						67
#define PM3386_IOCTL_EGMAC_SET_HOST_PAUSE						68
#define PM3386_IOCTL_EGMAC_GET_HOST_PAUSE						69
#define PM3386_IOCTL_EGMAC_SET_PASS_ERR							70
#define PM3386_IOCTL_EGMAC_GET_PASS_ERR							71
#define PM3386_IOCTL_EGMAC_SET_PASS_CTRL						72
#define PM3386_IOCTL_EGMAC_GET_PASS_CTRL						73
#define PM3386_IOCTL_EGMAC_SET_PAUSE_TIME						74
#define PM3386_IOCTL_EGMAC_GET_PAUSE_TIME						75
#define PM3386_IOCTL_EGMAC_SET_PAUSE_IVAL						76
#define PM3386_IOCTL_EGMAC_GET_PAUSE_IVAL						77
#define PM3386_IOCTL_EGMAC_SET_MAX_TX_FRAME						78
#define PM3386_IOCTL_EGMAC_GET_MAX_TX_FRAME						79
#define PM3386_IOCTL_EGMAC_SET_RX_FWD_TSHLD						80
#define PM3386_IOCTL_EGMAC_GET_RX_FWD_TSHLD						81
#define PM3386_IOCTL_EGMAC_SET_ADDR_MATCH						82
#define PM3386_IOCTL_EGMAC_GET_ADDR_MATCH						83
#define PM3386_IOCTL_EGMAC_SET_VID_MATCH						84
#define PM3386_IOCTL_EGMAC_GET_VID_MATCH						85
#define PM3386_IOCTL_EGMAC_SET_MHASH							86
#define PM3386_IOCTL_EGMAC_GET_MHASH							87
#define PM3386_IOCTL_EGMAC_SET_ADDR_FILT_CTRL					88
#define PM3386_IOCTL_EGMAC_GET_ADDR_FILT_CTRL					89
#define PM3386_IOCTL_EGMAC_SET_MHASH_EN							90
#define PM3386_IOCTL_EGMAC_GET_MHASH_EN							91
#define PM3386_IOCTL_EGMAC_SET_PMODE							92
#define PM3386_IOCTL_EGMAC_GET_PMODE							93
#define PM3386_IOCTL_MSTAT_SNAP									95
#define PM3386_IOCTL_MSTAT_CLEAR								96
#define PM3386_IOCTL_MSTAT_WRITE_CNTR							97
#define PM3386_IOCTL_MSTAT_GET_ROLLOVER							98
#define PM3386_IOCTL_MSTAT_SET_INT_MASK							99
#define PM3386_IOCTL_MSTAT_GET_INT_MASK							100
#define PM3386_IOCTL_MSTAT_READ_CNTR							101
#define PM3386_IOCTL_MSTAT_READ_ALL_COUNTERS					102
#define PM3386_IOCTL_SERDES_SET_SYS_LPBK						105
#define PM3386_IOCTL_SERDES_GET_SYS_LPBK						106
#define PM3386_SET_INT_ENABLE									109
#define PM3386_GET_INT_ENABLE									110
#define PM3386_CLR_INT_ENABLE									111

/* hide */
#define PM3386_IOCTL_GET_REG									7
#define PM3386_IOCTL_SET_REG									8
#define PM3386_IOCTL_PL3IP_APPLY_CHAN_UPDATE					25
#define PM3386_IOCTL_PL3EP_CH_APPLY_UPDATE						32
#define EGMAC_APPLY_UPDATE										53
#define PM3386_IOCTL_EGMAC_UPDATE_FLTR_CTRL						94


/* delete */
#define PM3386_IOCTL_PL3IP_SET_INT_MASK							9
#define PM3386_IOCTL_PL3IP_GET_INT_MASK							10
#define PM3386_IOCTL_PL3EP_SET_INT_MASK							26
#define PM3386_IOCTL_PL3EP_GET_INT_MASK							27
#define PM3386_IOCTL_SERDES_SET_INT_MASK						103
#define PM3386_IOCTL_SERDES_GET_INT_MASK						104
#define PM3386_IOCTL_SERDES_ENABLE								107
#define PM3386_IOCTL_SERDES_DISABLE								108


/******************************************************************************
 *	DATA TYPES
 ******************************************************************************/
typedef int PM3386_STATUS;
typedef int PM3386_HANDLE;


/******************************************************************************
 *	API
 ******************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

PM3386_STATUS pm3386ModuleStart( void );

PM3386_STATUS pm3386ModuleStop( void );

PM3386_STATUS pm3386DeviceOpen( int device, PM3386_HANDLE *handle );

PM3386_STATUS pm3386DeviceClose( PM3386_HANDLE handle );

PM3386_STATUS pm3386InstallUsrHandler( PM3386_HANDLE handle, 
									   void *usrCtxt,
									   void (*usrHandler)(void *usrCtxt, PM3386_INTERRUPTS *pIntStatus) );

PM3386_STATUS pm3386RemoveUsrHandler( PM3386_HANDLE handle );

PM3386_STATUS pm3386DeviceIoctl( PM3386_HANDLE handle, int cmd, void *arg );

#ifdef __cplusplus
}
#endif

#endif /*__PM3386_VXWORKS_H__*/
