/******************************************************************************
 *
 *	pm338_util.h
 *	------------
 *	Header file for pm3386 device driver functions
 *
 ******************************************************************************
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/

#ifndef __PM3386_UTIL_H__
#define __PM3386_UTIL_H__

#include "enpv2_types.h"
#include "pm3386_defs.h"
#include "pm3386_linux.h"

/******************************************************************************
 *
 *							 Read/Write Macros
 *
 ******************************************************************************/

#define PM3386_RD(pbase, offset) \
	*( ((volatile UINT16 *)pbase) + ((UINT16)offset) )

#define PM3386_WR(pbase, offset, value) \
 	*( ((volatile UINT16 *)pbase) + ((UINT16)offset) ) = ((UINT16)value)

/******************************************************************************
 *
 *							 	Data Types
 *
 ******************************************************************************/
/* Device initialization structure */
typedef struct
{
	UINT8	pl3ipEqTxModeEn;
    UINT8	pl3ipPar;
    UINT8   pl3ipTransferGap;
    UINT8	pl3ipPauseMode;
    UINT8   pl3ipEqTshldLimit;
    UINT8	pl3ipEqDiffLimit;
    UINT8	pl3ipChHiWaterMark;
    UINT8	pl3ipChLoWaterMark;
    UINT8	pl3ipChPktBurstMax;

    UINT8	pl3epParEn;
    UINT8	pl3epPar;
    UINT8	pl3epChFifoRsv;
    UINT8	pl3epChMinFrameSize;

    UINT8	egmacMiiMode;
    UINT8	egmacPadEn;
    UINT8	egmacCrcEn;
    UINT8	egmacFlchk;
    UINT8	egmacPurp;
    UINT8	egmacFctx;
    UINT8	egmacFcrx;
    UINT8	egmacLongp;
    UINT8	egmacIpg;
    UINT8	egmacSpre;
    UINT8	egmacAutos;
    UINT16	egmacRxMaxFrame;
    UINT8	egmacAnEn;
    UINT16	egmacAnAdvLo;
    UINT16	egmacAnADvHi;
    UINT8	egmacPassCtrl;
    UINT8	egmacPassErr;
    UINT16	egmacPauseTime;
    UINT16	egmacPauseIval;
    UINT16	egmacTxMaxFrame;
    UINT16	egmacRxfifoFwdTshld;
	UINT8	egmacPmode;
	UINT8	egmacMhashEn;
}
PM3386_INITS;



/*
 *	Function Prototypes
 */

void pm3386Delay( UINT32 mSec );
void pm3386ConvertMacAddr2Regs( UINT8 *pMacAddr, UINT16 *pRegs );
void pm3386ConvertRegs2MacAddr( UINT16 *pRegs, UINT8 *pMacAddr );



void pm3386GetDevID( UINT16 *pBaseAddr, UINT16 *id );
void pm3386GetDevRev( UINT16 *pBaseAddr, UINT16 *rev );
void pm3386ResetDev( UINT16 *pBaseAddr );
void pm3386GetDevIntStts( UINT16 *pBaseAddr, UINT16 *val );
void pm3386GetDevStts( UINT16 *pBaseAddr, UINT16 *val );
void pm3386GetDevRoolStts( UINT16 *pBaseAddr, UINT16 *val );
void pm3386GetDevDoolStts( UINT16 *pBaseAddr, UINT16 *val );
void pm3386SetPl3ipIntMask( UINT16 *pBaseAddr, UINT16 mask );
void pm3386GetPl3ipIntMask( UINT16 *pBaseAddr, UINT16 *mask );
void pm3386SetEqMode( UINT16 *pBaseAddr, UINT16 enable );
void pm3386GetEqMode( UINT16 *pBaseAddr, UINT16 *enable );
void pm3386SetPmode( UINT16 *pBaseAddr, UINT16 mode );
void pm3386GetPmode( UINT16 *pBaseAddr, UINT16 *mode );
void pm3386SetEqTshld( UINT16 *pBaseAddr, UINT16 tshld );
void pm3386GetEqTshld( UINT16 *pBaseAddr, UINT16 *tshld );
void pm3386SetEqDiff( UINT16 *pBaseAddr, UINT16 diff );
void pm3386GetEqDiff( UINT16 *pBaseAddr, UINT16 *diff );
void pm3386SetPl3ipChanHiWater( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPl3ipChanHiWater( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetPl3ipChanLoWater( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPl3ipChanLoWater( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetPl3ipChanPktBurst( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPl3ipChanPktBurst( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386Pl3ipApplyChanUpdate( UINT16 *pBaseAddr );
void pm3386SetPl3epIntMask( UINT16 *pBaseAddr, UINT16 mask );
void pm3386GetPl3epIntMask( UINT16 *pBaseAddr, UINT16 *mask );
void pm3386SetPl3epChanFifoRsv( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPl3epChanFifoRsv( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetPl3epChanMinFrame( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPl3epChanMinFrame( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386Pl3epApplyChanUpdate( UINT16 *pBaseAddr, UINT16 channel );
void pm3386SetEgmacL32b( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetEgmacL32b( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetEgmacL10b( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetEgmacL10b( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetEgmacPaden( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetEgmacPaden( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetEgmacCrcen( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetEgmacCrcen( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetFctx( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetFctx( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetFcrx( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetFcrx( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetLongp( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetLongp( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetRxEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetRxEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetTxEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetTxEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetEgmacIpg( UINT16 *pBaseAddr, UINT16 channel, UINT16 ipg );
void pm3386GetEgmacIpg( UINT16 *pBaseAddr, UINT16 channel, UINT16 *ipg );
void pm3386SetStnAddr( UINT16 *pBaseAddr, UINT16 channel, UINT8 *pMacAddr );
void pm3386GetStnAddr( UINT16 *pBaseAddr, UINT16 channel, UINT8 *pMacAddr );
void pm3386SetMaxRxFrame( UINT16 *pBaseAddr, UINT16 channel, UINT16 maxLen );
void pm3386GetMaxRxFrame( UINT16 *pBaseAddr, UINT16 channel, UINT16 *maxLen );
void pm3386RestartAn( UINT16 *pBaseAddr, UINT16 channel );
void pm3386SetAnEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetAnEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386GetAnStatus( UINT16 *pBaseAddr, UINT16 channel, UINT16 *status );
void pm3386SetAnAdvLo( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetAnAdvLo( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetAnAdvHi( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetAnAdvHi( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386GetAnLinkLo( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386GetAnLinkHi( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetHostPause( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetHostPause( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetPassErr( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetPassErr( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetPassCtrl( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetPassCtrl( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetPauseTime( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPauseTime( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetPauseIval( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetPauseIval( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetMaxTxFrame( UINT16 *pBaseAddr, UINT16 channel, UINT16 maxLen );
void pm3386GetMaxTxFrame( UINT16 *pBaseAddr, UINT16 channel, UINT16 *maxLen );
void pm3386SetRxFifoFwdTshld( UINT16 *pBaseAddr, UINT16 channel, UINT16 tshld );
void pm3386GetRxFifoFwdTshld( UINT16 *pBaseAddr, UINT16 channel, UINT16 *tshld );
void pm3386SetAddrMatch( UINT16 *pBaseAddr, UINT16 channel, UINT16 num, UINT8 *pMacAddr );
void pm3386GetAddrMatch( UINT16 *pBaseAddr, UINT16 channel, UINT16 num, UINT8 *pMacAddr );
void pm3386SetVidMatch( UINT16 *pBaseAddr, UINT16 channel, UINT16 num, UINT16 val );
void pm3386GetVidMatch( UINT16 *pBaseAddr, UINT16 channel, UINT16 num, UINT16 *vid );
void pm3386SetMhash( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386GetMhash( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetAddrFltrCtrl( UINT16 *pBaseAddr, UINT16 channel, UINT16 num, UINT16 val );
void pm3386GetAddrFltrCtrl( UINT16 *pBaseAddr, UINT16 channel, UINT16 num, UINT16 *val );
void pm3386SetMhashEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetMhashEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetPmodeEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetPmodeEn( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386UpdateFltrCtrl( UINT16* pBaseAddr, UINT16 channel );
void pm3386MstatSnap( UINT16 *pBaseAddr, UINT16 channel);
void pm3386MstatClear( UINT16* pBaseAddr, UINT16 channel );
void pm3386MstatWriteCntr( UINT16* pBaseAddr, UINT16 channel, UINT16 CntrNum, UINT64 val );
void pm3386MstatGetRollover( UINT16* pBaseAddr, UINT16 channel, UINT64 *val );
void pm3386MstatSetIntMask( UINT16* pBaseAddr, UINT16 channel, UINT64 val );
void pm3386MstatGetIntMask( UINT16* pBaseAddr, UINT16 channel, UINT64 *val );
void pm3386MstatReadCntr( UINT16* pBaseAddr, UINT16 channel, UINT16 cntr, UINT64 *val );
void pm3386MstatReadAllCntr( UINT16* pBaseAddr, UINT16 channel, UINT64 *val );
void pm3386SetSerdesIntMask( UINT16 *pBaseAddr, UINT16 channel, UINT16 val );
void pm3386GetSerdesIntMask( UINT16 *pBaseAddr, UINT16 channel, UINT16 *val );
void pm3386SetSerdesSysLoopback( UINT16 *pBaseAddr, UINT16 channel, UINT16 enable );
void pm3386GetSerdesSysLoopback( UINT16 *pBaseAddr, UINT16 channel, UINT16 *enable );
void pm3386SetIntEnable( UINT16 *pBaseAddr, int maxChan, PM3386_INTERRUPTS *pIntMask );
void pm3386GetIntEnable( UINT16 *pBaseAddr, int maxChan, PM3386_INTERRUPTS *pIntMask );
void pm3386ClrIntEnable( UINT16 *pBaseAddr, int maxChan, PM3386_INTERRUPTS *pIntMask );
void pm3386GetIntEvents( UINT16 *pBaseAddr, int maxChan, PM3386_INTERRUPTS *pIntStatus );

void pm3386ConvertMacAddr2Regs( UINT8 *pMacAddr, UINT16 *pRegs );
void pm3386ConvertRegs2MacAddr( UINT16 *pRegs, UINT8 *pMacAddr );
void pm3386SetBit( UINT16 *pBaseAddr, UINT16 offset, UINT16 mask );
void pm3386ClrBit( UINT16 *pBaseAddr, UINT16 offset, UINT16 mask );
UINT8 pm3386ChkBit( UINT16 *pBaseAddr, UINT16 offset, UINT16 mask );

UINT32 pm3386InitDevice( UINT16 *pBaseAddr, UINT8 maxChannels, PM3386_INITS *pDevInit );
int pm3386ForceNarrowBandLock( UINT16 *pBaseAddr, UINT16 channel );
int pm3386VerifyNarrowBandLock( UINT16 *pBaseAddr, UINT16 channel );

#endif /*__PM3386_UTIL_H__*/

