/******************************************************************************
 *
 *	pm3386_linux.h
 *	----------------
 *	Header file for pm3386 linux device driver API.
 *
 ******************************************************************************
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/
#ifndef __PM3386_LINUX_H__
#define __PM3386_LINUX_H__

#include "pm3386_defs.h"

/* return status definitions */
#define PM3386_SUCCESS                                  0
#define PM3386_INVALID_ARG                              1
#define PM3386_DEVICE_NOT_FOUND                 2
#define PM3386_INSUFFICIENT_RESOURCES   3
#define PM3386_INVALID_OPERATION                4

/* devices availabe for open */
#define PM3386_DEV0                                             0
#define PM3386_DEV1                                             1

/* device info */
#define PM3386_BASE_0					0xC6000000
#define PM3386_BASE_1					0xC6400000
#define PM3386_REG_BANK_SIZE				0x00400000

/******************************************************************************
 *
 *							 	Data Types
 *
 ******************************************************************************/

typedef int PM3386_STATUS;
typedef int PM3386_HANDLE;

typedef struct
{
	UINT16	chan;
	UINT16	val;
}
PM3386_CHAN_CFG;


typedef struct
{
	UINT16	chan;
	UINT8	macAddr[6];
}
PM3386_CHAN_MAC_ADDR;


typedef struct
{
	UINT16	chan;
	UINT16	num;
	UINT8	macAddr[6];
}
PM3386_CHAN_AMATCH;


typedef struct
{
	UINT16	chan;
	UINT16	num;
	UINT16	vid;
}
PM3386_CHAN_VMATCH;


typedef struct
{
	UINT16	chan;
	UINT64	mhash;
}
PM3386_CHAN_MHASH;


typedef struct
{
	UINT16	chan;
	UINT16	num;
	UINT16	val;
}
PM3386_CHAN_FLTR_CTRL;


typedef struct
{
	UINT16	chan;
	UINT16	num;
	UINT64	cntr;
}
PM3386_CHAN_CNTR;


typedef struct
{
	UINT16	chan;
	UINT64	stats[PM3386_MAX_CNTRS];
}
PM3386_CHAN_STATS;


typedef struct
{
	UINT32	interface;
	UINT64	mstat0;
	UINT64	mstat1;
}
PM3386_INTERRUPTS;

/******************************************************************************
 *	API DEFINITIONS
 ******************************************************************************/
#define PM3386_IOCTL_MAGIC                      0xAC

/* IOCTL Commands */
#define PM3386_IOCTL_DEV_GET_ID					_IOR(PM3386_IOCTL_MAGIC, 0, UINT16)
#define PM3386_IOCTL_DEV_GET_REV				_IOR(PM3386_IOCTL_MAGIC, 1, UINT16)
#define PM3386_IOCTL_DEV_RESET					_IO(PM3386_IOCTL_MAGIC, 2)
#define PM3386_IOCTL_DEV_GET_INT_STTS			_IOR(PM3386_IOCTL_MAGIC, 3, UINT16)
#define PM3386_IOCTL_DEV_GET_DEV_STTS			_IOR(PM3386_IOCTL_MAGIC, 4, UINT16)
#define PM3386_IOCTL_DEV_GET_ROOL_STTS			_IOR(PM3386_IOCTL_MAGIC, 5, UINT16)
#define PM3386_IOCTL_DEV_GET_DOOL_STTS			_IOR(PM3386_IOCTL_MAGIC, 6, UINT16)
#define PM3386_IOCTL_PL3IP_SET_EQ_MODE			_IOR(PM3386_IOCTL_MAGIC, 11, UINT16)
#define PM3386_IOCTL_PL3IP_GET_EQ_MODE			_IOR(PM3386_IOCTL_MAGIC, 12, UINT16)
#define PM3386_IOCTL_PL3IP_SET_PMODE			_IOR(PM3386_IOCTL_MAGIC, 13, UINT16)
#define PM3386_IOCTL_PL3IP_GET_PMODE			_IOR(PM3386_IOCTL_MAGIC, 14, UINT16)
#define PM3386_IOCTL_PL3IP_SET_EQ_TSHLD			_IOR(PM3386_IOCTL_MAGIC, 15, UINT16)
#define PM3386_IOCTL_PL3IP_GET_EQ_TSHLD			_IOR(PM3386_IOCTL_MAGIC, 16, UINT16)
#define PM3386_IOCTL_PL3IP_SET_EQ_DIFF			_IOR(PM3386_IOCTL_MAGIC, 17, UINT16)
#define PM3386_IOCTL_PL3IP_GET_EQ_DIFF			_IOR(PM3386_IOCTL_MAGIC, 18, UINT16)
#define PM3386_IOCTL_PL3IP_SET_CHAN_HI_WATER	_IOR(PM3386_IOCTL_MAGIC, 19, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3IP_GET_CHAN_HI_WATER	_IOR(PM3386_IOCTL_MAGIC, 20, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3IP_SET_CHAN_LO_WATER	_IOR(PM3386_IOCTL_MAGIC, 21, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3IP_GET_CHAN_LO_WATER	_IOR(PM3386_IOCTL_MAGIC, 22, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3IP_SET_CHAN_PKT_BURST	_IOR(PM3386_IOCTL_MAGIC, 23, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3IP_GET_CHAN_PKT_BURST	_IOR(PM3386_IOCTL_MAGIC, 24, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3EP_SET_CHAN_FIFO_RSV	_IOR(PM3386_IOCTL_MAGIC, 28, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3EP_GET_CHAN_FIFO_RSV	_IOR(PM3386_IOCTL_MAGIC, 29, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3EP_SET_CHAN_MIN_FRAME	_IOR(PM3386_IOCTL_MAGIC, 30, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3EP_GET_CHAN_MIN_FRAME	_IOR(PM3386_IOCTL_MAGIC, 31, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_L32B				_IOR(PM3386_IOCTL_MAGIC, 33, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_L32B				_IOR(PM3386_IOCTL_MAGIC, 34, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_L10B				_IOR(PM3386_IOCTL_MAGIC, 35, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_L10B				_IOR(PM3386_IOCTL_MAGIC, 36, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_PADEN			_IOR(PM3386_IOCTL_MAGIC, 37, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_PADEN			_IOR(PM3386_IOCTL_MAGIC, 38, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_CRCEN			_IOR(PM3386_IOCTL_MAGIC, 39, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_CRCEN			_IOR(PM3386_IOCTL_MAGIC, 40, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_FCTX				_IOR(PM3386_IOCTL_MAGIC, 41, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_FCTX				_IOR(PM3386_IOCTL_MAGIC, 42, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_FCRX				_IOR(PM3386_IOCTL_MAGIC, 43, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_FCRX				_IOR(PM3386_IOCTL_MAGIC, 44, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_LONGP			_IOR(PM3386_IOCTL_MAGIC, 45, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_LONGP			_IOR(PM3386_IOCTL_MAGIC, 46, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_RXEN				_IOR(PM3386_IOCTL_MAGIC, 47, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_RXEN				_IOR(PM3386_IOCTL_MAGIC, 48, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_TXEN				_IOR(PM3386_IOCTL_MAGIC, 49, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_TXEN				_IOR(PM3386_IOCTL_MAGIC, 50, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_IPG				_IOR(PM3386_IOCTL_MAGIC, 51, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_IPG				_IOR(PM3386_IOCTL_MAGIC, 52, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_STN_ADDR			_IOR(PM3386_IOCTL_MAGIC, 54, PM3386_CHAN_MAC_ADDR)
#define PM3386_IOCTL_EGMAC_GET_STN_ADDR			_IOR(PM3386_IOCTL_MAGIC, 55, PM3386_CHAN_MAC_ADDR)
#define PM3386_IOCTL_EGMAC_SET_MAX_RX_FRAME		_IOR(PM3386_IOCTL_MAGIC, 56, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_MAX_RX_FRAME		_IOR(PM3386_IOCTL_MAGIC, 57, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_RESTART_AN			_IO(PM3386_IOCTL_MAGIC, 58)
#define PM3386_IOCTL_EGMAC_SET_AN_EN			_IOR(PM3386_IOCTL_MAGIC, 59, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_AN_EN			_IOR(PM3386_IOCTL_MAGIC, 60, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_AN_STTS			_IOR(PM3386_IOCTL_MAGIC, 61, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_AN_ADV_LO		_IOR(PM3386_IOCTL_MAGIC, 62, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_AN_ADV_LO		_IOR(PM3386_IOCTL_MAGIC, 63, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_AN_ADV_HI		_IOR(PM3386_IOCTL_MAGIC, 64, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_AN_ADV_HI		_IOR(PM3386_IOCTL_MAGIC, 65, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_AN_LINK_LO		_IOR(PM3386_IOCTL_MAGIC, 66, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_AN_LINK_HI		_IOR(PM3386_IOCTL_MAGIC, 67, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_HOST_PAUSE		_IOR(PM3386_IOCTL_MAGIC, 68, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_HOST_PAUSE		_IOR(PM3386_IOCTL_MAGIC, 69, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_PASS_ERR			_IOR(PM3386_IOCTL_MAGIC, 70, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_PASS_ERR			_IOR(PM3386_IOCTL_MAGIC, 71, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_PASS_CTRL		_IOR(PM3386_IOCTL_MAGIC, 72, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_PASS_CTRL		_IOR(PM3386_IOCTL_MAGIC, 73, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_PAUSE_TIME		_IOR(PM3386_IOCTL_MAGIC, 74, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_PAUSE_TIME		_IOR(PM3386_IOCTL_MAGIC, 75, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_PAUSE_IVAL		_IOR(PM3386_IOCTL_MAGIC, 76, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_PAUSE_IVAL		_IOR(PM3386_IOCTL_MAGIC, 77, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_MAX_TX_FRAME		_IOR(PM3386_IOCTL_MAGIC, 78, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_MAX_TX_FRAME		_IOR(PM3386_IOCTL_MAGIC, 79, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_RX_FWD_TSHLD		_IOR(PM3386_IOCTL_MAGIC, 80, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_RX_FWD_TSHLD		_IOR(PM3386_IOCTL_MAGIC, 81, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_ADDR_MATCH		_IOR(PM3386_IOCTL_MAGIC, 82, PM3386_CHAN_AMATCH)
#define PM3386_IOCTL_EGMAC_GET_ADDR_MATCH		_IOR(PM3386_IOCTL_MAGIC, 83, PM3386_CHAN_AMATCH)
#define PM3386_IOCTL_EGMAC_SET_VID_MATCH		_IOR(PM3386_IOCTL_MAGIC, 84, PM3386_CHAN_VMATCH)
#define PM3386_IOCTL_EGMAC_GET_VID_MATCH		_IOR(PM3386_IOCTL_MAGIC, 85, PM3386_CHAN_VMATCH)
#define PM3386_IOCTL_EGMAC_SET_MHASH			_IOR(PM3386_IOCTL_MAGIC, 86, PM3386_CHAN_MHASH)
#define PM3386_IOCTL_EGMAC_GET_MHASH			_IOR(PM3386_IOCTL_MAGIC, 87, PM3386_CHAN_MHASH)
#define PM3386_IOCTL_EGMAC_SET_ADDR_FILT_CTRL	_IOR(PM3386_IOCTL_MAGIC, 88, PM3386_CHAN_FLTR_CTRL)
#define PM3386_IOCTL_EGMAC_GET_ADDR_FILT_CTRL	_IOR(PM3386_IOCTL_MAGIC, 89, PM3386_CHAN_FLTR_CTRL)
#define PM3386_IOCTL_EGMAC_SET_MHASH_EN			_IOR(PM3386_IOCTL_MAGIC, 90, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_MHASH_EN			_IOR(PM3386_IOCTL_MAGIC, 91, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_SET_PMODE			_IOR(PM3386_IOCTL_MAGIC, 92, PM3386_CHAN_CFG)
#define PM3386_IOCTL_EGMAC_GET_PMODE			_IOR(PM3386_IOCTL_MAGIC, 93, PM3386_CHAN_CFG)
#define PM3386_IOCTL_MSTAT_SNAP					_IOR(PM3386_IOCTL_MAGIC, 95, UINT16)
#define PM3386_IOCTL_MSTAT_CLEAR				_IOR(PM3386_IOCTL_MAGIC, 96, UINT16)
#define PM3386_IOCTL_MSTAT_WRITE_CNTR			_IOR(PM3386_IOCTL_MAGIC, 97, PM3386_CHAN_CNTR)
#define PM3386_IOCTL_MSTAT_READ_CNTR			_IOR(PM3386_IOCTL_MAGIC, 101, PM3386_CHAN_CNTR)
#define PM3386_IOCTL_MSTAT_READ_ALL_COUNTERS	_IOR(PM3386_IOCTL_MAGIC, 102, PM3386_CHAN_STATS)
#define PM3386_IOCTL_SERDES_SET_SYS_LPBK		_IOR(PM3386_IOCTL_MAGIC, 105, PM3386_CHAN_CFG)
#define PM3386_IOCTL_SERDES_GET_SYS_LPBK		_IOR(PM3386_IOCTL_MAGIC, 106, PM3386_CHAN_CFG)
#define PM3386_SET_INT_ENABLE					_IOR(PM3386_IOCTL_MAGIC, 109, PM3386_INTERRUPTS)
#define PM3386_GET_INT_ENABLE					_IOR(PM3386_IOCTL_MAGIC, 110, PM3386_INTERRUPTS)
#define PM3386_CLR_INT_ENABLE					_IOR(PM3386_IOCTL_MAGIC, 111, PM3386_INTERRUPTS)

/* hide */
#define PM3386_IOCTL_GET_REG					_IOR(PM3386_IOCTL_MAGIC, 7, PM3386_CHAN_CFG)
#define PM3386_IOCTL_SET_REG					_IOR(PM3386_IOCTL_MAGIC, 8, PM3386_CHAN_CFG)
#define PM3386_IOCTL_PL3IP_APPLY_CHAN_UPDATE	_IO(PM3386_IOCTL_MAGIC, 25)
#define PM3386_IOCTL_PL3EP_CH_APPLY_UPDATE		_IO(PM3386_IOCTL_MAGIC, 32)
#define EGMAC_APPLY_UPDATE						_IO(PM3386_IOCTL_MAGIC, 53)
#define PM3386_IOCTL_EGMAC_UPDATE_FLTR_CTRL		_IO(PM3386_IOCTL_MAGIC, 94)


/* delete */
#define PM3386_IOCTL_PL3IP_SET_INT_MASK			_IOR(PM3386_IOCTL_MAGIC, 9, UINT16)
#define PM3386_IOCTL_PL3IP_GET_INT_MASK			_IOR(PM3386_IOCTL_MAGIC, 10, UINT16)
#define PM3386_IOCTL_PL3EP_SET_INT_MASK			_IOR(PM3386_IOCTL_MAGIC, 26, UINT16)
#define PM3386_IOCTL_PL3EP_GET_INT_MASK			_IOR(PM3386_IOCTL_MAGIC, 27, UINT16)
#define PM3386_IOCTL_SERDES_SET_INT_MASK		_IOR(PM3386_IOCTL_MAGIC, 103, UINT16)
#define PM3386_IOCTL_SERDES_GET_INT_MASK		_IOR(PM3386_IOCTL_MAGIC, 104, UINT16)
#define PM3386_IOCTL_SERDES_ENABLE				_IO(PM3386_IOCTL_MAGIC, 107)
#define PM3386_IOCTL_SERDES_DISABLE				_IO(PM3386_IOCTL_MAGIC, 108)
#define PM3386_IOCTL_MSTAT_GET_ROLLOVER			_IO(PM3386_IOCTL_MAGIC, 98)
#define PM3386_IOCTL_MSTAT_SET_INT_MASK			_IO(PM3386_IOCTL_MAGIC, 99)
#define PM3386_IOCTL_MSTAT_GET_INT_MASK			_IO(PM3386_IOCTL_MAGIC, 100)


/******************************************************************************
 *	API
 ******************************************************************************/

#endif /*__PM3386_LINUX_H__*/
