/******************************************************************************
 *
 *	pm3386_defs.h
 *	-------------
 *	Definitions for pm3386 registers and common utility functions
 *
 ******************************************************************************
 *
 *	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
 *
 ******************************************************************************/

#ifndef __PM3386_DEFS_H__
#define __PM3386_DEFS_H__

#include "enpv2_types.h"

/******************************************************************************
 *
 *							 	Definitions
 *
 ******************************************************************************/

#define PM3386_CHAN0				0
#define PM3386_CHAN1				1
#define PM3386_MAX_CNTRS			52
#define PM3386_MAX_FILTERS			8


/* PM3386_INTERRUPTS.interface bit definitions */
#define PM3386_INT_TX_ROOL					0x00000001
#define PM3386_INT_RX_ROOL_0				0x00000002
#define PM3386_INT_RX_DOOL_0				0x00000004
#define PM3386_INT_RX_ROOL_1				0x00000008
#define PM3386_INT_RX_DOOL_1				0x00000010
#define PM3386_INT_PL3EP_CH0_FIFO_TRUNC		0x00000020
#define PM3386_INT_PL3EP_CH0_PERR			0x00000040
#define PM3386_INT_PL3EP_CH1_FIFO_TRUNC		0x00000080
#define PM3386_INT_PL3EP_CH1_PERR			0x00000100
#define PM3386_INT_PL3IP_CH0_SW_PROG_FAULT	0x00000200
#define PM3386_INT_PL3IP_CH0_EQUALIZATION	0x00000400
#define PM3386_INT_PL3IP_CH1_SW_PROG_FAULT	0x00000800
#define PM3386_INT_PL3IP_CH1_EQUALIZATION	0x00001000




/******************************************************************************
 *
 *							 Register Addresses
 *
 ******************************************************************************/

/*----------------------------------------------------------------------------*/
/* Top Level Registers                                                        */
/*----------------------------------------------------------------------------*/
#define PM3386_REG_CHIP_ID						0x0000
#define PM3386_REG_CHIP_REV						0x0001
#define PM3386_REG_RESET_CTRL					0x0002
#define PM3386_REG_INT_STTS						0x0003
#define PM3386_REG_DEV_STTS						0x0004
#define PM3386_REG_ROOL_STTS					0x0005
#define PM3386_REG_DOOL_STTS					0x0006
#define PM3386_REG_SW_RSRC						0x0007

/*----------------------------------------------------------------------------*/
/* PL3IP Registers                                                            */
/*----------------------------------------------------------------------------*/
#define PM3386_REG_PL3IP_INT_STTS				0x0101
#define PM3386_REG_PL3IP_INT_MASK				0x0102
#define PM3386_REG_PL3IP_CFG					0x0103
#define PM3386_REG_PL3IP_EQ_THSHLD				0x0104
#define PM3386_REG_PL3IP_EQ_DIFF				0x0105
/* these register exist for each channel - these definitions apply to CH0 */
#define PM3386_REG_PL3IP_CHAN_HI_WATER			0x0120
#define PM3386_REG_PL3IP_CHAN_LO_WATER			0x0121
#define PM3386_REG_PL3IP_CHAN_PKT_BURST			0x0122
/* add this offset to get address for CH1 channel registers */
#define PM3386_PL3IP_CHAN_OFFSET				0x0020

/*----------------------------------------------------------------------------*/
/* PL3IEP Registers                                                           */
/*----------------------------------------------------------------------------*/
#define PM3386_REG_PL3EP_INT_STTS				0x0201
#define PM3386_REG_PL3EP_INT_MASK				0x0202
#define PM3386_REG_PL3EP_CFG					0x0203
/* these register exist for each channel - these definitions apply to CH0 */
#define PM3386_REG_PL3EP_CHAN_FIFO_RSV			0x0220
#define PM3386_REG_PL3EP_CHAN_MIN_FRAME			0x0221
/* add this offset to get address for CH1 channel registers */
#define PM3386_PL3EP_CHAN_OFFSET				0x0020

/*----------------------------------------------------------------------------*/
/* EGMAC Registers                                                            */
/*----------------------------------------------------------------------------*/
/* these register exist for each channel - these definitions apply to CH0 */
#define PM3386_REG_EGMAC_GMACC0_CFG_LO			0x0300
#define PM3386_REG_EGMAC_GMACC0_CFG_HI			0x0301
#define PM3386_REG_EGMAC_GMACC1_CFG_LO			0x0302
#define PM3386_REG_EGMAC_GMACC1_CFG_HI			0x0303
#define PM3386_REG_EGMAC_GMACC2_CFG_LO			0x0304
#define PM3386_REG_EGMAC_GMACC2_CFG_HI			0x0305
#define PM3386_REG_EGMAC_GPCS_PHY_CFG_LO		0x0306
#define PM3386_REG_EGMAC_GPCS_PHY_CFG_HI		0x0307
#define PM3386_REG_EGMAC_SA_15_00				0x0308
#define PM3386_REG_EGMAC_SA_31_16				0x0309
#define PM3386_REG_EGMAC_SA_47_32				0x030A
#define PM3386_REG_EGMAC_VLAN_TAG_ID			0x030C
#define PM3386_REG_EGMAC_RX_MAX_FRAME			0x0310
#define PM3386_REG_EGMAC_AN_CTRL				0x0318
#define PM3386_REG_EGMAC_AN_STTS				0x031A
#define PM3386_REG_EGMAC_AN_ADV_LO				0x031C
#define PM3386_REG_EGMAC_AN_ADV_HI				0x031D
#define PM3386_REG_EGMAC_AN_LPA_LO				0x031E
#define PM3386_REG_EGMAC_AN_LPA_HI				0x031F
#define PM3386_REG_EGMAC_TX_CTRL				0x0332
#define PM3386_REG_EGMAC_CTRL					0x0333
#define PM3386_REG_EGMAC_PAUSE_TIME				0x0334
#define PM3386_REG_EGMAC_PAUSE_IVAL				0x0335
#define PM3386_REG_EGMAC_TX_MAX_FRAME			0x0336
#define PM3386_REG_EGMAC_RX_FIFO_FWD_TSHLD		0x0337
#define PM3386_REG_EGMAC_AMATCH0_A				0x0339
#define PM3386_REG_EGMAC_AMATCH0_B				0x033A
#define PM3386_REG_EGMAC_AMATCH0_C				0x033B
#define PM3386_REG_EGMAC_AMATCH1_A				0x033C
#define PM3386_REG_EGMAC_AMATCH1_B				0x033D
#define PM3386_REG_EGMAC_AMATCH1_C				0x033E
#define PM3386_REG_EGMAC_AMATCH2_A				0x033F
#define PM3386_REG_EGMAC_AMATCH2_B				0x0340
#define PM3386_REG_EGMAC_AMATCH2_C				0x0341
#define PM3386_REG_EGMAC_AMATCH3_A				0x0342
#define PM3386_REG_EGMAC_AMATCH3_B				0x0343
#define PM3386_REG_EGMAC_AMATCH3_C				0x0344
#define PM3386_REG_EGMAC_AMATCH4_A				0x0345
#define PM3386_REG_EGMAC_AMATCH4_B				0x0346
#define PM3386_REG_EGMAC_AMATCH4_C				0x0347
#define PM3386_REG_EGMAC_AMATCH5_A				0x0348
#define PM3386_REG_EGMAC_AMATCH5_B				0x0349
#define PM3386_REG_EGMAC_AMATCH5_C				0x034A
#define PM3386_REG_EGMAC_AMATCH6_A				0x034B
#define PM3386_REG_EGMAC_AMATCH6_B				0x034C
#define PM3386_REG_EGMAC_AMATCH6_C				0x034D
#define PM3386_REG_EGMAC_AMATCH7_A				0x034E
#define PM3386_REG_EGMAC_AMATCH7_B				0x034F
#define PM3386_REG_EGMAC_AMATCH7_C				0x0350
#define PM3386_REG_EGMAC_VMATCH0				0x0351
#define PM3386_REG_EGMAC_VMATCH1				0x0352
#define PM3386_REG_EGMAC_VMATCH2				0x0353
#define PM3386_REG_EGMAC_VMATCH3				0x0354
#define PM3386_REG_EGMAC_VMATCH4				0x0355
#define PM3386_REG_EGMAC_VMATCH5				0x0356
#define PM3386_REG_EGMAC_VMATCH6				0x0357
#define PM3386_REG_EGMAC_VMATCH7				0x0358
#define PM3386_REG_EGMAC_MHASH_LO				0x0359
#define PM3386_REG_EGMAC_MHASH_ML				0x035A
#define PM3386_REG_EGMAC_MHASH_MH				0x035B
#define PM3386_REG_EGMAC_MHASH_HI				0x035C
#define PM3386_REG_EGMAC_ADDR_FILT_CTRL_0		0x035D
#define PM3386_REG_EGMAC_ADDR_FILT_CTRL_1		0x035E
#define PM3386_REG_EGMAC_ADDR_FILT_CTRL_2		0x035F
#define PM3386_REG_EGMAC_ADDR_FILT_CTRL_3		0x0360
/* add this offset to get address for CH1 channel registers */
#define PM3386_EGMAC_CHAN_OFFSET				0x0100
/* these registers exist only at the defined addresses */
#define PM3386_REG_EGMAC_MII_COMMAND			0x0320
#define PM3386_REG_EGMAC_MII_PHY_ADDR			0x0322
#define PM3386_REG_EGMAC_MII_WR_DATA			0x0324
#define PM3386_REG_EGMAC_MII_RD_DATA			0x0326
#define PM3386_REG_EGMAC_MII_INDICATORS			0x0328
/* use this value to calculate the offset of the amtch filter from num 0 */
#define PM3386_EGMAC_AMTCH_OFFSET				0x0003
/* use this value to calculate the offset of the amtch filter from num 0 */
#define PM3386_EGMAC_VMTCH_OFFSET				0x0001

/*----------------------------------------------------------------------------*/
/* MSTAT Registers                                                            */
/*----------------------------------------------------------------------------*/
/* these register exist for each channel - these definitions apply to CH0 */
#define PM3386_REG_MSTAT_CTRL					0x0500
#define PM3386_REG_MSTAT_ROLLOVER_0				0x0501
#define PM3386_REG_MSTAT_ROLLOVER_1				0x0502
#define PM3386_REG_MSTAT_ROLLOVER_2				0x0503
#define PM3386_REG_MSTAT_ROLLOVER_3				0x0504
#define PM3386_REG_MSTAT_INT_MASK_0				0x0505
#define PM3386_REG_MSTAT_INT_MASK_1				0x0506
#define PM3386_REG_MSTAT_INT_MASK_2				0x0507
#define PM3386_REG_MSTAT_INT_MASK_3				0x0508
#define PM3386_REG_MSTAT_WR_ADDR				0x0509
#define PM3386_REG_MSTAT_WR_DATA_L				0x050A
#define PM3386_REG_MSTAT_WR_DATA_M				0x050B
#define PM3386_REG_MSTAT_WR_DATA_H				0x050C
/* 52 counters are contiguously located at 4 word boundaries starting here */
#define PM3386_REG_MSTAT_CNTR_BASE				0x0510
/* multiply counter number by this offset to get base address of counter */
#define PM3386_MSTAT_CNTR_OFFSET				0x0004
/* each counter has a low, med, and high register offset from counter base */
#define PM3386_MSTAT_CNTR_L						0
#define PM3386_MSTAT_CNTR_M						1
#define PM3386_MSTAT_CNTR_H						2
/* number of counters */
#define PM3386_MSTAT_CNTRS_MAX					54	/* two elements skipped in array */

/* all registers above exist for each channel, add this offset to get
 * address of equivilent CH1 register
 */
#define PM3386_MSTAT_CHAN_OFFSET				0x0100

/*----------------------------------------------------------------------------*/
/* SERDES Registers                                                           */
/*----------------------------------------------------------------------------*/
#define PM3386_REG_SERDES_LOCK_DET_CHANGE		0x0700
#define PM3386_REG_SERDES_LOCK_DET_MASK			0x0701
/* these register exist for each channel - definitions below apply to CH0 */
#define PM3386_REG_SERDES_PORT_CFG				0x0703
#define PM3386_REG_SERDES_PORT_RX_MODE			0x0704
#define PM3386_REG_SERDES_PORT_TX_MODE			0x0705
#define PM3386_REG_SERDES_PORT_CRU_MODE			0x0708
/* add this offset to get address for CH1 channel registers */
#define PM3386_SERDES_CHAN_OFFSET				0x0010



/******************************************************************************
 *
 *							 Register Definitions
 *
 ******************************************************************************/
/*----------------------------------------------------------------------------*/
/*	0x0: Device Identification                                            */
/*----------------------------------------------------------------------------*/
#define PM3386_DEV_ID							0x3386
#define PM3387_DEV_ID							0x3387

/*----------------------------------------------------------------------------*/
/*	0x1: Device Revision                                                  */
/*----------------------------------------------------------------------------*/
#define PM3386_DEV_REV							0x0000

/*----------------------------------------------------------------------------*/
/*	0x2: Reset Control                                                    */
/*----------------------------------------------------------------------------*/
#define PM3386_OUT_OF_RESET						0x0063

/*----------------------------------------------------------------------------*/
/*	0x3: Interrupt Status                                                 */
/*----------------------------------------------------------------------------*/
#define PM3386_SYS_DOOL_INT						0x0080
#define PM3386_SYS_ROOL_INT						0x0040
#define PM3386_SYS_PL3EP_INT					0x0008
#define PM3386_SYS_PL3IP_INT					0x0004
#define PM3386_SYS_MSTAT1_INT					0x0002
#define PM3386_SYS_MSTAT0_INT					0x0001

/*----------------------------------------------------------------------------*/
/*	0x4: DeviceStatus                                                     */
/*----------------------------------------------------------------------------*/
#define PM3386_DLL1_ERR							0x0020
#define PM3386_DLL1_RUN							0x0010
#define PM3386_DLL0_ERR							0x0002
#define PM3386_DLL0_RUN							0x0001

/*----------------------------------------------------------------------------*/
/*	0x5: ROOL Status                                                      */
/*----------------------------------------------------------------------------*/
#define PM3386_TX_ROOL							0x8000
#define PM3386_RX_ROOL1							0x0002
#define PM3386_RX_ROOL0							0x0001

/*----------------------------------------------------------------------------*/
/*	0x6: DOOL Status                                                      */
/*----------------------------------------------------------------------------*/
#define PM3386_RX_DOOL1							0x0002
#define PM3386_RX_DOOL0							0x0001

/*----------------------------------------------------------------------------*/
/*	0x7: SW Resource                                                      */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/*	0x101: PL3IP Interrupt Status                                         */
/*----------------------------------------------------------------------------*/
#define PM3386_PL3IP_CH0_SW_PROG_FAULT_INT		0x0020
#define PM3386_PL3IP_CH0_EQUALIZATION_INT		0x0080
#define PM3386_PL3IP_CH1_SW_PROG_FAULT_INT		0x2000
#define PM3386_PL3IP_CH1_EQUALIZATION_INT		0x8000

/*----------------------------------------------------------------------------*/
/*	0x102: PL3IP Interrupt Mask                                           */
/*----------------------------------------------------------------------------*/
#define PM3386_PL3IP_CH0_SW_PROG_FAULT_MASK		0x0020
#define PM3386_PL3IP_CH0_EQUALIZATION_MASK		0x0080
#define PM3386_PL3IP_CH1_SW_PROG_FAULT_MASK		0x2000
#define PM3386_PL3IP_CH1_EQUALIZATION_MASK		0x8000

/*----------------------------------------------------------------------------*/
/*	0x102: PL3IP Interrupt Mask                                           */
/*----------------------------------------------------------------------------*/
#define PM3386_PL3IP_CH0_PROTOCOL_EN			0x0001
#define PM3386_PL3IP_CH1_PROTOCOL_EN			0x0002
#define PM3386_PL3IP_EQTX						0x0004
#define PM3386_PL3IP_PAR						0x0008
#define PM3386_PL3IP_PAUSE_MODE					0x0040
#define PM3386_PL3IP_CHAN_EN					0x0080
#define PM3386_PL3IP_CHAN_UPDATE				0x0080



/*----------------------------------------------------------------------------*/
/* PL3IP Channel Packet Burst Max                                             */
/* 0x122, 0x142                                                               */
/* 15:4		R		Reserved                                      */
/* 3:0		R/W     IP_CFBM[3:0]                                          */
/*----------------------------------------------------------------------------*/
#define PL3IP_CHAN_PKT_BURST_16B	0
#define PL3IP_CHAN_PKT_BURST_32B	1
#define PL3IP_CHAN_PKT_BURST_64B	2
#define PL3IP_CHAN_PKT_BURST_128B	3
#define PL3IP_CHAN_PKT_BURST_256B	4
#define PL3IP_CHAN_PKT_BURST_512B	5
#define PL3IP_CHAN_PKT_BURST_1024B	6
#define PL3IP_CHAN_PKT_BURST_2048B	7
#define PL3IP_CHAN_PKT_BURST_EOP	8

#define PM3386_PL3IP_EQ_THSHLD_LIMIT_MASK		0x0007
#define PM3386_PL3IP_EQ_DIFF_LIMIT_MASK			0x0007
#define PM3386_PL3IP_CH_HI_WATER_MARK_MASK		0x000f
#define PM3386_PL3IP_CH_LO_WATER_MARK_MASK		0x000f
#define PM3386_PL3IP_CH_PKT_BURST_MAX_MASK		0x000f
#define PM3386_PL3IP_RFCLK_TXGAP_SHIFT			4
#define PM3386_PL3IP_RFCLK_TXGAP_MASK			0x0030

#define PM3386_PL3EP_CH_FIFO_RSV_MASK			0x0007
#define PM3386_PL3EP_CH_MIN_FRAME_SIZE_MASK		0x0007



/*----------------------------------------------------------------------------*/
/*	0x201: PL3EP Interrupt Status                                         */
/*----------------------------------------------------------------------------*/
#define PM3386_PL3EP_CH0_FIFO_TRUNC_INT			0x0002
#define PM3386_PL3EP_CH0_PERR_INT				0x0008
#define PM3386_PL3EP_CH1_FIFO_TRUNC_INT			0x0020
#define PM3386_PL3EP_CH1_PERR_INT				0x0080

/*----------------------------------------------------------------------------*/
/*	0x202: PL3EP Interrupt Mask                                           */
/*----------------------------------------------------------------------------*/
#define PM3386_PL3EP_CH0_FIFO_TRUNC_MASK		0x0002
#define PM3386_PL3EP_CH0_PERR_MASK				0x0008
#define PM3386_PL3EP_CH1_FIFO_TRUNC_MASK		0x0020
#define PM3386_PL3EP_CH1_PERR_MASK				0x0080

/*----------------------------------------------------------------------------*/
/*	0x203: PL3EP Configuration                                            */
/*----------------------------------------------------------------------------*/
#define PM3386_PL3EP_PAR_EN						0x0001
#define PM3386_PL3EP_PAR						0x0002
#define PM3386_PL3EP_CH0_UPDATE					0x0004
#define PM3386_PL3EP_CH1_UPDATE					0x0008
#define PM3386_PL3EP_CHAN_EN_MASK				0x000c


#define PM3386_EGMAC_MIIM						0x0001
#define PM3386_EGMAC_PADEN						0x0002
#define PM3386_EGMAC_CRCEN						0x0010
#define PM3386_EGMAC_FLCHK						0x0020
#define PM3386_EGMAC_PURP						0x0100
#define PM3386_EGMAC_FCTX						0x0200
#define PM3386_EGMAC_FCRX						0x0400
#define PM3386_EGMAC_LONGP						0x1000
#define PM3386_EGMAC_L32B						0x0100
#define PM3386_EGMAC_L10B						0x0200
#define PM3386_EGMAC_TPAUSE_MASK				0x0002			

#define PM3386_EGMAC_IPG_MASK					0x003f
#define PM3386_EGMAC_SPRE						0x0010
#define PM3386_EGMAC_SRST						0x8000
#define PM3386_EGMAC_AUTOS						0x0100
#define PM3386_EGMAC_AUTOS						0x0100


/*----------------------------------------------------------------------------*/
/*	0x303: EBMAC GMACC1 Config Register Hi                                */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_TXEN0						0x4000	
#define PM3386_EGMAC_RXEN0						0x1000


/*----------------------------------------------------------------------------*/
/*	0x318,0x418: Auto-Negotiation Control                                 */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_RSTAN						0x0001
#define PM3386_EGMAC_ANEN						0x0002

/*----------------------------------------------------------------------------*/
/*	0x31A,0x41A: Auto-Negotiation Status                                  */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_ANSTTS_MASK				0x001f

/*----------------------------------------------------------------------------*/
/*	0x333,0x433: EGMAC Control Register                                   */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_HPAUSE						0x0004


#define PM3386_EGMAC_PASS_ERR					0x0008
#define PM3386_EGMAC_PASS_CTRL					0x0010



/*----------------------------------------------------------------------------*/
/*	0x35D,0x45D: EGMAC Address Filter Control 0 Register                  */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_AFC_0_MASK					0x000f
#define PM3386_EGMAC_AFC_1_MASK					0x00f0
#define PM3386_EGMAC_AFC_2_MASK					0x0f00
#define PM3386_EGMAC_AFC_3_MASK					0xf000

/*----------------------------------------------------------------------------*/
/*	0x35E,0x45E: EGMAC Address Filter Control 1 Register                  */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_AFC_4_MASK					0x000f
#define PM3386_EGMAC_AFC_5_MASK					0x00f0
#define PM3386_EGMAC_AFC_6_MASK					0x0f00
#define PM3386_EGMAC_AFC_7_MASK					0xf000

/*----------------------------------------------------------------------------*/
/*	0x35F,0x45F: EGMAC Address Filter Control 2 Register                  */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_MHASH_EN					0x0001
#define PM3386_EGMAC_PMODE						0x0002

/*----------------------------------------------------------------------------*/
/*	0x360,0x460: EGMAC Address Filter Control 3 Register                  */
/*----------------------------------------------------------------------------*/
#define PM3386_EGMAC_ADDR_FLTR_CTRL_UPDATE		0x0001


/*----------------------------------------------------------------------------*/
/*	0x500,0x600: MSTAT Control                                            */
/*----------------------------------------------------------------------------*/
#define PM3386_MSTAT_SNAP						0x0001
#define PM3386_MSTAT_CLEAR						0x0002
#define PM3386_MSTAT_WRITE						0x0004

/*----------------------------------------------------------------------------*/
/*	0x700: SERDES Lock Detect Change                                      */
/*----------------------------------------------------------------------------*/
#define PM3386_TX_ROOL_INT						0x8000
#define PM3386_RX_ROOL_INT_1					0x0200
#define PM3386_RX_ROOL_INT_0					0x0100
#define PM3386_RX_DOOL_INT_1					0x0002
#define PM3386_RX_DOOL_INT_0					0x0001

/*----------------------------------------------------------------------------*/
/*	0x701: SERDES Lock Detect Mask                                        */
/*----------------------------------------------------------------------------*/
#define PM3386_TX_ROOL_MASK						0x8000
#define PM3386_RX_ROOL_MASK_1					0x0200
#define PM3386_RX_ROOL_MASK_0					0x0100
#define PM3386_RX_DOOL_MASK_1					0x0002
#define PM3386_RX_DOOL_MASK_0					0x0001


/*----------------------------------------------------------------------------*/
/*	0x703,0x713: SERDES Port Configuration                                */
/*----------------------------------------------------------------------------*/
#define PM3386_SERDES_RXSEL						0x0020




#define PM3386_SERDES_PORT_CFG_DEFAULT			0x1001
#define PM3386_SERDES_PORT_RX_MODE_DEFAULT		0x0800
#define PM3386_SERDES_PORT_TX_MODE_DEFAULT		0x0800

/*----------------------------------------------------------------------------*/
/*	0x708,0x718: SERDES Port CRU Mode                                     */
/*----------------------------------------------------------------------------*/
#define PM3386_SERDES_NARROWBAND_INIT_PHASE1	0xD055
#define PM3386_SERDES_NARROWBAND_INIT_PHASE2	0x5055



#endif /* __PM3386_DEFS_H__ */
