/******************************************************************************/
/*
/*	caleb_linux.h
/*	-------------
/*	Header file for caleb SPI-3 bridge linux device driver
/*
/******************************************************************************/
/*
/*	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
/*
/******************************************************************************/

#ifndef __CALEB_LINUX_H__
#define __CALEB_LINUX_H__

/*
 *	IOCTL Data structures
 */

typedef struct
{
	UINT8	port;
	UINT8	val;
}
SPIBR_CHAN_CFG;


typedef struct
{
	UINT8	idlo;
	UINT8	idhi;
	UINT8	rev;
	UINT8	reset;
	UINT8	intren0;
	UINT8	intren1;
	UINT8	intrstat0;
	UINT8	intrstat1;
	UINT8	porten;
	UINT8	burstsize;
	UINT8	portpaus;
	UINT8	portpausd;
	UINT8	rsvd_0c;
	UINT8	rsvd_0d;
	UINT8	rsvd_0e;
	UINT8	rsve_0f;
	UINT8	phy0rx;
	UINT8	phy1rx;
	UINT8	phy0tx;
	UINT8	phy1tx;
	UINT8	rsvd_14;
	UINT8	ixprxcnthi;
	UINT8	phy0rxcnthi;
	UINT8	phy1rxcnthi;
	UINT8	ixprxcnt;
	UINT8	phy0rxcnt;
	UINT8	phy1rxcnt;
	UINT8	ixptxcnt;
	UINT8	phy0txcnt;
	UINT8	phy1txcnt;
	UINT8	debug0;
	UINT8	debug1;
}
SPIBR_REGS;



/*	
 *	IOCTL COMMAND DEFINITIONS
 *	(TBD - calculate real encodings)
 */

#define SPIBR_IOCTL_GET_CHIP_ID						0
#define SPIBR_IOCTL_GET_CHIP_REV					1
#define SPIBR_IOCTL_RESET_GLOBAL					2
#define SPIBR_IOCTL_RESET_LOGIC						3
#define SPIBR_IOCTL_SET_INT_EN						4
#define	SPIBR_IOCTL_CLR_INT_EN						5
#define SPIBR_IOCTL_GET_INT_EN						6
#define SPIBR_IOCTL_GET_INT_STTS					7
#define SPIBR_IOCTL_SET_PORT_EN						8
#define SPIBR_IOCTL_GET_PORT_EN						9
#define SPIBR_IOCTL_SET_BURST_SIZE					10
#define SPIBR_IOCTL_GET_BURST_SIZE					11
#define SPIBR_IOCTL_SET_PORT_PAUS					12
#define SPIBR_IOCTL_CLR_PORT_PAUS					13
#define SPIBR_IOCTL_GET_PORT_PAUS					14
#define SPIBR_IOCTL_GET_PORT_PAUSD					15
#define SPIBR_IOCTL_SET_RX_FIFO_CTL					16
#define SPIBR_IOCTL_GET_RX_FIFO_CTL					17
#define SPIBR_IOCTL_SET_TX_FIFO_CTL					18
#define SPIBR_IOCTL_GET_TX_FIFO_CTL					19
#define SPIBR_IOCTL_DBG_SET_LOOPBACK_MODE			20
#define SPIBR_IOCTL_DBG_CLR_LOOPBACK_MODE			21
#define SPIBR_IOCTL_DBG_SET_REG						22
#define SPIBR_IOCTL_DBG_GET_REG						23
#define SPIBR_IOCTL_DBG_DUMP						24



#endif /*__CALEB_LINUX_H__*/
