/******************************************************************************/
/*
/*	Caleb.h
/*
/*	COPYRIGHT 2003 BY RADISYS CORPORATION.  ALL RIGHTS RESERVED.
/*
/******************************************************************************/
#ifndef __CALEB_H__
#define __CALEB_H__

#include "enpv2_types.h"


#define CALEB_BASE_ADDR		0xC5000000



/******************************************************************************/
/*
/*								REGISTER ADDRESSES
/*
/******************************************************************************/
#define CALEB_REG_IDLO				0x00
#define CALEB_REG_IDHI				0x01
#define CALEB_REG_RID				0x02
#define CALEB_REG_RESET				0x03
#define CALEB_REG_INTREN0			0x04
#define CALEB_REG_INTREN1			0x05
#define CALEB_REG_INTRSTAT0			0x06
#define CALEB_REG_INTRSTAT1			0x07
#define CALEB_REG_PORTEN			0x08
#define CALEB_REG_BURST_SIZE		0x09
#define CALEB_REG_PORTPAUS			0x0a
#define CALEB_REG_PORTPAUSD			0x0b
#define CALEB_REG_RSVD_0C			0x0c
#define CALEB_REG_RSVD_0D			0x0d
#define CALEB_REG_RSVD_0E			0x0d
#define CALEB_REG_RSVD_0F			0x0f
#define CALEB_REG_PHY0RX			0x10
#define CALEB_REG_PHY1RX			0x11
#define CALEB_REG_PHY0TX			0x12
#define CALEB_REG_PHY1TX			0x13
#define CALEB_REG_RSVD_14			0x14
#define CALEB_REG_IXPRX_CNTR_HI		0x15
#define CALEB_REG_PHY0RX_CNTR_HI	0x16
#define CALEB_REG_PHY1RX_CNTR_HI	0x17
#define CALEB_REG_IXPRX_CNTR		0x18
#define CALEB_REG_PHY0RX_CNTR		0x19
#define CALEB_REG_PHY1RX_CNTR		0x1a
#define CALEB_REG_IXPTX_CNTR		0x1b
#define CALEB_REG_PHY0TX_CNTR		0x1c
#define CALEB_REG_PHY1TX_CNTR		0x1d
#define CALEB_REG_DEBUG0			0x1e
#define CALEB_REG_DEBUG1			0x1f


/******************************************************************************/
/*
/*								REGISTER DEFINITIONS
/*
/******************************************************************************/
/*----------------------------------------------------------------------------*/
/*	0x00	IDLO
/*----------------------------------------------------------------------------*/
#define CALEB_IDLO_VAL		0x31

/*----------------------------------------------------------------------------*/
/*	0x01	IDHI
/*----------------------------------------------------------------------------*/
#define CALEB_IDHI_VAL		0x13

/*----------------------------------------------------------------------------*/
/*	0x02	REVID
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x03	RESET CONTROL REG
/*----------------------------------------------------------------------------*/
#define CALEB_LOGIC_RESET		0x01
#define CALEB_GLOBAL_RESET		0x02

/*----------------------------------------------------------------------------*/
/*	0x04	INTREN0
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_CH1_TX_OVRFLW_INTEN	0x80
#define CALEB_PHY1_CH0_TX_OVRFLW_INTEN	0x40
#define CALEB_PHY0_CH1_TX_OVERFW_INTEN	0x20
#define CALEB_PHY0_CH0_TX_OVERFW_INTEN	0x10
#define CALEB_PHY1_CH1_RX_OVRFLW_INTEN	0x08
#define CALEB_PHY1_CH0_RX_OVRFLW_INTEN	0x04
#define CALEB_PHY0_CH1_RX_OVERFW_INTEN	0x02
#define CALEB_PHY0_CH0_RX_OVERFW_INTEN	0x01

/*----------------------------------------------------------------------------*/
/*	0x05	INTREN1
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_RX_PARITY_INTEN		0x04
#define CALEB_PHY0_RX_PARITY_INTEN		0x02
#define CALEB_IXP_TX_PARITY_INTEN		0x01

/*----------------------------------------------------------------------------*/
/*	0x06	INTERRUPT STATUS 0
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_CH1_TX_OVRFLW_INT	0x80
#define CALEB_PHY1_CH0_TX_OVRFLW_INT	0x40
#define CALEB_PHY0_CH1_TX_OVERFW_INT	0x20
#define CALEB_PHY0_CH0_TX_OVERFW_INT	0x10
#define CALEB_PHY1_CH1_RX_OVRFLW_INT	0x08
#define CALEB_PHY1_CH0_RX_OVRFLW_INT	0x04
#define CALEB_PHY0_CH1_RX_OVERFW_INT	0x02
#define CALEB_PHY0_CH0_RX_OVERFW_INT	0x01

/*----------------------------------------------------------------------------*/
/*	0x07	INTERRUPT STATUS 1
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_RX_PARITY_INT		0x04
#define CALEB_PHY0_RX_PARITY_INT		0x02
#define CALEB_IXP_TX_PARITY_INT			0x01

/*----------------------------------------------------------------------------*/
/*	0x08	PORT ENABLE
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_CH1_TXEN				0x80
#define CALEB_PHY1_CH0_TXEN				0x40
#define CALEB_PHY0_CH1_TXEN				0x20
#define CALEB_PHY0_CH0_TXEN				0x10
#define CALEB_PHY1_CH1_RXEN				0x08
#define CALEB_PHY1_CH0_RXEN				0x04
#define CALEB_PHY0_CH1_RXEN				0x02
#define CALEB_PHY0_CH0_RXEN				0x01

/*----------------------------------------------------------------------------*/
/*	0x09	BURST SIZE
/*----------------------------------------------------------------------------*/
#define CALEB_BURST_SIZE_64				0x0
#define CALEB_BURST_SIZE_128			0x1
#define CALEB_BURST_SIZE_256			0x2

/*----------------------------------------------------------------------------*/
/*	0x0a	PORT PAUSE
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_CH1_PAUS				0x08
#define CALEB_PHY1_CH0_PAUS				0x04
#define CALEB_PHY0_CH1_PAUS				0x02
#define CALEB_PHY0_CH0_PAUS				0x01

/*----------------------------------------------------------------------------*/
/*	0x0b	PORT PAUSED
/*----------------------------------------------------------------------------*/
#define CALEB_PHY1_CH1_PAUSD			0x08
#define CALEB_PHY1_CH0_PAUSD			0x04
#define CALEB_PHY0_CH1_PAUSD			0x02
#define CALEB_PHY0_CH0_PAUSD			0x01

/*----------------------------------------------------------------------------*/
/*	0x10	PHY0 RX FIFO CONTROL
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x11	PHY1 RX FIFO CONTROL
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x12	PHY0 TX FIFO CONTROL
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x13	PHY1 TX FIFO CONTROL
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	0x1f	DEBUG1
/*----------------------------------------------------------------------------*/
#define CALEB_PHY_LOOPBACK_ENABLE		0x40
#define CALEB_PHY1_TPRTY_FORCE			0x20
#define CALEB_PHY0_TPRTY_FORCE			0x10
#define CALEB_IXP_RPRTY_FORCE			0x08



/******************************************************************************/
/*
/*							API PARAMETER DEFINITIONS
/*
/******************************************************************************/
/*----------------------------------------------------------------------------*/
/*	DEVICE ID
/*----------------------------------------------------------------------------*/
#define CALEB_DEVICE_ID					0x1331

/*----------------------------------------------------------------------------*/
/*	INTERRUPT MASK BITS
/*----------------------------------------------------------------------------*/
#define CALEB_IRQ_PHY0_CH0_RX_OVERFW	0x0001
#define CALEB_IRQ_PHY0_CH1_RX_OVERFW	0x0002
#define CALEB_IRQ_PHY1_CH0_RX_OVRFLW	0x0004
#define CALEB_IRQ_PHY1_CH1_RX_OVRFLW	0x0008
#define CALEB_IRQ_PHY0_CH0_TX_OVERFW	0x0010
#define CALEB_IRQ_PHY0_CH1_TX_OVERFW	0x0020
#define CALEB_IRQ_PHY1_CH0_TX_OVRFLW	0x0040
#define CALEB_IRQ_PHY1_CH1_TX_OVRFLW	0x0080
#define CALEB_IRQ_IXP_TX_PARITY			0x0100
#define CALEB_IRQ_PHY0_RX_PARITY		0x0200
#define CALEB_IRQ_PHY1_RX_PARITY		0x0400
#define CALEB_IRQ_ALL					0x07FF

/*----------------------------------------------------------------------------*/
/*	PORT MODES
/*----------------------------------------------------------------------------*/
#define CALEB_PORTMODE_OFF				0x0
#define CALEB_PORTMODE_RXONLY			0x1
#define CALEB_PORTMODE_TXONLY			0x2
#define CALEB_PORTMODE_RXANDTX			0x3


/*----------------------------------------------------------------------------*/
/*	BURST SIZES
/*----------------------------------------------------------------------------*/
#define CALEB_BURSTSIZE_64				0x0
#define CALEB_BURSTSIZE_128				0x1
#define CALEB_BURSTSIZE_256				0x2


/*----------------------------------------------------------------------------*/
/*	PORTMASK BITS
/*----------------------------------------------------------------------------*/
#define CALEB_PORTMASK_0				0x01
#define CALEB_PORTMASK_1				0x02
#define CALEB_PORTMASK_2				0x04
#define CALEB_PORTMASK_3				0x08
#define CALEB_PORTMASK_ALL				0x0F


/*----------------------------------------------------------------------------*/
/*	FIFO THRESHOLD VALUES
/*----------------------------------------------------------------------------*/
#define CALEB_RX_THSHLD_0				0x0
#define CALEB_RX_THSHLD_64				0x1
#define CALEB_RX_THSHLD_128				0x2
#define CALEB_RX_THSHLD_256				0x3

#define CALEB_TX_THSHLD_0				0x0
#define CALEB_TX_THSHLD_64				0x1
#define CALEB_TX_THSHLD_128				0x2
#define CALEB_TX_THSHLD_256				0x3


/*----------------------------------------------------------------------------*/
/*	DBG PARITY TYPES
/*----------------------------------------------------------------------------*/
#define CALEB_DBG_IXP_RPRTY				0x0
#define CALEB_DBG_PHY0_TPRTY			0x1
#define CALEB_DBG_PHY1_TPRTY			0x2



/******************************************************************************/
/*
/*										API
/*
/******************************************************************************/
UINT8
calebRead( UINT8 reg );

void
calebWrite( UINT8 reg, UINT8 data );

UINT16
calebGetChipID( void );

UINT8
calebGetChipRev( void );

void
calebResetGlobal( void );

void
calebResetLogic( void );

void
calebSetIE( UINT16 mask );

void
calebClrIE( UINT16 mask );

UINT16
calebGetIE( void );

UINT16
calebGetIV( void );

void
calebClrIV( UINT16 mask );

void
calebSetPortEnable(UINT8 port, UINT8 mode );

void
calebSetPortEnableAll( UINT8 mode );

UINT8
calebGetPortEnble( UINT8 port );

void
calebSetBurstSize( UINT8 val );

UINT8
calebGetBurstSize( void );

void
calebSetPortPaus( UINT8 port );

void
calebSetPortPausAll( void );

void
calebClrPortPaus( UINT8 port );

void
calebClrPortPausAll( void );

UINT8
calebGetPortPaus( UINT8 port );

UINT8
calebGetPortPausAll( void );

UINT8
calebGetPortPausd( UINT8 port );

UINT8
calebGetPortPausdAll( void );

void
calebSetPortRxThshld( UINT8 port, UINT8 thshld );

void
calebSetPortRxThshldAll( UINT8 thshld );

UINT8
calebGetPortRxThshld( UINT8 port );

void
calebSetPortTxThshld( UINT8 port, UINT8 thshld );

void
calebSetPortTxThshldAll( UINT8 thshld );

UINT8
calebGetPortTxThshld( UINT8 port );

UINT16
calebGetIXPRxCount();

UINT16
calebGetPhy0RxCount();

UINT16
calebGetPhy1RxCount();

UINT8
calebGetIXPTxCount();

UINT8
calebGetPhy0TxCount();

UINT8
calebGetPhy1TxCount();

void
calebDbgSetIrq( UINT16 mask );

void
calebDbgClrIrq( UINT16 mask );

void
calebDbgSetLoopback( void );

void
calebDbgClrLoopback( void );

void
calebDbgSetParityErr( UINT8 type );

void
calebDbgClrParityErr( UINT8 type );

void
calebShow();


#endif /*__CALEB_H__*/
