/*******************************************************************************
  INTEL CONFIDENTIAL

  Copyright 2003 Intel Corporation All Rights Reserved.

  The source code contained or described herein and all documents related to
  the source code ("Material") are owned by Intel Corporation or its
  suppliers or licensors.

  Title to the Material remains with Intel Corporation or its suppliers and
  licensors. The Material contains trade secrets and proprietary and
  confidential information of Intel or its suppliers and licensors.
  The Material is protected by worldwide copyright and trade secret laws and
  treaty provisions. No part of the Material may be used, copied, reproduced,
  modified, published, uploaded, posted, transmitted, distributed,
  or disclosed in any way without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure
  or delivery of the Materials, either expressly, by implication, inducement,
  estoppel or otherwise. Any license under such intellectual property rights
  must be express and approved by Intel in writing.

*******************************************************************************/

/**
 * ============================================================================
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2400 Network Processor
 *
 * = FILENAME
 *      linux_mmap_lib.c
 *
 * = DESCRIPTION
 *
 * ============================================================================
 */

#include "linux_mmap_lib.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

unsigned char *pVirtSramChan0Base = NULL;
unsigned char *pVirtSramChan1Base = NULL;
unsigned char *pVirtSDramBase = NULL;
unsigned char *pVirtScratchBase = NULL;

int memFd;

#define SRAM_CH1_ME_BASE 0x40000000

/* We support only Channel0 and Channel1 */
volatile unsigned int *
me2core_sram(unsigned int addr)
{

    if (addr > PHY_SRAM_CH0 + SRAM_CH0_REAL_SIZE)
    {
        printf("*********** WARNING: trying to access out of bounds 0x%.8x in SRAM channel 0 (0x0 - 0x%.8x).\n",
               addr, SRAM_CH0_REAL_SIZE + PHY_SRAM_CH0);
        exit(-1);
    }
    else
    {
        return (volatile unsigned int *) (pVirtSramChan0Base + addr - PHY_SRAM_CH0);
    }
}

volatile unsigned int *
me2core_dram(unsigned int addr)
{
    if (addr >  SDRAM_REAL_SIZE)
    {
        printf("*********** WARNING: trying to access out of bounds 0x%.8x in SDRAM (0x0-0x%.8x).\n",
               addr, SDRAM_REAL_SIZE);
        exit(-1);
    }
    else
    {
        return (volatile unsigned int *) (addr + pVirtSDramBase);
    }
}

void
internal_set_scratch(unsigned int addr, unsigned int value)
{
    if (addr > PHY_SCRATCH + SCRATCH_SIZE)
    {
        printf("*********** WARNING: trying to access out of bounds 0x%.8x in SCRATCH (0x0-0x%.8x).\n",
               addr, SCRATCH_SIZE + PHY_SCRATCH);
        exit(-1);
    }
    else
    {
        *(volatile unsigned int *)(addr + pVirtScratchBase - PHY_SCRATCH) = (unsigned int)(value);
    }
}

int
ind_lib_start(void)
{
    if ((memFd = open("/dev/mem", O_RDWR)) < 0)
    {
        printf("Error opening /dev/mem\n");
        return -1;
    }

    if ((pVirtSramChan0Base = mmap(NULL, SRAM_CH0_REAL_SIZE, PROT_READ | PROT_WRITE,
                                   MAP_SHARED, memFd, PHY_SRAM_CH0)) == MAP_FAILED)
    {
        printf("Error mapping SRAM channel 0\n");
        return -1;
    }

    printf("SRAM CH0: 0x%.8x mapped to 0x%.8x\n", PHY_SRAM_CH0, (unsigned int) pVirtSramChan0Base);

#if (SRAM_CH1_REAL_SIZE > 0)

    if ((pVirtSramChan1Base = mmap(NULL, SRAM_CH1_REAL_SIZE, PROT_READ | PROT_WRITE,
                                   MAP_SHARED, memFd, PHY_SRAM_CH1)) == MAP_FAILED)
    {
        printf("Error mapping SRAM channel 1\n");
        return -1;
    }

    printf("SRAM CH1: 0x%.8x mapped to 0x%.8x\n", PHY_SRAM_CH1, pVirtSramChan1Base);

#else

    printf("SRAM CH0: empty, not mapped.\n");

#endif

    if ((pVirtSDramBase = mmap(NULL, SDRAM_REAL_SIZE, PROT_READ | PROT_WRITE,
                               MAP_SHARED, memFd, 0)) == MAP_FAILED)
    {
        printf("Error mapping SDRAM.\n");
        return -1;
    }

    printf("SDRAM   : 0x%.8x mapped to 0x%.8x\n", PHYS_SDRAM_BASE, (unsigned int) pVirtSDramBase);

    if ((pVirtScratchBase = mmap(NULL, SCRATCH_SIZE, PROT_READ | PROT_WRITE,
                                 MAP_SHARED, memFd, PHY_SCRATCH)) == MAP_FAILED)
    {
        printf("Error mapping SCRATCH.\n");
        return -1;
    }

    printf("SCRATCH : 0x%.8x mapped to 0x%.8x\n", PHY_SCRATCH,  (unsigned int) pVirtScratchBase);

    return 0;
}

void
ind_lib_end(void)
{
    if (pVirtSramChan0Base)
    {
        munmap(pVirtSramChan0Base, SRAM_CH0_REAL_SIZE);
    }

    if (pVirtSramChan1Base)
    {
        munmap(pVirtSramChan1Base, SRAM_CH1_REAL_SIZE);
    }

    if (pVirtSDramBase)
    {
        munmap(pVirtSDramBase, SDRAM_REAL_SIZE);
    }

    if (pVirtScratchBase)
    {
        munmap(pVirtScratchBase, SCRATCH_SIZE);
    }

    close(memFd);

}












