/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a licence agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      l2_encap_init.c
 *
 * = DESCRIPTION
 *      This file contains scripts to initialize the quad_gbeth_jamestown
 *      application on an IXPD2401 platform.
 *
 * = AUTHOR
 *      Tomasz Madajczak
 *      tomasz.madajczak@intel.com
 *
 * = CHANGE HISTORY
 *      01/22/2003      Adopted from a POS file by Tomasz Madajczak
 * ============================================================================
 */

#include "../quad_gbeth_memory.h"
#include "xscale_init.h"

/* Defines for APP setup */

#define _L2_TABLE_SRAM_BASE (SRAM_BASE_CH0 + L2_TABLE_SRAM_BASE)

/*#define L2_TABLE_NUM_OF_ENTRIES	65536*/
#define L2_TABLE_NUM_OF_ENTRIES	(L2_TABLE_SRAM_SIZE/32)

/**
 * NAME: l2_encap_init_addresses
 *
 * DESCRIPTION: This function configures L2 addresses in the L2 table
 */
int l2_encap_init_addresses(void)
{

    int i;

	printf("l2_encap_init_addresse(): Configuring L2 Table addresses...\n");

    /* we need a lot of L2 static addreses (values of them are meaningless)*/
    for (i = 0; i < 0x200; i++)
    {

        /* setup L2_table entry */
        /* entry i */
        set_sram(_L2_TABLE_SRAM_BASE + 0x000 + (i<<4), 0x800090d7);
        set_sram(_L2_TABLE_SRAM_BASE + 0x004 + (i<<4), 0x00080000 + (i<<8));
        set_sram(_L2_TABLE_SRAM_BASE + 0x008 + (i<<4), 0x90d80008);
        set_sram(_L2_TABLE_SRAM_BASE + 0x00c + (i<<4), 0x00080000);

    }

#if 0
	/* setup 48 L2_table entries */
    /* entry 0 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x000,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x004,0x00080000);
	set_sram(_L2_TABLE_SRAM_BASE + 0x008,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x00c,0x00080000);

	/* entry 1 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x010,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x014,0x00080100);
	set_sram(_L2_TABLE_SRAM_BASE + 0x018,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x01c,0x01080000);

	/* entry 2 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x020,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x024,0x00080200);
	set_sram(_L2_TABLE_SRAM_BASE + 0x028,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x02c,0x02080000);

	/* entry 3 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x030,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x034,0x00080300);
	set_sram(_L2_TABLE_SRAM_BASE + 0x038,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x03c,0x03080000);

	/* entry 4 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x040,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x044,0x00080400);
	set_sram(_L2_TABLE_SRAM_BASE + 0x048,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x04c,0x04080000);

	/* entry 5 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x050,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x054,0x00080500);
	set_sram(_L2_TABLE_SRAM_BASE + 0x058,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x05c,0x05080000);

	/* entry 6 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x060,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x064,0x00080600);
	set_sram(_L2_TABLE_SRAM_BASE + 0x068,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x06c,0x06080000);

	/* entry 7 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x070,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x074,0x00080700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x078,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x07c,0x07080000);

	/* entry 8 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x080,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x084,0x00080800);
	set_sram(_L2_TABLE_SRAM_BASE + 0x088,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x08c,0x08080000);

	/* entry 9 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x090,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x094,0x00080900);
	set_sram(_L2_TABLE_SRAM_BASE + 0x098,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x09c,0x09080000);

	/* entry 10 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x0a0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0a4,0x00080a00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0a8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0ac,0x0a080000);

	/* entry 11 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x0b0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0b4,0x00080b00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0b8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0bc,0x0b080000);

	/* entry 12 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x0c0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0c4,0x00080c00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0c8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0cc,0x0c080000);

	/* entry 13 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x0d0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0d4,0x00080d00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0d8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0dc,0x0d080000);

	/* entry 14 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x0e0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0e4,0x00080e00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0e8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0ec,0x0e080000);

	/* entry 15 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x0f0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0f4,0x00080f00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0f8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x0fc,0x0f080000);

	/* entry 16 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x100,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x104,0x00081000);
	set_sram(_L2_TABLE_SRAM_BASE + 0x108,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x10c,0x10080000);

	/* entry 17 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x110,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x114,0x00081100);
	set_sram(_L2_TABLE_SRAM_BASE + 0x118,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x11c,0x11080000);

	/* entry 18 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x120,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x124,0x00081200);
	set_sram(_L2_TABLE_SRAM_BASE + 0x128,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x12c,0x12080000);

	/* entry 19 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x130,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x134,0x00081300);
	set_sram(_L2_TABLE_SRAM_BASE + 0x138,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x13c,0x13080000);

	/* entry 20 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x140,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x144,0x00081400);
	set_sram(_L2_TABLE_SRAM_BASE + 0x148,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x14c,0x14080000);

	/* entry 21 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x150,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x154,0x00081500);
	set_sram(_L2_TABLE_SRAM_BASE + 0x158,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x15c,0x15080000);

	/* entry 22 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x160,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x164,0x00081600);
	set_sram(_L2_TABLE_SRAM_BASE + 0x168,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x16c,0x16080000);

	/* entry 23 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x170,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x174,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x178,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x17c,0x17080000);

	/* entry 24 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x180,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x184,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x188,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x18c,0x18080000);

	/* entry 25 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x190,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x194,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x198,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x19c,0x19080000);

	/* entry 26 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x1a0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1a4,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1a8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1ac,0x1a080000);

	/* entry 27 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x1b0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1b4,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1b8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1bc,0x1b080000);

	/* entry 28 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x1c0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1c4,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1c8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1cc,0x1c080000);

	/* entry 29 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x1d0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1d4,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1d8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1dc,0x1d080000);

	/* entry 30 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x1e0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1e4,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1e8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1ec,0x1e080000);

	/* entry 31 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x1f0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1f4,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1f8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x1fc,0x1f080000);

	/* entry 32 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x200,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x204,0x00081700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x208,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x20c,0x20080000);

	/* entry 33 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x210,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x214,0x00080100);
	set_sram(_L2_TABLE_SRAM_BASE + 0x218,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x21c,0x21080000);

	/* entry 34 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x220,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x224,0x00080200);
	set_sram(_L2_TABLE_SRAM_BASE + 0x228,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x22c,0x22080000);

	/* entry 35 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x230,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x234,0x00080300);
	set_sram(_L2_TABLE_SRAM_BASE + 0x238,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x23c,0x23080000);

	/* entry 36 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x240,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x244,0x00080400);
	set_sram(_L2_TABLE_SRAM_BASE + 0x248,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x24c,0x24080000);

	/* entry 37 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x250,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x254,0x00080500);
	set_sram(_L2_TABLE_SRAM_BASE + 0x258,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x25c,0x25080000);

	/* entry 38 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x260,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x264,0x00080600);
	set_sram(_L2_TABLE_SRAM_BASE + 0x268,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x26c,0x26080000);

	/* entry 39 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x270,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x274,0x00080700);
	set_sram(_L2_TABLE_SRAM_BASE + 0x278,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x27c,0x27080000);

	/* entry 40 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x280,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x284,0x00080800);
	set_sram(_L2_TABLE_SRAM_BASE + 0x288,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x28c,0x28080000);

	/* entry 41 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x290,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x294,0x00080900);
	set_sram(_L2_TABLE_SRAM_BASE + 0x298,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x29c,0x29080000);

	/* entry 42 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x2a0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2a4,0x00080a00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2a8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2ac,0x2a080000);

	/* entry 43 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x2b0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2b4,0x00080b00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2b8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2bc,0x2b080000);

	/* entry 44 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x2c0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2c4,0x00080c00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2c8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2cc,0x2c080000);

	/* entry 45 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x2d0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2d4,0x00080d00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2d8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2dc,0x2d080000);

	/* entry 46 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x2e0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2e4,0x00080e00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2e8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2ec,0x2e080000);

	/* entry 47 */
	set_sram(_L2_TABLE_SRAM_BASE + 0x2f0,0x800090d7);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2f4,0x00080f00);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2f8,0x90d80008);
	set_sram(_L2_TABLE_SRAM_BASE + 0x2fc,0x2f080000);
    
#endif /* 0 */
    
	printf("L2 Table configuration COMPLETE.\n\n");

	return 1;
}




