//------------------------------------------------------------------------------------
//
//                   I N T E L   P R O P R I E T A R Y
//
//      COPYRIGHT (c)  2003 BY  INTEL  CORPORATION.  ALL RIGHTS
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//      THE PRIOR WRITTEN PERMISSION OF :
//
//                         INTEL  CORPORATION
//
//                      2200 MISSION COLLEGE BLVD
//
//                SANTA  CLARA,  CALIFORNIA  95052-8119
//
//------------------------------------------------------------------------------------
/////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: 	quad_gbeth_dl_system.h
//
//      Purpose: 	This file contains the system wide parameters that can be
//					customised for a given hardware/application
//
//      History:
//
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      01/22/2003      Created                         Tomasz Madajczak
//
//
/////////////////////////////////////////////////////////////////////////////
#ifndef	__QUAD_GBETH_DL_SYSTEM__H__
#define	__QUAD_GBETH_DL_SYSTEM__H__

#include <definitions.h>

#include "ix_cc_microengines_bindings.h"

#include "quad_gbeth_memory.h"

/*	Platform is IXDP2401 */
#ifndef IX_PLATFORM_2401
#define IX_PLATFORM_2401
#endif

/*	Chip is IXP2400 */
#ifndef IXP2400
#define IXP2400
#endif


#if 0  /* nizhner -- phy_mode (MPHY) is defined in dl_system.h */

/*	Receive Phy mode */
#define RX_PHY_MODE		SPHY_4_8

/* Transmit Phy mode */
#define TX_PHY_MODE 	SPHY_4_8		// SPHY_4x8 mode

#endif

//#define IPV4_COUNTERS_SCRATCH


#ifndef USE_IMPORT_VAR

/* free list id that is stored in meta data  in POS RX */

#define     FREE_LIST_ID                    0x0

//	Next 1 (20) SRAM Q-Array entry is used for Drop Queue in Queue Manager.

#define		QM_DROP_QUEUE_ENTRY				20


//	BLADE ID
#if 0	/* nizhner -- defined in dl_system.h */

#define		THIS_BLADE_ID					1

#endif

#endif	/* #ifdef USE_IMPORT_VAR */


#if 0 //now in quad_gbeth_memory.h
///////////////////////////////////////////
///  		SCRATCH DEFINITIONS
///////////////////////////////////////////

/* These are all Scratch ring definitions */

/*  There are two exception ring to send pkts up */
#define         EXCEPTION_RING_OUT_0			0
#define         EXCEPTION_RING_OUT_1			1

/*  There are two exception ring to send pkts down */
#define         EXCEPTION_RING_IN_0			    2
#define         EXCEPTION_RING_IN_1			    3


//	Scratch for communicating between ETH RX and IPv4 Blocks
//	Ring number 4, base 0, and size 128 Long Words

#define			ETH_RX_TO_IPV4_SCR_RING			4
#define			ETH_RX_TO_IPV4_SCR_RING_BASE	0
#define			ETH_RX_TO_IPV4_SCR_RING_SIZE	1024

//	Scratch for communicating between IPV4 and Queue Manager Blocks
//	Ring number 5, base 512, and size 128 Long Words

#define			IPV4_TO_QM_SCR_RING				5
#define			IPV4_TO_QM_SCR_RING_BASE		4096
#define			IPV4_TO_QM_SCR_RING_SIZE		512
#ifndef IXP_MICROCODE
#define			IPV4_TO_QM_SCR_RING_FULL_CSR	inp_state_scr_ring5_full 
#endif

//	Scratch for communicating between Scheduler and Queue Manager Blocks
//	Ring number 6, base 1024, and size 128 Long Words

#define			SCHEDULER_TO_QM_SCR_RING		6
#define			SCHEDULER_TO_QM_SCR_RING_BASE	6144
#define			SCHEDULER_TO_QM_SCR_RING_SIZE	512

//	First scractch ring for communicating between Queue Manager and Packet TX
//  microblocks
//	Ring number 6, base 4096, and size 256 long words
#define 		QM_TO_PACKET_TX_SCR_RING_0		7
#define 		QM_TO_PACKET_TX_SCR_RING_0_BASE	8192
#define 		QM_TO_PACKET_TX_SCR_RING_0_SIZE	128

//	Second scractch ring for communicating between Queue Manager and Packet TX
//  microblocks
//	Ring number 7, base 5120, and size 256 long words
#define 		QM_TO_PACKET_TX_SCR_RING_1		8
#define 		QM_TO_PACKET_TX_SCR_RING_1_BASE	9216
#define 		QM_TO_PACKET_TX_SCR_RING_1_SIZE	128

//	Third scractch ring for communicating between Queue Manager and Packet TX
//  microblocks
//	Ring number 8, base 6144, and size 256 long words
#define 		QM_TO_PACKET_TX_SCR_RING_2		9
#define 		QM_TO_PACKET_TX_SCR_RING_2_BASE	10240
#define 		QM_TO_PACKET_TX_SCR_RING_2_SIZE	128

//	Fourth scractch ring for communicating between Queue Manager and Packet TX
//  microblocks
//	Ring number 9, base 7168, and size 256 long words
#define 		QM_TO_PACKET_TX_SCR_RING_3		10
#define 		QM_TO_PACKET_TX_SCR_RING_3_BASE	11264
#define 		QM_TO_PACKET_TX_SCR_RING_3_SIZE	128

#endif /* 0 */

//  These defines are used by the individual microcode to identify their scratch rings.
//	The reason for these defines is to improve the portability of microblocks. User just
//	has to make changes here and the microblocks will remain untouched.
// 	For the naming convention, the microblock name goes first, then the _RING_ specifier.
//  Following this is the direction indicator. '_OUT' would imply the microblock is writing
//	to this scratch ring and '_IN' would imply the microblock is reading from this scratch
//	ring. If there is more than one 'IN' or 'OUT' ring the name will have '_<digit>' to
//  differentiate the rings.

#define			QM_RING_IN_0					IPV4_TO_QM_SCR_RING
#define			QM_RING_IN_0_BASE				IPV4_TO_QM_SCR_RING_BASE
#define			QM_RING_IN_0_SIZE				IPV4_TO_QM_SCR_RING_SIZE

#define			QM_RING_IN_1					SCHEDULER_TO_QM_SCR_RING
#define			QM_RING_IN_1_BASE				SCHEDULER_TO_QM_SCR_RING_BASE
#define			QM_RING_IN_1_SIZE				SCHEDULER_TO_QM_SCR_RING_SIZE

#define			QM_RING_OUT_0					QM_TO_PACKET_TX_SCR_RING_0
#define			QM_RING_OUT_0_BASE				QM_TO_PACKET_TX_SCR_RING_0_BASE
#define			QM_RING_OUT_0_SIZE				QM_TO_PACKET_TX_SCR_RING_0_SIZE

#define			QM_RING_OUT_1					QM_TO_PACKET_TX_SCR_RING_1
#define			QM_RING_OUT_1_BASE				QM_TO_PACKET_TX_SCR_RING_1_BASE
#define			QM_RING_OUT_1_SIZE				QM_TO_PACKET_TX_SCR_RING_1_SIZE


#define			QM_RING_OUT_2					QM_TO_PACKET_TX_SCR_RING_2
#define			QM_RING_OUT_2_BASE				QM_TO_PACKET_TX_SCR_RING_2_BASE
#define			QM_RING_OUT_2_SIZE				QM_TO_PACKET_TX_SCR_RING_2_SIZE

#define			QM_RING_OUT_3					QM_TO_PACKET_TX_SCR_RING_3
#define			QM_RING_OUT_3_BASE				QM_TO_PACKET_TX_SCR_RING_3_BASE
#define			QM_RING_OUT_3_SIZE				QM_TO_PACKET_TX_SCR_RING_3_SIZE


#define			SCHEDULER_RING_OUT				SCHEDULER_TO_QM_SCR_RING
#define			SCHEDULER_RING_OUT_BASE			SCHEDULER_TO_QM_SCR_RING_BASE
#define			SCHEDULER_RING_OUT_SIZE			SCHEDULER_TO_QM_SCR_RING_SIZE

#define			PACKET_TX_IN_0					QM_TO_PACKET_TX_SCR_RING_0
#define			PACKET_TX_IN_0_BASE				QM_TO_PACKET_TX_SCR_RING_0_BASE
#define			PACKET_TX_IN_0_SIZE				QM_TO_PACKET_TX_SCR_RING_0_SIZE

#define 		PACKET_TX_IN_1					QM_TO_PACKET_TX_SCR_RING_1
#define			PACKET_TX_IN_1_BASE				QM_TO_PACKET_TX_SCR_RING_1_BASE
#define			PACKET_TX_IN_1_SIZE				QM_TO_PACKET_TX_SCR_RING_1_SIZE


#define			PACKET_TX_IN_2					QM_TO_PACKET_TX_SCR_RING_2
#define			PACKET_TX_IN_2_BASE				QM_TO_PACKET_TX_SCR_RING_2_BASE
#define			PACKET_TX_IN_2_SIZE				QM_TO_PACKET_TX_SCR_RING_2_SIZE

#define 		PACKET_TX_IN_3					QM_TO_PACKET_TX_SCR_RING_3
#define			PACKET_TX_IN_3_BASE				QM_TO_PACKET_TX_SCR_RING_3_BASE
#define			PACKET_TX_IN_3_SIZE				QM_TO_PACKET_TX_SCR_RING_3_SIZE


//	Scratch address required by Packet TX for updating available Transmit Buffers.
//#define 		PACKET_TX_AVAIL_TBUF_ELE_SCR_ADDR	14336//ok


/////////////////////////////////////////////
///  	Q_ARRAY DEFINITIONS
/////////////////////////////////////////////
//	First 16 (0-15) SRAM Q-Array entries are allocated for the Queue Manager

#define			QM_QARRAY_BASE					0
#define			QM_QARRAY_SIZE					16

//	Next 4 (16-19) SRAM Q-Array entries are allocated for buffer free list

#define			BUF_QARRAY_BASE					16
#define			BUF_QARRAY_SIZE					4


//	Queue Number for Drop Queue. (0-1023 are the normal queues used in forwarding pkts)

#define			QM_DROP_QUEUE					1024

/////////////////////////////////////////////////
///  		SYSTEM DEFINITIONS
////////////////////////////////////////////////
//	These tell if a the executing threads need to work in order. i.e wait for
//	a signal from prev thread, do some work and signal next thread.

#define			DL_THREAD_NO_ORDER				0x0
#define			DL_THREAD_ORDER					0x1


//	All the IX_* constants should be between 0 and 255 (i.e 1 byte) to enable using
//	them as immed operands in instructions.

//	IX_NULL is used to denote a NULL (or empty) packet handle, It should not be zero, 
//	as it would interfere with ring empty (0) condition.

#define			IX_NULL							0xFF
#define			IX_EXCEPTION					0x1
#define			IX_DROP							0x2

#define			UC_NULL							0xFF		/* NULL for microcode */
#define			DL_BUF_NULL						UC_NULL 	/* NULL Buffer representation */


#define			BID_NULL						UC_NULL		/* NULL Block ID */
#define			BID_EXCEPTION					0x1			/* Exception Block ID */
#define			BID_DROP						0x2			/* Drop Block ID */


//	Block IDs for various blocks. Block IDs Start from 0x20. (0 to 0x1f and 0xFF are 
//	reserved for IX_* )

#define			BID_POS							IX_CC_POS_RX_PKT_ID
#define			BID_IPV4						IX_CC_IPV4_PKT_MICROBLOCK_ID
#define			BID_QM							0x23
#define 		BID_ETHER						IX_CC_ETH_TX_PKT_ID
#define			BID_IPV6						IX_DROP
#define			BID_ARP							IX_EXCEPTION
#define			BID_ETHER_PPP_DISCOVERY			0x27
#define			BID_ETHER_PPP_SESSION			0x28
#define			BID_MPLSILM						0x29

// 	Static Bindings (a.k.a targets) for various microblocks. 
//	Should this go into project/application specific global header file?

#define			DL_SOURCE_NEXT1					BID_ETHER
#define			POS_RX_NEXT1					BID_ETHER
#define			IPV4_NEXT1						BID_QM

#ifdef IX_PLATFORM_2401

/* Bug fix IGK0100027037. During merge to 3.5 definition of IPV4_LOCAL_NEXT1 is needed.
 *
 */

#ifndef			IPV4_LOCAL_NEXT1
#define			IPV4_LOCAL_NEXT1				IX_EXCEPTION
#endif

#endif /* IX_PLATFORM_2401 */

//	To be Redefined as an import variable. And its value should be one of the above
//	Block IDs.

//#ifdef			BID_NEXT_BLOCK
//#undef 			BID_NEXT_BLOCK
//#endif

#ifndef			BID_NEXT_BLOCK
#define			BID_NEXT_BLOCK					BID_QM
//#define			BID_NEXT_BLOCK					BID_ETHER
#endif

//	Signals being a precious resource, we use a single signal for 
//	inter-thread as well as any other inter-me signalling (init over signal)

#define			COMMON_INTER_THD_ME_SIGNAL		10

//	We are not able to use a single signal before of limitations in assembler.
//	until then, we need a separate signal for inter-thread signalling.

#define			INTER_THD_SIGNAL				12

//	ME_NIT_SIGNAL signal is used to let everyone know that initialisation is over
//	and all blocks in all MEs can start running. This signal will be typically issued
//	by the system initialisation code and all other MEs should wait for this signal
//	before starting to run.

#define			ME_INIT_SIGNAL					COMMON_INTER_THD_ME_SIGNAL

//////////////////////////////////////////////
//	Source and Sink related defines
//////////////////////////////////////////////

//	specify if next neighbor ring is used. If not, default is scratch rings.

// 	Valid values for RING_SIZE are 128, 256, 512 or 1024.

#define 		DL_RING_SIZE			ETH_RX_TO_IPV4_SCR_RING_SIZE
//#define 		DL_RING_SIZE			QM_TO_PACKET_TX_SCR_RING_0_SIZE

// 	Base Address for Scratch Ring is 0x1000. Should be aligned on a 4 x RING_SIZE byte boundary.

#define 		DL_RING_BASE			ETH_RX_TO_IPV4_SCR_RING_BASE
//#define 		DL_RING_BASE			QM_TO_PACKET_TX_SCR_RING_0_BASE

// 	Ring number to use. 0-15.

#ifndef IXP_MICROCODE
#define 	DL_RING_NUMBER			ETH_RX_TO_IPV4_SCR_RING	
#else
#define_eval 	DL_RING_NUMBER			ETH_RX_TO_IPV4_SCR_RING	
#endif
//#define_eval 	DL_RING_NUMBER			QM_TO_PACKET_TX_SCR_RING_0

// 	Signal number to use in inter thread signalling. 

#define 		DL_SIG_WAKE				INTER_THD_SIGNAL

// Drop buffer chain ring

#ifndef IXP_MICROCODE
#define 	DL_DROP_RING			IPV4_TO_QM_SCR_RING
#define		DL_DROP_RING_FULL		IPV4_TO_QM_SCR_RING_FULL_CSR
#else
#define_eval 	DL_DROP_RING			IPV4_TO_QM_SCR_RING
#endif

// some definition to keep compatibel with PR3 code
#ifdef IXP_MICROCODE
#define_eval QM_TO_POS_TX_SCR_RING_0 	QM_TO_PACKET_TX_SCR_RING_0
#define_eval QM_TO_POS_TX_SCR_RING_1 	QM_TO_PACKET_TX_SCR_RING_1
#else
#define QM_TO_POS_TX_SCR_RING_0 	QM_TO_PACKET_TX_SCR_RING_0
#define QM_TO_POS_TX_SCR_RING_1 	QM_TO_PACKET_TX_SCR_RING_1
#endif

//the below define is to obsolete old assembler
#ifdef IXP_MICROCODE
#define_eval _FULL 						_STATUS
#else
#define _FULL 						_STATUS
#endif

/*---------------------------------------------------------------------
 * 6) DRAM memory map.
 *-------------------------------------------------------------------*/

/* The DDR (Double Data Rate) DRAM bank size is used to randomize 
   buffer offset. */
#ifndef		DDR_BANK_SIZE
#define		DDR_BANK_SIZE			128
#endif

/* Number of DDR banks. */
#ifndef		NO_OF_DDR_BANKS
#define		NO_OF_DDR_BANKS			4
#endif

#define		MAX_BUFFER_OFFSET		(DDR_BANK_SIZE * NO_OF_DDR_BANKS)

/* Changes for PR6 compatibility */
#define		BID_ETHER_DECAP_NEXT1	(ETHER_IPV4_TYPE)
#define		BID_ETHER_DECAP_NEXT2	(ETHER_IPV6_TYPE)
#define		BID_ETHER_DECAP_NEXT3	(ETHER_ARP_TYPE)


/*
 * Define Default Targets for Ethernet microblock.
 */


#ifndef		TARGET_ETHER_DECAP_IPV4
#define TARGET_ETHER_DECAP_IPV4		BID_IPV4
#endif

#ifndef		ETHER_NEXT_IPV4
#define ETHER_NEXT_IPV4		BID_IPV4
#endif

#ifndef		TARGET_ETHER_DECAP_IPV6
#define TARGET_ETHER_DECAP_IPV6		BID_IPV6
#endif

#ifndef		ETHER_NEXT_IPV6
#define ETHER_NEXT_IPV6		BID_IPV6
#endif

#ifndef		TARGET_ETHER_DECAP_ARP
#define TARGET_ETHER_DECAP_ARP		BID_ARP
#endif

#ifndef		ETHER_NEXT_ARP
#define ETHER_NEXT_ARP		BID_ARP
#endif

#ifndef		TARGET_ETHER_DECAP_MPLS
#define TARGET_ETHER_DECAP_MPLS		BID_ILM_CLASSIFIER
#endif

#ifndef		ETHER_NEXT_MPLS
#define ETHER_NEXT_MPLS		BID_ILM_CLASSIFIER
#endif

#ifndef		TARGET_ETHER_DECAP_PPP_DISCOVERY
#define TARGET_ETHER_DECAP_PPP_DISCOVERY	BID_ETHER_PPP_DISCOVERY
#endif

#ifndef		ETHER_NEXT_PPP_DISCOVERY
#define ETHER_NEXT_PPP_DISCOVERY		BID_ETHER_PPP_DISCOVERY
#endif

#ifndef		TARGET_ETHER_DECAP_PPP_SESSION
#define TARGET_ETHER_DECAP_PPP_SESSION		BID_ETHER_PPP_SESSION
#endif

#ifndef		ETHER_NEXT_PPP_SESSION
#define ETHER_NEXT_PPP_SESSION		BID_ETHER_PPP_SESSION
#endif

#endif		// __QUAD_GBETH_DL_SYSTEM__H__

