# ******************************************************************************
#  INTEL CONFIDENTIAL
#
#  Copyright 2003 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material #ains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#
# ******************************************************************************

# ******************************************************************************
# ============================================================================
#
# = PRODUCT
#      Intel(r) IXA SDK for the IXP2400 Network Processor
#
# = FILENAME
#      quad_gbeth_2401_run.sh
#
# = DESCRIPTION
#
# ============================================================================
# ******************************************************************************

if [ -z "$1" ]; then
echo
echo Syntax for $0.
echo $0 [bb/db0/db1].
echo
echo Two Gb ports are always positioned on backplane.
echo
echo ie.1. Two other Gb on mezz in db0.
echo $0 db0
echo
echo ie.2. Two other Gb on baseboard [MIC or backplane].
echo $0 bb
echo
exit
fi

if [ "$1" = "db0" ]; then
    GB_CONF=0
elif [ "$1" = "db1" ]; then
    GB_CONF=1
elif [ "$1" = "bb" ]; then
    GB_CONF=2
else
    echo Two Gb ports are positioned on backplane.
    echo Specify where two other giga bit ports are positioned:
    echo On baseboard [baseboard MIC] - \"bb\" or
    echo on mezzanine in db0 or db1 - \"db0\" or \"db1\".
   exit
fi

# enable source routing in the stack
echo "1" > /proc/sys/net/ipv4/conf/all/accept_source_route
echo "1" > /proc/sys/net/ipv4/conf/all/forwarding

insmod ./libossl.o
insmod ./halMeDrv.o
insmod ./halMev2_lib.o
insmod ./rm_lib.o
insmod ./cci_lib.o
insmod ./utilities_lib.o
insmod ./msg_support_lib.o
insmod ./properties_lib.o
insmod ./fragmentation_lib.o
insmod ./lkup_lib.o
insmod ./rtmv4_lib.o
insmod ./l2tm_lib.o
insmod ./l2_config_util.o
insmod ./ether_arp_lib.o
insmod ./ipv4_cc.o
insmod ./route_config_util.o

if [ $GB_CONF = 0 ]; then
insmod ./bb_linux_drv val_conf="spi2;spi3;sphy;125mhz" db0_conf="spi0;spi1;sphy;125mhz"
elif [ $GB_CONF = 1 ]; then
insmod ./bb_linux_drv val_conf="spi2;spi3;sphy;125mhz" db1_conf="spi0;spi1;sphy;125mhz"
elif [ $GB_CONF = 2 ]; then
insmod ./bb_linux_drv val_conf="spi0;spi1;spi2;spi3;sphy;125mhz"
fi

insmod ./ixf1104drv_kernel.o
insmod ./ethernet_tx_cc.o
insmod ./ethernet_rx_cc.o
insmod ./qm_cc.o
insmod ./sched_cc.o
insmod ./stkdrv_cc.o
insmod ./quad_gbeth_2401_config.o
insmod ./sysapp_common_egress.o

./sa start 1 &

