/*******************************************************************************
  INTEL CONFIDENTIAL

  Copyright 2003 Intel Corporation All Rights Reserved.

  The source code contained or described herein and all documents related to
  the source code ("Material") are owned by Intel Corporation or its
  suppliers or licensors.

  Title to the Material remains with Intel Corporation or its suppliers and
  licensors. The Material contains trade secrets and proprietary and
  confidential information of Intel or its suppliers and licensors.
  The Material is protected by worldwide copyright and trade secret laws and
  treaty provisions. No part of the Material may be used, copied, reproduced,
  modified, published, uploaded, posted, transmitted, distributed,
  or disclosed in any way without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure
  or delivery of the Materials, either expressly, by implication, inducement,
  estoppel or otherwise. Any license under such intellectual property rights
  must be express and approved by Intel in writing.

*******************************************************************************/

/**
 * ============================================================================
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2400 Network Processor
 *
 * = FILENAME
 *      ipv4_enp2611_config_module.c
 *
 * = DESCRIPTION
 *
 * ============================================================================
 */

#if defined(MODULE) && defined(__KERNEL__)

#include <linux/config.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/string.h>

#include <sa/ix_sa_cc_list.h>


MODULE_LICENSE("Proprietary");

char	*uofFile = NULL;

MODULE_PARM(uofFile, "s");
MODULE_PARM_DESC(uofFile, "The name of microcode file");


int init_module(void)
{
    if (uofFile != NULL)	/* if provided at module load time */
    {
        if (strlen(uofFile) >= 512 - 1)
        {
            return E2BIG;
        }
        strcpy(g_sa_uofFile, uofFile);
    }
    return 0;
}


void cleanup_module(void)
{
    return;
}

#endif /* defined(MODULE) && defined(__KERNEL__) */
