/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      bindings.h
 *
 * = DESCRIPTION
 *      Defines communication ids for core components and maps output id of the component with
 *      input of the receiving component
 *
 * = CHANGE HISTORY
 *      8/15/2002 - Created
 * $Id: bindings.h,v 1.1.2.1 2004/03/11 17:44:46 ksandowi Exp $
 **/

#if !defined(__BINDINGS_H__)
#define __BINDINGS_H__
/* include resource manager communication header file */
#include "ix_rm.h"

#include "bindings_general.h"
#include "ix_cc_microengines_bindings.h"

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

 /*
 *    Only 255 - 64 ID available for core components. Because of limitations, the core components IDs
 *      are not splitted by range in order to preserve ID space. Some components require one or two input ids,
 *      and others may requre more.
 *      The enumeration below must list all CC input ids, and values must not exceed 253
 *
 *    Output ids should be defined to input ids of the next component.
 *    'Next Component' means component, module, or application that receives packets
 *    or messages from input componnet. For example, IPv4 sends some of packets to Queue Manager, so it will
 *    define output id for these packets to the input id of Queue Manager.
 */


/*   Core-to-microcode commIds are defined in the shared bindings file*/

/**
 *
 * DESCRIPTION: This enumeration defines the input ids for the core components
 *          New input ids should be added here for all core components. the total number
 *          of CC input ids must be between 64 and 254. The enumerated values are used as input
 *          to RM macros to make communication ids alligned to requirement of local, peer, and remote
 *          ids
 */

	/*ID for Dropping packets */
#define IX_CC_PKT_DROP_ID	254

#define IX_CC_START_CORE_COMP_IDS  (END_SHARED_COMM_IDS + 1)

enum  {
    /* IPV4 communication ids */
    IX_CC_IPV4_COMMON_ID = IX_CC_START_CORE_COMP_IDS,  /* input id for common packet handling */
    IX_CC_IPV4_PKT_STKDRV_ID, /* input id for stack driver packet handling */

    /*Shared commIds moved to shared bindings file*/
    /*IX_CC_IPV4_PKT_MICROBLOCK_HIGH_PRIORITY_ID,*/ /* input id for high priority packet handling */
    /*IX_CC_IPV4_PKT_MICROBLOCK_LOW_PRIORITY_ID,*/ /* input id for low priority packet handling */
    IX_CC_IPV4_MSG_ID, /* id for meesage handling */


    /* Stack Driver communication ids */
    IX_CC_STKDRV_COMMON_ID,             /* communication input for common packet handling */
    IX_CC_STKDRV_LOW_PRIORITY_PKT_ID,   /* communication input for low priority packet handling */
    IX_CC_STKDRV_HIGH_PRIORITY_PKT_ID,   /* communication input for high priority packet handling */
    IX_CC_STKDRV_MSG_ID,   /* communication input for message handling */
    IX_CC_STKDRV_FPM_ID,


    /* Pos Rx communication ids  */
    IX_CC_POS_RX_COMMON_ID,
    IX_CC_POS_RX_MSG_ID,
    /*Shared commIds moved to shared bindings file*/
    /*IX_CC_POS_RX_PKT_ID,*/

    /* FP Module communication ids  */
    IX_CC_FP_MODULE_COMMON_ID,
    IX_CC_FP_MODULE_MSG_ID,
    IX_CC_FP_MODULE_PKT_ID,
    IX_CC_FP_MODULE_EGRESS_ID,

    /* Eth Rx communication ids  */
    IX_CC_ETH_RX_COMMON_ID,
    IX_CC_ETH_RX_MSG_ID,
    /*Shared commIds moved to shared bindings file*/
    /*IX_CC_ETH_RX_PKT_ID,*/

    /* AtmPosTx communication ids  */
    IX_CC_ATM_POS_TX_COMMON_ID,
    IX_CC_ATM_POS_TX_MSG_ID,
    IX_CC_ATM_POS_TX_PROPERTY_MSG_ID,

    /*  Ethernet Tx communication ids  */
    IX_CC_ETH_TX_COMMON_ID,
    IX_CC_ETH_TX_HIGH_PRIORITY_PKT_ID,
    IX_CC_ETH_TX_MSG_ID,
    IX_CC_ETH_TX_PROPERTY_MSG_ID,

    /* Csix Rx communication ids  */
    IX_CC_CSIX_RX_COMMON_ID,
    IX_CC_CSIX_RX_MSG_ID,

    /* CSIX Tx communication ids  */
    IX_CC_CSIX_TX_COMMON_ID,
    IX_CC_CSIX_TX_MSG_ID,

    /* QM communication id */
    IX_CC_QM_COMMON_ID,     /* communication input for common packet handling */
    IX_CC_QM_EGRESS_ID,     /* communication input for egress QM for packets comming from ingress to egress */
    IX_CC_QM_MSG_ID,        /* communication id for the message input */
    IX_CC_QM_UBLOCK_ID,     /* communication id for the packet core to ublocks input */

    /* Message Support communication ids  */
    IX_CC_MSUP_COMMON_ID,
    IX_CC_MSUP_REPLY_EE_0_ID, /* reply input for EE 0 */
    IX_CC_MSUP_REPLY_EE_1_ID, /* reply input for EE 1 */
    IX_CC_MSUP_REPLY_EE_2_ID, /* reply input for EE 2 */
    IX_CC_MSUP_REPLY_EE_3_ID, /* reply input for EE 3 */
    IX_CC_MSUP_REPLY_EE_4_ID, /* reply input for EE 4 */

    /* System App communication id */
    IX_CC_SA_COMMON_ID,

    /* MPLS communication ids  */
    IX_CC_MPLS_COMMON_ID,
    IX_CC_MPLS_MSG_ID,

    /* CLASSIFIER_6T communication ids */
    IX_CC_CLASSIFIER_6T_MSG_ID,
    IX_CC_CLASSIFIER_6T_LOCAL_PKT_ID,

    /* CLASSIFIER_DSCP communication ids */
    IX_CC_CLASSIFIER_DSCP_PKT_ID,
    IX_CC_CLASSIFIER_DSCP_MSG_ID,

    /* TC Meter communication ids */
    IX_CC_TC_METER_PKT_ID,
    IX_CC_TC_METER_MSG_ID,

    /* WRED communication ids */
    IX_CC_WRED_PKT_ID,
    IX_CC_WRED_MSG_ID,

    /* IPv6 Core Component IDs */
    IX_CC_IPV6_COMMON_ID,  /* input id for common packet handling */
    IX_CC_IPV6_PKT_STKDRV_ID, /* input id for stack driver packet handling */

    /*Shared commIds moved to shared bindings file*/
    IX_CC_IPV6_MSG_ID, /* id for meesage handling */

    /* Ipv6/v4 tunneling communication ids */
    IX_CC_V6V4_PKT_IPV4_ID,
    IX_CC_V6V4_PKT_IPV6_ID,
    IX_CC_V6V4_MSG_ID,

    /* NAT-PT communication ids */
    IX_CC_NATPT_COMMON_ID,
    IX_CC_NATPT_MSG_ID,

    /* WARNING - the values in this enumeration should no exceed
        IX_COMM_FIRST_CORE_ID         + IX_COMM_LOCAL_ID_NUMBER */
    IX_CC_COMMID_LAST
};
#define IX_MAX_LOCAL_COMM_ID     (IX_COMM_FIRST_CORE_ID + IX_COMM_LOCAL_ID_NUMBER - 1)
/* TODO - system app might want to check IX_CC_COMMID_LAST against IX_MAX_LOCAL_COMM_ID
*   during initialization
*/

/* define peer susbsystem */
#define IX_PEER_SUBSYSTEM   1

/* microblock input */
/* TODO - coordinate this with resource manager and microblocks */
/* Aneet suggested to use 0 here */
#define IX_UBLOCK_PKT_ID        0
#define IX_UBLOCK_PKT_INPUT     IX_RM_COMM_MAKE_LOCAL_ID(IX_UBLOCK_PKT_ID)

/* define real INPUT IDS - this will be used
to register message and packet handlers */

/* use enum values to define inputs with rm macros from communication.h */
/* output id definitions are in the end of the file */

/*Drop output*/
#define IX_CC_PKT_DROP   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_PKT_DROP_ID)

/* START of Queue Manager INPUT ID definitions */

#define IX_CC_QM_COMMON_PKT_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_QM_COMMON_ID)
#define IX_CC_QM_EGRESS_PKT_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_QM_EGRESS_ID)
#define IX_CC_QM_MSG_INPUT          IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_QM_MSG_ID)
#define IX_CC_QM_UBLOCK_PKT_INPUT	IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_QM_UBLOCK_ID)

/* END of Queue Manager INPUT ID definitions */

/* START of IPV4 INPUT ID definitions */
#define IX_CC_IPV4_PKT_COMMON_INPUT     IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV4_COMMON_ID)
#define IX_CC_IPV4_PKT_STKDRV_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV4_PKT_STKDRV_ID)
#define IX_CC_IPV4_PKT_MICROBLOCK_HIGH_PRIORITY_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV4_PKT_MICROBLOCK_ID)
#define IX_CC_IPV4_PKT_MICROBLOCK_LOW_PRIORITY_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV4_PKT_MICROBLOCK_ID)
#define IX_CC_IPV4_MSG_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV4_MSG_ID)


/* END of IPV4 INPUT ID definitions */

/* START of IPV6 INPUT ID definitions */
#define IX_CC_IPV6_PKT_COMMON_INPUT     IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV6_COMMON_ID)
#define IX_CC_IPV6_PKT_STKDRV_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV6_PKT_STKDRV_ID)
#define IX_CC_IPV6_PKT_MICROBLOCK_HIGH_PRIORITY_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV6_PKT_MICROBLOCK_ID)
#define IX_CC_IPV6_PKT_MICROBLOCK_LOW_PRIORITY_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV6_PKT_MICROBLOCK_ID)
#define IX_CC_IPV6_MSG_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_IPV6_MSG_ID)


/* END of IPV6 INPUT ID definitions */

/* START of IPv6/V4 Tunneling INPUT ID definitions */
#define IX_CC_V6V4_PKT_IPV4_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_V6V4_PKT_IPV4_ID)
#define IX_CC_V6V4_PKT_IPV6_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_V6V4_PKT_IPV6_ID)
#define IX_CC_V6V4_PKT_MICROBLOCK_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_V6V4_PKT_MICROBLOCK_ID)
#define IX_CC_V6V4_MSG_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_V6V4_MSG_ID)


/* END of IPv6/V4 Tunneling INPUT ID definitions */

/* START of NAT-PT INPUT ID definitions */

#define IX_CC_NATPT_PKT_MICROBLOCK_INPUT  \
                        IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_NATPT_PKT_MICROBLOCK_ID)
#define IX_CC_NATPT_MSG_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_NATPT_MSG_ID)

/* END of NAT-PT INPUT ID definitions */

/* START of Stack Driver INPUT ID definitions */
#define IX_CC_STKDRV_COMMON_INPUT               IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_STKDRV_COMMON_ID)
#define IX_CC_STKDRV_LOW_PRIORITY_PKT_INPUT     IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_STKDRV_LOW_PRIORITY_PKT_ID)
#define IX_CC_STKDRV_HIGH_PRIORITY_PKT_INPUT    IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_STKDRV_HIGH_PRIORITY_PKT_ID)
#define IX_CC_STKDRV_MSG_INPUT                  IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_STKDRV_MSG_ID)
#define IX_CC_STKDRV_FPM_INPUT                  IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_STKDRV_FPM_ID)

/* END of Stack Driver INPUT ID definitions */

/* START of POS RX INPUT ID definitions */
#define IX_CC_POS_RX_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_POS_RX_COMMON_ID)
#define IX_CC_POS_RX_MSG_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_POS_RX_MSG_ID)
#define IX_CC_POS_RX_PKT_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_POS_RX_PKT_ID)

/* add Pos Rx input ids */

/* END of POS_RX INPUT ID definitions */

/* START of FP Module INPUT ID definitions */
#define IX_CC_FP_MODULE_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_FP_MODULE_COMMON_ID)
#define IX_CC_FP_MODULE_MSG_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_FP_MODULE_MSG_ID)
#define IX_CC_FP_MODULE_PKT_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_FP_MODULE_PKT_ID)
#define IX_CC_FP_MODULE_EGRESS_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_FP_MODULE_EGRESS_ID)
#define IX_CC_FP_MODULE_INGRESS_OUTPUT   IX_RM_COMM_MAKE_ID(IX_CC_FP_MODULE_EGRESS_INPUT, IX_PEER_SUBSYSTEM, 0)
#define IX_CC_FP_MODULE_INGRESS_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_FP_MODULE_MSG_INPUT)
#define IX_CC_FP_MODULE_EGRESS_OUTPUT   IX_RM_COMM_MAKE_ID(IX_CC_FP_MODULE_INGRESS_INPUT, IX_PEER_SUBSYSTEM, 0)

/* add FP Module input ids */

/* END of FP_MODULE INPUT ID definitions */

/* START of Ethernet RX INPUT ID definitions */
#define IX_CC_ETH_RX_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_RX_COMMON_ID)
#define IX_CC_ETH_RX_MSG_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_RX_MSG_ID)
#define IX_CC_ETH_MICROBLOCK_HIGH_PRIORITY_PKT_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_RX_PKT_ID)
#define IX_CC_ETH_MICROBLOCK_LOW_PRIORITY_PKT_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_RX_PKT_ID)


/* END of Ethernet RX INPUT ID definitions */


/* Number of execution engine IDs defined */
#define IX_CC_MSUP_NUM_EE_INPUTS 5

/* START of Message Support INPUT ID definitions */
#define IX_CC_MSUP_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MSUP_COMMON_ID)
#define IX_CC_MSUP_EE_0_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MSUP_REPLY_EE_0_ID)
#define IX_CC_MSUP_EE_1_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MSUP_REPLY_EE_1_ID)
#define IX_CC_MSUP_EE_2_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MSUP_REPLY_EE_2_ID)
#define IX_CC_MSUP_EE_3_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MSUP_REPLY_EE_3_ID)
#define IX_CC_MSUP_EE_4_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MSUP_REPLY_EE_4_ID)
/* END of Message Support INPUT ID definitions */


/* START of ATM_POS_TX INPUT ID definitions */
#define IX_CC_ATM_POS_TX_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ATM_POS_TX_COMMON_ID)
#define IX_CC_ATM_POS_TX_MSG_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ATM_POS_TX_MSG_ID)
#define IX_CC_ATM_POS_TX_PROPERTY_MSG_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ATM_POS_TX_PROPERTY_MSG_ID)
/* add ATM POS Tx input ids */


/* END of ATM_POS_TX INPUT ID definitions */

/* START of CSIX_RX INPUT ID definitions */
#define IX_CC_CSIX_RX_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_CSIX_RX_COMMON_ID)
#define IX_CC_CSIX_RX_MSG_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_CSIX_RX_MSG_ID)

/* add CSIX RX input ids */
/* END of CSIX_RX INPUT ID definitions */


/* START of CSIX_TX INPUT ID definitions */
#define IX_CC_CSIX_TX_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_CSIX_TX_COMMON_ID)
#define IX_CC_CSIX_TX_MSG_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_CSIX_TX_MSG_ID)
/* add CSIX TX input ids */
/* END of CSIX_TX INPUT ID definitions */


/* START of Ethernet Tx INPUT ID definitions */

#define IX_CC_ETH_TX_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_TX_COMMON_ID)
#define IX_CC_ETH_TX_ARP_PKT_INPUT     IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_TX_HIGH_PRIORITY_PKT_ID)
#define IX_CC_ETH_TX_UBLK_PKT_INPUT  IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_TX_PKT_ID)
#define IX_CC_ETH_TX_MSG_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_TX_MSG_ID)
#define IX_CC_ETH_TX_PROPERTY_MSG_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_ETH_TX_PROPERTY_MSG_ID)
/* END of Ethernet Tx INPUT ID definitions */


/* START of System App INPUT ID definitions */

#define IX_CC_SA_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_SA_COMMON_ID)
/* add System App  input ids */

/* END of System App INPUT ID definitions */


/* START of MPLS INPUT ID definitions */
#define IX_CC_MPLS_COMMON_INPUT   IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MPLS_COMMON_ID)
#define IX_CC_MPLS_MSG_INPUT      IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MPLS_MSG_ID)
#define IX_CC_MPLS_PKT_MICROBLOCK_LOW_PRIORITY_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_MPLS_PKT_MICROBLOCK_ID)
/* END of MPLS INPUT ID definitions */

/* START of CLASSIFER_6T INPUT ID definitions */
#define IX_CC_CLASSIFIER_6T_MSG_INPUT               IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_CLASSIFIER_6T_MSG_ID)
#define IX_CC_CLASSIFIER_6T_LOCAL_PKT_INPUT         IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_CLASSIFIER_6T_LOCAL_PKT_ID)
#define IX_CC_CLASSIFIER_6T_MICROBLOCK_PKT_INPUT    IX_CC_CLASSIFIER_6T_PKT_MICROBLOCK_ID
/* END of CLASSIFIER_6T INPUT ID definitions */

/* START of CLASSIFIER DSCP INPUT ID definitions */
#define IX_CC_CLASSIFIER_DSCP_LOCAL_PKT_INPUT  IX_RM_COMM_MAKE_LOCAL_ID( IX_CC_CLASSIFIER_DSCP_PKT_ID )
#define IX_CC_CLASSIFIER_DSCP_MSG_INPUT        IX_RM_COMM_MAKE_LOCAL_ID( IX_CC_CLASSIFIER_DSCP_MSG_ID )
/* END of CLASSIFIER DSCP INPUT ID definitions */


/* START of TC Meter INPUT ID definitions */
/* local input for other core componenets to send packets to wred */
#define IX_CC_TC_METER_PKT_INPUT           IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_TC_METER_PKT_ID)
#define IX_CC_TC_METER_MSG_INPUT           IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_TC_METER_MSG_ID)
/* END of TC Meter INPUT ID definitions */

/* START of WRED INPUT ID definitions */
/* local input for other core componenets to send packets to wred */
#define IX_CC_WRED_PKT_INPUT            IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_WRED_PKT_ID)
#define IX_CC_WRED_MSG_INPUT            IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_WRED_MSG_ID)
/* END of WRED INPUT ID definitions */


/* define outputs  - in fact it defines comminication map */
/* this should go after all input definitions */

/*START of POS Rx OUTPUT ID definitions */
#ifdef IX_PLATFORM_2401
#define IX_CC_POS_RX_PKT_OUTPUT				IX_CC_QM_COMMON_PKT_INPUT
#else /*IX_PLATFORM_2401*/
#define IX_CC_POS_RX_PKT_OUTPUT				IX_CC_PKT_DROP /*PPP control packets are dropped right now*/
#endif /*IX_PLATFORM_2401*/
/*END of POS Rxer OUTPUT ID definitions */

/*START of Ethernet Rx OUTPUT ID definitions */
#define IX_CC_ETH_RX_COMMON_PKT_OUTPUT				IX_CC_PKT_DROP /*Non IP  packets are dropped right now*/
#define IX_CC_ETH_RX_ARP_PKT_OUTPUT  	IX_RM_COMM_MAKE_ID(IX_CC_ETH_TX_ARP_PKT_INPUT, IX_PEER_SUBSYSTEM, 0)
#define IX_CC_ETH_RX_MSG_OUTPUT  	IX_RM_COMM_MAKE_ID(IX_CC_ETH_TX_MSG_INPUT, IX_PEER_SUBSYSTEM, 0)
/*END of Eth Rx OUTPUT ID definitions */

/*START of Ethernet Tx OUTPUT ID definitions */
#define IX_CC_ETH_TX_COMMON_PKT_OUTPUT      IX_CC_QM_EGRESS_PKT_INPUT
#define IX_CC_ETH_TX_ARP_PKT_OUTPUT         IX_CC_QM_EGRESS_PKT_INPUT
#define IX_CC_ETH_TX_FP_MODULE_MSG_OUTPUT   IX_CC_FP_MODULE_EGRESS_OUTPUT
#define IX_CC_ETH_TX_IPV6_PKT_OUTPUT        IX_RM_COMM_MAKE_ID(IX_CC_IPV6_MSG_INPUT, IX_PEER_SUBSYSTEM, 0)
/*END of Eth Tx OUTPUT ID definitions */

/* START of Queue Manager OUTPUT ID definitions */
#define IX_CC_QM_UBLOCK_PKT_OUTPUT          IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_QM_CORE_TO_MICROBLOCK_ID)
#define IX_CC_QM_EGRESS_PKT_OUTPUT          IX_RM_COMM_MAKE_ID(IX_CC_QM_EGRESS_PKT_INPUT,IX_PEER_SUBSYSTEM,0)
/* END of Queue Manager OUTPUT ID definitions */

/* START of Stack Driver OUTPUT ID definitions */
#define IX_CC_STKDRV_MULTICAST_PKT_OUTPUT          IX_CC_QM_COMMON_PKT_INPUT
#define IX_CC_STKDRV_NEED_ROUTE_PKT_OUTPUT         IX_CC_IPV4_PKT_STKDRV_INPUT
/* END of Stack Driver OUTPUT ID definitions */

/* Start of IPv4 OUTPUT ID definitions */
#define IX_CC_IPV4_PKT_QM_OUTPUT                   IX_CC_QM_COMMON_PKT_INPUT
#define IX_CC_IPV4_PKT_QM_BID                      IX_CC_QM_CORE_TO_MICROBLOCK_ID
#define IX_CC_IPV4_PKT_HIGH_PRIORITY_STKDRV_OUTPUT IX_CC_STKDRV_HIGH_PRIORITY_PKT_INPUT
#define IX_CC_IPV4_PKT_LOW_PRIORITY_STKDRV_OUTPUT  IX_CC_STKDRV_LOW_PRIORITY_PKT_INPUT

/* End of IPv4 OUTPUT ID definitions*/

/* Start of IPv6 OUTPUT ID definitions */
#define IX_CC_IPV6_PKT_QM_OUTPUT    IX_CC_QM_COMMON_PKT_INPUT
#define IX_CC_IPV6_PKT_HIGH_PRIORITY_STKDRV_OUTPUT \
                                    IX_CC_STKDRV_HIGH_PRIORITY_PKT_INPUT
#define IX_CC_IPV6_PKT_LOW_PRIORITY_STKDRV_OUTPUT  \
                                    IX_CC_STKDRV_LOW_PRIORITY_PKT_INPUT
/* End of IPv6 OUTPUT ID definitions*/


/* Start of IPv6/V4 Tunneling OUTPUT ID definitions */
#define IX_CC_V6V4_PKT_DEFAULT_OUTPUT    IX_CC_QM_COMMON_PKT_INPUT
#define IX_CC_V6V4_PKT_LOW_PRIORITY_STKDRV_OUTPUT  IX_CC_STKDRV_LOW_PRIORITY_PKT_INPUT
#define IX_CC_V6V4_PKT_HIGH_PRIORITY_STKDRV_OUTPUT  IX_CC_STKDRV_HIGH_PRIORITY_PKT_INPUT
#define IX_CC_V6V4_PKT_IPV4_OUTPUT  IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_V6V4_PKT_IPV6_OUTPUT  IX_CC_IPV6_PKT_COMMON_INPUT
/* End of IPv6/V4 Tunneling OUTPUT ID definitions*/

/* Start of NAT-PT OUTPUT ID definitions */
#define IX_CC_NATPT_PKT_QM_OUTPUT  IX_CC_QM_COMMON_PKT_INPUT
#define IX_CC_NATPT_PKT_HIGH_PRIORITY_STKDRV_OUTPUT \
                             IX_CC_STKDRV_HIGH_PRIORITY_PKT_INPUT
#define IX_CC_NATPT_PKT_LOW_PRIORITY_STKDRV_OUTPUT \
                             IX_CC_STKDRV_LOW_PRIORITY_PKT_INPUT
#define IX_CC_NATPT_PKT_IPV4_OUTPUT  IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_NATPT_PKT_IPV6_OUTPUT  IX_CC_IPV6_PKT_COMMON_INPUT
/* End of NAT-PT OUTPUT ID definitions */

/* START of Classifier 6t OUTPUT ID definitions */
#define IX_CC_CLASSIFIER_6T_METER_OUTPUT       IX_CC_TC_METER_PKT_INPUT
#define IX_CC_CLASSIFIER_6T_METER_BID          IX_CC_TC_METER_PKT_MICROBLOCK_ID

#define IX_CC_CLASSIFIER_6T_MARKER_OUTPUT      IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_CLASSIFIER_6T_MARKER_BID         IX_CC_DSCP_MARKER_PKT_MICROBLOCK_ID

#define IX_CC_CLASSIFIER_6T_FORWARDER_OUTPUT   IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_CLASSIFIER_6T_FORWARDER_BID      IX_CC_IPV4_PKT_MICROBLOCK_ID

#define IX_CC_CLASSIFIER_6T_DEFAULT_OUTPUT     IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_CLASSIFIER_6T_DEFAULT_BID        IX_CC_IPV4_PKT_MICROBLOCK_ID
/* END of Classifier 6t OUTPUT ID definitions */


/* START of CLASSIFIER DSCP OUTPUT ID definitions */
#define IX_CC_CLASSIFIER_DSCP_METER_OUTPUT              IX_CC_TC_METER_PKT_INPUT
#define IX_CC_CLASSIFIER_DSCP_IP4_FWD_OUTPUT            IX_CC_IPV4_COMMON_INPUT
#define IX_CC_CLASSIFIER_DSCP_IP6_FWD_OUTPUT            IX_CC_IPV6_COMMON_INPUT
#define IX_CC_CLASSIFIER_DSCP_INV_IP_OUTPUT             IX_CC_PKT_DROP

#define IX_CC_CLASSIFIER_DSCP_IP4_DEFAULT_OUTPUT        IX_CC_CLASSIFIER_6T_LOCAL_PKT_INPUT
#define IX_CC_CLASSIFIER_DSCP_IP6_DEFAULT_OUTPUT        IX_CC_PKT_DROP

/* END of CLASSIFIER DSCP OUTPUT ID definitions */


/* START of WRED OUTPUT ID definitions */
#define IX_CC_WRED_PKT_OUTPUT                  IX_CC_QM_CORE_TO_MICROBLOCK_ID
/* END of WRED OUTPUT ID definitions */


/* START of TC Meter OUTPUT ID definitions */
#define IX_CC_TC_METER_PKT_OUTPUT              IX_CC_QM_CORE_TO_MICROBLOCK_ID
/* END of TC Meter OUTPUT ID definitions */


/* START of MPLS OUTPUT ID definitions */
#define IX_CC_MPLS_ILM_CLASSIFIER_PKT_OUTPUT_1 IX_CC_MPLS_COMMON_INPUT
#define IX_CC_MPLS_ILM_CLASSIFIER_PKT_OUTPUT_2 IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_MPLS_ILM_CLASSIFIER_PKT_OUTPUT_3 IX_CC_IPV6_PKT_COMMON_INPUT
#define IX_CC_MPLS_ILM_CLASSIFIER_PKT_OUTPUT_4 IX_CC_TC_METER_PKT_INPUT
#define IX_CC_MPLS_ILM_CLASSIFIER_PKT_OUTPUT_5 IX_CC_IPV4_PKT_COMMON_INPUT
#define IX_CC_MPLS_ILM_CLASSIFIER_PKT_OUTPUT_6 IX_CC_CLASSIFIER_6T_LOCAL_PKT_INPUT

#define IX_CC_MPLS_MARKER_PKT_OUTPUT    IX_CC_QM_CORE_TO_MICROBLOCK_ID

/* END of MPLS OUTPUT ID definitions */


/* This set of defines provides CC IDs for all Core Components.
 * These are used in ix_sa_cc_list.c as a unique identifier to assign
 * init and fini pointers for CCs.
 * These IDs are then used in ix_sa_registry_data.xml to indicate which
 * core coponents will be launched in each execution engine.
 *
 * We cannot use and enumeration here because we need preprocessor
 * substitution.
 */
#define IX_CC_IPV4              0
#define IX_CC_STKDRV            1
#define IX_CC_POS_RX            2
#define IX_CC_ATM_POS_TX        3
#define IX_CC_CSIX_RX           4
#define IX_CC_CSIX_TX           5
#define IX_CC_QM                6
#define IX_CC_SCHEDULER         7
#define IX_CC_ETH_TX            8
#define IX_CC_ETH_RX            9
#define IX_CC_MPLS              10
#define IX_CC_CLASSIFIER_6T     11
#define IX_CC_TC_METER          12
#define IX_CC_WRED              13
#define IX_CC_IPV6              14
#define IX_CC_V6V4              15
#define IX_CC_FPM               16
#define IX_CC_CLASSIFIER_DSCP   17
#define IX_CC_NATPT             18
#define IX_CC_FPM_PROXY         19
#define IX_CC_ENUM_LAST         20

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__BINDINGS_H__) */

