/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 2003 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmitted,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*
 * linux_mmap_lib.h
 */

#define __C_COMPILER__
#define IXP2400
#define CORE_CODE 1

#include <stdio.h>
#include <stdlib.h>
#include <asm-arm/arch-ixp2000/hardware.h>
#include "definitions.h"
#include <linux/config.h>

#define PHY_SRAM_CH0    0x80000000
#define SRAM_CH0_SIZE   0x02000000

#define PHY_SRAM_CH1    0x90000000
#define SRAM_CH1_SIZE   0x02000000

#define PHY_SCRATCH     0xca000000
/*#define SCRATCH_SIZE    0x02000000*/
#define SCRATCH_SIZE    0x4000 /* 16KB */ /* from xscale init for VxWorks */


#ifndef SRAM_CH0_REAL_SIZE
//#define SRAM_CH0_REAL_SIZE (4*1024*1024)
#define SRAM_CH0_REAL_SIZE SRAM_CH0_SIZE
#endif

#ifndef SRAM_CH1_REAL_SIZE
#define SRAM_CH1_REAL_SIZE (0)
#endif

#ifndef SDRAM_REAL_SIZE
#define SDRAM_REAL_SIZE    (224*1024*1024)
#endif

#if (SRAM_CH0_REAL_SIZE > SRAM_CH0_SIZE)
#undef SRAM_CH0_REAL_SIZE
#define SRAM_CH0_REAL_SIZE SRAM_CH0_SIZE
#endif

#if (SRAM_CH1_REAL_SIZE > SRAM_CH1_SIZE)
#undef SRAM_CH1_REAL_SIZE
#define SRAM_CH1_REAL_SIZE SRAM_CH1_SIZE
#endif

#if (SDRAM_REAL_SIZE > PHYS_SDRAM_SIZE)
#undef SDRAM_REAL_SIZE
#define SDRAM_REAL_SIZE PHYS_SDRAM_SIZE
#endif

volatile unsigned int *me2core_sram(unsigned int addr);

volatile unsigned int *me2core_dram(unsigned int addr);

int ind_lib_start(void);

void ind_lib_end(void);

int log2(int arg);

void internal_set_scratch(unsigned int addr, unsigned int value);

#define ps_start_packet_receive() \
        printf("Now ready to receive packets.")

#define get_sram(addr) \
    	(*(volatile unsigned int *) me2core_sram(addr))
#define set_sram(addr, value) \
        (*(volatile unsigned int *) me2core_sram(addr) = (unsigned int)(value))

#define get_dram(addr) \
        (*(volatile unsigned int *) me2core_dram(addr))
#define set_dram(addr, value) \
        (*(volatile unsigned int *) me2core_dram(addr) = (unsigned int)(value))

#define set_scratch(addr, value) \
        internal_set_scratch(addr, (unsigned int) value);

#define init_lmem(me, value) \
        printf("Warning: Init LM for ME#%d with %08x. Unsupported...\n", me, value);

#define init_sram(value, startAddr, stopAddr) \
    { \
	    int _ii; \
        printf("Filling SRAM memory from 0x%x to 0x%x, size 0x%x\n", (startAddr), (stopAddr), (stopAddr) - (startAddr)); \
 	    for (_ii = startAddr; _ii < stopAddr; _ii += 4) set_sram(_ii, value); \
    }

#define init_dram(value, startAddr, stopAddr) \
    { \
       int _ii; \
       printf("Filling DRAM memory from 0x%x to 0x%x, size 0x%x\n", (startAddr), (stopAddr), (stopAddr) - (startAddr)); \
       for (_ii = startAddr; _ii < stopAddr; _ii += 4) set_dram(_ii, value); \
    }

#define init_scratch(value, startAddr, stopAddr) \
    { \
       int _ii; \
       printf("Filling SCRATCH memory from 0x%x to 0x%x, size 0x%x\n", (startAddr), (stopAddr), (stopAddr) - (startAddr)); \
       for (_ii = startAddr; _ii < stopAddr; _ii += 4) set_scratch(_ii, value); \
    }









