/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a licence agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ethernet_rtm_routes.c
 *
 * = DESCRIPTION
 *      This file contains scripts to initialize the quad_gbeth_jamestown
 *      application on an IXPD2401 platform.
 *
 * = AUTHOR
 *      Tomasz Madajczak
 *      tomasz.madajczak@intel.com
 *
 * = CHANGE HISTORY
 *      01/22/2003      Adopted from a POS file by Tomasz Madajczak
 * ============================================================================
 */

#include "../quad_gbeth_memory.h"
#include "xscale_init.h"

/* Defines for APP setup */

int rtm_routes(void) {

int trie_base = SRAM_BASE_CH0 + TRIE_TABLE_SRAM_BASE;

int nh_base = SDRAM_BASE + NEXTHOP_TABLE_SDRAM_BASE;


SDRAM_WRITE(nh_base + 0x0,0xffffffff);

/* #
   # This rtm_routes is used for testing IPv4 PR-5 onwards.
   #
 */

 /* #-----------------------------------------------
    # Limited broadcast - exception
    #-----------------------------------------------
 */

/* add 255.255.255.255 255.255.255.255 0x7255 0x8 1500 0x02000000
 */
/* @@@ Adding dest=0xffffffff, mask = 0xffffffff, blade_nh_id=0x2007255,mtu_port=0x05dc0000,flags=0x8 */

	SRAM_WRITE(trie_base + 0x4053c,0x10000);

/* writing nexthop entry with flags 0x8 */

SDRAM_WRITE(nh_base + 0x10,0x8);

/* blade 0x2 and NH 0x7255 */

SDRAM_WRITE(nh_base + 0x14,0x2007255);

/* MTU is 1500, outport is 0x0 */

SDRAM_WRITE(nh_base + 0x18,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1c,0x0);


	SRAM_WRITE(trie_base + 0x404fc,0x4);


	SRAM_WRITE(trie_base + 0x404bc,0x3);


	SRAM_WRITE(trie_base + 0x4047c,0x2);


	SRAM_WRITE(trie_base + 0x3fffc,0x1);

/* #-----------------------------------------------
   #  Invalid destination addresses
   #----------------------------------------------
 */

/* # dst==0 - drop
 */

/* add 0.0.0.0 255.255.255.255 0x7000 0x4 1500 0x02000000
 */
/* @@@ Adding dest=0x0, mask = 0xffffffff, blade_nh_id=0x2007000,mtu_port=0x05dc0000,flags=0x4 */

	SRAM_WRITE(trie_base + 0x40600,0x20000);

/* writing nexthop entry with flags 0x4 */

SDRAM_WRITE(nh_base + 0x20,0x4);

/* blade 0x2 and NH 0x7000 */

SDRAM_WRITE(nh_base + 0x24,0x2007000);

/* MTU is 1500, outport is 0x0 */

SDRAM_WRITE(nh_base + 0x28,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2c,0x0);


	SRAM_WRITE(trie_base + 0x405c0,0x8);


	SRAM_WRITE(trie_base + 0x40580,0x7);


	SRAM_WRITE(trie_base + 0x40540,0x6);


	SRAM_WRITE(trie_base + 0x0,0x5);

/* # dst==127.*.*.* - drop
 */

/* add 127.0.0.0 255.0.0.0 0x7127 0x4 1500 0x03000000
 */
/* @@@ Adding dest=0x7f000000, mask = 0xff000000, blade_nh_id=0x3007127,mtu_port=0x05dc0000,flags=0x4 */

	SRAM_WRITE(trie_base + 0x401fc,0x30000);

/* writing nexthop entry with flags 0x4 */

SDRAM_WRITE(nh_base + 0x30,0x4);

/* blade 0x3 and NH 0x7127 */

SDRAM_WRITE(nh_base + 0x34,0x3007127);

/* MTU is 1500, outport is 0x0 */

SDRAM_WRITE(nh_base + 0x38,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3c,0x0);

/* # dst==classE - drop
 */
/* add 240.0.0.0 240.0.0.0 0x7740 0x4 1500 0x04000000
 */
/* @@@ Adding dest=0xf0000000, mask = 0xf0000000, blade_nh_id=0x4007240,mtu_port=0x05dc0000,flags=0x4 */

	SRAM_WRITE(trie_base + 0x403c0,0x40000);


	SRAM_WRITE(trie_base + 0x403c4,0x40000);


	SRAM_WRITE(trie_base + 0x403c8,0x40000);


	SRAM_WRITE(trie_base + 0x403cc,0x40000);


	SRAM_WRITE(trie_base + 0x403d0,0x40000);


	SRAM_WRITE(trie_base + 0x403d4,0x40000);


	SRAM_WRITE(trie_base + 0x403d8,0x40000);


	SRAM_WRITE(trie_base + 0x403dc,0x40000);


	SRAM_WRITE(trie_base + 0x403e0,0x40000);


	SRAM_WRITE(trie_base + 0x403e4,0x40000);


	SRAM_WRITE(trie_base + 0x403e8,0x40000);


	SRAM_WRITE(trie_base + 0x403ec,0x40000);


	SRAM_WRITE(trie_base + 0x403f0,0x40000);


	SRAM_WRITE(trie_base + 0x403f4,0x40000);


	SRAM_WRITE(trie_base + 0x403f8,0x40000);


	SRAM_WRITE(trie_base + 0x403fc,0x40000);

/* writing nexthop entry with flags 0x4 */ 

SDRAM_WRITE(nh_base + 0x40,0x4);

/* blade 0x4 and NH 0x7240 */

SDRAM_WRITE(nh_base + 0x44,0x4007240);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x48,0x05dc0000);


SDRAM_WRITE(nh_base + 0x4c,0x0);

/* # dest==multicast - exception
 */ 
/* add 224.0.0.0 224.0.0.0 0x7224 0x10 1500 0x05000000
 */
/* @@@ Adding dest=0xe0000000, mask = 0xe0000000, blade_nh_id=0x5007224,mtu_port=0x05dc0000,flags=0x10 */

	SRAM_WRITE(trie_base + 0x40380,0x50000);


	SRAM_WRITE(trie_base + 0x40384,0x50000);


	SRAM_WRITE(trie_base + 0x40388,0x50000);


	SRAM_WRITE(trie_base + 0x4038c,0x50000);


	SRAM_WRITE(trie_base + 0x40390,0x50000);


	SRAM_WRITE(trie_base + 0x40394,0x50000);


	SRAM_WRITE(trie_base + 0x40398,0x50000);


	SRAM_WRITE(trie_base + 0x4039c,0x50000);


	SRAM_WRITE(trie_base + 0x403a0,0x50000);


	SRAM_WRITE(trie_base + 0x403a4,0x50000);


	SRAM_WRITE(trie_base + 0x403a8,0x50000);


	SRAM_WRITE(trie_base + 0x403ac,0x50000);


	SRAM_WRITE(trie_base + 0x403b0,0x50000);


	SRAM_WRITE(trie_base + 0x403b4,0x50000);


	SRAM_WRITE(trie_base + 0x403b8,0x50000);


	SRAM_WRITE(trie_base + 0x403bc,0x50000);

/* writing nexthop entry with flags 0x10 */ 

SDRAM_WRITE(nh_base + 0x50,0x10);

/* blade 0x5 and NH 0x7224 */

SDRAM_WRITE(nh_base + 0x54,0x5007224);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x58,0x05dc0000);


SDRAM_WRITE(nh_base + 0x5c,0x0);

/* #-----------------------------------------------
   # Local delivery - exception 			
   #-----------------------------------------------
 */
 /* 
  add 100.0.0.1 255.255.255.255 0x0001 0x1 1500 0x02000000 
 */
/* @@@ Adding dest=0x64000001, mask = 0xffffffff, blade_nh_id=0x2000001,mtu_port=0x05dc0000,flags=0x1 */

	SRAM_WRITE(trie_base + 0x40704,0x60000);

/* writing nexthop entry with flags 0x1 */ 

SDRAM_WRITE(nh_base + 0x60,0x1);

/* blade 0x2 and NH 0x0001 */

SDRAM_WRITE(nh_base + 0x64,0x2000001);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x68,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6c,0x0);


	SRAM_WRITE(trie_base + 0x406c0,0xc);


	SRAM_WRITE(trie_base + 0x40680,0xb);


	SRAM_WRITE(trie_base + 0x40640,0xa);


	SRAM_WRITE(trie_base + 0x19000,0x9);

/* #-----------------------------------------------
   # redirect - exception  			
   #-----------------------------------------------
 */ 

/* add 100.0.0.2 255.255.255.255 0x0002 0x0 1500 0x01000000
 */

/* @@@ Adding dest=0x64000002, mask = 0xffffffff, blade_nh_id=0x1000002,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40708,0x70000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x70,0x0);

/* blade 0x1 and NH 0x0002 */

SDRAM_WRITE(nh_base + 0x74,0x1000002);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x78,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7c,0x0);

/* #-----------------------------------------------
   # fragment - exception  			
   #-----------------------------------------------
 */ 
 /* add 100.0.0.3 255.255.255.255 0x0003 0x0 32  0x03000000
 */
/* @@@ Adding dest=0x64000003, mask = 0xffffffff, blade_nh_id=0x3000003,mtu_port=0x200000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4070c,0x80000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x80,0x0);

/* blade 0x3 and NH 0x0003 */

SDRAM_WRITE(nh_base + 0x84,0x3000003);

/* MTU is 32, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x88,0x200000);


SDRAM_WRITE(nh_base + 0x8c,0x0);

/* #-----------------------------------------------
   # Interface/host down - exception  			
   #-----------------------------------------------
 */

/* add 100.0.0.4 255.255.255.255 0x0004 0x2 1500 0x04000000
 */
/* @@@ Adding dest=0x64000004, mask = 0xffffffff, blade_nh_id=0x4000004,mtu_port=0x05dc0000,flags=0x2 */

	SRAM_WRITE(trie_base + 0x40710,0x90000);

/* writing nexthop entry with flags 0x2 */ 

SDRAM_WRITE(nh_base + 0x90,0x2);

/* blade 0x4 and NH 0x0004 */

SDRAM_WRITE(nh_base + 0x94,0x4000004);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x98,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9c,0x0);


/* #-----------------------------------------------
   # Directed broadcast - Exception		 
   #-----------------------------------------------
 */ 

 /* # dest={<prefix>,-1} 
 */ 
 
/* add 192.1.2.255 255.255.255.0 0x7ab1 0x8 1500 0x02000000
 */
/* @@@ Adding dest=0xc00102ff, mask = 0xffffff00, blade_nh_id=0x2007ab1,mtu_port=0x05dc0000,flags=0x8 */

	SRAM_WRITE(trie_base + 0x40788,0xa0000);

/* writing nexthop entry with flags 0x8 */ 

SDRAM_WRITE(nh_base + 0xa0,0x8);

/* blade 0x2 and NH 0x7ab1 */

SDRAM_WRITE(nh_base + 0xa4,0x2007ab1);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0xa8,0x05dc0000);


SDRAM_WRITE(nh_base + 0xac,0x0);


	SRAM_WRITE(trie_base + 0x40740,0xe);


	SRAM_WRITE(trie_base + 0x30004,0xd);

/* # dest={<prefix>,0} 
 */ 
/* add 192.1.2.0 255.255.255.0 0x7ab2 0x8 1500 0x03000000
 */
/* @@@ Adding dest=0xc0010200, mask = 0xffffff00, blade_nh_id=0x3007ab2,mtu_port=0x05dc0000,flags=0x8 */
/* writing nexthop entry with flags 0x8 */ 

SDRAM_WRITE(nh_base + 0xa0,0x8);

/* blade 0x3 and NH 0x7ab2 */

SDRAM_WRITE(nh_base + 0xa4,0x3007ab2);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0xa8,0x05dc0000);


SDRAM_WRITE(nh_base + 0xac,0x0);

/* # dest={0,<host>} 
 */ 
/* add 0.0.0.3 255.255.255.0 0x7ab3 0x8 1500 0x04000000
 */
/* @@@ Adding dest=0x3, mask = 0xffffff00, blade_nh_id=0x4007ab3,mtu_port=0x05dc0000,flags=0x8 */

	SRAM_WRITE(trie_base + 0x40580,0xb0007);

/* writing nexthop entry with flags 0x8 */ 

SDRAM_WRITE(nh_base + 0xb0,0x8);

/* blade 0x4 and NH 0x7ab3 */

SDRAM_WRITE(nh_base + 0xb4,0x4007ab3);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0xb8,0x05dc0000);


SDRAM_WRITE(nh_base + 0xbc,0x0);

/* #-----------------------------------------------
   # 32-bit routes - Forward			 
   #-----------------------------------------------
 */
/*  add 32.0.0.1 255.255.255.255 0x0051 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x20000001, mask = 0xffffffff, blade_nh_id=0x0051,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40884,0xc0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0xc0,0x0);

/* blade 0x0 and NH 0x0051 */

SDRAM_WRITE(nh_base + 0xc4,0x0000051);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0xc8,0x05dc0000);


SDRAM_WRITE(nh_base + 0xcc,0x0);


	SRAM_WRITE(trie_base + 0x40840,0x12);


	SRAM_WRITE(trie_base + 0x40800,0x11);


	SRAM_WRITE(trie_base + 0x407c0,0x10);


	SRAM_WRITE(trie_base + 0x8000,0xf);

/*  add 32.0.0.2 255.255.255.255 0x0052 0x1 1500 0x02000000
 */
/* @@@ Adding dest=0x20000002, mask = 0xffffffff, blade_nh_id=0x2000052,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40888,0xd0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0xd0,0x0);

/* blade 0x2 and NH 0x0052 */

SDRAM_WRITE(nh_base + 0xd4,0x2000052);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0xd8,0x05dc0001);


SDRAM_WRITE(nh_base + 0xdc,0x0);

/*  add 32.0.0.3 255.255.255.255 0x0053 0x2 1500 0x00000000
 */
/* @@@ Adding dest=0x20000003, mask = 0xffffffff, blade_nh_id=0x0000053,mtu_port=0x05dc0002,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4088c,0xe0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0xe0,0x0);

/* blade 0x0 and NH 0x0053 */

SDRAM_WRITE(nh_base + 0xe4,0x0000053);

/* MTU is 1500, outport is 0x2 */ 

SDRAM_WRITE(nh_base + 0xe8,0x05dc0002);


SDRAM_WRITE(nh_base + 0xec,0x0);

/*  add 32.0.0.4 255.255.255.255 0x0054 0x3 1500 0x00000000
 */
/* @@@ Adding dest=0x20000004, mask = 0xffffffff, blade_nh_id=0x0000054,mtu_port=0x05dc0003,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40890,0xf0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0xf0,0x0);

/* blade 0x0 and NH 0x0054 */

SDRAM_WRITE(nh_base + 0xf4,0x0000054);

/* MTU is 1500, outport is 0x3 */ 

SDRAM_WRITE(nh_base + 0xf8,0x05dc0003);


SDRAM_WRITE(nh_base + 0xfc,0x0);

/*  add 32.0.0.5 255.255.255.255 0x0055 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x20000005, mask = 0xffffffff, blade_nh_id=0x0000055,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40894,0x100000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x100,0x0);

/* blade 0x0 and NH 0x0055 */

SDRAM_WRITE(nh_base + 0x104,0x0000055);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x108,0x05dc0000);


SDRAM_WRITE(nh_base + 0x10c,0x0);

/*  add 32.0.0.6 255.255.255.255 0x0056 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x20000006, mask = 0xffffffff, blade_nh_id=0x0000056,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40898,0x110000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x110,0x0);

/* blade 0x0 and NH 0x0056 */

SDRAM_WRITE(nh_base + 0x114,0x0000056);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x118,0x05dc0000);


SDRAM_WRITE(nh_base + 0x11c,0x0);

/*  add 32.0.0.7 255.255.255.255 0x0057 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x20000007, mask = 0xffffffff, blade_nh_id=0x0000057,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4089c,0x120000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x120,0x0);

/* blade 0x0 and NH 0x0057 */

SDRAM_WRITE(nh_base + 0x124,0x0000057);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x128,0x05dc0000);


SDRAM_WRITE(nh_base + 0x12c,0x0);

/*  add 32.0.0.8 255.255.255.255 0x0058 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x20000008, mask = 0xffffffff, blade_nh_id=0x0000058,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408a0,0x130000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x130,0x0);

/* blade 0x0 and NH 0x0058 */

SDRAM_WRITE(nh_base + 0x134,0x0000058);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x138,0x05dc0000);


SDRAM_WRITE(nh_base + 0x13c,0x0);

/*  add 32.0.0.9 255.255.255.255 0x0059 0x0 1500 0x09000000
 */
/* @@@ Adding dest=0x20000009, mask = 0xffffffff, blade_nh_id=0x9000059,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408a4,0x140000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x140,0x0);

/* blade 0x9 and NH 0x0059 */

SDRAM_WRITE(nh_base + 0x144,0x9000059);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x148,0x05dc0000);


SDRAM_WRITE(nh_base + 0x14c,0x0);

/*  add 32.0.0.10 255.255.255.255 0x0060 0x0 1500 0x0a000000
 */
/* @@@ Adding dest=0x2000000a, mask = 0xffffffff, blade_nh_id=0xa000060,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408a8,0x150000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x150,0x0);

/* blade 0xa and NH 0x0060 */

SDRAM_WRITE(nh_base + 0x154,0xa000060);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x158,0x05dc0000);


SDRAM_WRITE(nh_base + 0x15c,0x0);

/*  add 32.0.0.11 255.255.255.255 0x0061 0x0 1500 0x0b000000
 */
/* @@@ Adding dest=0x2000000b, mask = 0xffffffff, blade_nh_id=0xb000061,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408ac,0x160000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x160,0x0);

/* blade 0xb and NH 0x0061 */

SDRAM_WRITE(nh_base + 0x164,0xb000061);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x168,0x05dc0000);


SDRAM_WRITE(nh_base + 0x16c,0x0);

/*  add 32.0.0.12 255.255.255.255 0x0062 0x0 1500 0x0c000000
 */
/* @@@ Adding dest=0x2000000c, mask = 0xffffffff, blade_nh_id=0xc000062,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408b0,0x170000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x170,0x0);

/* blade 0xc and NH 0x0062 */

SDRAM_WRITE(nh_base + 0x174,0xc000062);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x178,0x05dc0000);


SDRAM_WRITE(nh_base + 0x17c,0x0);

/*  add 32.0.0.13 255.255.255.255 0x0063 0x0 1500 0x0d000000
 */
/* @@@ Adding dest=0x2000000d, mask = 0xffffffff, blade_nh_id=0xd000063,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408b4,0x180000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x180,0x0);

/* blade 0xd and NH 0x0063 */

SDRAM_WRITE(nh_base + 0x184,0xd000063);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x188,0x05dc0000);


SDRAM_WRITE(nh_base + 0x18c,0x0);

/*  add 32.0.0.14 255.255.255.255 0x0064 0x0 1500 0x0e000000
 */
/* @@@ Adding dest=0x2000000e, mask = 0xffffffff, blade_nh_id=0xe000064,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408b8,0x190000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x190,0x0);

/* blade 0xe and NH 0x0064 */

SDRAM_WRITE(nh_base + 0x194,0xe000064);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x198,0x05dc0000);


SDRAM_WRITE(nh_base + 0x19c,0x0);

/*  add 32.0.0.15 255.255.255.255 0x0065 0x0 1500 0x0f000000
 */
/* @@@ Adding dest=0x2000000f, mask = 0xffffffff, blade_nh_id=0xf000065,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408bc,0x1a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x1a0,0x0);

/* blade 0xf and NH 0x0065 */

SDRAM_WRITE(nh_base + 0x1a4,0xf000065);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x1a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1ac,0x0);

/*  add 32.0.0.16 255.255.255.255 0x0066 0x0 1500 0x10000000
 */
/* @@@ Adding dest=0x20000010, mask = 0xffffffff, blade_nh_id=0x10000066,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408c0,0x1b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x1b0,0x0);

/* blade 0x10 and NH 0x0066 */

SDRAM_WRITE(nh_base + 0x1b4,0x10000066);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x1b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1bc,0x0);


	SRAM_WRITE(trie_base + 0x40844,0x13);

/*  add 32.0.0.17 255.255.255.255 0x0067 0x0 1500 0x11000000
 */
/* @@@ Adding dest=0x20000011, mask = 0xffffffff, blade_nh_id=0x11000067,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408c4,0x1c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x1c0,0x0);

/* blade 0x11 and NH 0x0067 */

SDRAM_WRITE(nh_base + 0x1c4,0x11000067);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x1c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1cc,0x0);

/*  add 32.0.0.18 255.255.255.255 0x0068 0x0 1500 0x12000000
 */
/* @@@ Adding dest=0x20000012, mask = 0xffffffff, blade_nh_id=0x12000068,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408c8,0x1d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x1d0,0x0);

/* blade 0x12 and NH 0x0068 */

SDRAM_WRITE(nh_base + 0x1d4,0x12000068);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x1d8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1dc,0x0);

/*  add 32.0.0.19 255.255.255.255 0x0069 0x0 1500 0x13000000
 */
/* @@@ Adding dest=0x20000013, mask = 0xffffffff, blade_nh_id=0x13000069,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408cc,0x1e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x1e0,0x0);

/* blade 0x13 and NH 0x0069 */

SDRAM_WRITE(nh_base + 0x1e4,0x13000069);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x1e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1ec,0x0);

/*  add 32.0.0.20 255.255.255.255 0x0070 0x0 1500 0x14000000
 */
/* @@@ Adding dest=0x20000014, mask = 0xffffffff, blade_nh_id=0x14000070,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408d0,0x1f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x1f0,0x0);

/* blade 0x14 and NH 0x0070 */

SDRAM_WRITE(nh_base + 0x1f4,0x14000070);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x1f8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x1fc,0x0);

/*  add 32.0.0.21 255.255.255.255 0x0071 0x0 1500 0x15000000
 */
/* @@@ Adding dest=0x20000015, mask = 0xffffffff, blade_nh_id=0x15000071,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408d4,0x200000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x200,0x0);

/* blade 0x15 and NH 0x0071 */

SDRAM_WRITE(nh_base + 0x204,0x15000071);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x208,0x05dc0000);


SDRAM_WRITE(nh_base + 0x20c,0x0);

/*  add 32.0.0.22 255.255.255.255 0x0072 0x0 1500 0x16000000
 */
/* @@@ Adding dest=0x20000016, mask = 0xffffffff, blade_nh_id=0x16000072,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408d8,0x210000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x210,0x0);

/* blade 0x16 and NH 0x0072 */

SDRAM_WRITE(nh_base + 0x214,0x16000072);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x218,0x05dc0000);


SDRAM_WRITE(nh_base + 0x21c,0x0);

/*  add 32.0.0.23 255.255.255.255 0x0073 0x0 1500 0x17000000
 */
/* @@@ Adding dest=0x20000017, mask = 0xffffffff, blade_nh_id=0x17000073,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408dc,0x220000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x220,0x0);

/* blade 0x17 and NH 0x0073 */

SDRAM_WRITE(nh_base + 0x224,0x17000073);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x228,0x05dc0000);


SDRAM_WRITE(nh_base + 0x22c,0x0);

/*  add 32.0.0.24 255.255.255.255 0x0074 0x0 1500 0x18000000
 */
/* @@@ Adding dest=0x20000018, mask = 0xffffffff, blade_nh_id=0x18000074,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408e0,0x230000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x230,0x0);

/* blade 0x18 and NH 0x0074 */

SDRAM_WRITE(nh_base + 0x234,0x18000074);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x238,0x05dc0000);


SDRAM_WRITE(nh_base + 0x23c,0x0);

/*  add 32.0.0.25 255.255.255.255 0x0075 0x0 1500 0x19000000
 */
/* @@@ Adding dest=0x20000019, mask = 0xffffffff, blade_nh_id=0x19000075,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408e4,0x240000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x240,0x0);

/* blade 0x19 and NH 0x0075 */

SDRAM_WRITE(nh_base + 0x244,0x19000075);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x248,0x05dc0000);


SDRAM_WRITE(nh_base + 0x24c,0x0);

/*  add 32.0.0.26 255.255.255.255 0x0076 0x0 1500 0x1a000000
 */
/* @@@ Adding dest=0x2000001a, mask = 0xffffffff, blade_nh_id=0x1a000076,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408e8,0x250000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x250,0x0);

/* blade 0x1a and NH 0x0076 */

SDRAM_WRITE(nh_base + 0x254,0x1a000076);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x258,0x05dc0000);


SDRAM_WRITE(nh_base + 0x25c,0x0);

/*  add 32.0.0.27 255.255.255.255 0x0077 0x0 1500 0x1b000000
 */
/* @@@ Adding dest=0x2000001b, mask = 0xffffffff, blade_nh_id=0x1b000077,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408ec,0x260000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x260,0x0);

/* blade 0x1b and NH 0x0077 */

SDRAM_WRITE(nh_base + 0x264,0x1b000077);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x268,0x05dc0000);


SDRAM_WRITE(nh_base + 0x26c,0x0);

/*  add 32.0.0.28 255.255.255.255 0x0078 0x0 1500 0x1c000000
 */
/* @@@ Adding dest=0x2000001c, mask = 0xffffffff, blade_nh_id=0x1c000078,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408f0,0x270000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x270,0x0);

/* blade 0x1c and NH 0x0078 */

SDRAM_WRITE(nh_base + 0x274,0x1c000078);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x278,0x05dc0000);


SDRAM_WRITE(nh_base + 0x27c,0x0);

/*  add 32.0.0.29 255.255.255.255 0x0079 0x0 1500 0x1d000000
 */
/* @@@ Adding dest=0x2000001d, mask = 0xffffffff, blade_nh_id=0x1d000079,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408f4,0x280000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x280,0x0);

/* blade 0x1d and NH 0x0079 */

SDRAM_WRITE(nh_base + 0x284,0x1d000079);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x288,0x05dc0000);


SDRAM_WRITE(nh_base + 0x28c,0x0);

/*  add 32.0.0.30 255.255.255.255 0x0080 0x0 1500 0x1e000000
 */
/* @@@ Adding dest=0x2000001e, mask = 0xffffffff, blade_nh_id=0x1e000080,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408f8,0x290000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x290,0x0);

/* blade 0x1e and NH 0x0080 */

SDRAM_WRITE(nh_base + 0x294,0x1e000080);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x298,0x05dc0000);


SDRAM_WRITE(nh_base + 0x29c,0x0);

/*  add 32.0.0.31 255.255.255.255 0x0081 0x0 1500 0x1f000000
 */
/* @@@ Adding dest=0x2000001f, mask = 0xffffffff, blade_nh_id=0x1f000081,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x408fc,0x2a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x2a0,0x0);

/* blade 0x1f and NH 0x0081 */

SDRAM_WRITE(nh_base + 0x2a4,0x1f000081);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x2a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2ac,0x0);

/*  add 32.0.0.32 255.255.255.255 0x0082 0x0 1500 0x20000000
 */
/* @@@ Adding dest=0x20000020, mask = 0xffffffff, blade_nh_id=0x20000082,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40900,0x2b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x2b0,0x0);

/* blade 0x20 and NH 0x0082 */

SDRAM_WRITE(nh_base + 0x2b4,0x20000082);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x2b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2bc,0x0);


	SRAM_WRITE(trie_base + 0x40848,0x14);

/*  add 32.0.0.33 255.255.255.255 0x0083 0x0 1500 0x21000000
 */
/* @@@ Adding dest=0x20000021, mask = 0xffffffff, blade_nh_id=0x21000083,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40904,0x2c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x2c0,0x0);

/* blade 0x21 and NH 0x0083 */

SDRAM_WRITE(nh_base + 0x2c4,0x21000083);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x2c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2cc,0x0);

/*  add 32.0.0.34 255.255.255.255 0x0084 0x0 1500 0x22000000
 */
/* @@@ Adding dest=0x20000022, mask = 0xffffffff, blade_nh_id=0x22000084,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40908,0x2d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x2d0,0x0);

/* blade 0x22 and NH 0x0084 */

SDRAM_WRITE(nh_base + 0x2d4,0x22000084);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x2d8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2dc,0x0);

/*  add 32.0.0.35 255.255.255.255 0x0085 0x0 1500 0x23000000
 */
/* @@@ Adding dest=0x20000023, mask = 0xffffffff, blade_nh_id=0x23000085,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4090c,0x2e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x2e0,0x0);

/* blade 0x23 and NH 0x0085 */

SDRAM_WRITE(nh_base + 0x2e4,0x23000085);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x2e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2ec,0x0);

/*  add 32.0.0.36 255.255.255.255 0x0086 0x0 1500 0x24000000
 */
/* @@@ Adding dest=0x20000024, mask = 0xffffffff, blade_nh_id=0x24000086,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40910,0x2f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x2f0,0x0);

/* blade 0x24 and NH 0x0086 */

SDRAM_WRITE(nh_base + 0x2f4,0x24000086);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x2f8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x2fc,0x0);

/*  add 32.0.0.37 255.255.255.255 0x0087 0x0 1500 0x25000000
 */
/* @@@ Adding dest=0x20000025, mask = 0xffffffff, blade_nh_id=0x25000087,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40914,0x300000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x300,0x0);

/* blade 0x25 and NH 0x0087 */

SDRAM_WRITE(nh_base + 0x304,0x25000087);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x308,0x05dc0000);


SDRAM_WRITE(nh_base + 0x30c,0x0);

/*  add 32.0.0.38 255.255.255.255 0x0088 0x0 1500 0x26000000
 */
/* @@@ Adding dest=0x20000026, mask = 0xffffffff, blade_nh_id=0x26000088,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40918,0x310000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x310,0x0);

/* blade 0x26 and NH 0x0088 */

SDRAM_WRITE(nh_base + 0x314,0x26000088);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x318,0x05dc0000);


SDRAM_WRITE(nh_base + 0x31c,0x0);

/*  add 32.0.0.39 255.255.255.255 0x0089 0x0 1500 0x27000000
 */
/* @@@ Adding dest=0x20000027, mask = 0xffffffff, blade_nh_id=0x27000089,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4091c,0x320000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x320,0x0);

/* blade 0x27 and NH 0x0089 */

SDRAM_WRITE(nh_base + 0x324,0x27000089);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x328,0x05dc0000);


SDRAM_WRITE(nh_base + 0x32c,0x0);

/*  add 32.0.0.40 255.255.255.255 0x0090 0x0 1500 0x28000000
 */
/* @@@ Adding dest=0x20000028, mask = 0xffffffff, blade_nh_id=0x28000090,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40920,0x330000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x330,0x0);

/* blade 0x28 and NH 0x0090 */

SDRAM_WRITE(nh_base + 0x334,0x28000090);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x338,0x05dc0000);


SDRAM_WRITE(nh_base + 0x33c,0x0);

/*  add 32.0.0.41 255.255.255.255 0x0091 0x0 1500 0x29000000
 */
/* @@@ Adding dest=0x20000029, mask = 0xffffffff, blade_nh_id=0x29000091,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40924,0x340000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x340,0x0);

/* blade 0x29 and NH 0x0091 */

SDRAM_WRITE(nh_base + 0x344,0x29000091);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x348,0x05dc0000);


SDRAM_WRITE(nh_base + 0x34c,0x0);

/*  add 32.0.0.42 255.255.255.255 0x0092 0x0 1500 0x2a000000
 */
/* @@@ Adding dest=0x2000002a, mask = 0xffffffff, blade_nh_id=0x2a000092,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40928,0x350000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x350,0x0);

/* blade 0x2a and NH 0x0092 */

SDRAM_WRITE(nh_base + 0x354,0x2a000092);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x358,0x05dc0000);


SDRAM_WRITE(nh_base + 0x35c,0x0);

/*  add 32.0.0.43 255.255.255.255 0x0093 0x0 1500 0x2b000000
 */
/* @@@ Adding dest=0x2000002b, mask = 0xffffffff, blade_nh_id=0x2b000093,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4092c,0x360000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x360,0x0);

/* blade 0x2b and NH 0x0093 */

SDRAM_WRITE(nh_base + 0x364,0x2b000093);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x368,0x05dc0000);


SDRAM_WRITE(nh_base + 0x36c,0x0);

/*  add 32.0.0.44 255.255.255.255 0x0094 0x0 1500 0x2c000000
 */
/* @@@ Adding dest=0x2000002c, mask = 0xffffffff, blade_nh_id=0x2c000094,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40930,0x370000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x370,0x0);

/* blade 0x2c and NH 0x0094 */

SDRAM_WRITE(nh_base + 0x374,0x2c000094);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x378,0x05dc0000);


SDRAM_WRITE(nh_base + 0x37c,0x0);

/*  add 32.0.0.45 255.255.255.255 0x0095 0x0 1500 0x2d000000
 */
/* @@@ Adding dest=0x2000002d, mask = 0xffffffff, blade_nh_id=0x2d000095,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40934,0x380000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x380,0x0);

/* blade 0x2d and NH 0x0095 */

SDRAM_WRITE(nh_base + 0x384,0x2d000095);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x388,0x05dc0000);


SDRAM_WRITE(nh_base + 0x38c,0x0);

/*  add 32.0.0.46 255.255.255.255 0x0096 0x0 1500 0x2e000000
 */
/* @@@ Adding dest=0x2000002e, mask = 0xffffffff, blade_nh_id=0x2e000096,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40938,0x390000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x390,0x0);

/* blade 0x2e and NH 0x0096 */

SDRAM_WRITE(nh_base + 0x394,0x2e000096);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x398,0x05dc0000);


SDRAM_WRITE(nh_base + 0x39c,0x0);

/*  add 32.0.0.47 255.255.255.255 0x0097 0x0 1500 0x2f000000
 */
/* @@@ Adding dest=0x2000002f, mask = 0xffffffff, blade_nh_id=0x2f000097,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4093c,0x3a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x3a0,0x0);

/* blade 0x2f and NH 0x0097 */

SDRAM_WRITE(nh_base + 0x3a4,0x2f000097);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x3a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3ac,0x0);

/*  add 32.0.0.48 255.255.255.255 0x0098 0x0 1500 0x30000000
 */
/* @@@ Adding dest=0x20000030, mask = 0xffffffff, blade_nh_id=0x30000098,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40940,0x3b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x3b0,0x0);

/* blade 0x30 and NH 0x0098 */

SDRAM_WRITE(nh_base + 0x3b4,0x30000098);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x3b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3bc,0x0);


	SRAM_WRITE(trie_base + 0x4084c,0x15);

/*  add 32.0.0.49 255.255.255.255 0x0099 0x0 1500 0x31000000
 */
/* @@@ Adding dest=0x20000031, mask = 0xffffffff, blade_nh_id=0x31000099,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40944,0x3c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x3c0,0x0);

/* blade 0x31 and NH 0x0099 */

SDRAM_WRITE(nh_base + 0x3c4,0x31000099);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x3c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3cc,0x0);

/*  add 32.0.0.50 255.255.255.255 0x00a0 0x0 1500 0x32000000
 */
/* @@@ Adding dest=0x20000032, mask = 0xffffffff, blade_nh_id=0x320000a0,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40948,0x3d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x3d0,0x0);

/* blade 0x32 and NH 0x00a0 */

SDRAM_WRITE(nh_base + 0x3d4,0x320000a0);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x3d8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3dc,0x0);

/*  add 32.0.0.51 255.255.255.255 0x00a1 0x0 1500 0x33000000
 */
/* @@@ Adding dest=0x20000033, mask = 0xffffffff, blade_nh_id=0x330000a1,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4094c,0x3e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x3e0,0x0);

/* blade 0x33 and NH 0x00a1 */

SDRAM_WRITE(nh_base + 0x3e4,0x330000a1);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x3e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3ec,0x0);

/*  add 32.0.0.52 255.255.255.255 0x00a2 0x0 1500 0x34000000
 */
/* @@@ Adding dest=0x20000034, mask = 0xffffffff, blade_nh_id=0x340000a2,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40950,0x3f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x3f0,0x0);

/* blade 0x34 and NH 0x00a2 */

SDRAM_WRITE(nh_base + 0x3f4,0x340000a2);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x3f8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x3fc,0x0);

/*  add 32.0.0.53 255.255.255.255 0x00a3 0x0 1500 0x35000000
 */
/* @@@ Adding dest=0x20000035, mask = 0xffffffff, blade_nh_id=0x350000a3,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40954,0x400000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x400,0x0);

/* blade 0x35 and NH 0x00a3 */

SDRAM_WRITE(nh_base + 0x404,0x350000a3);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x408,0x05dc0000);


SDRAM_WRITE(nh_base + 0x40c,0x0);

/*  add 32.0.0.54 255.255.255.255 0x00a4 0x0 1500 0x36000000
 */
/* @@@ Adding dest=0x20000036, mask = 0xffffffff, blade_nh_id=0x360000a4,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40958,0x410000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x410,0x0);

/* blade 0x36 and NH 0x00a4 */

SDRAM_WRITE(nh_base + 0x414,0x360000a4);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x418,0x05dc0000);


SDRAM_WRITE(nh_base + 0x41c,0x0);

/*  add 32.0.0.55 255.255.255.255 0x00a5 0x0 1500 0x37000000
 */
/* @@@ Adding dest=0x20000037, mask = 0xffffffff, blade_nh_id=0x370000a5,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4095c,0x420000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x420,0x0);

/* blade 0x37 and NH 0x00a5 */

SDRAM_WRITE(nh_base + 0x424,0x370000a5);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x428,0x05dc0000);


SDRAM_WRITE(nh_base + 0x42c,0x0);

/*  add 32.0.0.56 255.255.255.255 0x00a6 0x0 1500 0x38000000
 */
/* @@@ Adding dest=0x20000038, mask = 0xffffffff, blade_nh_id=0x380000a6,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40960,0x430000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x430,0x0);

/* blade 0x38 and NH 0x00a6 */

SDRAM_WRITE(nh_base + 0x434,0x380000a6);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x438,0x05dc0000);


SDRAM_WRITE(nh_base + 0x43c,0x0);

/*  add 32.0.0.57 255.255.255.255 0x00a7 0x0 1500 0x39000000
 */
/* @@@ Adding dest=0x20000039, mask = 0xffffffff, blade_nh_id=0x390000a7,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40964,0x440000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x440,0x0);

/* blade 0x39 and NH 0x00a7 */

SDRAM_WRITE(nh_base + 0x444,0x390000a7);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x448,0x05dc0000);


SDRAM_WRITE(nh_base + 0x44c,0x0);

/*  add 32.0.0.58 255.255.255.255 0x00a8 0x0 1500 0x3a000000
 */
/* @@@ Adding dest=0x2000003a, mask = 0xffffffff, blade_nh_id=0x3a0000a8,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40968,0x450000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x450,0x0);

/* blade 0x3a and NH 0x00a8 */

SDRAM_WRITE(nh_base + 0x454,0x3a0000a8);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x458,0x05dc0000);


SDRAM_WRITE(nh_base + 0x45c,0x0);

/*  add 32.0.0.59 255.255.255.255 0x00a9 0x0 1500 0x3b000000
 */
/* @@@ Adding dest=0x2000003b, mask = 0xffffffff, blade_nh_id=0x3b0000a9,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4096c,0x460000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x460,0x0);

/* blade 0x3b and NH 0x00a9 */

SDRAM_WRITE(nh_base + 0x464,0x3b0000a9);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x468,0x05dc0000);


SDRAM_WRITE(nh_base + 0x46c,0x0);

/*  add 32.0.0.60 255.255.255.255 0x00b0 0x0 1500 0x3c000000
 */
/* @@@ Adding dest=0x2000003c, mask = 0xffffffff, blade_nh_id=0x3c0000b0,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40970,0x470000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x470,0x0);

/* blade 0x3c and NH 0x00b0 */

SDRAM_WRITE(nh_base + 0x474,0x3c0000b0);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x478,0x05dc0000);


SDRAM_WRITE(nh_base + 0x47c,0x0);

/*  add 32.0.0.61 255.255.255.255 0x00b1 0x0 1500 0x3d000000
 */
/* @@@ Adding dest=0x2000003d, mask = 0xffffffff, blade_nh_id=0x3d0000b1,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40974,0x480000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x480,0x0);

/* blade 0x3d and NH 0x00b1 */

SDRAM_WRITE(nh_base + 0x484,0x3d0000b1);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x488,0x05dc0000);


SDRAM_WRITE(nh_base + 0x48c,0x0);

/*  add 32.0.0.62 255.255.255.255 0x00b2 0x0 1500 0x3e000000
 */
/* @@@ Adding dest=0x2000003e, mask = 0xffffffff, blade_nh_id=0x3e0000b2,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40978,0x490000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x490,0x0);

/* blade 0x3e and NH 0x00b2 */

SDRAM_WRITE(nh_base + 0x494,0x3e0000b2);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x498,0x05dc0000);


SDRAM_WRITE(nh_base + 0x49c,0x0);

/*  add 32.0.0.63 255.255.255.255 0x00b3 0x0 1500 0x3f000000
 */
/* @@@ Adding dest=0x2000003f, mask = 0xffffffff, blade_nh_id=0x3f0000b3,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x4097c,0x4a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x4a0,0x0);

/* blade 0x3f and NH 0x00b3 */

SDRAM_WRITE(nh_base + 0x4a4,0x3f0000b3);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x4a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x4ac,0x0);

/*  add 32.0.0.64 255.255.255.255 0x00b4 0x0 1500 0x3f000000
 */
/* @@@ Adding dest=0x20000040, mask = 0xffffffff, blade_nh_id=0x3f0000b4,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40980,0x4b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x4b0,0x0);

/* blade 0x3f and NH 0x00b4 */

SDRAM_WRITE(nh_base + 0x4b4,0x3f0000b4);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x4b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x4bc,0x0);


	SRAM_WRITE(trie_base + 0x40850,0x16);

/* 
 *//* 
 *//* 
 *//* #-----------------------------------------------
 */ /* # 16-bit routes - Forward			 
 */ /* #-----------------------------------------------
 */ /* 
 *//*  add 16.1.0.0 255.255.0.0 0x0101 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x10010000, mask = 0xffff0000, blade_nh_id=0x0101,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a04,0x4c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x4c0,0x0);

/* blade 0x0 and NH 0x0101 */

SDRAM_WRITE(nh_base + 0x4c4,0x0101);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x4c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x4cc,0x0);


	SRAM_WRITE(trie_base + 0x409c0,0x18);


	SRAM_WRITE(trie_base + 0x40040,0x17);

/*  add 16.2.0.0 255.255.0.0 0x0102 0x1 1500 0x02000000
 */
/* @@@ Adding dest=0x10020000, mask = 0xffff0000, blade_nh_id=0x2000102,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a08,0x4d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x4d0,0x0);

/* blade 0x2 and NH 0x0102 */

SDRAM_WRITE(nh_base + 0x4d4,0x2000102);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x4d8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x4dc,0x0);

/*  add 16.3.0.0 255.255.0.0 0x0103 0x2 1500 0x03000000
 */
/* @@@ Adding dest=0x10030000, mask = 0xffff0000, blade_nh_id=0x3000103,mtu_port=0x05dc0002,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a0c,0x4e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x4e0,0x0);

/* blade 0x3 and NH 0x0103 */

SDRAM_WRITE(nh_base + 0x4e4,0x3000103);

/* MTU is 1500, outport is 0x2 */ 

SDRAM_WRITE(nh_base + 0x4e8,0x05dc0002);


SDRAM_WRITE(nh_base + 0x4ec,0x0);

/*  add 16.4.0.0 255.255.0.0 0x0104 0x3 1500 0x04000000
 */
/* @@@ Adding dest=0x10040000, mask = 0xffff0000, blade_nh_id=0x4000104,mtu_port=0x05dc0003,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a10,0x4f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x4f0,0x0);

/* blade 0x4 and NH 0x0104 */

SDRAM_WRITE(nh_base + 0x4f4,0x4000104);

/* MTU is 1500, outport is 0x3 */ 

SDRAM_WRITE(nh_base + 0x4f8,0x05dc0003);


SDRAM_WRITE(nh_base + 0x4fc,0x0);

/*  add 16.5.0.0 255.255.0.0 0x0105 0x0 1500 0x05000000
 */
/* @@@ Adding dest=0x10050000, mask = 0xffff0000, blade_nh_id=0x5000105,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a14,0x500000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x500,0x0);

/* blade 0x5 and NH 0x0105 */

SDRAM_WRITE(nh_base + 0x504,0x5000105);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x508,0x05dc0000);


SDRAM_WRITE(nh_base + 0x50c,0x0);

/*  add 16.6.0.0 255.255.0.0 0x0106 0x1 1500 0x01000000
 */
/* @@@ Adding dest=0x10060000, mask = 0xffff0000, blade_nh_id=0x1000106,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a18,0x510000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x510,0x0);

/* blade 0x1 and NH 0x0106 */

SDRAM_WRITE(nh_base + 0x514,0x6000106);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x518,0x05dc0001);


SDRAM_WRITE(nh_base + 0x51c,0x0);

/*  add 16.7.0.0 255.255.0.0 0x0107 0x2 1500 0x01000000
 */
/* @@@ Adding dest=0x10070000, mask = 0xffff0000, blade_nh_id=0x1000107,mtu_port=0x05dc0002,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a1c,0x520000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x520,0x0);

/* blade 0x1 and NH 0x0107 */

SDRAM_WRITE(nh_base + 0x524,0x7000107);

/* MTU is 1500, outport is 0x2 */ 

SDRAM_WRITE(nh_base + 0x528,0x05dc0002);


SDRAM_WRITE(nh_base + 0x52c,0x0);

/*  add 16.8.0.0 255.255.0.0 0x0108 0x3 1500 0x01000000
 */
/* @@@ Adding dest=0x10080000, mask = 0xffff0000, blade_nh_id=0x1000108,mtu_port=0x05dc0003,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a20,0x530000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x530,0x0);

/* blade 0x1 and NH 0x0108 */

SDRAM_WRITE(nh_base + 0x534,0x1000108);

/* MTU is 1500, outport is 0x3 */ 

SDRAM_WRITE(nh_base + 0x538,0x05dc0003);


SDRAM_WRITE(nh_base + 0x53c,0x0);

/*  add 16.9.0.0 255.255.0.0 0x0109 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x10090000, mask = 0xffff0000, blade_nh_id=0x1000109,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a24,0x540000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x540,0x0);

/* blade 0x1 and NH 0x0109 */

SDRAM_WRITE(nh_base + 0x544,0x1000109);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x548,0x05dc0001);


SDRAM_WRITE(nh_base + 0x54c,0x0);

/*  add 16.10.0.0 255.255.0.0 0x0110 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x100a0000, mask = 0xffff0000, blade_nh_id=0x1000110,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a28,0x550000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x550,0x0);

/* blade 0x1 and NH 0x0110 */

SDRAM_WRITE(nh_base + 0x554,0x1000110);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x558,0x05dc0001);


SDRAM_WRITE(nh_base + 0x55c,0x0);

/*  add 16.11.0.0 255.255.0.0 0x0111 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x100b0000, mask = 0xffff0000, blade_nh_id=0x1000111,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a2c,0x560000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x560,0x0);

/* blade 0x1 and NH 0x0111 */

SDRAM_WRITE(nh_base + 0x564,0x1000111);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x568,0x05dc0001);


SDRAM_WRITE(nh_base + 0x56c,0x0);

/*  add 16.12.0.0 255.255.0.0 0x0112 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x100c0000, mask = 0xffff0000, blade_nh_id=0x1000112,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a30,0x570000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x570,0x0);

/* blade 0x1 and NH 0x0112 */

SDRAM_WRITE(nh_base + 0x574,0x1000112);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x578,0x05dc0001);


SDRAM_WRITE(nh_base + 0x57c,0x0);

/*  add 16.13.0.0 255.255.0.0 0x0113 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x100d0000, mask = 0xffff0000, blade_nh_id=0x1000113,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a34,0x580000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x580,0x0);

/* blade 0x1 and NH 0x0113 */

SDRAM_WRITE(nh_base + 0x584,0x1000113);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x588,0x05dc0001);


SDRAM_WRITE(nh_base + 0x58c,0x0);

/*  add 16.14.0.0 255.255.0.0 0x0114 0x0 1500 0x0e000000
 */
/* @@@ Adding dest=0x100e0000, mask = 0xffff0000, blade_nh_id=0xe000114,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a38,0x590000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x590,0x0);

/* blade 0xe and NH 0x0114 */

SDRAM_WRITE(nh_base + 0x594,0xe000114);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x598,0x05dc0000);


SDRAM_WRITE(nh_base + 0x59c,0x0);

/*  add 16.15.0.0 255.255.0.0 0x0115 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x100f0000, mask = 0xffff0000, blade_nh_id=0x1000115,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a3c,0x5a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x5a0,0x0);

/* blade 0x1 and NH 0x0115 */

SDRAM_WRITE(nh_base + 0x5a4,0x1000115);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x5a8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x5ac,0x0);

/*  add 16.16.0.0 255.255.0.0 0x0116 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x10100000, mask = 0xffff0000, blade_nh_id=0x01000116,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a40,0x5b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x5b0,0x0);

/* blade 0x1 and NH 0x0116 */

SDRAM_WRITE(nh_base + 0x5b4,0x01000116);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x5b8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x5bc,0x0);


	SRAM_WRITE(trie_base + 0x409c4,0x19);

/*  add 16.17.0.0 255.255.0.0 0x0117 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x10110000, mask = 0xffff0000, blade_nh_id=0x01000117,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a44,0x5c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x5c0,0x0);

/* blade 0x11 and NH 0x0117 */

SDRAM_WRITE(nh_base + 0x5c4,0x01000117);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x5c8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x5cc,0x0);

/*  add 16.18.0.0 255.255.0.0 0x0118 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10120000, mask = 0xffff0000, blade_nh_id=0x1000118,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a48,0x5d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x5d0,0x0);

/* blade 0x1 and NH 0x0118 */

SDRAM_WRITE(nh_base + 0x5d4,0x01000118);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x5d8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x05dc,0x0);

/*  add 16.19.0.0 255.255.0.0 0x0119 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10130000, mask = 0xffff0000, blade_nh_id=0x1000119,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a4c,0x5e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x5e0,0x0);

/* blade 0x1 and NH 0x0119 */

SDRAM_WRITE(nh_base + 0x5e4,0x01000119);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x5e8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x5ec,0x0);

/*  add 16.20.0.0 255.255.0.0 0x0120 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10140000, mask = 0xffff0000, blade_nh_id=0x1000120,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a50,0x5f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x5f0,0x0);

/* blade 0x1 and NH 0x0120 */

SDRAM_WRITE(nh_base + 0x5f4,0x1000120);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x5f8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x5fc,0x0);

/*  add 16.21.0.0 255.255.0.0 0x0121 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10150000, mask = 0xffff0000, blade_nh_id=0x1000121,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a54,0x600000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x600,0x0);

/* blade 0x1 and NH 0x0121 */

SDRAM_WRITE(nh_base + 0x604,0x01000121);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x608,0x05dc0001);


SDRAM_WRITE(nh_base + 0x60c,0x0);

/*  add 16.22.0.0 255.255.0.0 0x0122 0x0 1500 0x01000000
 */
/* @@@ Adding dest=0x10160000, mask = 0xffff0000, blade_nh_id=0x1000122,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a58,0x610000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x610,0x0);

/* blade 0x1 and NH 0x0122 */

SDRAM_WRITE(nh_base + 0x614,0x01000122);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x618,0x05dc0001);


SDRAM_WRITE(nh_base + 0x61c,0x0);

/*  add 16.23.0.0 255.255.0.0 0x0123 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10170000, mask = 0xffff0000, blade_nh_id=0x1000123,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a5c,0x620000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x620,0x0);

/* blade 0x1 and NH 0x0123 */

SDRAM_WRITE(nh_base + 0x624,0x1000123);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x628,0x05dc0001);


SDRAM_WRITE(nh_base + 0x62c,0x0);

/*  add 16.24.0.0 255.255.0.0 0x0124 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10180000, mask = 0xffff0000, blade_nh_id=0x1000124,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a60,0x630000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x630,0x0);

/* blade 0x1 and NH 0x0124 */

SDRAM_WRITE(nh_base + 0x634,0x1000124);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x638,0x05dc0001);


SDRAM_WRITE(nh_base + 0x63c,0x0);

/*  add 16.25.0.0 255.255.0.0 0x0125 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x10190000, mask = 0xffff0000, blade_nh_id=0x1000125,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a64,0x640000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x640,0x0);

/* blade 0x1 and NH 0x0125 */

SDRAM_WRITE(nh_base + 0x644,0x01000125);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x648,0x05dc0001);


SDRAM_WRITE(nh_base + 0x64c,0x0);

/*  add 16.26.0.0 255.255.0.0 0x0126 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x101a0000, mask = 0xffff0000, blade_nh_id=0x1000126,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a68,0x650000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x650,0x0);

/* blade 0x1 and NH 0x0126 */

SDRAM_WRITE(nh_base + 0x654,0x1000126);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x658,0x05dc0001);


SDRAM_WRITE(nh_base + 0x65c,0x0);

/*  add 16.27.0.0 255.255.0.0 0x0127 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x101b0000, mask = 0xffff0000, blade_nh_id=0x1000127,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a6c,0x660000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x660,0x0);

/* blade 0x1 and NH 0x0127 */

SDRAM_WRITE(nh_base + 0x664,0x01000127);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x668,0x05dc0001);


SDRAM_WRITE(nh_base + 0x66c,0x0);

/*  add 16.28.0.0 255.255.0.0 0x0128 0x0 1500 0x1000000
 */
/* @@@ Adding dest=0x101c0000, mask = 0xffff0000, blade_nh_id=0x1000128,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a70,0x670000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x670,0x0);

/* blade 0x1 and NH 0x0128 */

SDRAM_WRITE(nh_base + 0x674,0x01000128);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x678,0x05dc0001);


SDRAM_WRITE(nh_base + 0x67c,0x0);

/*  add 16.29.0.0 255.255.0.0 0x0129 0x0 1500 0x1d000000
 */
/* @@@ Adding dest=0x101d0000, mask = 0xffff0000, blade_nh_id=0x1d000129,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a74,0x680000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x680,0x0);

/* blade 0x1d and NH 0x0129 */

SDRAM_WRITE(nh_base + 0x684,0x1d000129);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x688,0x05dc0000);


SDRAM_WRITE(nh_base + 0x68c,0x0);

/*  add 16.30.0.0 255.255.0.0 0x0130 0x0 1500 0x1e000000
 */
/* @@@ Adding dest=0x101e0000, mask = 0xffff0000, blade_nh_id=0x1e000130,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a78,0x690000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x690,0x0);

/* blade 0x1e and NH 0x0130 */

SDRAM_WRITE(nh_base + 0x694,0x1e000130);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x698,0x05dc0000);


SDRAM_WRITE(nh_base + 0x69c,0x0);

/*  add 16.31.0.0 255.255.0.0 0x0131 0x0 1500 0x1f000000
 */
/* @@@ Adding dest=0x101f0000, mask = 0xffff0000, blade_nh_id=0x1f000131,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a7c,0x6a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x6a0,0x0);

/* blade 0x1f and NH 0x0131 */

SDRAM_WRITE(nh_base + 0x6a4,0x1f000131);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x6a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6ac,0x0);

/*  add 16.32.0.0 255.255.0.0 0x0132 0x0 1500 0x20000000
 */
/* @@@ Adding dest=0x10200000, mask = 0xffff0000, blade_nh_id=0x20000132,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a80,0x6b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x6b0,0x0);

/* blade 0x20 and NH 0x0132 */

SDRAM_WRITE(nh_base + 0x6b4,0x20000132);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x6b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6bc,0x0);


	SRAM_WRITE(trie_base + 0x409c8,0x1a);

/*  add 16.33.0.0 255.255.0.0 0x0133 0x0 1500 0x21000000
 */
/* @@@ Adding dest=0x10210000, mask = 0xffff0000, blade_nh_id=0x21000133,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a84,0x6c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x6c0,0x0);

/* blade 0x21 and NH 0x0133 */

SDRAM_WRITE(nh_base + 0x6c4,0x21000133);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x6c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6cc,0x0);

/*  add 16.34.0.0 255.255.0.0 0x0134 0x0 1500 0x22000000
 */
/* @@@ Adding dest=0x10220000, mask = 0xffff0000, blade_nh_id=0x22000134,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a88,0x6d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x6d0,0x0);

/* blade 0x22 and NH 0x0134 */

SDRAM_WRITE(nh_base + 0x6d4,0x22000134);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x6d8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6dc,0x0);

/*  add 16.35.0.0 255.255.0.0 0x0135 0x0 1500 0x23000000
 */
/* @@@ Adding dest=0x10230000, mask = 0xffff0000, blade_nh_id=0x23000135,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a8c,0x6e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x6e0,0x0);

/* blade 0x23 and NH 0x0135 */

SDRAM_WRITE(nh_base + 0x6e4,0x23000135);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x6e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6ec,0x0);

/*  add 16.36.0.0 255.255.0.0 0x0136 0x0 1500 0x24000000
 */
/* @@@ Adding dest=0x11240000, mask = 0xffff0000, blade_nh_id=0x24000136,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a90,0x6f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x6f0,0x0);

/* blade 0x24 and NH 0x0136 */

SDRAM_WRITE(nh_base + 0x6f4,0x24000136);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x6f8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x6fc,0x0);

/*  add 16.37.0.0 255.255.0.0 0x0137 0x0 1500 0x25000000
 */
/* @@@ Adding dest=0x10250000, mask = 0xffff0000, blade_nh_id=0x25000137,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a94,0x700000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x700,0x0);

/* blade 0x25 and NH 0x0137 */

SDRAM_WRITE(nh_base + 0x704,0x25000137);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x708,0x05dc0000);


SDRAM_WRITE(nh_base + 0x70c,0x0);

/*  add 16.38.0.0 255.255.0.0 0x0138 0x0 1500 0x26000000
 */
/* @@@ Adding dest=0x10260000, mask = 0xffff0000, blade_nh_id=0x26000138,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a98,0x710000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x710,0x0);

/* blade 0x26 and NH 0x0138 */

SDRAM_WRITE(nh_base + 0x714,0x26000138);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x718,0x05dc0000);


SDRAM_WRITE(nh_base + 0x71c,0x0);

/*  add 16.39.0.0 255.255.0.0 0x0139 0x0 1500 0x27000000
 */
/* @@@ Adding dest=0x10270000, mask = 0xffff0000, blade_nh_id=0x27000139,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40a9c,0x720000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x720,0x0);

/* blade 0x27 and NH 0x0139 */

SDRAM_WRITE(nh_base + 0x724,0x27000139);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x728,0x05dc0000);


SDRAM_WRITE(nh_base + 0x72c,0x0);

/*  add 16.40.0.0 255.255.0.0 0x0140 0x0 1500 0x28000000
 */
/* @@@ Adding dest=0x10280000, mask = 0xffff0000, blade_nh_id=0x28000140,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40aa0,0x730000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x730,0x0);

/* blade 0x28 and NH 0x0140 */

SDRAM_WRITE(nh_base + 0x734,0x28000140);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x738,0x05dc0000);


SDRAM_WRITE(nh_base + 0x73c,0x0);

/*  add 16.41.0.0 255.255.0.0 0x0141 0x0 1500 0x29000000
 */
/* @@@ Adding dest=0x10290000, mask = 0xffff0000, blade_nh_id=0x29000141,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40aa4,0x740000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x740,0x0);

/* blade 0x29 and NH 0x0141 */

SDRAM_WRITE(nh_base + 0x744,0x29000141);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x748,0x05dc0000);


SDRAM_WRITE(nh_base + 0x74c,0x0);

/*  add 16.42.0.0 255.255.0.0 0x0142 0x0 1500 0x2a000000
 */
/* @@@ Adding dest=0x102a0000, mask = 0xffff0000, blade_nh_id=0x2a000142,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40aa8,0x750000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x750,0x0);

/* blade 0x2a and NH 0x0142 */

SDRAM_WRITE(nh_base + 0x754,0x2a000142);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x758,0x05dc0000);


SDRAM_WRITE(nh_base + 0x75c,0x0);

/*  add 16.43.0.0 255.255.0.0 0x0143 0x0 1500 0x2b000000
 */
/* @@@ Adding dest=0x102b0000, mask = 0xffff0000, blade_nh_id=0x2b000143,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40aac,0x760000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x760,0x0);

/* blade 0x2b and NH 0x0143 */

SDRAM_WRITE(nh_base + 0x764,0x2b000143);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x768,0x05dc0000);


SDRAM_WRITE(nh_base + 0x76c,0x0);

/*  add 16.44.0.0 255.255.0.0 0x0144 0x0 1500 0x2c000000
 */
/* @@@ Adding dest=0x102c0000, mask = 0xffff0000, blade_nh_id=0x2c000144,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ab0,0x770000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x770,0x0);

/* blade 0x2c and NH 0x0144 */

SDRAM_WRITE(nh_base + 0x774,0x2c000144);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x778,0x05dc0000);


SDRAM_WRITE(nh_base + 0x77c,0x0);

/*  add 16.45.0.0 255.255.0.0 0x0145 0x0 1500 0x2d000000
 */
/* @@@ Adding dest=0x102d0000, mask = 0xffff0000, blade_nh_id=0x2d000145,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ab4,0x780000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x780,0x0);

/* blade 0x2d and NH 0x0145 */

SDRAM_WRITE(nh_base + 0x784,0x2d000145);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x788,0x05dc0000);


SDRAM_WRITE(nh_base + 0x78c,0x0);

/*  add 16.46.0.0 255.255.0.0 0x0146 0x0 1500 0x2e000000
 */
/* @@@ Adding dest=0x102e0000, mask = 0xffff0000, blade_nh_id=0x2e000146,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ab8,0x790000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x790,0x0);

/* blade 0x2e and NH 0x0146 */

SDRAM_WRITE(nh_base + 0x794,0x2e000146);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x798,0x05dc0000);


SDRAM_WRITE(nh_base + 0x79c,0x0);

/*  add 16.47.0.0 255.255.0.0 0x0147 0x0 1500 0x2f000000
 */
/* @@@ Adding dest=0x102f0000, mask = 0xffff0000, blade_nh_id=0x2f000147,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40abc,0x7a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x7a0,0x0);

/* blade 0x2f and NH 0x0147 */

SDRAM_WRITE(nh_base + 0x7a4,0x2f000147);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x7a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7ac,0x0);

/*  add 16.48.0.0 255.255.0.0 0x0148 0x0 1500 0x30000000
 */
/* @@@ Adding dest=0x10300000, mask = 0xffff0000, blade_nh_id=0x30000148,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ac0,0x7b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x7b0,0x0);

/* blade 0x30 and NH 0x0148 */

SDRAM_WRITE(nh_base + 0x7b4,0x30000148);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x7b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7bc,0x0);


	SRAM_WRITE(trie_base + 0x409cc,0x1b);

/*  add 16.49.0.0 255.255.0.0 0x0149 0x0 1500 0x31000000
 */
/* @@@ Adding dest=0x10310000, mask = 0xffff0000, blade_nh_id=0x31000149,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ac4,0x7c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x7c0,0x0);

/* blade 0x31 and NH 0x0149 */

SDRAM_WRITE(nh_base + 0x7c4,0x31000149);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x7c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7cc,0x0);

/*  add 16.50.0.0 255.255.0.0 0x0150 0x0 1500 0x32000000
 */
/* @@@ Adding dest=0x10320000, mask = 0xffff0000, blade_nh_id=0x32000150,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ac8,0x7d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x7d0,0x0);

/* blade 0x32 and NH 0x0150 */

SDRAM_WRITE(nh_base + 0x7d4,0x32000150);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x7d8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7dc,0x0);

/*  add 16.51.0.0 255.255.0.0 0x0151 0x0 1500 0x33000000
 */
/* @@@ Adding dest=0x10330000, mask = 0xffff0000, blade_nh_id=0x33000151,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40acc,0x7e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x7e0,0x0);

/* blade 0x33 and NH 0x0151 */

SDRAM_WRITE(nh_base + 0x7e4,0x33000151);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x7e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7ec,0x0);

/*  add 16.52.0.0 255.255.0.0 0x0152 0x0 1500 0x34000000
 */
/* @@@ Adding dest=0x10340000, mask = 0xffff0000, blade_nh_id=0x34000152,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ad0,0x7f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x7f0,0x0);

/* blade 0x34 and NH 0x0152 */

SDRAM_WRITE(nh_base + 0x7f4,0x34000152);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x7f8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x7fc,0x0);

/*  add 16.53.0.0 255.255.0.0 0x0153 0x0 1500 0x35000000
 */
/* @@@ Adding dest=0x10350000, mask = 0xffff0000, blade_nh_id=0x35000153,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ad4,0x800000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x800,0x0);

/* blade 0x35 and NH 0x0153 */

SDRAM_WRITE(nh_base + 0x804,0x35000153);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x808,0x05dc0000);


SDRAM_WRITE(nh_base + 0x80c,0x0);

/*  add 16.54.0.0 255.255.0.0 0x0154 0x0 1500 0x36000000
 */
/* @@@ Adding dest=0x10360000, mask = 0xffff0000, blade_nh_id=0x36000154,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ad8,0x810000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x810,0x0);

/* blade 0x36 and NH 0x0154 */

SDRAM_WRITE(nh_base + 0x814,0x36000154);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x818,0x05dc0000);


SDRAM_WRITE(nh_base + 0x81c,0x0);

/*  add 16.55.0.0 255.255.0.0 0x0155 0x0 1500 0x37000000
 */
/* @@@ Adding dest=0x10370000, mask = 0xffff0000, blade_nh_id=0x37000155,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40adc,0x820000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x820,0x0);

/* blade 0x37 and NH 0x0155 */

SDRAM_WRITE(nh_base + 0x824,0x37000155);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x828,0x05dc0000);


SDRAM_WRITE(nh_base + 0x82c,0x0);

/*  add 16.56.0.0 255.255.0.0 0x0156 0x0 1500 0x38000000
 */
/* @@@ Adding dest=0x10380000, mask = 0xffff0000, blade_nh_id=0x38000156,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ae0,0x830000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x830,0x0);

/* blade 0x38 and NH 0x0156 */

SDRAM_WRITE(nh_base + 0x834,0x38000156);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x838,0x05dc0000);


SDRAM_WRITE(nh_base + 0x83c,0x0);

/*  add 16.57.0.0 255.255.0.0 0x0157 0x0 1500 0x39000000
 */
/* @@@ Adding dest=0x10390000, mask = 0xffff0000, blade_nh_id=0x39000157,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ae4,0x840000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x840,0x0);

/* blade 0x39 and NH 0x0157 */

SDRAM_WRITE(nh_base + 0x844,0x39000157);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x848,0x05dc0000);


SDRAM_WRITE(nh_base + 0x84c,0x0);

/*  add 16.58.0.0 255.255.0.0 0x0158 0x0 1500 0x3a000000
 */
/* @@@ Adding dest=0x103a0000, mask = 0xffff0000, blade_nh_id=0x3a000158,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40ae8,0x850000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x850,0x0);

/* blade 0x3a and NH 0x0158 */

SDRAM_WRITE(nh_base + 0x854,0x3a000158);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x858,0x05dc0000);


SDRAM_WRITE(nh_base + 0x85c,0x0);

/*  add 16.59.0.0 255.255.0.0 0x0159 0x0 1500 0x3b000000
 */
/* @@@ Adding dest=0x103b0000, mask = 0xffff0000, blade_nh_id=0x3b000159,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40aec,0x860000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x860,0x0);

/* blade 0x3b and NH 0x0159 */

SDRAM_WRITE(nh_base + 0x864,0x3b000159);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x868,0x05dc0000);


SDRAM_WRITE(nh_base + 0x86c,0x0);

/*  add 16.60.0.0 255.255.0.0 0x0160 0x0 1500 0x3c000000
 */
/* @@@ Adding dest=0x103c0000, mask = 0xffff0000, blade_nh_id=0x3c000160,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40af0,0x870000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x870,0x0);

/* blade 0x3c and NH 0x0160 */

SDRAM_WRITE(nh_base + 0x874,0x3c000160);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x878,0x05dc0000);


SDRAM_WRITE(nh_base + 0x87c,0x0);

/*  add 16.61.0.0 255.255.0.0 0x0161 0x0 1500 0x3d000000
 */
/* @@@ Adding dest=0x103d0000, mask = 0xffff0000, blade_nh_id=0x3d000161,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40af4,0x880000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x880,0x0);

/* blade 0x3d and NH 0x0161 */

SDRAM_WRITE(nh_base + 0x884,0x3d000161);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x888,0x05dc0000);


SDRAM_WRITE(nh_base + 0x88c,0x0);

/*  add 16.62.0.0 255.255.0.0 0x0162 0x0 1500 0x3e000000
 */
/* @@@ Adding dest=0x103e0000, mask = 0xffff0000, blade_nh_id=0x3e000162,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40af8,0x890000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x890,0x0);

/* blade 0x3e and NH 0x0162 */

SDRAM_WRITE(nh_base + 0x894,0x3e000162);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x898,0x05dc0000);


SDRAM_WRITE(nh_base + 0x89c,0x0);

/*  add 16.63.0.0 255.255.0.0 0x0163 0x0 1500 0x3f000000
 */
/* @@@ Adding dest=0x103f0000, mask = 0xffff0000, blade_nh_id=0x3f000163,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40afc,0x8a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x8a0,0x0);

/* blade 0x3f and NH 0x0163 */

SDRAM_WRITE(nh_base + 0x8a4,0x3f000163);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x8a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x8ac,0x0);

/*  add 16.64.0.0 255.255.0.0 0x0164 0x0 1500 0x3f000000
 */
/* @@@ Adding dest=0x10400000, mask = 0xffff0000, blade_nh_id=0x3f000164,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40b00,0x8b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x8b0,0x0);

/* blade 0x3f and NH 0x0164 */

SDRAM_WRITE(nh_base + 0x8b4,0x3f000164);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x8b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x8bc,0x0);


	SRAM_WRITE(trie_base + 0x409d0,0x1c);

/* 
 *//* 
 *//* 
 *//* #-----------------------------------------------
 */ /* # 32-bit routes - Forward			 
 */ /* #-----------------------------------------------
 */ /* 
 *//*  add 48.2.0.1 255.255.255.255 0x0011 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x30020001, mask = 0xffffffff, blade_nh_id=0x0011,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40c04,0x8c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x8c0,0x0);

/* blade 0x0 and NH 0x0011 */

SDRAM_WRITE(nh_base + 0x8c4,0x0011);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x8c8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x8cc,0x0);


	SRAM_WRITE(trie_base + 0x40bc0,0x20);


	SRAM_WRITE(trie_base + 0x40b80,0x1f);


	SRAM_WRITE(trie_base + 0x40b40,0x1e);


	SRAM_WRITE(trie_base + 0xc008,0x1d);

/*  add 48.2.0.2 255.255.255.255 0x0012 0x0 1500 0x02000000
 */
/* @@@ Adding dest=0x30020002, mask = 0xffffffff, blade_nh_id=0x2000012,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40c08,0x8d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x8d0,0x0);

/* blade 0x2 and NH 0x0012 */

SDRAM_WRITE(nh_base + 0x8d4,0x2000012);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x8d8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x8dc,0x0);

/*  add 48.2.0.3 255.255.255.255 0x0013 0x0 1500 0x03000000
 */
/* @@@ Adding dest=0x30020003, mask = 0xffffffff, blade_nh_id=0x3000013,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40c0c,0x8e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x8e0,0x0);

/* blade 0x3 and NH 0x0013 */

SDRAM_WRITE(nh_base + 0x8e4,0x3000013);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x8e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x8ec,0x0);

/*  add 48.2.0.4 255.255.255.255 0x0014 0x0 1500 0x04000000
 */
/* @@@ Adding dest=0x30020004, mask = 0xffffffff, blade_nh_id=0x4000014,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40c10,0x8f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x8f0,0x0);

/* blade 0x4 and NH 0x0014 */

SDRAM_WRITE(nh_base + 0x8f4,0x4000014);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x8f8,0x05dc0001);


SDRAM_WRITE(nh_base + 0x8fc,0x0);

/*  add 48.2.0.5 255.255.255.255 0x0015 0x0 1500 0x05000000
 */
/* @@@ Adding dest=0x30020005, mask = 0xffffffff, blade_nh_id=0x5000015,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40c14,0x900000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x900,0x0);

/* blade 0x5 and NH 0x0015 */

SDRAM_WRITE(nh_base + 0x904,0x5000015);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x908,0x05dc0001);


SDRAM_WRITE(nh_base + 0x90c,0x0);

/* 
 *//* #-----------------------------------------------
 */ /* # 16-bit routes - Forward			 
 */ /* #-----------------------------------------------
 */ /* 
 *//*  add 48.2.0.0 255.255.0.0 0x0010 0x0 1500 0x06000000
 */
/* @@@ Adding dest=0x30020000, mask = 0xffff0000, blade_nh_id=0x6000010,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40c88,0x910000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x910,0x0);

/* blade 0x1 and NH 0x0010 */

SDRAM_WRITE(nh_base + 0x914,0x6000010);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x918,0x05dc0001);


SDRAM_WRITE(nh_base + 0x91c,0x0);


	SRAM_WRITE(trie_base + 0x40c40,0x22);


	SRAM_WRITE(trie_base + 0x400c0,0x21);

/* 
 *//* 
 *//* 
 *//* #-----------------------------------------------
 */ /* # 8-bit routes  - Forward			 
 */ /* #-----------------------------------------------
 */ /* 
 *//* add 8.0.0.0 255.0.0.0 0x0005 0x0 1500 0x02000000
 */
/* @@@ Adding dest=0x8000000, mask = 0xff000000, blade_nh_id=0x2000005,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40020,0x920000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x920,0x0);

/* blade 0x2 and NH 0x0005 */

SDRAM_WRITE(nh_base + 0x924,0x2000005);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x928,0x05dc0000);


SDRAM_WRITE(nh_base + 0x92c,0x0);

/* 
 *//* 
 *//* #-----------------------------------------------
 */ /* # 11-bit routes  - Forward			 
 */ /* #-----------------------------------------------
 */ /* 
 *//* add 11.32.0.0 255.224.0.0 0x0006 0x0 1500 0x20000000
 */
/* @@@ Adding dest=0xb200000, mask = 0xffe00000, blade_nh_id=0x20000006,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40cc8,0x930000);


	SRAM_WRITE(trie_base + 0x40ccc,0x930000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x930,0x0);

/* blade 0x20 and NH 0x0006 */

SDRAM_WRITE(nh_base + 0x934,0x20000006);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x938,0x05dc0000);


SDRAM_WRITE(nh_base + 0x93c,0x0);


	SRAM_WRITE(trie_base + 0x4002c,0x23);

/* add 11.64.0.0 255.224.0.0 0x0007 0x0 1500 0x3f000000
 */
/* @@@ Adding dest=0xb400000, mask = 0xffe00000, blade_nh_id=0x3f000007,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40cd0,0x940000);


	SRAM_WRITE(trie_base + 0x40cd4,0x940000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x940,0x0);

/* blade 0x3f and NH 0x0007 */

SDRAM_WRITE(nh_base + 0x944,0x3f000007);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x948,0x05dc0000);


SDRAM_WRITE(nh_base + 0x94c,0x0);

/* #-----------------------------------------------
   # 15-bit routes - Forward			 
   #-----------------------------------------------
 */

/* add 15.2.0.0 255.254.0.0 0x0008 0x0 1500 0x02000000
 */
/* @@@ Adding dest=0xf020000, mask = 0xfffe0000, blade_nh_id=0x2000008,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d48,0x950000);


	SRAM_WRITE(trie_base + 0x40d4c,0x950000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x950,0x0);

/* blade 0x2 and NH 0x0008 */

SDRAM_WRITE(nh_base + 0x954,0x2000008);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x958,0x05dc0000);


SDRAM_WRITE(nh_base + 0x95c,0x0);


	SRAM_WRITE(trie_base + 0x40d00,0x25);


	SRAM_WRITE(trie_base + 0x4003c,0x24);

/* add 15.4.0.0 255.254.0.0 0x0009 0x0 1500 0x04000000
 */
/* @@@ Adding dest=0xf040000, mask = 0xfffe0000, blade_nh_id=0x4000009,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d50,0x960000);


	SRAM_WRITE(trie_base + 0x40d54,0x960000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x960,0x0);

/* blade 0x4 and NH 0x0009 */

SDRAM_WRITE(nh_base + 0x964,0x4000009);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x968,0x05dc0000);


SDRAM_WRITE(nh_base + 0x96c,0x0);

/* add 15.6.0.0 255.254.0.0 0x00c0 0x0 1500 0x06000000
 */
/* @@@ Adding dest=0xf060000, mask = 0xfffe0000, blade_nh_id=0x10000c0,mtu_port=0x05dc0001,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d58,0x970000);


	SRAM_WRITE(trie_base + 0x40d5c,0x970000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x970,0x0);

/* blade 0x1 and NH 0x00c0 */

SDRAM_WRITE(nh_base + 0x974,0x60000c0);

/* MTU is 1500, outport is 0x1 */ 

SDRAM_WRITE(nh_base + 0x978,0x05dc0001);


SDRAM_WRITE(nh_base + 0x97c,0x0);

/* add 15.8.0.0 255.254.0.0 0x00c1 0x0 1500 0x08000000
 */
/* @@@ Adding dest=0xf080000, mask = 0xfffe0000, blade_nh_id=0x80000c1,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d60,0x980000);


	SRAM_WRITE(trie_base + 0x40d64,0x980000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x980,0x0);

/* blade 0x8 and NH 0x00c1 */

SDRAM_WRITE(nh_base + 0x984,0x80000c1);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x988,0x05dc0000);


SDRAM_WRITE(nh_base + 0x98c,0x0);

/* add 15.10.0.0 255.254.0.0 0x00c2 0x0 1500 0x0a000000
 */
/* @@@ Adding dest=0xf0a0000, mask = 0xfffe0000, blade_nh_id=0xa0000c2,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d68,0x990000);


	SRAM_WRITE(trie_base + 0x40d6c,0x990000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x990,0x0);

/* blade 0xa and NH 0x00c2 */

SDRAM_WRITE(nh_base + 0x994,0xa0000c2);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x998,0x05dc0000);


SDRAM_WRITE(nh_base + 0x99c,0x0);

/* #-----------------------------------------------
   # 20-bit routes - Forward			 
   #-----------------------------------------------
 */ 
/* add 20.0.16.0 255.255.240.0 0x00c3 0x0 1500 0x10000000
 */
/* @@@ Adding dest=0x14001000, mask = 0xfffff000, blade_nh_id=0x100000c3,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d84,0x9a0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x9a0,0x0);

/* blade 0x10 and NH 0x00c3 */

SDRAM_WRITE(nh_base + 0x9a4,0x100000c3);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x9a8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9ac,0x0);


	SRAM_WRITE(trie_base + 0x5000,0x26);

/* add 20.0.32.0 255.255.240.0 0x00c4 0x0 1500 0x20000000
 */
/* @@@ Adding dest=0x14002000, mask = 0xfffff000, blade_nh_id=0x200000c4,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d88,0x9b0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x9b0,0x0);

/* blade 0x20 and NH 0x00c4 */

SDRAM_WRITE(nh_base + 0x9b4,0x200000c4);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x9b8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9bc,0x0);

/* add 20.0.48.0 255.255.240.0 0x00c5 0x0 1500 0x30000000
 */
/* @@@ Adding dest=0x14003000, mask = 0xfffff000, blade_nh_id=0x300000c5,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d8c,0x9c0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x9c0,0x0);

/* blade 0x30 and NH 0x00c5 */

SDRAM_WRITE(nh_base + 0x9c4,0x300000c5);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x9c8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9cc,0x0);

/* add 20.0.64.0 255.255.240.0 0x00c6 0x0 1500 0x3f000000
 */
/* @@@ Adding dest=0x14004000, mask = 0xfffff000, blade_nh_id=0x3f0000c6,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40d90,0x9d0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x9d0,0x0);

/* blade 0x3f and NH 0x00c6 */

SDRAM_WRITE(nh_base + 0x9d4,0x3f0000c6);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x9d8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9dc,0x0);

/* #-----------------------------------------------
   # 24-bit routes - Forward			 
   #-----------------------------------------------
 */ 

 /* add 24.0.1.0 255.255.255.0 0x00c7 0x0 1500 0x00000000
 */
/* @@@ Adding dest=0x18000100, mask = 0xffffff00, blade_nh_id=0x00c7,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40e04,0x9e0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x9e0,0x0);

/* blade 0x0 and NH 0x00c7 */

SDRAM_WRITE(nh_base + 0x9e4,0x00c7);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x9e8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9ec,0x0);


	SRAM_WRITE(trie_base + 0x40dc0,0x28);


	SRAM_WRITE(trie_base + 0x6000,0x27);

/* add 24.0.2.0 255.255.255.0 0x00c8 0x0 1500 0x02000000
 */
/* @@@ Adding dest=0x18000200, mask = 0xffffff00, blade_nh_id=0x20000c8,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40e08,0x9f0000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0x9f0,0x0);

/* blade 0x2 and NH 0x00c8 */

SDRAM_WRITE(nh_base + 0x9f4,0x20000c8);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0x9f8,0x05dc0000);


SDRAM_WRITE(nh_base + 0x9fc,0x0);

/* add 24.0.3.0 255.255.255.0 0x00c9 0x0 1500 0x03000000
 */
/* @@@ Adding dest=0x18000300, mask = 0xffffff00, blade_nh_id=0x30000c9,mtu_port=0x05dc0000,flags=0x0 */

	SRAM_WRITE(trie_base + 0x40e0c,0xa00000);

/* writing nexthop entry with flags 0x0 */ 

SDRAM_WRITE(nh_base + 0xa00,0x0);

/* blade 0x3 and NH 0x00c9 */

SDRAM_WRITE(nh_base + 0xa04,0x30000c9);

/* MTU is 1500, outport is 0x0 */ 

SDRAM_WRITE(nh_base + 0xa08,0x05dc0000);


SDRAM_WRITE(nh_base + 0xa0c,0x0);


return 1;


}
