//------------------------------------------------------------------------------------
//
//                   I N T E L   P R O P R I E T A R Y
//
//      COPYRIGHT (c)  2003 BY  INTEL  CORPORATION.  ALL RIGHTS
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//      THE PRIOR WRITTEN PERMISSION OF :
//
//                         INTEL  CORPORATION
//
//                      2200 MISSION COLLEGE BLVD
//
//                SANTA  CLARA,  CALIFORNIA  95052-8119
//
//------------------------------------------------------------------------------------
/////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: quad_gbeth_system_init.uc
//
//      Purpose:
//
//      History:
//
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      01/22/2003      Created                         Tomasz Madajczak
//
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __QUAD_GBETH_SYSTEM_INIT_UC__
#define __QUAD_GBETH_SYSTEM_INIT_UC__


#include <dispatch_loop.uc>

#define SRAM_Q_ARRAY_NUM_FIELD  24
#define RM_QARRAY_CHANNEL_NOT_PRESENT 0xffffffff

////////////////////////////////////////////////////////////////////////
// Macro Name  : _rm_read_q_array
// Description : Macro to read and cache a Queue Descriptor entry from
//               SRAM to Q_Array. $QDArray is actually packet count.
// Output      : out_qd_array
// Input       : in_queue_ptr, in_qarray_entry, in_qa_signal
// Constant    : nil
// Size        : 4
// Branches    : 0
////////////////////////////////////////////////////////////////////////
#macro _rm_read_q_array[ in_sram_base, in_queue_ptr, in_qarray_entry, in_qa_signal, out_qd_array  ]

.begin

    .reg  qarray_sram_addr, dummy

    // multiply the pointer by 4 to get the offset

    alu[dummy, --, b, in_queue_ptr, <<2]

    // get the sram QD address by adding the offset to the base
    // the address has to be LW alighned( ie byte address >> 2)

    alu[qarray_sram_addr,dummy , +, in_sram_base]

    // read the complete queue descriptor from the sram.

    sram[rd_qdesc_head, out_qd_array, in_qarray_entry,qarray_sram_addr,2], sig_done[in_qa_signal]
    sram[rd_qdesc_other, --, in_qarray_entry, qarray_sram_addr]


.end
#endm

////////////////////////////////////////////////////////////////////////
// Macro Name  : rm_qarray_init
// Description : Macro to read and cache a Queue Descriptor entry from
//               SRAM to Q_Array. The macro initializes all 64 Q_arrays
//               for a given channel
// Output      :
// Input       : in_sram_base
// Constant    : nil
// Size        :
// Branches    : 0
////////////////////////////////////////////////////////////////////////
#macro rm_qarray_init[in_qarray_sram_base]

.begin

   .reg count
   .reg channel_mask
   .reg channel_num
   .reg sram_base
   .reg qarray_entry
   .reg qarray_sram_add
   .reg $qd_return
   .sig qarray_signal

    .if(in_qarray_sram_base==RM_QARRAY_CHANNEL_NOT_PRESENT)
        br[end#]
    .endif

   // move sram_Base into a register

   move[sram_base, in_qarray_sram_base]

  // mask used to mask out everything except
   // the two most significant bits, which are
   // the channel numbers

   move[channel_mask, 0xC0000000]

   // using the mask obtain the channel num from
   // the given sram address

   alu[channel_num, sram_base, AND, channel_mask]

   // initialize the count register to the
   // num of qarrays in a channel
   immed[count, 64]

   .while(count != 0 )


       // setting the channelnum and q array entry. This is done before the branch
       // since it might be required for enqueue and dequeue operations in hit case.

       alu[qarray_entry, channel_num, OR, count, <<SRAM_Q_ARRAY_NUM_FIELD]

       _rm_read_q_array[ sram_base, count, qarray_entry, qarray_signal, $qd_return ]

       ctx_arb[qarray_signal]

       alu[count, count, -, 1]
   .endw

nop
end#:
.end
#endm


///////////////////////////////////////////////////////////////////////////////
// init_meta_cache_to_zero:
//      Description:
//          Just sets the registers used for meta data caching to zero. [This
//          helps a lot when debugging, because all the unused meta data regsiters
//          will be zero instead of something like 0x5a5a5a).
//
//      Outputs:
//
//      Inputs:
//
//      Size:
//
#macro  init_meta_cache_to_zero[]
.begin
.reg zero

    immed32[zero, 0]
    dl_meta_init_cache[zero, zero, zero, zero, zero, zero, zero, zero]

.end
#endm

///////////////////////////////////////////////////////////////////////////////
// system_init:
//      Description:
//          Does all the initialisation to get the system up and running.
//          Typically it initialises all the various rings, creates the buffer
//          free list, initialises the various cache (meta, ip header etc).
//          Once initialisation is done, a signal is sent to all other MEs
//          so that rest of the code, that depends on this initialisation,
//          to run.
//
//      Outputs:
//
//      Inputs:
//
//      Size:
//
//
#macro  system_init[]

#ifdef USE_IMPORT_VAR

    .import_var QARRAY_INIT_SRAM_BASE_CH0
    .import_var QARRAY_INIT_SRAM_BASE_CH1

    .reg sram_base_ch0,sram_base_ch1
    .set sram_base_ch0,sram_base_ch1

    immed32[sram_base_ch0, QARRAY_INIT_SRAM_BASE_CH0 ]
    immed32[sram_base_ch1, QARRAY_INIT_SRAM_BASE_CH1 ]

    // initialize qarrays for both SRAM channels

    rm_qarray_init[sram_base_ch0]
    rm_qarray_init[sram_base_ch1]

#else
    // Initialise the various scratch rings used in the ingress pipeline

/*  There are two exception ring to send pkts up */

    init_scratch_ring[EXCEPTION_RING_OUT_0_BASE, EXCEPTION_RING_OUT_0_SIZE, EXCEPTION_RING_OUT_0]
    init_scratch_ring[EXCEPTION_RING_OUT_1_BASE, EXCEPTION_RING_OUT_1_SIZE, EXCEPTION_RING_OUT_1]
    init_scratch_ring[EXCEPTION_RING_IN_0_BASE, EXCEPTION_RING_IN_0_SIZE, EXCEPTION_RING_IN_0]
    init_scratch_ring[EXCEPTION_RING_IN_1_BASE, EXCEPTION_RING_IN_1_SIZE, EXCEPTION_RING_IN_1]
    init_scratch_ring[ETH_RX_TO_IPV4_SCR_RING_BASE, ETH_RX_TO_IPV4_SCR_RING_SIZE, ETH_RX_TO_IPV4_SCR_RING]
    init_scratch_ring[IPV4_TO_QM_SCR_RING_BASE, IPV4_TO_QM_SCR_RING_SIZE, IPV4_TO_QM_SCR_RING]
    init_scratch_ring[SCHEDULER_TO_QM_SCR_RING_BASE, SCHEDULER_TO_QM_SCR_RING_SIZE, SCHEDULER_TO_QM_SCR_RING]
    init_scratch_ring[QM_TO_PACKET_TX_SCR_RING_0_BASE, QM_TO_PACKET_TX_SCR_RING_0_SIZE, QM_TO_PACKET_TX_SCR_RING_0]
    init_scratch_ring[QM_TO_PACKET_TX_SCR_RING_1_BASE, QM_TO_PACKET_TX_SCR_RING_1_SIZE, QM_TO_PACKET_TX_SCR_RING_1]
    init_scratch_ring[QM_TO_PACKET_TX_SCR_RING_2_BASE, QM_TO_PACKET_TX_SCR_RING_2_SIZE, QM_TO_PACKET_TX_SCR_RING_2]
    init_scratch_ring[QM_TO_PACKET_TX_SCR_RING_3_BASE, QM_TO_PACKET_TX_SCR_RING_3_SIZE, QM_TO_PACKET_TX_SCR_RING_3]

    // Initialise the free buffer list

    dl_buffer_init[]

#endif
    //  To ease debugging. Not absoultely essential for proper execution.

    init_meta_cache_to_zero[]       ; all the dl_meta* gprs will be set to 0.

    //  signal all MEs, except ME 0 (ME0 is running POS RX & this code)

    signal_me[0x01, ME_INIT_SIGNAL] ; ME 1
    signal_me[0x02, ME_INIT_SIGNAL] ; ME 2
    signal_me[0x03, ME_INIT_SIGNAL] ; ME 3

    // The Next 4 MEs are in Cluster 1. 

    ;signal_me[0x10, ME_INIT_SIGNAL]    ; ME 4 is running Packet Scheduller (don't need this signal)
    signal_me[0x11, ME_INIT_SIGNAL] ; ME 5
    signal_me[0x12, ME_INIT_SIGNAL] ; ME 6
    signal_me[0x13, ME_INIT_SIGNAL] ; ME 7

#endm

#endif  //__QUAD_GBETH_SYSTEM_INIT_UC__
