//------------------------------------------------------------------------------------
//
//                   I N T E L   P R O P R I E T A R Y
//
//      COPYRIGHT (c)  2003 BY  INTEL  CORPORATION.  ALL RIGHTS
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//      THE PRIOR WRITTEN PERMISSION OF :
//
//                         INTEL  CORPORATION
//
//                      2200 MISSION COLLEGE BLVD
//
//                SANTA  CLARA,  CALIFORNIA  95052-8119
//
//------------------------------------------------------------------------------------
/////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: 	dl_iphdr.uc
//
//      Purpose:
//					Contains IP Header Caching Macros.
//
//      History:
//
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      11/19/2001      Created                         Senthil Nathan
//
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __DL_IPHDR_UC__
#define __DL_IPHDR_UC__

#ifndef	PKT_HDR_CACHE_SIZE
#define	PKT_HDR_CACHE_SIZE		10	// 10 longwords
#endif

#ifndef			PKT_HDR_DRAM_RD_SIZE
#define_eval	PKT_HDR_DRAM_RD_SIZE	(PKT_HDR_CACHE_SIZE >> 1)	// read 5 quadwords
#endif

///////////////////////////////////////////////////////////////////////////////
// dl_load_iphdr_cache:
//	 	Description:
//			Reads the IP header (32 bytes) of the packet from SDRAM and keeps
//			it in a cache (DRAM transfer registers).
//
//	 	Outputs:
//			The $$dl_iphdr# global dram transfer registers will be set with appropriate
//			header data.
//
//		Inputs:
//			buf_handle	:			Handle of buffer.
//			req_sig		:			Signal to use in the I/O (DRAM read) operation.
//			sig_action	:			What to do with I/O operation -
//									- wait for signal(s) as specified by sig_action
//									- do not wait for signal, just return (SIG_NONE)
//		Size:   				:
//
#define	dl_load_iphdr_cache		dl_iphdr_load_cache

#macro dl_iphdr_load_cache[buf_handle, req_sig, sig_action]
.begin
.reg 	sdram_offset, buf_offset

	//	Read 32 bytes of IP Header from SDRAM

	dl_buf_get_data[sdram_offset, buf_handle]
	dl_meta_get_offset[buf_offset]
#ifndef DISABLE_MAC_FILTERING
	dram[read, $$iphdr0, sdram_offset, buf_offset, PKT_HDR_DRAM_RD_SIZE], sig_done[req_sig]	; DRAM reads are in QWORD (8 bytes)
#else // DISABLE_MAC_FILTERING
	alu[buf_offset, buf_offset, +, 8]
	dram[read, $$iphdr2, sdram_offset, buf_offset, 4], sig_done[req_sig]	; DRAM reads are in QWORD (8 bytes)
#endif // DISABLE_MAC_FILTERING

#if (!streq('sig_action', 'SIG_NONE'))
	ctx_arb[sig_action]
#endif

.end
#endm


///////////////////////////////////////////////////////////////////////////////
// dl_flush_iphdr_cache:
//	 	Description:
//			Writes back the IP header (32 bytes) from the cache to the packet in SDRAM.
//
//	 	Outputs:
//
//		Inputs:
//			buf_handle	:			Handle of buffer.
//			req_sig		:			Signal to use in the I/O (DRAM read) operation.
//			sig_action	:			What to do with I/O operation -
//									- wait for signal(s) as specified by sig_action
//									- do not wait for signal, just return (SIG_NONE)
//			The $$dl_iphdr# global dram transfer registers will be the set of registers
//			from which data will be written back to SDRAM.
//
//		Size:   				:
//
#define	dl_flush_iphdr_cache		dl_iphdr_flush_cache

#macro dl_iphdr_flush_cache[buf_handle, req_sig, sig_action]
.begin
.reg 	sdram_offset, buf_offset

	//	Write 32 bytes of IP Header from SDRAM

	dl_buf_get_data[sdram_offset, buf_handle]
	dl_meta_get_offset[buf_offset]

	alu[buf_offset,buf_offset,+,2]
	dram[write, $$iphdr4, sdram_offset, buf_offset, 2], sig_done[req_sig]	; DRAM reads are in QWORD (8 bytes)

#if (!streq('sig_action', 'SIG_NONE'))
	ctx_arb[sig_action]
#endif

.end
#endm


///////////////////////////////////////////////////////////////////////////////
// dl_iphdr_cache_init:
//	 	Description:
//			This macro needs to be called before any of the dl_iphdr_* can be called.
//			It allocates a set of DRAM xfer registers to be used for caching. This macro
//			doesn't generate any code (instructions). It only produces some assembler
//			directives.
//
//	 	Outputs:
//
//		Inputs:
//
//		Size:   				:
//			0 Instructions

#macro dl_iphdr_cache_init[]

	xbuf_alloc[$$iphdr, PKT_HDR_CACHE_SIZE, read_write]

#endm

///////////////////////////////////////////////////////////////////////////////
// dl_iphdr_cache_fini:
//	 	Description:
//			This macro needs to be called at the end when dl_iphdr_macros are no longer
//			required. It frees a set of DRAM xfer registers that were allocated using
//			dl_iphdr_cache_init. This macro	doesn't generate any code (instructions).
//			It only produces some assembler	directives.
//
//	 	Outputs:
//
//		Inputs:
//
//		Size:   				:
//			0 Instructions

#macro dl_iphdr_cache_fini[]

	xbuf_free[$$iphdr]

#endm

#endif	//__DL_IPHDR_UC__
