////////////////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: sig_functions.h
//
//      Purpose: This file defines a set of simple functions used for signalling threads 
//				 and micro engines.
//
//
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef	__SIG_FUNCTIONS_H__
#define	__SIG_FUNCTIONS_H__

#include "ixp.h"

/*
 *	These definitions are provided for backward compatibilty to enable smooth 
 *	transition. They will be removed soon
 */

#define	get_current_ctx			GetCurrentCtx
#define	get_current_me			GetCurrentMe
#define	init_interthread_sig	InitInterthreadSig
#define	signal_next_ctx			SignalNextCtx
#define	signal_me				SignalMe


#ifdef	BIGENDIAN

typedef __declspec(packed) union {

	struct {
		unsigned int reserved:24;
		unsigned int next_ctx:1;
		unsigned int sig:4;
		unsigned int thread:3;
	};

	unsigned int value;

} same_me_signal_t;

#else	//!BIGENDIAN
typedef __declspec(packed) union {

	struct {
		unsigned int thread:3;
		unsigned int sig:4;
		unsigned int next_ctx:1;
		unsigned int reserved:24;
	};

	unsigned int value;

} same_me_signal_t;

#endif

// Use IN_ORDER to signal the next thread (or context) during strict thread ordering.
#define IN_ORDER	0x80

// For details on each function, see "sig_functions.c".

int GetCurrentCtx();
int GetCurrentMe();
void SignalNextCtx(same_me_signal_t x);
void SignalMe(int me, int sig);
same_me_signal_t InitInterthreadSig(int sigval_next_ctx);

#endif // __SIG_FUNCTIONS_H__