/*--------------------------------------------------------------------------
 *                                                                     
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *--------------------------------------------------------------------------
 */

#ifndef	__ETHER_C__
#define	__ETHER_C__

#include	"ixp_ipv4.c"
#include	"ether_decap.h"


extern __declspec(gp_reg) int 	dlNextBlock;
extern dl_meta_t dlMeta;


//#define 	UNKNOWN_TYPE				0x00


/**************************************************************************
 * _ether_get_pkt_type
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE	int _ether_get_pkt_type(void *p_pkt,UINT in_offset,mem_t memType)
{
	int type =0x00;

	type = _buf_byte_extract((UINT*)p_pkt,in_offset, ETHER_HEADER_LENGTH, memType);

	return (type);

}


/**************************************************************************
 * _ether_decap
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE void	_ether_decap(void)
{
	
	/* simply strip off the Ethernet header */
	dlMeta.offset += ETHER_HEADER_LENGTH;
	dlMeta.bufferSize -= ETHER_HEADER_LENGTH;
	dlMeta.packetSize -= ETHER_HEADER_LENGTH;

	return;
}

/**************************************************************************
 * _ether_classify
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE void	_ether_classify(void *p_pkt,UINT in_offset,mem_t memType)
{
	int type;

	type = _ether_get_pkt_type(p_pkt,in_offset,memType);

	if (type == ETHER_IPV4)
	{
		dlMeta.headerType = ETHER_IPV4_TYPE;
		dlNextBlock = BID_ETHER_DECAP_NEXT1;
	}
	else if (type == ETHER_IPV6)
	{
		dlMeta.headerType = ETHER_IPV6_TYPE;
		dlNextBlock = BID_ETHER_DECAP_NEXT2;
	}
	else if (type == ETHER_MPLS_UNICAST)
	{
		dlMeta.headerType = ETHER_MPLS_TYPE;
		dlNextBlock = BID_ETHER_DECAP_NEXT3;
	}
	else
	{
		dlMeta.headerType = UNKNOWN_TYPE;
		dlNextBlock = IX_EXCEPTION;
	}

	return;

}

/**************************************************************************
 * _ether_decap_classify
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE void	ether_decap_classify(void *p_pkt,UINT in_offset,mem_t memType)
{
	
	//if (dlNextBlock != BID_ETHER)
	//	return;

	_ether_decap();

	_ether_classify(p_pkt,in_offset,memType);

	return;
}

#endif	// end __ETHER_C__