/*
 *---------------------------------------------------------------------------
 *
 *                  I N T E L   P R O P R I E T A R Y
 *
 *     COPYRIGHT (c)  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
 *     THE PRIOR WRITTEN PERMISSION OF :
 *
 *                        INTEL  CORPORATION
 *
 *                     2200 MISSION COLLEGE BLVD
 *
 *               SANTA  CLARA,  CALIFORNIA  95052-8119
 *
 *---------------------------------------------------------------------------
 */

#ifndef __DL_META_H__
#define __DL_META_H__

#include <dl_buf.h>

/*
 *	These definitions are provided for backward compatibilty to enable smooth 
 *	transition. They will be removed soon
 */

#define	dl_meta_load_cache		Dl_MetaLoadCache
#define	dl_meta_flush_cache		Dl_MetaFlushCache
#define	dl_meta_get_buffer_next	Dl_MetaGetBufferNext
#define	init_scratch_ring		InitScratchRing


/**
******************************************************************************
* @ingroup Buffer Meta data API
* Packet Buffer Meta Data structure
*
* @description
*	This structure defines the meta data for the packet buffers. The size of 
*	meta data should be power of 2.
*
* @see		Dl_Meta Functions
******************************************************************************/

typedef __declspec(packed) union
{
	struct {
		dl_buf_handle_t	bufferNext;		/**< Next buffer in the chain */

		unsigned short	bufferSize;		/**< amount of data currently in buffer */
		unsigned short	offset;				/**< offset in DRAM where data begins */

		unsigned int	packetSize	: 16;	/**< amount of data in the chain of buffers */
		unsigned int	freeListId	: 4;	/**< Free List to which this buffer belongs to */
		unsigned int	rxStat	 	: 4;	/**< Receive status */
		unsigned int 	headerType	: 8;	/**< HEader Type: IPv4, IPv6 etc */

		unsigned short	inputPort;			/**< Input port on which packet was received */
		unsigned short	outputPort;			/**< Output port on which packet to be transmitted */

		unsigned int	nextHopId	: 16;	/**< Nexthop ID */
		unsigned int	fabricPort	: 8;	/**< Blade:Port */
		unsigned int	reserved    : 4;	/**< reserved */
		unsigned int	nhidType	: 4;	/**< nexthop ID type */

		unsigned int	colorId		:4;
		unsigned int	reserved1	:4;		
		unsigned int	flowId		:24;	/**< FLow ID */

		unsigned short	classId;			/**< Class ID */
		unsigned short	reserved2;

		unsigned int	packetNext;			/**< Next packet in the chain */
											/**< (used only in Hierarchical Queuing) */
	};	// end of struct

	unsigned int value[8];					/**< aggregate for the above fields */

} dl_meta_t;


/*
 *	These are the Meta Data API functions 
 */

void Dl_MetaLoadCache(dl_buf_handle_t	bufHandle, 
						SIGNAL*			sig_requested, 
						unsigned int	numLongWords);

void Dl_MetaFlushCache(dl_buf_handle_t	buf_handle, 
						SIGNAL*			req_sig, 
						unsigned int	sig_action,
						unsigned int	start_lw,
						unsigned int	num_lw);

void Dl_MetaFlushCache2(dl_buf_handle_t	buf_handle, 
						__declspec(sram_write_reg) dl_meta_t *sram_wxfer,
						SIGNAL*			req_sig, 
						unsigned int	sig_action,
						unsigned int	start_lw,
						unsigned int	num_lw);

void Dl_MetaWrite(dl_buf_handle_t	buf_handle, 
					__declspec(sram_write_reg) dl_meta_t *sram_wxfer,
					unsigned int	buffer_next,
					unsigned int	buffer_size,
					unsigned int	offset,
					unsigned int	packet_size,
					unsigned int	free_list_id,
					unsigned int	rx_stat,
					unsigned int	header_type,
					unsigned int	input_port,
					unsigned int	output_port,
					unsigned int	next_hop_id,
					unsigned int	fabric_port,
					unsigned int	flow_id,
					unsigned int	calss_id,
					unsigned int	packet_next,
					SIGNAL*		    req_sig, 
					unsigned int	sig_action,
					unsigned int	start_lw,
					unsigned int	num_lw);

void Dl_MetaFlushCacheSkip0(dl_buf_handle_t	buf_handle, 
						SIGNAL*			req_sig, 
						unsigned int	sig_action,
						unsigned int	num_lw);

/*	XXX - Is this function really required */

int Dl_MetaGetBufferNext(void);

/* 	XXX - Is there a better place where InitScratchRing can be put */

void InitScratchRing(int rbase, int rsize, int ring);




#endif 	// __DL_META_H__
