/*
 *---------------------------------------------------------------------------
 *
 *                  I N T E L   P R O P R I E T A R Y
 *
 *     COPYRIGHT (c)  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
 *     THE PRIOR WRITTEN PERMISSION OF :
 *
 *                        INTEL  CORPORATION
 *
 *                     2200 MISSION COLLEGE BLVD
 *
 *               SANTA  CLARA,  CALIFORNIA  95052-8119
 *
 *---------------------------------------------------------------------------
 */

#ifndef __DL_BUF_H__
#define __DL_BUF_H__

#include <dl_system.h>
#include <ixp_buf.c>

/*
 *	These definitions are provided for backward compatibilty to enable smooth 
 *	transition. They will be removed soon
 */
#ifdef	BACKWARD_COMPATIBILITY

#define	dl_buf_init					Dl_BufInit
#define	dl_buf_alloc				Dl_BufAlloc
#define	dl_buf_free					Dl_BufFree
#define	dl_buf_get_desc				Dl_BufGetDesc
#define	dl_buf_get_data				Dl_BufGetData
#define	dl_buf_get_data_from_meta	Dl_BufGetDataFromMeta
#define	dl_buf_drop					Dl_BufDrop
#define	dl_buf_drop_chain			Dl_BufDropChain

#endif

//	Number of packet buffers

#define			NO_OF_PKT_BUFFERS	BUF_SRAM_SIZE/META_DATA_SIZE

// 	Some sanity check. Check if the specified SDRAM memory is of suffcient size 
//	to hold all buffers

#if BUFFER_SIZE == 0
#error "BUFER SIZE NOT DEFINED"
#endif

#define	DRAM_COMPUTE		BUF_SDRAM_SIZE/BUFFER_SIZE

#if	(DRAM_COMPUTE != NO_OF_PKT_BUFFERS)
#error	"The amount of memory allocated in SRAM for packet buffers doesn't match with\
the SDRAM size. Check BUF_SRAM_SIZE and BUF_SDRAM_SIZE. Also check META_DATA_SIZE and BUFFER_SIZE"
#endif

#undef	DRAM_COMPUTE

#define	AVLBL_PKT_BUFFERS	NO_OF_PKT_BUFFERS

// 	DL_DS_RATIO = Sizeof (SDRAM entry) / Sizeof (SRAM Entry)

#define	DL_DS_RATIO				BUFFER_SIZE/META_DATA_SIZE

/* nizhner 8/17/04: added support for load-time constants */
//#ifndef USE_IMPORT_VAR

//	SRAM-QArray ID for enqueing/dequeing pkt buffers. (i.e maintinaing the free list)
// 	Right now there is only one free list. But there may be multiple in the near future.

#define			BUF_FREE_LIST0		BUF_QARRAY_BASE

//	The combination of BUF_SDRAM_BASE, BUFFER_SIZE, BUF_SRAM_BASE, META_DATA_SIZE
//	specify a particular buffer pool. The IXP buf functions need it this way and it needs
//	it in Long Words.
// 	NOTE: Changed: The IXP buf functions needs it in bytes (not Long Words)!
//	BUt we still use *_LW for holding temp. values. But all values are in bytes.

#define	BUF_SDRAM_BASE_LW	BUF_SDRAM_BASE
#define	BUFFER_SIZE_LW		BUFFER_SIZE
#define	BUF_SRAM_BASE_LW	BUF_SRAM_BASE
#define	META_DATA_SIZE_LW	META_DATA_SIZE

//	Specifying a base of address of 0 for SRAM (and DRAM) simplifies the arithmatic required
//	to translate the handle to offset. (it saves one instruction. See dl_buf_get_desc)
//	However, dl_buf_alloc will return 0 for a null buffer (i.e no buffer available) and it may 
//	not be possible to differentiate between a null buffer and a buffer at address 0.
//	So we simply make that one buffer at address 0 unavailable for allocation/freeing, yet
//	taking advantage of using a base address of 0. We end up wasting a little memory (1 buffer)
//	but that's ok.

#if	(BUF_SRAM_BASE_LW == 0)

#undef	BUF_SRAM_BASE_LW
#define	BUF_SRAM_BASE_LW		BUF_SRAM_BASE + META_DATA_SIZE_LW

#undef	BUF_SDRAM_BASE_LW
#define	BUF_SDRAM_BASE_LW		BUF_SDRAM_BASE + BUFFER_SIZE_LW

#undef	AVLBL_PKT_BUFFERS
#define	AVLBL_PKT_BUFFERS		NO_OF_PKT_BUFFERS - 1

#endif

#define	BUF_POOL				BUF_SDRAM_BASE_LW, BUFFER_SIZE_LW, BUF_SRAM_BASE_LW, META_DATA_SIZE_LW	

// DL_REL_BASE = DRAM_BASE - (BUF_SRAM_BASE * DL_DS_RATIO)

#define	DL_REL_BASE				BUF_SDRAM_BASE - (BUF_SRAM_BASE * DL_DS_RATIO)

//#else  /* USE_IMPORT_VAR */

//#define	BUF_POOL				0, BUFFER_SIZE, BUF_SRAM_BASE, META_DATA_SIZE
//#define	BUF_POOL				BUF_SRAM_BASE, BUFFER_SIZE, 0, META_DATA_SIZE

//#endif /* USE_IMPORT_VAR */

//	ln(DL_DS_RATIO). i.e 2^MULT_FACTOR = DL_DS_RATIO. This value is required to
// 	reduce multiplication in to simple shift operation. The following set of lines
// 	computes MULT_FACTOR (at compile time) (XXX - This computation cannot be done with
//	'C' preprocessor. requires the assembler preprocessor)

#define MULT_FACTOR				6

typedef	buf_handle_t	dl_buf_handle_t;

/*
 *	These are the Packet Buffer API functions 
 */

void Dl_BufInit();
void Dl_BufAlloc(__declspec(sram_read_reg)dl_buf_handle_t* buf_handle,
					    pool_t			free_list, 
					    unsigned int	d_base, 
					    unsigned int	d_size, 
					    unsigned int	s_base, 
					    unsigned int	s_size,
						SIGNAL*			req_sig, 
						unsigned int	sig_action, 
						queue_t			Q_OPTION);


void Dl_BufFree(dl_buf_handle_t buf_handle, 
			    pool_t			free_list, 
			    unsigned int	d_base, 
			    unsigned int	d_size, 
			    unsigned int	s_base, 
			    unsigned int	s_size);

unsigned int Dl_BufGetDesc(dl_buf_handle_t buf_handle);
unsigned int Dl_BufGetData(dl_buf_handle_t buf_handle);
unsigned int Dl_BufGetDataFromMeta(unsigned int sram_offset);

void Dl_BufDrop(dl_buf_handle_t buf_handle);
void Dl_BufDropChain(dl_buf_handle_t buf_handle, dl_buf_handle_t buf_eop_handle);

#endif	// __DL_BUF_H__