////////////////////////////////////////////////////////////////////////////////
//
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: test_stub.h
//
//      Purpose: header file for Test Stub
//
//
//      History:
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __TEST_STUB_H__
#define __TEST_STUB_H__

#ifdef USE_IMPORT_VAR

.import_var SCHED_QUEUE_STRUCTURES_BASE

#endif 	// USE_IMPORT_VAR

////////////////////////////////////////////////////////////////////////////////
//
// Signal declaration
//
////////////////////////////////////////////////////////////////////////////////

.sig sig_scratch_write 				; signal for scratch ring write

.sig volatile sig_next_context		; signal used to wakeup next thread, 
									; declared as volatile to avoid assembler's warning

.sig sig_sram_read					; signal for sram read

.sig sig_sram_write					; signal for sram write

.sig sig_rd_deq_cntr_done			; this is to signal end of reading the dequeue 
									; counter 

.sig sig_wr_deq_cntr_done			; this is to signal end of writing the dequeue 
									; counter

#define _NO_TX_REQUEST_BIT	0

/* for CAM status */
#define STATUS_VALID				0x1

#if( (TX_PHY_MODE == SPI_4_16PORTS) || (TX_PHY_MODE == SPI_4_10PORTS) )
#define_eval RING_0_NUM		QM_TO_PACKET_TX_SCR_RING_0
#define_eval RING_0_FULL	SCR_Ring/**/RING_0_NUM/**/_Full	
#define_eval RING_1_NUM		QM_TO_PACKET_TX_SCR_RING_1
#define_eval RING_1_FULL	SCR_Ring/**/RING_1_NUM/**/_Full	
#endif	// #if((TX_PHY_MODE == SPI_4_16PORTS) || (TX_PHY_MODE == SPI_4_10PORTS))


////////////////////////////////////////////////////////////////////////////////
		
#endif	// __TEST_STUB_H__

////////////////////////////////////////////////////////////////////////////////
