/*****************************************************************************
 *                            Intel Proprietary
 *
 * Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 * No part of this program or publication may be reproduced, transmitted,
 * transcribed, stored in a retrieval system, or translated into any language
 * or computer language in any form or by any means, electronic, mechanical,
 * magnetic, optical, chemical, manual, or otherwise, without the prior
 * written permission of:
 *                        Intel Corporation
 *                        2200 Mission College Blvd.
 *                        Santa Clara, CA  95052-8119
 *****************************************************************************/

/**
 *****************************************************************************
 * @ingroup PppEncap
 * File:  ppp_encap_util.h
 * @description
 *        Initialization file for PPP Encap microblock in egress pipeline.
 *****************************************************************************/

/*****************************************************************************
 *
 * Contents:
 *        Definitions of following functions:
 *            PppEncap_Init   
 *
 *****************************************************************************/

#ifndef __PPP_ENCAP_INIT_UC__
#define __PPP_ENCAP_INIT_UC__

#include "ppp_encap.h"

/*****************************************************************************
 * Abstract:
 *   Initialization of the microblock
 *    
 *
 * Side Effects:
 *    None
 *
 * Assumptions:
 * 	  None
 *****************************************************************************/
INLINE void									/* OUT: No return value			 */
PppEncap_Init(void)
{
	/* get current thread */
	int thread = get_current_ctx();

	if (thread == 0)
	{
		/* next_thrd_1_gpr and sig_next_thrd_1 are global */
		next_thrd_1_gpr = init_interthread_sig(__signal_number(&sig_next_thrd_1));

		/* next_thrd_2_gpr and sig_next_thrd_2 are global */
		next_thrd_2_gpr = init_interthread_sig(__signal_number(&sig_next_thrd_2));

		/* next_thrd_3_gpr and sig_next_thrd_3 are global */
		next_thrd_3_gpr = init_interthread_sig(__signal_number(&sig_next_thrd_3));

		/* next_thrd_4_gpr and sig_next_thrd_4 are global */
		next_thrd_4_gpr = init_interthread_sig(__signal_number(&sig_next_thrd_4));

#ifdef WAIT_FOR_COMMON_RESOURCE_INITIALIZATION 
		wait_for_all(&sig_commonInitComplete);
#endif
	}

	PppEncap_InitGprs();  /* initialize context relative variables */

	if (thread == 7)
	{
		signal_next_ctx(next_thrd_1_gpr);
		signal_next_ctx(next_thrd_2_gpr);
		signal_next_ctx(next_thrd_3_gpr);
		signal_next_ctx(next_thrd_4_gpr);
	}
}			/* PppEncap_Init */

#endif 		//  __PPP_ENCAP_INIT_UC__
