/*****************************************************************************
 *                            Intel Proprietary
 *
 * Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 * No part of this program or publication may be reproduced, transmitted,
 * transcribed, stored in a retrieval system, or translated into any language
 * or computer language in any form or by any means, electronic, mechanical,
 * magnetic, optical, chemical, manual, or otherwise, without the prior
 * written permission of:
 *                        Intel Corporation
 *                        2200 Mission College Blvd.
 *                        Santa Clara, CA  95052-8119
 *****************************************************************************/

/**
 *****************************************************************************
 * @ingroup PppEncap
 * File:  ppp_encap.h
 * @description
 *        Header file for PPP Encap microblock in egress pipeline.
 *****************************************************************************/

/*****************************************************************************
 *
 * Contents:
 *        Definitions of constants used in PPP Encap microblock
 *        Declaration of external variables and functions used in 
 *            PPP Encap microblock 
 *
 *****************************************************************************/

#ifndef __PPP_ENCAP_H__
#define __PPP_ENCAP_H__

#include <ixp.h>
#include <dl_system.h>
#include <sig_functions.h>
#include <dl_buf.c>
#include <dl_meta.c>
#include <dl_source.h>
#include <dl_source.c>
#include <sig_functions.c>

#define ME_INIT_SIGNAL_C	10

#define NUM_WORDS_L2_ENCAP_MSG		3

#define L2_HEADER_ALREADY_EXIST_ID	0xFFFF

// start: Pt Reyes San Jose changes

//#define _PPP_L2_HEADER_SIZE		4
#define PPP_L2_HEADER_SIZE		2

// end: Pt Reyes San Jose changes

//#define _CONST_07 				0x07

// start: MPLS changes 

//#define _PPP_HEADER	 			0x21

// start: Pt Reyes San Jose changes

//#define _PPP_HEADER_IP	 		0xFF030021
#define PPP_HEADER_IP	 			0x0021

//#define _PPP_HEADER_MPLS 			0xFF030281
#define PPP_HEADER_MPLS 			0x0281

// end: Pt Reyes San Jose changes

#define NEXT_HOP_ID_MPLS			0x2000

// end: MPLS changes

#define SCRATCH_RING_FULL(N) inp_state_scr_ring##N##_full
#define PPP_ENCAP_SINK_RING_FULL(N) SCRATCH_RING_FULL(N)


/**
 *************************************************************************
 * @ingroup PppEncap
 * Receive context
 * @description
 *     This structure holds the information between microblocks passed  
 *     this microblock and it's upstream and downstream microblocks  
 *     through scratch rings
 * @see if_message_t
 ************************************************************************/
typedef __declspec(packed) struct if_message_s
{
 union
 {
  struct
  {
	dl_buf_handle_t sopBufHandle;				/* SOP buffer handle */
	dl_buf_handle_t eopBufHandle;				/* EOP buffer handle */
  	unsigned int validBit				: 1;	/* Valid bit		*/
 	unsigned int reserved00				: 15;   /* Reserved			*/
  	unsigned int queueNumber			: 16; 	/* Queue number		*/
  };
  unsigned int value[3];
 };
} if_message_t;

/*****************************************************************************
 * Abstract 
 *    Thread excution status flag
 *
 * Purpose/Intended Use:
 *    This data stucture will be used to store the thread execution staus 
 *    information.
 *****************************************************************************/
typedef struct exe_stat_flag_s
{
 union
 {
  struct
  {
    unsigned int reserved00				: 31;	/*  Reserved */
    unsigned int noValidSrcMsg			: 1;    /*  No valid source message */
  };
  unsigned int value;
 };
} exe_stat_flag_t;

/**
 *************************************************************************
 * @ingroup PppEncap
 * Receive context
 * @description
 *     This structure holds the information between microblocks passed  
 *     this microblock and it's upstream and downstream microblocks  
 *     through scratch rings
 * @see if_message_t
 ************************************************************************/
typedef __declspec(packed) struct hdr_paylo_dram_s
{
	unsigned int value[4];
} hdr_paylo_dram_t;

extern __declspec(gp_reg shared) same_me_signal_t next_thrd_1_gpr;
extern __declspec(gp_reg shared) same_me_signal_t next_thrd_2_gpr;
extern __declspec(gp_reg shared) same_me_signal_t next_thrd_3_gpr;
extern __declspec(gp_reg shared) same_me_signal_t next_thrd_4_gpr;

extern unsigned int pppHeader;
extern unsigned int scrRingSource, scrRingSink;
extern __declspec(sram_read_reg) if_message_t srcIfMessage;
extern __declspec(sram_write_reg) if_message_t sinkIfMessage;

extern __declspec(dram_read_reg) hdr_paylo_dram_t inPayload;
extern __declspec(dram_write_reg) hdr_paylo_dram_t outHdrPayload;
extern __declspec(sram_read_reg) dl_meta_t inMetaData;

extern dl_meta_t dlMeta;

extern SIGNAL sig_next_thrd_1, sig_next_thrd_2, sig_next_thrd_3, sig_next_thrd_4;
extern SIGNAL sig_sramRead; 					/*signal for sram read*/
extern SIGNAL sig_sramWrite; 					/*signal for sram write*/
extern SIGNAL_PAIR sig_dramRead; 				/*signal for dram read*/
extern SIGNAL_PAIR sig_dramWrite; 				/*signal for dram write*/
extern SIGNAL sig_scratchRead; 				/*signal for scratch ring read*/
extern SIGNAL sig_scratchWrite; 				/*signal for scratch ring write*/
extern SIGNAL sig_commonInitComplete;
extern SIGNAL_MASK sigmask_phs1Default;
extern SIGNAL_MASK sigmask_phs2Default;
extern SIGNAL_MASK sigmask_phs3Default;
extern SIGNAL_MASK sigmask_phs4Default;

extern void PppEncap_Init(void);

extern void PppEncap_InitGprs(void);
extern int PppEncap_SetSignal(int, SIGNAL *);
extern int PppEncap_ClearSignal(int, SIGNAL *);
extern int PppEncap_SetSignalPair(int, SIGNAL_PAIR *);
extern int PppEncap_ClearSignalPair(int, SIGNAL_PAIR *);

extern void PppEncap_saveSrctoSink(void);
extern void	PppEncap_ReadDram(unsigned int, unsigned int, unsigned int);
extern void PppEncap_UpdateMetaData(void);
extern void PppEncap_WritePppHeader(unsigned int, unsigned int);

#endif /* __PPP_ENCAP_H__ */
