///////////////////////////////////////////////////////////////////////
//                                                                   
//                  I N T E L   P R O P R I E T A R Y                
//                                                                   
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS  
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY   
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A 
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER 
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL, 
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT 
//     THE PRIOR WRITTEN PERMISSION OF :                             
//                                                                   
//                        INTEL  CORPORATION                         
//                                                                   
//                     2200 MISSION COLLEGE BLVD                     
//                                                                   
//               SANTA  CLARA,  CALIFORNIA  95052-8119               
//                                                                   
///////////////////////////////////////////////////////////////////////
//                                                                   
//                                                                   
//      File Name: llc_encap.uc                                         
//                                                                   
//      Description: This is the main LLC/SNAP encapsulation file.
//                   It does the following.
//                   1. Add the 8-byte LLC/SNAP header to start of
//                      packet payload.
//                   2. Update sop buffer meta-data due to 1.
//                   3. Update sop buffer cell count due to 1 and
//                      additional ATM cell consideration for 8-byte
//                      trailer.
//                   4. Compute packet cell count.
//                   5. Update vcq# for the packet if necessary.
//                   6. Optionally fetch outgoing VPI/VCI information
//                      for the packet in the sop buffer meta-data.
//                                                                                                                                 
///////////////////////////////////////////////////////////////////////
#ifndef	_LLC_ENCAP_UC_
#define	_LLC_ENCAP_UC_

//---------------------------------------------------------------------
// Preprocessor definitions.
//---------------------------------------------------------------------

// Set meta-data cache size in lw's.
#ifdef META_CACHE_SIZE
#undef META_CACHE_SIZE
#endif

#define META_CACHE_SIZE				5

// Scratch ring entry size in lw's.
#define SCR_RING_CACHE_SIZE 		3

// Defines the previous thread done signal address.
#define	PREV_THREAD_DONE_SIG_VAL	12

//---------------------------------------------------------------------
// Including needed files.
//---------------------------------------------------------------------

#include <xbuf.uc>
#include <dl_system.h>
#include <dispatch_loop.uc>
#include <llc_encap_util.uc>

//---------------------------------------------------------------------
// Signal definitions.
//---------------------------------------------------------------------

	; Define some signals.
	.sig src_ring_sig
	.sig sink_ring_sig

	.sig meta_rd_sig
	.sig meta_wr_sig

//---------------------------------------------------------------------
// Register definitions.
//---------------------------------------------------------------------

	; Holds the information needed to signal the next thread.
	.reg next_thread

	; Defines the next thread signal.
	.sig volatile prev_thread_done_sig
	.addr prev_thread_done_sig			PREV_THREAD_DONE_SIG_VAL

	; Defines incoming (source) and outgoing (sink) scratch ring numbers.
	.reg src_ring sink_ring

	; Set incoming and outgoing scratch rings.
	alu[src_ring, --, B, L2_ENCAP_RING_IN_0, <<2]
	alu[sink_ring, --, B, L2_ENCAP_RING_OUT_0, <<2]

	; Defines SCR_RING_CACHE_SIZE gpr's.

	.reg src_sink_data[SCR_RING_CACHE_SIZE]

	; Define signal mask gpr's.
	.reg default_sigmask_a
	.reg sigmask_a
	.reg default_sigmask_b
	.reg sigmask_b

	; Initialize some gpr's that store constants.
	; These gpr's save cycle in the critical path.
	.reg OxFFFF
	move(OxFFFF, 0xFFFF)

	.reg OxE003FFFF
	move(OxE003FFFF, 0xE003FFFF)

	.reg drop_queue
	move(drop_queue, QM_DROP_QUEUE)

	.reg NEXT_HOP_TABLE_BASE_SRAM_GPR
	move(NEXT_HOP_TABLE_BASE_SRAM_GPR, NEXT_HOP_TABLE_BASE_SRAM)

	; Allocate s-xfer and d-xfer registers.

	; Allocate SCR_RING_CACHE_SIZE lw's to read from the source
	; scratch ring and write to the sink scratch ring.
	xbuf_alloc($src, SCR_RING_CACHE_SIZE, read)
	xbuf_alloc($sink, SCR_RING_CACHE_SIZE, write)

	; Allocate META_CACHE_SIZE lw's to read-modify-write sop buffer
	; meta-data.
	xbuf_alloc($dl_meta, META_CACHE_SIZE, read_write)

	; Allocate a register to increment eop buffer size when additional
	; ATM cell is detected.
	.reg write $eop_buf_size_incr

	; Allocate 2 lw's to read the first qw of a non 8-byte aligned
	; start of payload
	; Allocate 4 lw's to write the 8-byte LLC/SNAP header along with
	; the first qw of the non 8-byte aligned start of payload.
	xbuf_alloc($$payload, 4, read_write)

	;-----------------------------------------------------------
	; One-time initialization phase.
	;-----------------------------------------------------------
	_llc_encap_init()

	; Wait for system initialization.
	.if(ctx()==0)
		; Thread 0 waits for the ME_INIT_SIGNAL indicating
		; completion of system initialization.
		.sig volatile system_init_done_sig
		.addr system_init_done_sig	ME_INIT_SIGNAL

		ctx_arb[system_init_done_sig]
	.else
		; Threads 1-7 wait for a prev_thread_done_sig signal.
		ctx_arb[prev_thread_done_sig]
	.endif

	signal_ctx(next_thread)

	; Read the source scratch ring.
	_llc_encap_source(src_sink_data, src_ring, src_ring_sig,
		sigmask_b, SCR_RING_CACHE_SIZE)

	;-----------------------------------------------------------
	; Recurring processing phase.
	;-----------------------------------------------------------

.while (1)

	; Signals that we could have waited on in _llc_encap_source()
	.io_completed prev_thread_done_sig
	.io_completed src_ring_sig
	.io_completed sink_ring_sig
	.io_completed meta_wr_sig
	.io_completed eop_meta_wr_sig
	.io_completed dram_wr_sig

	; Run llc encap.
	_llc_encap()

	; Write scratch ring cache contents to the sink scratch ring.
	_llc_encap_sink(src_sink_data, sink_ring, sink_ring_sig,
		sigmask_b, SCR_RING_CACHE_SIZE)

	; Read the source scratch ring for the next iteration.
	_llc_encap_source(src_sink_data, src_ring, src_ring_sig,
		sigmask_b, SCR_RING_CACHE_SIZE)

.endw

#endif // _LLC_ENCAP_UC_