///////////////////////////////////////////////////////////////////////////////
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: ethernet_encap.uc
//
//      Purpose: Ehernet layer 2 encap for Egress IXP2400
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ETHERNET_ENCAP_UC__
#define __ETHERNET_ENCAP_UC__

///////////////////////////////////////////////////////////////////////////////
// This a context pipe-stage microblock which receives tansmit request from 
// CSIX RX, add Ethernet header, then send this transmit request to Queue 
// Manager. After it get transmit request from CSIX RX, it gets next hop ID 
// from meta data, if next_hop_id = 0xFFFF, it means Ethernet header is already
// in DRAM, this microblock just send this transmit request to Queue Manager.
// If next_hop_id !=0xFFFF, it check whether there is a valid L2 table entry 
// for this next_hop_id in L2_TABLE in SRAM by the valid bit in MSB bit of this 
// L2 table entry.  If valid, it prepared Ethernet header from this L2 table 
// entry, and aligns with payload and write back to DRAM, the send this transmit 
// request to Queue Manager. If this is not a valid L2 table entry, it will issue
// an exception packet message to core component running in Xscale.  Since there 
// is no core component in simulation now, we just use this invalid L2 table 
// entry to prepare Ethernet header.  
//
// This microblock runs in four phases.
//
// Worst case instuction cycle: 97
//
/////////////////////////////////////////////////////////////////////////////////////

// Following definition enable this microblock waiting for an inter-ME signal 
// generated by the ME whcih initializes common resources, such as scratch ring,
// near the end of thread 0 of this microblockinitialization to make sure all 
// common resource are available. This option should be enabled when this POS TX 
// microblock is integrated with other egress microblocks.  
#define WAIT_FOR_COMMON_RESOURCE_INITIALIZATION 

// following definition selects IXP24000 definition in hardware.h
#define IXP2400

// following definition selects sram transfer registers to be used with 
// dl_meta.uc dispatch loop
#define DL_META_DATA_IN_SXFER
	

// include stdmac.uc in IXPblocks Portable library

#include <stdmac.uc>

// include local memory macros in IXPblocks 

#include <localmem.uc>

// definition of hardware register address 

#include <hardware.h>

// global definition of common constants which are shared by all microblocks

#include "dl_system.h"

// definition of constants used

#include "ethernet_encap.h"

// definition of utilization macros used

#include "ethernet_encap_util.uc"

// initialization code for L2_ENCAP TX

#include "ethernet_encap_init.uc"

// dispatch loop macros

#include "dispatch_loop.uc"

// following context relative GPR variables are preassigned in initialization 
// to save instrction cycles in POS TX process
.reg sig1_next_context_gpr		; value to write to SAME_ME_SIGNAL csr to wake up
								; next thread
.reg sig2_next_context_gpr		; value to write to SAME_ME_SIGNAL csr to wake up
								; next thread
.reg sig3_next_context_gpr		; value to write to SAME_ME_SIGNAL csr to wake up
								; next thread
.reg sig4_next_context_gpr		; value to write to SAME_ME_SIGNAL csr to wake up
								; next thread

.reg $l2_entry_lw0 $l2_entry_lw1 $l2_entry_lw2 $l2_entry_lw3 
.xfer_order $l2_entry_lw0 $l2_entry_lw1 $l2_entry_lw2 $l2_entry_lw3 

///////////////////////////////////////////////////////////////////////////////

//	Global Signals
.sig sig_scratch_read 				; signal for scratch ring read
.sig sig_scratch_write 				; signal for scratch ring write
// following four signals need to be declared as volatile
.sig volatile sig1_next_context		; signal to wakeup next thread, declared as
									; volatile to eliminate assembling warning
.sig volatile sig2_next_context		; signal to wakeup next thread, declared as
									; volatile to eliminate assembling warning
.sig volatile sig3_next_context		; signal to wakeup next thread, declared as
									; volatile to eliminate assembling warning
.sig volatile sig4_next_context		; signal to wakeup next thread, declared as
									; volatile to eliminate assembling warning
.sig sig_sram_read					; signal for sram read
.sig sig_sram_write					; signal for sram write
.sig sig_dram_read					; signal for sram read
.sig sig_dram_write					; signal for dram write
.sig volatile common_init_complete_sig_num		; this is the inter-ME signal 
										; generated by the ME whcih initializes
										; common resources, such as scratch ring,
										; POS TX MEs will wait for this signal at
										; end of their initialization to make 
										; sure all common resource are available 

//	Manual signal allocation
.addr common_init_complete_sig_num	ME_INIT_SIGNAL	; manual signal allocation,
													; ME_INIT_SIGNAL defined as
													; in dl_system.h  

														
///////////////////////////////////////////////////////////////////////////////
// ethernet_encap()
//
// Ethernet Layer 2 haeader encap  processing entry point for csix microblock
//
// Size:	min packet is 90 instructions
//
///////////////////////////////////////////////////////////////////////////////

#macro ethernet_encap()

.begin
.reg sig_mask_1
.reg sig_mask_2
.reg sig_mask_3
.reg sig_mask_4
.reg sigmask1_default 		; default value for signal mask for phase 1
.reg sigmask2_default 		; default value for signal mask for phase 2
.reg sigmask3_default 		; default value for signal mask for phase 3
.reg sigmask4_default 		; default value for signal mask for phase 4
.reg src_ring
.reg sink_ring
.reg exe_stat_flag	
.reg id_l2_header_exist
.reg l2_table_base
.reg volatile offset dram_addr
.reg volitile buf_size 

													
.reg $source_lw0 $source_lw1 $source_lw2
.xfer_order $source_lw0 $source_lw1 $source_lw2

.reg $sink_lw0 $sink_lw1 $sink_lw2
.xfer_order $sink_lw0 $sink_lw1 $sink_lw2

.reg $$dram_lw0 $$dram_lw1  $$dram_lw2  $$dram_lw3  $$dram_lw4  $$dram_lw5
.xfer_order $$dram_lw0 $$dram_lw1  $$dram_lw2  $$dram_lw3  $$dram_lw4  $$dram_lw5

.reg $dl_meta0 $dl_meta1 $dl_meta2 $dl_meta3 $dl_meta4
.xfer_order $dl_meta0 $dl_meta1 $dl_meta2 $dl_meta3 $dl_meta4
	
	// For the initial run let the assembler think the meta data is loaded 

	_ethernet_encap_init_gprs(src_ring, sink_ring, sigmask1_default, \
		sigmask2_default, sigmask3_default, sigmask4_default, \
		id_l2_header_exist, l2_table_base)

	// get initial ethernet_encap source 
	_ethernet_encap_source(src_ring, sig_scratch_read)	
	ctx_arb[sig_scratch_read]

	// The first time through the loop, wait for next thread signal only 
	ctx_arb[sig1_next_context]

	// set sig_mask_1 to sigmask1_default for phase 1 
	alu[sig_mask_1, --, B, sigmask1_default]


phase1#:

	// At this point the meta data i/o is finished and the signals for dram and
	// sram have been received. let the assembler know

	// wake up next thread in the very beginning of phase 2 to reduce wakeup 
	// latency (1)
	_ethernet_encap_signal_next[sig1_next_context_gpr]

	alu[exe_stat_flag, --, B, 0]		; reset exe_stat_flag

	// check for a null ethernet_encap source message
	alu[--, $source_lw0, -, 0x0]
	beq[no_valid_ethernet_encap_source_in_phase_1#]

	// get meta data by dl_meta_load_cache (3)
	dl_meta_load_cache($source_lw0, $dl_meta, sig_sram_read, 0, 5)

	// wait for sram read to finish and signal from next thread (4)
end_of_phase_1#:
	local_csr_wr[active_ctx_wakeup_events, sig_mask_1]		
	ctx_arb[--], defer[1] 
		// set sig_mask_2 to sigmask2_default for phase 2 
		alu[sig_mask_2, --, B, sigmask2_default]
	
	.io_completed sig2_next_context sig_sram_read

phase2#:
.begin 
//.reg buf_size pkt_size 
.reg pkt_size 

	.set $dl_meta0 $dl_meta1 $dl_meta2 $dl_meta3 $dl_meta4
.begin 
.reg l2_entry_addr
	// wake up next thread in the very beginning of phase 2 to reduce wakeup 
	// latency (1)
	_ethernet_encap_signal_next[sig2_next_context_gpr]


	br_bset[exe_stat_flag, _NO_VALID_SOURCE_MSG_BIT, \
					no_valid_ethernet_encap_source_in_phase_2#]

.begin
.reg nexthop nexthopid
 	// get next_hop_id
//	dl_meta_get_nexthop_id(nexthopid)
	ld_field_w_clr[nexthop, 0011, $dl_meta4, >>16]
	alu[--, nexthop, -, id_l2_header_exist]
	beq[ethernet_l2_header_exist_in_pahse2#]

	alu_shf[l2_entry_addr, --, B, nexthop, <<_L2_TABLE_ENTRY_SHFT]
	sram[read, $l2_entry_lw0, l2_table_base, l2_entry_addr, 4],\
								 sig_done[sig_sram_read]
	// read 8 bytes payload
	dl_meta_get_offset(offset)

	// get 8 bytes data from dram (4)
	_ethernet_encap_read_dram($$dram_lw0, dram_addr, $source_lw0, offset, 1, \
						sig_dram_read)
.end // nexthop nexthopid

	// wait for sram read and dram read to finishand signal from next thread (4)
end_of_phase_2#:
	local_csr_wr[active_ctx_wakeup_events, sig_mask_2]		
	ctx_arb[--], defer[2]
		// set sig_mask to sigmask3_default for phase 3 
		alu[sig_mask_3, --, B, sigmask3_default]
		// get buffer size
		dl_meta_get_buffer_size(buf_size)

	.io_completed sig3_next_context sig_sram_read sig_dram_read sig_scratch_write
.end // l2_entry_address

phase3#:
	// wake up next thread in the very beginning of phase 3 to reduce wakeup 
	// latency (1)
	_ethernet_encap_signal_next[sig3_next_context_gpr]


	.set $source_lw0 $source_lw1 $source_lw2
	.set $$dram_lw0 $$dram_lw1  $$dram_lw2  $$dram_lw3  $$dram_lw4  $$dram_lw5
	.set $l2_entry_lw0 $l2_entry_lw1 $l2_entry_lw2 $l2_entry_lw3 


	br_bset[exe_stat_flag, _NO_VALID_SOURCE_MSG_BIT, \
					no_valid_ethernet_encap_source_in_phase_3#]

	// if not valid L2 table entry, send core componenyt in XSCALE a exception 
	// request, since there still no component yet
	br_bclr[$l2_entry_lw0, _L2_TABLE_VALID_BIT, exception_to_core_in_phase3#] 

no_core_component_continue#:
//	dl_meta_get_buffer_size(buf_size)
	dl_meta_get_packet_size(pkt_size)

	// realign and write Ethernet L2 header back to dram (26)
	_ethernet_encap_write_ethernet_header(dram_addr, offset, \
				sig_dram_write)

	alu[offset, offset, -, _ETHERNET_L2_HEADER_SIZE]
	alu[buf_size, buf_size, +, _ETHERNET_L2_HEADER_SIZE]
	alu[pkt_size, pkt_size, +, _ETHERNET_L2_HEADER_SIZE]

	// update meta data (8)
	_ethernet_encap_update_meta_data($source_lw0, offset, buf_size, pkt_size, \
				sig_sram_write)


end_of_phase_3#:
	local_csr_wr[active_ctx_wakeup_events, sig_mask_3]		
	ctx_arb[--], defer[2]
		// set sig_mask_4 to sigmask4_default for phase 4 
		alu[sig_mask_4, --, B, sigmask4_default]
		// set sig_mask_1 to sigmask1_default for phase 1 
		alu[sig_mask_1, --, B, sigmask1_default]
	.io_completed sig4_next_context sig_sram_write sig_dram_write sig_sram_read
.end // offset buf_size pkt_size dram_addr 

phase4#:
	// wake up next thread in the very beginning of phase 4 to reduce wakeup 
	// latency (1)
	_ethernet_encap_signal_next[sig4_next_context_gpr]

	// save $source to $sink before reading another source (3)
	_ethernet_encap_save_to_sink()

	// get ethernet_encap source message for next run	(1)
	_ethernet_encap_source(src_ring, sig_scratch_read)	


	br_bset[exe_stat_flag, _NO_VALID_SOURCE_MSG_BIT, \
					no_valid_ethernet_encap_source_in_phase_4#]

	// write ethernet_encap sink message out (2)
	_ethernet_encap_sink(sink_ring, sig_scratch_write)

end_of_phase_4#:
	local_csr_wr[active_ctx_wakeup_events, sig_mask_4]
	.io_completed sig1_next_context sig_scratch_read sig_scratch_write
	ctx_arb[--] , br[phase1#]
			
no_valid_ethernet_encap_source_in_phase_1#:
	_ethernet_encap_clear_signal[sig_mask_1, sig_sram_read]			; clear sig_sram_read
	alu_shf[exe_stat_flag, exe_stat_flag, OR, 1, <<_NO_VALID_SOURCE_MSG_BIT]
	br[end_of_phase_1#]

no_valid_ethernet_encap_source_in_phase_2#:
	_ethernet_encap_clear_signal[sig_mask_2, sig_sram_read]			; clear sig_sram_read
	_ethernet_encap_clear_signal[sig_mask_2, sig_dram_read]			; clear sig_dram_read
	_ethernet_encap_clear_push_signal[sig_mask_2, sig_dram_read]	; clear push signal
	br[end_of_phase_2#]

ethernet_l2_header_exist_in_pahse2#:
	// save $source to $sink before reading another source (3)
	_ethernet_encap_save_to_sink()
	// write ethernet_encap sink message out (2)
	_ethernet_encap_sink(sink_ring, sig_scratch_write)
	_ethernet_encap_set_signal[sig_mask_2, sig_scratch_write]	; add sig_scratch_write 
	alu_shf[exe_stat_flag, exe_stat_flag, OR, 1, <<_NO_VALID_SOURCE_MSG_BIT]
	// after sending request message to QM, acted as no valid request
	br[no_valid_ethernet_encap_source_in_phase_2#]

no_valid_ethernet_encap_source_in_phase_3#:
	_ethernet_encap_clear_signal[sig_mask_3, sig_sram_write]		; clear sig_sram_write
	_ethernet_encap_clear_signal[sig_mask_3, sig_dram_write]		; clear sig_dram_write
	_ethernet_encap_clear_push_signal[sig_mask_3, sig_dram_write]	; clear push signal
	br[end_of_phase_3#]

no_valid_ethernet_encap_source_in_phase_4#:
	_ethernet_encap_clear_signal[sig_mask_4, sig_scratch_write]		; clear sig_scratch_write
	br[end_of_phase_4#]

exception_to_core_in_phase3#:
//  issue exception message to core component
//	_ethernet_encap_clear_signal[sig_mask_3, sig_sram_write]		; clear sig_sram_write
//	_ethernet_encap_clear_signal[sig_mask_3, sig_dram_write]		; clear sig_dram_write
//	_ethernet_encap_clear_push_signal[sig_mask_3, sig_dram_write]	; clear push signal
//	alu_shf[exe_stat_flag, exe_stat_flag, OR, 1, <<_NO_VALID_SOURCE_MSG_BIT]
//	br[end_of_phase_3#]
	br[no_core_component_continue#]


.end

#endm // end of #macro ethernet_encap()


///////////////////////////////////////////////////////////////////////////////

// The main code starts here

main#:

	// initialize the microblock

	ethernet_encap_init()

	// call the packet processing block

	ethernet_encap()

///////////////////////////////////////////////////////////////////////////////

#endif 		// __ETHERNET_ENCAP_UC__

///////////////////////////////////////////////////////////////////////////////


      

