///////////////////////////////////////////////////////////////////////////////
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: ethernet_bmk_encap.uc
//
//      Purpose: Ehernet layer 2 encap for Benchmark application
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ETHERNET_BMK_ENCAP_UC__
#define __ETHERNET_BMK_ENCAP_UC__

///////////////////////////////////////////////////////////////////////////////
// This is Ethernet Banchmark project encap module.
// This module will get the destination MAC address, source MAC address from
// L2 and the Frame type from a L2 table.  Using these parameters, this module 
// will update the Ethernet header.  The Ethernet headers is CACHED in the 
// transfer regitsers. 
/////////////////////////////////////////////////////////////////////////////////////

// include xbuf.uc from IXPblocks portable library
#include	"ether_bmk_encap.h"

.reg l2_table_base
.reg bmk_scr_ring_base

///////////////////////////////////////////////////////////////////////////////
// _ethernet_bmk_encap()
//
//	 	Description: 
// 			Ethernet Layer 2 haeader encap initialization
//
//	 	Outputs:
//			l2_table_base	:	L2 table base
//
//		Inputs:
//			
//			ether_buf		:	Ethernet header buffer 
//			l2_table_base	:	The l2 look up table
//			dl_next_block	:	The next processing block ID, this is a globle 
//								gpr
//		Size: 
//
//			instructions at a minimum. (max depends on the loop)
//
//		Note:
//			This macro will run with IPv4 block because it uses cached 
//			nexthop_id and Ethernet header. 
///////////////////////////////////////////////////////////////////////////////

#macro _ethernet_bmk_encap_init()

.begin

	// Set up the L2 encap table base

	move(l2_table_base, L2_TABLE_SRAM_BASE)

.end
#endm



///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _ethernet_bmk_encap_wr_scr_ring
// Description : Macro to write messages to the corresponding scratch ring.
//				 This micro will chekc the ring status.  If the ring
//				 is full, the macro will do a busy wait until ring is not full.
// Output      : 
// Input       : in_num, in_message
// Size        : 2
// Branches    : 1
///////////////////////////////////////////////////////////////////////////////
#macro _ethernet_bmk_encap_wr_scr_ring(in_num, in_message, sig_scr)

.begin
.reg tmp, ring

		//	Get output port number

		dl_meta_get_output_port[tmp]
		
		// Compute offset for the jump table
		// and then jump to the corresponding processing

		alu[tmp, --, b, tmp, <<2]
		jump[tmp, tbl_0#], targets[tbl_0#,tbl_1#,tbl_2#,tbl_3#]
		

tbl_0#:
		// Wait for scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_0/**/_Full, tbl_0#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_0, <<2]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		

		br[tbl_done#]
tbl_1#:
		// Wait scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_1/**/_Full, tbl_1#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_1, <<2 ]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		

		br[tbl_done#]

tbl_2#:
		// Wait for scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_2/**/_Full, tbl_2#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_2, <<2 ]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		
		br[tbl_done#]

tbl_3#:
		// Wait for scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_3/**/_Full, tbl_3#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_3, <<2 ]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		
	
tbl_done#:

.end

#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _ethernet_bmk_encap_wr_scr_ring_drct
// Description : Macro to write messages to the corresponding scratch ring.
//				 directly from input RX to the out put TX.
//				 This micro will chekc the ring status.  If the ring
//				 is full, the macro will do a busy wait until ring is not full.
// Output      : 
// Input       : in_num, in_message
// Size        : 2
// Branches    : 1
///////////////////////////////////////////////////////////////////////////////
#macro _ethernet_bmk_encap_wr_scr_ring_drct(in_num, in_message, sig_scr)

.begin
.reg tmp, ring

		//	Get output port number

		dl_meta_get_input_port[tmp]
		
		// Compute offset for the jump table
		// and then jump to the corresponding processing

		alu[tmp, --, b, tmp, <<2]
		jump[tmp, tbl_0#], targets[tbl_0#,tbl_1#,tbl_2#,tbl_3#]
		

tbl_0#:
		// Wait for scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_0/**/_Full, tbl_0#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_0, <<2]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		

		br[tbl_done#]
tbl_1#:
		// Wait scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_1/**/_Full, tbl_1#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_1, <<2 ]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		

		br[tbl_done#]

tbl_2#:
		// Wait for scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_2/**/_Full, tbl_2#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_2, <<2 ]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		
		br[tbl_done#]

tbl_3#:
		// Wait for scratch ring not full

		br_inp_state[SCR_Ring/**/IPV4_TO_PACKET_TX_SCR_RING_3/**/_Full, tbl_3#]

		// Get scratch ring number

		alu[ring, --, b, IPV4_TO_PACKET_TX_SCR_RING_3, <<2 ]

		// Write to the scratch ring

		scratch[put, in_message, 0, ring, in_num], sig_done[sig_scr]		
	
tbl_done#:

.end

#endm

///////////////////////////////////////////////////////////////////////////////
// _ethernet_bmk_encap()
//
//	 	Description: 
// 			Ethernet Layer 2 haeader encap  processing entry point 
//			for Benchmark project
//
//	 	Outputs:
//			ether_buf		:	Ethernet header buffer
//
//		Inputs:
//			
//			ether_buf		:	Ethernet header buffer 
//			l2_table_base	:	The l2 look up table
//			dl_next_block	:	The next processing block ID, this is a globle 
//								gpr
//		Size: 
//
//			instructions at a minimum. (max depends on the loop)
//
//		Note:
//			This macro will run with IPv4 block because it uses cached 
//			nexthop_id and Ethernet header. 
///////////////////////////////////////////////////////////////////////////////

#macro _ethernet_bmk_encap(ether_buf)

.begin

// Declare transfer registers used to read the four Long wards from SRAM

//.reg $l2_lw0 $l2_lw1 $l2_lw2 $l2_lw3
//.xfer_order $l2_lw0 $l2_lw1 $l2_lw2 $l2_lw3

.reg l2_table_addr 
.reg nexthop_id
.reg tmp

.sig sram_l2_table_rd

	// First, check if the packet is a valid packet

	alu[--, dl_next_block, -, IPV4_NEXT1]
	br!=0[ethernet_bmk_encap_done#]

	xbuf_alloc($l2_lw, 4, read)	

	// Get nex hop ID from the cached meta data, IPv4 write this one to the 
	// Meta cache. 
	// Compute L2 table entry address using the next hop ID

	dl_meta_get_nexthop_id[nexthop_id]
	alu[l2_table_addr, --, b, nexthop_id, <<5]
	alu[l2_table_addr, l2_table_addr, +, l2_table_base]

	// Read the corresponding L2 table entry

	sram[read, $l2_lw0, l2_table_addr, 0, 4],
		ctx_swap[sram_l2_table_rd]

	// Check if the entry is valid.  If valid continue.
	// If not, set dl_nextblock to the exception

	br_bclr[$l2_lw0, L2_TABLE_VALID_BIT, ethernet_bmk_encap_err#]
	 
	// Write the new MAC addresses from L2 table to the ethernet
	// header buffer

	xbuf_copy(ether_buf,tmp, 0, $l2_lw, 1, 0, 14, 0)	; write total 14 bytes

	br[ethernet_bmk_encap_done#]

ethernet_bmk_encap_err#:
	immed[dl_next_block,IX_EXCEPTION]

ethernet_bmk_encap_done#:
.end

	xbuf_free($l2_lw)	
#endm // end of #macro _ethernet_bmk_encap()

#endif __ETHERNET_BMK_ENCAP_UC__