/////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//
/////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: ethernet_arp_init.uc
//
//      Purpose: Initialization code for L2_ENCAP microblock
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __ETHERNET_ARP_INIT_UC__
#define __ETHERNET_ARP_INIT_UC__

///////////////////////////////////////////////////////////////////////////////
// _ethernet_arp_thread_specific_init()
//
// Description: initialize context relative GPRs for specific thread to save 
//              instruction cycles in POS TX processing
//
// Outputs: 
//      out_next_ctx_sig1:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 1
//      out_next_ctx_sig2:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 2
//      out_next_ctx_sig3:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 3
//      out_next_ctx_sig4:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 4
//
// Inputs:  
//		in_next_thread:		next thread number of this thread 
//
// Constants:
//		none
//
///////////////////////////////////////////////////////////////////////////////
#macro _ethernet_arp_thread_specific_init(out_next_ctx_sig1, out_next_ctx_sig2, \
				out_next_ctx_sig3, in_next_thread) 
.begin 
.reg next_context
	// value to write to SAME_ME_SIGNAL csr to wake up next thread
	// will differs for each thread
	move[next_context,in_next_thread]
	alu_shf[out_next_ctx_sig1, next_context, or, &sig1_next_context, <<3]
	alu_shf[out_next_ctx_sig2, next_context, or, &sig2_next_context, <<3]
	alu_shf[out_next_ctx_sig3, next_context, or, &sig3_next_context, <<3]

.end  // end for local variable next_context

#endm //end of macro _ethernet_arp_thread_specific_init()


/////////////////////////////////////////////////////////////////////////////////////
// 
// ethernet_arp_init()
//
// Description:
// 	
//		Initialization of the microblock
//
// Outputs: 
//		none
//
// Inputs:  
//		non
//		
// Constants
//		none
//
/////////////////////////////////////////////////////////////////////////////////////

#macro ethernet_arp_init()

//--------------------------------------------------------------
	br=ctx[0, ctx0_init#]
    br=ctx[1, ctx1_init#]
    br=ctx[2, ctx2_init#]
    br=ctx[3, ctx3_init#]
    br=ctx[4, ctx4_init#]
    br=ctx[5, ctx5_init#]
    br=ctx[6, ctx6_init#]
    br=ctx[7, ctx7_init#]

// general ME and global GPRs initializtion and thread 0 context relative
// variables initialization
ctx0_init#:


	// For kick start thread 0 will send itself 1 initial signals for 
	// phase 1
.begin //begin of local variable sig
.reg sig
    alu[sig, --, B,  &sig1_next_context]
    alu_shf[sig, 0x0, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

 	alu[sig, --, B,  &sig2_next_context]
    alu_shf[sig, 0x0, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

	alu[sig, --, B,  &sig3_next_context]
    alu_shf[sig, 0x0, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

.end // sig
	
	// thread 0 context relative GPR variables initialization
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 1)


#ifdef WAIT_FOR_COMMON_RESOURCE_INITIALIZATION 
	ctx_arb[common_init_complete_sig_num]
#endif //#ifdef WAIT_FOR_COMMON_RESOURCE_INITIALIZATION
	br[ethernet_arp_init_done#]

	
ctx1_init#:
	// For kick start thread 0 will send itself 3 initial signals for 
	// phase 2, 3, and 4 

.begin //begin of local variable sig
.reg sig
 	alu[sig, --, B,  &sig2_next_context]
    alu_shf[sig, 0x1, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

	alu[sig, --, B,  &sig3_next_context]
    alu_shf[sig, 0x1, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

.end // sig

	// thread 1 context relative GPR variables initialization
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 2)
	br[ethernet_arp_init_done#]

ctx2_init#:
	// thread 2 context relative GPR variables initialization
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 3)
	br[ethernet_arp_init_done#]

	// thread 3 context relative GPR variables initialization
ctx3_init#:
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 4)
	br[ethernet_arp_init_done#]

	// thread 4 context relative GPR variables initialization
ctx4_init#:
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 5)
	br[ethernet_arp_init_done#]

	// thread 5 context relative GPR variables initialization
ctx5_init#:
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 6)
	br[ethernet_arp_init_done#]


	// thread 6 context relative GPR variables initialization
ctx6_init#:
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 7)
	br[ethernet_arp_init_done#]


	// thread 7 context relative GPR variables initialization
ctx7_init#:
//	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
//		sig3_next_context_gpr, 0)
	// thread 0 handle exception from core, so wakeup thread 1
	_ethernet_arp_thread_specific_init(sig1_next_context_gpr, sig2_next_context_gpr, \
		sig3_next_context_gpr, 1)



ethernet_arp_init_done#:

#endm  // ethernet_arp_init[]



/////////////////////////////////////////////////////////////////////////////////////

#endif 		//  __ETHERNET_ARP_INIT_UC__

/////////////////////////////////////////////////////////////////////////////////////
