/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_eth_tx.h
 *
 * = DESCRIPTION
 *      This file will describe the common definitions that will be exported
 *      by the Ethernet Tx Core Component.
 *
 * = CHANGE HISTORY
 *      11/21/2002 - Created.
 *
 * ============================================================================
 * $Id: ix_cc_eth_tx.h,v 1.42 2003/11/13 18:31:26 ktseng Exp $
 */

#if !defined(__IX_CC_ETH_TX_H__)
#define __IX_CC_ETH_TX_H__



/**
 * System defined include files required.
 */
#include "ix_types.h"
#include "ix_error.h"
#include "ix_cc.h"

#ifndef IX_EXCLUDE_CCI
#include "ix_cci.h"
#endif

#include "cc/ix_cc_arp.h"


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


/* defines for driver modes (bit 2:0) */
#define IX_CC_ETH_TX_DRIVER_MODE_FIBER               0x0
#define IX_CC_ETH_TX_DRIVER_MODE_GIGA_HALF_DUPLEX    0x1
#define IX_CC_ETH_TX_DRIVER_MODE_GIGA_FULL_DUPLEX    0x2
#define IX_CC_ETH_TX_DRIVER_MODE_100_HALF_DUPLEX     0x3
#define IX_CC_ETH_TX_DRIVER_MODE_100_FULL_DUPLEX     0x4
#define IX_CC_ETH_TX_DRIVER_MODE_10_HALF_DUPLEX      0x5
#define IX_CC_ETH_TX_DRIVER_MODE_10_FULL_DUPLEX      0x6

#if (defined IX_PLATFORM_2401) || (defined IX_PLATFORM_2801)
#ifdef USE_HW_CONFIG
#define IX_CC_ETH_TX_DRIVER_MODE_AUTO_NEGOTIATION    0x7
#endif /* USE_HW_CONFIG */
#endif /* IX_PLATFORM_2x01 */

#ifdef ETH_TX_MODE_FIBER
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_FIBER
#elif ETH_TX_MODE_GIGA_HALF_DUPLEX
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_GIGA_HALF_DUPLEX
#elif  ETH_TX_MODE_GIGA_FULL_DUPLEX
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_GIGA_FULL_DUPLEX
#elif  ETH_TX_MODE_100_HALF_DUPLEX
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_100_HALF_DUPLEX
#elif  ETH_TX_MODE_100_FULL_DUPLEX
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_100_FULL_DUPLEX
#elif  ETH_TX_MODE_10_HALF_DUPLEX
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_10_HALF_DUPLEX
#elif  ETH_TX_MODE_10_FULL_DUPLEX
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_10_FULL_DUPLEX
#else
#define DEFAULT_ETH_TX_MODE      IX_CC_ETH_TX_DRIVER_MODE_FIBER
#endif


/* defines for driver parity (bit 3) */
#define IX_CC_ETH_TX_DRIVER_MODE_PARITY_ODD          0x0
#define IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN         0x8

#ifdef ETH_TX_PARITY_ODD
#define DEFAULT_PARITY         IX_CC_ETH_TX_DRIVER_MODE_PARITY_ODD
#elif ETH_TX_PARITY_EVEN
#define DEFAULT_PARITY         IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN
#else
#define DEFAULT_PARITY         IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN
#endif


/* defines for driver block modes (bit 4) */
#define IX_CC_ETH_TX_DRIVER_MODE_BLOCK_MPHY          0x00
#define IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8           0x10

#ifdef ETH_TX_MODE_MPHY
#define DEFAULT_MODE_BLOCK         IX_CC_ETH_TX_DRIVER_MODE_BLOCK_MPHY
#elif ETH_TX_MODE_4_8
#define DEFAULT_MODE_BLOCK         IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8
#else
#define DEFAULT_MODE_BLOCK         IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8
#endif

#if (defined IX_PLATFORM_2401) || (defined IX_PLATFORM_2801)
#ifdef USE_HW_CONFIG
#define IX_CC_ETH_TX_DRIVER_MODE_FIB      (IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8 | IX_CC_ETH_TX_DRIVER_MODE_FIBER | IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN)
#define IX_CC_ETH_TX_DRIVER_MODE_COP_AUTO (IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8 | IX_CC_ETH_TX_DRIVER_MODE_AUTO_NEGOTIATION | IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN)
#define IX_CC_ETH_TX_DRIVER_MODE_COP      (IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8 | IX_CC_ETH_TX_DRIVER_MODE_GIGA_FULL_DUPLEX | IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN)
#endif /* USE_HW_CONFIG */
#endif /* IX_PLATFORM_2x01 */

#define IX_CC_ETH_TX_DRIVER_MODE_DEFAULT (DEFAULT_MODE_BLOCK | DEFAULT_ETH_TX_MODE | DEFAULT_PARITY)

#define IX_CC_ETH_TX_FRAME_SIZE  0x23FC /* 9216 - 4 */


#define IX_CC_ETH_TX_DRIVER_PORT_MASK_01   0x3
#define IX_CC_ETH_TX_DRIVER_PORT_MASK_23   0xc

#ifdef ETH_TX_DRIVER_PORT_MASK_01
#define IX_CC_ETH_TX_DRIVER_PORT_MASK IX_CC_ETH_TX_DRIVER_PORT_MASK_01
#elif ETH_TX_DRIVER_PORT_MASK_23
#define IX_CC_ETH_TX_DRIVER_PORT_MASK IX_CC_ETH_TX_DRIVER_PORT_MASK_23
#else
#define IX_CC_ETH_TX_DRIVER_PORT_MASK 0xF
#endif

#ifdef IX_PLATFORM_2800

/* IXF1110 media device physical base address and size */
#define IXF1110_BASE_ADDRESS        0xC6000000
#define IXF1110_SIZE                (0x100000 * 8)   /* 8M bytes */

#endif /* IX_PLATFORM_2800 */

/**
 * The following defines static configuration data.
 * Ethernet Tx uses the #define values when system repository is not included
 * in the system.
 */
#ifdef IX_INCLUDE_REGISTRY

#define IX_CC_ETH_TX_PROP_MEV2_NUM_MASK "ETH_TX/ETH_TX_MEV2_NUM_MASK"

#endif /* IX_INCLUDE_REGISTRY */

#ifdef IX_PLATFORM_2800
#define IX_CC_ETH_TX_MEV2_NUM_MASK      0x308 /* ME3, ME8 and ME9*/
#else /* IX_PLATFORM_2800 */
#define IX_CC_ETH_TX_MEV2_NUM_MASK      0x00000070 /* default ME4, ME5 and ME6*/
#endif /* IX_PLATFORM_2800 */





/**
 * The following defines the symbols to be patched into the microblock.
 */
#ifdef MICROBLOCK_COUNTERS
#define IX_CC_ETH_TX_NUM_SYMBOLS_PATCHED        2
#else
#define IX_CC_ETH_TX_NUM_SYMBOLS_PATCHED        1
#endif

#define IX_CC_ETH_TX_SYMBOL_COUNTERS_BASE       "PACKET_TX_COUNTER_BASE"
#define IX_CC_ETH_TX_SYMBOL_L2_TABLE_BASE       "L2_TABLE_SRAM_BASE"



/**
 * Various definitions for maximum number of ports, SRAM channel
 * number for the context memory, ME number.
 */
#if defined(IX_PLATFORM_2401) || defined(IX_PLATFORM_2801)

#ifdef ETH_TX_MAX_NUM_PORTS
#define IX_CC_ETH_TX_MAX_NUM_PORTS         ETH_TX_MAX_NUM_PORTS /* max. number of Ethernet ports */
#else /* ETH_TX_MAX_NUM_PORTS */

#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)

#if (_IX_BOARD_TYPE_ == _IX_IXDP2801_)
#define IX_CC_ETH_TX_MAX_NUM_PORTS         12
#else /* _IX_BOARD_TYPE_ == _IX_IXDP2801_ */
#define IX_CC_ETH_TX_MAX_NUM_PORTS         10
#endif /* _IX_BOARD_TYPE_ == _IX_IXDP2801_ */

#elif (_IX_HARDWARE_TYPE_ == _IX_HW_2400_)

#if (_IX_BOARD_TYPE_ == _IX_IXDP2401_)
#define IX_CC_ETH_TX_MAX_NUM_PORTS         12
#else /* _IX_BOARD_TYPE_ == _IX_IXDP2401_ */
#define IX_CC_ETH_TX_MAX_NUM_PORTS         4
#endif /* _IX_BOARD_TYPE_ == _IX_IXDP2801_ */

#else /* _IX_HARDWARE_TYPE_ == _IX_HW_2400_ */
#error Hardware type undefined
#endif /* _IX_HARDWARE_TYPE_ == _IX_HW_2400_ */

#endif /* ETH_TX_MAX_NUM_PORTS */


#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
#define IX_CC_ETH_TX_MAX_ME_NUM            16  /* max. number of MEv2 */
#elif (_IX_HARDWARE_TYPE_ == _IX_HW_2400_)
#define IX_CC_ETH_TX_MAX_ME_NUM            8  /* max. number of MEv2 */
#else /* _IX_HARDWARE_TYPE_ == _IX_HW_2400_ */
#error Hardware type undefined
#endif /* (_IX_HARDWARE_TYPE_ == _IX_HW_2400_) */


#if (_IX_BOARD_TYPE_ == _IX_IXDP2801_)
#define IX_CC_ETH_TX_DEFAULT_SRAM_CH_NUM   1  /* SRAM channel number */
#else
#define IX_CC_ETH_TX_DEFAULT_SRAM_CH_NUM   0  /* SRAM channel number */
#endif /* _IX_BOARD_TYPE_ == _IX_IXDP2801_ */


#else /* defined(IX_PLATFORM_2401) || defined(IX_PLATFORM_2801) */

#ifdef ETH_TX_MAX_NUM_PORTS
#define IX_CC_ETH_TX_MAX_NUM_PORTS         ETH_TX_MAX_NUM_PORTS /* max. number of Ethernet ports */
#else

#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
#define IX_CC_ETH_TX_MAX_NUM_PORTS         10
#define IX_CC_ETH_TX_MAX_ME_NUM            16  /* max. number of MEv2 */
#else
#define IX_CC_ETH_TX_MAX_NUM_PORTS         4
#define IX_CC_ETH_TX_MAX_ME_NUM            8  /* max. number of MEv2 */
#endif /* (_IX_HARDWARE_TYPE_ == _IX_HW_2400_) */

#endif

#define IX_CC_ETH_TX_DEFAULT_SRAM_CH_NUM   0  /* SRAM channel number */ 

#endif /* defined(IX_PLATFORM_2401) || defined(IX_PLATFORM_2801) */

/**
 * Ethernet Tx error codes. 
 */
enum ix_cc_eth_tx_error {
    IX_CC_ETH_TX_ERROR_USER_CB = IX_ERROR_MAKE_GROUP(CC_ETH_TX),
    IX_CC_ETH_TX_ERROR_REG_HDLR, 
    IX_CC_ETH_TX_ERROR_REM_HDLR, 
    IX_CC_ETH_TX_ERROR_RM_PATCH_SYMBOL, 
    IX_CC_ETH_TX_ERROR_RM_FREE_MEM, 
    IX_CC_ETH_TX_ERROR_RM_FREE_BUF,
    IX_CC_ETH_TX_ERROR_RM_DELETE_64BIT_COUNTER,
    IX_CC_ETH_TX_ERROR_RM_GET_64BIT_COUNTER,
    IX_CC_ETH_TX_ERROR_RM_GET_DATA,
    IX_CC_ETH_TX_ERROR_RM_GET_PHYS_OFFSET,
    IX_CC_ETH_TX_ERROR_MSUP_SEND_REPLY,
    IX_CC_ETH_TX_ERROR_MSUP_SEND_MSG, 
    IX_CC_ETH_TX_ERROR_INVALID_BLADE_ID,
    IX_CC_ETH_TX_ERROR_INVALID_HANDLE,
    IX_CC_ETH_TX_ERROR_INVALID_PKT_TYPE,
    IX_CC_ETH_TX_ERROR_INVALID_IF_STATE,
    IX_CC_ETH_TX_ERROR_OSSL_MUTEX_INIT,
    IX_CC_ETH_TX_ERROR_OSSL_MUTEX_FINI,
    IX_CC_ETH_TX_ERROR_OSSL_MUTEX_LOCK,
    IX_CC_ETH_TX_ERROR_MEDIA_INIT,
    IX_CC_ETH_TX_ERROR_MEDIA_FINI,
    IX_CC_ETH_TX_ERROR_MEDIA_IOCTL,
    IX_CC_ETH_TX_ERROR_MEDIA_GET,
    IX_CC_ETH_TX_ERROR_MEDIA_SET,
    IX_CC_ETH_TX_ERROR_MEDIA_RESET,
    IX_CC_ETH_TX_ERROR_ARP_INIT,
    IX_CC_ETH_TX_ERROR_ARP_FINI,
    IX_CC_ETH_TX_ERROR_L2TM_INIT,
    IX_CC_ETH_TX_ERROR_L2TM_FINI,
    IX_CC_ETH_TX_ERROR_L2TM_GET_SYMBOL
};



/**
 * defines for message types
 */
typedef enum ix_e_cc_eth_tx_msg_type
{
    IX_CC_ETH_TX_MSG_GET_STATISTICS_INFO = IX_CC_ETH_RX_MSG_LAST,
    IX_CC_ETH_TX_MSG_GET_INTERFACE_STATE,
    IX_CC_ETH_TX_MSG_CREATE_ARP_ENTRY,
    IX_CC_ETH_TX_MSG_ADD_ARP_ENTRY,
    IX_CC_ETH_TX_MSG_DEL_ARP_ENTRY,
    IX_CC_ETH_TX_MSG_PURGE_ARP_CACHE,
    IX_CC_ETH_TX_MSG_DUMP_ARP_CACHE,
} ix_cc_eth_tx_msg_type;



/**
 * defines for statistics counters
 */
#ifdef MICROBLOCK_COUNTERS

#define IX_CC_ETH_TX_NUM_UBLK_COUNTERS_PER_PORT         4

#endif /* MICROBLOCK_COUNTERS */

#define IX_CC_ETH_TX_NUM_DRIVER_COUNTERS_PER_PORT       25
#define IX_CC_ETH_RX_NUM_DRIVER_COUNTERS_PER_PORT       25

typedef enum ix_e_cc_eth_tx_statistics_info
{
    IX_CC_ETH_TX_COUNTER_FIRST = IX_CC_ETH_RX_COUNTER_LAST, /* Start of Ethernet Tx counter */

#ifdef MICROBLOCK_COUNTERS

    /**
     * Per port Ethernet Tx microblock counters. The order of the
     * counters is defined by microblock code and must not be 
     * altered here. 
     */
    IX_CC_ETH_TX_PACKETS,           /* Tx packet count */
    IX_CC_ETH_TX_DROP_PACKETS,      /* Tx drop packet count */
    IX_CC_ETH_TX_BYTES,             /* Tx byte count */
    IX_CC_ETH_TX_DROP_BYTES,        /* Tx drop byte count */

    IX_CC_ETH_TX_ALL_UBLK_COUNTERS, /* All above ublk counters */

#endif /* MICROBLOCK_COUNTERS */

    /**
     * per port Ethernet device driver Tx counters.
     */
    IX_CC_ETH_TX_OCTETS_OK,      /* bytes transmitted in all legal frames */

    IX_CC_ETH_TX_OCTETS_BAD,     /* bytes transmitted in all bad frames */

    IX_CC_ETH_TX_UC_PKTS,        /* # of unicast packets transmitted */

    IX_CC_ETH_TX_MC_PKTS,        /* # of multicast packets transmitted */

    IX_CC_ETH_TX_BC_PKTS,        /* # of broadcast packets transmitted */

    IX_CC_ETH_TX_PKTS_64,        /* # of packets transmitted that are 64 bytes in length*/

    IX_CC_ETH_TX_PKTS_65_127, /* # of packets transmitted that are 65 - 127 bytes in length */

    IX_CC_ETH_TX_PKTS_128_255, /* # of packets transmitted that are 128 - 255 bytes in length */

    IX_CC_ETH_TX_PKTS_256_511, /* # of packets transmitted that are 256 - 511 bytes in length */

    IX_CC_ETH_TX_PKTS_512_1023, /* # of packets transmitted that are 512  1023 bytes in length */

    IX_CC_ETH_TX_PKTS_1024_1518, /* # of packets transmitted that are 1024  1518 bytes in length */

    IX_CC_ETH_TX_PKTS_1519_MAX, /* # of packets transmitted that are >1518 bytes in length */

    IX_CC_ETH_TX_DEFERED_ERR, /* number of times, the initial transmission attempt of a frame is postponed due to another frame already being transmitted on the Ethernet network. */

    IX_CC_ETH_TX_TOTAL_COLLISION, /* sum of all collision events */

    IX_CC_ETH_TX_SINGLE_COLLISION, /* number of successfully transmitted frames, on a particular interface where the transmission is inhibited by exactly one collision */

    IX_CC_ETH_TX_MUL_COLLISION, /* number of successfully transmitted frames, on a particular interface for which transmission is inhibited by more than one collision */

    IX_CC_ETH_TX_LATE_COLLISION, /* number of times, a collision is detected on a particular interface later than 512 bit-times into the transmission of a packet. Such frame are terminated and discarded */

    IX_CC_ETH_TX_EXCV_COLLISION, /* number of frames, which collides 16 times and is then discarded by the MAC. Not effecting xMultipleCollisions */

    IX_CC_ETH_TX_EXCV_DEFERRED_ERR, /* number of times frame, for which transmission is postponed more than 2*MaxFrameSize due to another frame already being transmitted on the Ethernet network. This causes the MAC to discard the frame */

    IX_CC_ETH_TX_EXCV_LEN_DROP, /* number of frame, for which transmissions aborted by the MAC because the frame is longer than maximum frame size */

    IX_CC_ETH_TX_UNDERRUN, /* the number of internal TX error, which causes the MAC to end the transmission before the end of the frame because the MAC did not get the needed data in time for transmission. The frames are lost and a fragment or a CRC error is transmitted */

    IX_CC_ETH_TX_VLAN_TAG, /* number of OK frames with VLAN tags */

    IX_CC_ETH_TX_CRC_ERR, /* number of frames, which are transmitted with a legal size, but with the wrong CRC field (also called FCS field) */

    IX_CC_ETH_TX_PAUSE_FRAME, /* number of pause frames transmitted */

    IX_CC_ETH_TX_FC_COLLISION_SEND, /* number of times the collision is generated on purpose on incoming frames, to avoid reception of traffic, while the port is in half-duplex and has flow control enabled, and have not sufficient memory to receive more frames */

    IX_CC_ETH_TX_ALL_DRIVER_COUNTERS, /* All above driver counters of a given port */

    IX_CC_ETH_TX_COUNTER_LAST       /* End of Ethernet Tx counter */

} ix_cc_eth_tx_statistics_info;

/*
 * 32-bit counter overflow time.
 * The overflow time is calculated for byte counters which need to be
 * updated more often than the packet counter. For packet counters, we
 * will use the same overflow time since RM 64bit_counter_new function
 * creates array of 64-bit counters with the same overflow time.
 * POS minimum 64-byte packet size is used:
 * 
 *      2^32
 *  ------------- = 13.81 sec  (IXP2400)
 *   2.488Gbps/8
 * 
 *      2^32
 *  ------------- = 3.436 sec  (IXP2800)
 *   10Gbps/8
 * 
 */
#if (_IX_HARDWARE_TYPE_ == _IX_HW_2400_)
#define IX_CC_ETH_TX_32BIT_COUNTER_OVERFLOW_TIME	13000
#elif (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
#define IX_CC_ETH_TX_32BIT_COUNTER_OVERFLOW_TIME	3000
#else
#error "Undefined platform type."
#endif


/**
 * The following define the API-level data structures.
 */
typedef struct ix_s_cc_eth_tx_statistics_info_context
{
    ix_cc_eth_tx_statistics_info entity;
    ix_uint32 index;
    void *pUserContext;
} ix_cc_eth_tx_statistics_info_context;


typedef struct ix_s_cc_eth_tx_statistics_info_data
{
    ix_uint32 dataLength; /* length in bytes of the data buffer */
    void *pDataBuffer;    /* buffer to store the statistics data */
} ix_cc_eth_tx_statistics_info_data;


typedef struct ix_s_cc_eth_tx_if_state_context
{
    ix_uint32 portId;
    void *pUserContext;
} ix_cc_eth_tx_if_state_context;


typedef enum ix_e_cc_eth_tx_if_state
{
    IX_CC_ETH_TX_IF_STATE_DOWN = 0,
    IX_CC_ETH_TX_IF_STATE_UP
} ix_cc_eth_tx_if_state;


typedef struct ix_s_cc_eth_tx_next_hop_info
{
    ix_uint32 l2Index;
    ix_uint32 nextHopIp;
    ix_uint32 outputPort;
    ix_ether_addr l2Addr;
} ix_cc_eth_tx_next_hop_info;


/**
 * prototypes for async messaging user callbacks
 */
typedef ix_error (*ix_cc_eth_tx_cb_get_statistics_info)(
    ix_error arg_Result,
    void *arg_pContext,
    ix_uint64 *arg_pBuffer,
    ix_uint32 arg_MsgLen);

typedef ix_error (*ix_cc_eth_tx_cb_get_interface_state)(
    ix_error arg_Result,
    void *arg_pContext,
    ix_cc_eth_tx_if_state *arg_pState);

typedef ix_error (*ix_cc_eth_tx_cb_create_arp_entry)(
    ix_uint32 arg_Result,
    void *arg_pContext);

typedef ix_error (*ix_cc_eth_tx_cb_add_arp_entry)(
    ix_uint32 arg_Result,
    void *arg_pContext);

typedef ix_error (*ix_cc_eth_tx_cb_del_arp_entry)(
    ix_uint32 arg_Result,
    void *arg_pContext);


typedef ix_error (*ix_cc_eth_tx_cb_notify_interface_state)(
    void *arg_pContext,
    ix_uint32 arg_Port,
    ix_cc_eth_tx_if_state arg_pState);



typedef struct ix_s_cc_eth_tx_cb_notify_data
{
    void *pUserContext;
    ix_cc_eth_tx_cb_notify_interface_state callback;
} ix_cc_eth_tx_cb_notify_data;



/**
 * Prototypes for interface functions.
 */
ix_error ix_cc_eth_tx_init(
    ix_cc_handle arg_CcHandle, 
    void **arg_ppContext);

ix_error ix_cc_eth_tx_fini(
    ix_cc_handle arg_CcHandle, 
    void *arg_pContext);

ix_error ix_cc_eth_tx_msg_handler(
    ix_buffer_handle arg_Msg, 
    ix_uint32 arg_UserData,
    void *arg_pContext);

ix_error ix_cc_eth_tx_property_msg_handler(
    ix_buffer_handle arg_Msg, 
    ix_uint32 arg_UserData,
    void *arg_pContext);

ix_error ix_cc_eth_tx_pkt_handler(
    ix_buffer_handle arg_hPacket, 
    ix_uint32 arg_ExceptionCode,
    void *arg_pContext);

ix_error ix_cc_eth_tx_async_get_statistics_info(
    ix_cc_eth_tx_statistics_info_context *arg_pMgInfoContext, 
    ix_cc_eth_tx_cb_get_statistics_info arg_Callback);

ix_error ix_cc_eth_tx_async_get_interface_state(
    ix_cc_eth_tx_if_state_context *arg_pStateContext, 
    ix_cc_eth_tx_cb_get_interface_state arg_Callback);

ix_error ix_cc_eth_tx_async_create_arp_entry(
    ix_cc_eth_tx_next_hop_info *arg_pArpInfo,
    ix_cc_eth_tx_cb_create_arp_entry arg_Callback,
    void *arg_pContext);

ix_error ix_cc_eth_tx_async_add_arp_entry(
    ix_cc_eth_tx_next_hop_info *arg_pArpInfo,
    ix_cc_eth_tx_cb_add_arp_entry arg_Callback,
    void *arg_pContext);

ix_error ix_cc_eth_tx_async_del_arp_entry(
    ix_uint32 arg_L2Index,
    ix_cc_eth_tx_cb_del_arp_entry arg_Callback,
    void *arg_pContext);

ix_error ix_cc_eth_tx_async_purge_arp_cache(void);

ix_error ix_cc_eth_tx_async_dump_arp_cache(void);

ix_error ix_cc_eth_tx_get_statistics_info(
    ix_cc_eth_tx_statistics_info arg_Entity,
    ix_uint32 arg_Index,
    ix_cc_eth_tx_statistics_info_data *arg_pBuffer,
    void *arg_pContext);

ix_error ix_cc_eth_tx_get_interface_state(
    ix_uint32 arg_PortId, 
    ix_cc_eth_tx_if_state *arg_pIfState,
    void *arg_pContext);

ix_error ix_cc_eth_tx_create_arp_entry(
    ix_cc_eth_tx_next_hop_info *arg_pArpInfo, 
    void *arg_pContext);

ix_error ix_cc_eth_tx_add_arp_entry(
    ix_cc_eth_tx_next_hop_info *arg_pArpInfo, 
    void *arg_pContext);

ix_error ix_cc_eth_tx_del_arp_entry(
    ix_uint32 arg_L2Index, 
    void *arg_pContext);

ix_error ix_cc_eth_tx_purge_arp_entry(
    void *arg_pContext);

ix_error ix_cc_eth_tx_dump_arp_entry(
    void *arg_pContext);

ix_error ix_cc_eth_tx_set_property(
    ix_uint32 arg_PropId,
    ix_cc_properties *arg_pProperty,
    void *arg_pContext);


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_ETH_TX_H__) */
