/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor, Release 6
 *
 * = FILENAME
 *      ix_cc_stkdrv_tm.h
 *
 * = DESCRIPTION
 *      Header file for Transport Module component of Stack Driver.
 *
 * = AUTHOR
 *      Aaron Luk
 *      aaron.luk@intel.com
 *
 * = CHANGE HISTORY
 *       6/19/2002 - initial revision
 *
 * ============================================================================
 * $Id: ix_cc_stkdrv_tm.h,v 1.19 2003/08/20 05:35:44 rranjeet Exp $
 */

#if !defined(__IX_CC_STKDRV_TM_H__)
#define __IX_CC_STKDRV_TM_H__

#if defined(IX_PLATFORM_2401) || defined(IX_PLATFORM_2801)
/* Improvement
 * Cleanup in headers - don't include user space stdio.h, use <> when including
 * headers from global include paths.
 */
#include <ix_ossl.h>
#include <ix_rm.h>

#include <ix_cc_error.h>
#include <ix_cc.h>
#include <ix_cc_properties.h>
#include <bindings.h>

#include <cc/ix_cc_stkdrv_common.h>

#else /* IX_PLATFORM_2x01 */

#include "ix_cc_error.h"
#include <stdio.h>
#include "ix_ossl.h"
#include "ix_rm.h"
#include "ix_cc.h"
#include "ix_cc_properties.h"
#include "cc/ix_cc_stkdrv_common.h"
#include "bindings.h"

#endif /* IX_PLATFORM_2x01 */

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * Pre-processor symbol and macro definitions.
 */
#if 1
    /* TM and FP module comm IDs defined here for now - should be in bindings.h */
    #define IX_CC_STKDRV_TM_PKT_INPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_COMMID_LAST+1)
    #define IX_CC_STKDRV_TM_PKT_OUTPUT IX_RM_COMM_MAKE_LOCAL_ID(IX_CC_COMMID_LAST+2)
#endif /* if 0 */

/**
 * Type definitions.
 */

/**
 * TYPENAME: ix_cc_stkdrv_tm_ctrl
 * 
 * DESCRIPTION: This is the control structure for the TM, used as a context
 * in receiving packets from the FP Module.
 *
 */
typedef struct ix_s_cc_stkdrv_tm_ctrl
{
    /* handle to free list from which to get ix buffers for transmit */
	ix_buffer_free_list_handle hFreeList;

    /* Handle of the TM core component. */
    ix_cc_handle hTMCC;

    /* Pointer to stack driver FP structure, containing blade and port info. */
    ix_cc_stkdrv_fp_node* pFP;
	
    /* expand as necessary */
} ix_cc_stkdrv_tm_ctrl;

/**
 * Prototypes for interface functions.
 */

/**
 * NAME: ix_cc_stkdrv_tm_fini
 *
 * DESCRIPTION: This function is called by the CC Module to shutdown the
 * Transport Module and free any memory allocated to it.
 * 
 * @Param:  - IN ix_cc_stkdrv_tm_ctrl* arg_pTmCtrl - pointer to TM
 *			control structure.
 *
 * @Return: IX_SUCCESS

 */
ix_error ix_cc_stkdrv_tm_fini(
							  ix_cc_stkdrv_tm_ctrl* arg_pTmCtrl
							  );

/**
 * NAME: ix_cc_stkdrv_tm_receive_pkt
 *
 * DESCRIPTION: This is the TM entry point (packet processing
 * callback invoked by the CC Module) that receives packets from
 * the CC Module and passes them to the FP Module.
 * 
 * @Param:  - IN ix_buffer_handle arg_hBuffer - handle to the input packet.
 * @Param:  - IN void* arg_pCtx - pointer to the context, in this case the
 *          pointer to the TM control structure.
 * @Param:  - IN ix_cc_stkdrv_packet_type arg_packetType - packet type.
 *			Will be passed on to the FP Module's receive routine.
 *
 * @Return: IX_SUCCESS
 *			IX_CC_ERROR_NULL
 *			IX_CC_ERROR_SEND_FAIL
 */
ix_error ix_cc_stkdrv_tm_receive_pkt(
									 ix_buffer_handle arg_hBuffer,
									 void* arg_pCtx,
									 ix_cc_stkdrv_packet_type arg_packetType
									 );

/**
 * NAME: ix_cc_stkdrv_tm_receive_msg_int
 *
 * DESCRIPTION: This is the TM entry point (integer message processing
 * callback invoked by the CC Module) that receives integer messages
 * from the CC Module.
 * 
 * @Param:  - IN ix_cc_stkdrv_tm_msg_id arg_MsgId - identification of the message.
 * @Param:  - IN ix_uint32 arg_msg - integer message value.
 * @Param:  - IN void* arg_pContext - pointer to the context.  Here the context
 *          is the TM control structure.
 * @Param:  - OUT void** arg_ppReplyMsg - location of pointer to reply message,
 *          if any.
 * @Param:  - OUT ix_uint32* arg_pReplyMsgSize - pointer to size of reply message,
 *          if any.
 *
 * @Return: IX_SUCCESS
 *          IX_CC_ERROR_UNDEFINED_MSG
 */
ix_error ix_cc_stkdrv_tm_receive_msg_int(
                                         ix_cc_stkdrv_tm_msg_id arg_msgId,
                                         const ix_uint32 arg_msg,
                                         void* arg_pContext,
                                         void** arg_ppReplyMsg,
                                         ix_uint32* arg_pReplyMsgSize
                                         );


/**
 * NAME: ix_cc_stkdrv_tm_cc_init
 *
 * DESCRIPTION: Initializes the TM core component.
 * 
 * @Param:  - ix_cc_handle arg_hCC - handle to Stack Driver core component;
 *          this shall be used later to get other services from the core
 *          component infrastructure.
 * @Param:  - INOUT void** arg_ppContext - location where the pointer to the
 *          control block will be stored.
 *
 * @Return: IX_SUCCESS
 *          IX_CC_STKDRV_ERROR_CCI_ADD_HANDLER
 *          IX_CC_STKDRV_ERROR_RM_ADD_HANDLER
 */
ix_error ix_cc_stkdrv_tm_cc_init(
                                 ix_cc_handle arg_hCC,
                                 void** arg_ppContext
                                 );


/**
 * NAME: ix_cc_stkdrv_tm_cc_fini
 *
 * DESCRIPTION: Termination function. Frees transport module core component memory
 * and data structures.
 * 
 * @Param:  - IN ix_cc_handle arg_hCC - handle to the core component.
 * @Param:  - IN void* arg_pContext - pointer to the control block.
 * @Return: IX_SUCCESS
 *          IX_CC_STKDRV_ERROR_CCI_REMOVE_HANDLER
 *          IX_CC_STKDRV_ERROR_RM_REMOVE_HANDLER
 *          IX_CC_STKDRV_ERROR_HANDLER_FINI
 *          IX_CC_ERROR_NULL
 */
ix_error ix_cc_stkdrv_tm_cc_fini(
                                 ix_cc_handle arg_hCC,
                                 void* arg_pContext
                                 );

/**
 * NAME: ix_cc_stkdrv_tm_pkt_handler
 *
 * DESCRIPTION: Packet processing function for transport module.
 * 
 * @Param:  - IN ix_buffer_handle arg_hDataToken - handle to a buffer which
 *          contains exception packets.
 * @Param:  - IN ix_uint32 arg_userData - User data for the packet.
 *          Represents output port ID in this case.
 * @Param:  - IN void* arg_pComponentContext - pointer to TM core
 *          component context.
 * @Return: IX_SUCCESS, or an appropriate error code on failure.
 */
ix_error ix_cc_stkdrv_tm_pkt_handler(
                                     ix_buffer_handle arg_hDataToken,
                                     ix_uint32 arg_userData,
                                     void* arg_pComponentContext
                                     );


/**
 * Exported variables.
 */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_STKDRV_TM_H__) */

