/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation.All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor, Release 6
 *
 * = FILENAME
 *      ix_cc_stkdrv_mux_stub.c
 *
 * = DESCRIPTION
 *      Stubs for the MUX library to allow the Stack Driver to load on VxSim-Lite.
 *      Note that these stubs do not implement any meaningful functionality!
 *      However they are required in order for the Stack Driver to have all the
 *      required symbols and functions to operate on VxSim-Lite.
 *
 * = AUTHOR
 *       Aaron Luk
 *       aaron.luk@intel.com
 *
 * = CHANGE HISTORY
 *      9/10/2002 5:01:47 PM - creation time
 *
 * ============================================================================
 * $Id: ix_cc_stkdrv_mux_stub.c,v 1.5 2003/01/07 01:45:12 asluk Exp $
 * $History: $
 */

#include "ix_cc_error.h"
#include <stdio.h>
#include <string.h>
#include <ix_ossl.h>
#include "ix_rm.h"

#include "vxWorks.h"
#include "assert.h"
#include "cacheLib.h"
#include "end.h"            /* Common END structures. */
#include "errno.h"
#include "etherLib.h"
#include "etherMultiLib.h"      /* multicast stuff. */
#include "m2Lib.h"
#include "memLib.h"
#include "muxLib.h"
#include "muxTkLib.h"
#include "net/if.h"
#include "net/if_subr.h"
#include "net/mbuf.h"
#include "net/protosw.h"
#include "net/route.h"
#include "netBufLib.h"
#include "netLib.h"
#include "netinet/if_ether.h"
#include "netinet/in.h"
#include "netinet/in_systm.h"
#include "netinet/in_var.h"
#include "netinet/ip.h"
#include "sys/ioctl.h"
#include "sys/socket.h"

#include "ix_cc.h"
#include "cc/ix_cc_stkdrv_common.h"
#include "cc/ix_cc_stkdrv.h"
#include "cc/internal/internal_stkdrv.h"

#include "ix_netmacros.h"

#include "cc/ix_cc_stkdrv_vidd.h"

#if (defined(MUX_STUB) && !defined(TEST_MUX_STUB))

    #if (_IX_OS_TYPE_ == _IX_OS_VXWORKS_)

        #if (defined(IX_TARGET_SIMNTgnu_Debug) || defined(IX_TARGET_SIMNTgnu))

extern ix_cc_stkdrv_ctrl* g_pStkdrvCtrl;
ix_uint32 g_vidd_pktcount = 0;

STATUS	mib2Init(M2_INTERFACETBL* arg1, long arg2 ,UCHAR* arg3, int arg4, int arg5, int arg6)
{
    return OK;
}

int netMblkToBufCopy(M_BLK_ID pMblk, char * pBuf,
                                          FUNCPTR pCopyRtn)
{
    return 0;
}

STATUS netPoolDelete(NET_POOL_ID arg1)
{
    return OK;
}

int etherMultiGet(LIST *pList, MULTI_TABLE* pTable)
{
    return 0;
}

STATUS netPoolInit (NET_POOL_ID pNetPool,
                                     M_CL_CONFIG * pMclBlkConfig,
                                     CL_DESC * pClDescTbl, int clDescTblNumEnt,
                                     POOL_FUNC * pFuncTbl)
{
    return OK;
}

STATUS muxDevStart(void* pCookie)
{
    return ix_cc_stkdrv_vidd_npt_start((END_OBJ*)pCookie);
}

int etherMultiDel(LIST* pList, char* pAddress)
{
    return OK;
}

int etherMultiAdd(LIST *pList, char* pAddress )
{
    return OK;
}

STATUS test_mux_receive_pkt
    (
    void *   pCookie,        /* Cookie passed in endLoad call */
    M_BLK_ID pMblk,          /* A buffer passed to us. */
    long     netSvcOffset,   /* offset to Network datagram in the packet */
    long     netSvcType,     /* Network service type */
    BOOL     uniPromiscuous, /* set to TRUE when Driver in promiscuous mode */
    void *   pSpareData      /* out of band data */
    )
{
    netMblkClChainFree(pMblk);
    g_vidd_pktcount++;
    return OK;
}

STATUS endObjInit (END_OBJ* pEndObj, DEV_OBJ* pDevice,
                    char* pBaseName ,int unit, NET_FUNCS* pFuncTable,
                    char* pDescription)
{
    pEndObj->receiveRtn = test_mux_receive_pkt;
    return OK;
}

M_BLK_ID netTupleGet (NET_POOL_ID pNetPool, int bufSize,
                         int canWait, UCHAR type, BOOL bestFit)
{
    M_BLK_ID pMblk;
    
    pMblk = ix_ossl_malloc(sizeof(M_BLK));
    ix_ossl_memset(&pMblk->mBlkHdr, 0, sizeof(M_BLK_HDR));
    pMblk->mBlkHdr.mData = ix_ossl_malloc(2048);
    return pMblk;
}

STATUS endObjFlagSet(END_OBJ* arg1, UINT arg2)
{
    return OK;
}

STATUS muxDevStop(void* pCookie)
{
    return ix_cc_stkdrv_vidd_npt_stop((END_OBJ*)pCookie);
}

void netMblkClChainFree (M_BLK_ID pMblk)
{
    if(pMblk != NULL)
        if(pMblk->mBlkHdr.mData != NULL)
        {
            free(pMblk->mBlkHdr.mData);
            pMblk->mBlkHdr.mData = NULL;
        }

        free(pMblk);
    return;
}

void muxError ( void* pCookie, END_ERR* pError )
{
    return;
}

STATUS	mib2ErrorAdd (M2_INTERFACETBL* arg1, int arg2, int arg3)
{
    return OK;
}

int ipAttach(int unit, char* pDevice)
{
    return 0;
}

STATUS 	ifAddrSet (char *interfaceName, char *interfaceAddress)
{
    return OK;
}

STATUS 	ifMaskSet (char *interfaceName, int netMask)
{
    return OK;
}

int 	ifRouteDelete (char *ifName, int unit)
{
    return 1;
}

STATUS ifBroadcastSet
    (
    char * interfaceName,   /* name of interface to assign, i.e. ei0 */
    char * broadcastAddress /* broadcast address to assign to interface */
    )
{
    return OK;
}


STATUS muxIoctl(void* pCookie, int cmd, caddr_t data)
{
    ix_cc_stkdrv_vidd_ctrl* pViddCtrl;
    ix_cc_stkdrv_handler_module* pHandlerModule = g_pStkdrvCtrl->pHandlerList;

    _IX_CC_STKDRV_GET_HANDLER_MODULE(IX_CC_STKDRV_HANDLER_ID_LOCAL_DRIVER, pHandlerModule);
    pViddCtrl = (ix_cc_stkdrv_vidd_ctrl*)pHandlerModule->pHandler_func->pPktContext;
    return ix_cc_stkdrv_vidd_npt_ioctl((void*)pViddCtrl->pFps->pPhysicalIfs, cmd, data);
}

void * muxDevLoad(int unit, END_OBJ* (*endLoad) (char *, void*),
                           char *initString,
                           BOOL loaning, void*pBSP)
{
    return endLoad(NULL, pBSP);
}

STATUS muxDevUnload(char* pName, int unit)
{
    ix_cc_stkdrv_vidd_ctrl* pViddCtrl;
    ix_cc_stkdrv_handler_module* pHandlerModule = g_pStkdrvCtrl->pHandlerList;

    _IX_CC_STKDRV_GET_HANDLER_MODULE(IX_CC_STKDRV_HANDLER_ID_LOCAL_DRIVER, pHandlerModule);
    
    pViddCtrl = (ix_cc_stkdrv_vidd_ctrl*)pHandlerModule->pHandler_func->pPktContext;

    ix_cc_stkdrv_vidd_npt_unload((END_OBJ*)pViddCtrl->pFps->pPhysicalIfs);
    free(pViddCtrl->pFps->pPhysicalIfs);
    return OK;
}


STATUS muxPollReceive(void* pCookie, M_BLK_ID pNBuff)
{
    return ix_cc_stkdrv_vidd_npt_pollRcv(NULL, NULL, NULL, NULL, NULL);
}

STATUS muxPollSend(void* pCookie, M_BLK_ID pNBuff)
{
    return ix_cc_stkdrv_vidd_npt_pollSend(NULL, NULL, NULL, 0, NULL);
}

STATUS muxMCastAddrAdd(void* pCookie, char* pAddress)
{
    return ix_cc_stkdrv_vidd_npt_mCastAddrAdd((void*)g_pStkdrvCtrl->pFPList->pPhysicalIfs, pAddress);
}

STATUS muxMCastAddrDel(void* pCookie, char* pAddress)
{
    return ix_cc_stkdrv_vidd_npt_mCastAddrDel((void*)g_pStkdrvCtrl->pFPList->pPhysicalIfs, pAddress);
}

STATUS muxMCastAddrGet(void* pCookie, MULTI_TABLE* pTable)
{
    return ix_cc_stkdrv_vidd_npt_mCastAddrGet((void*)g_pStkdrvCtrl->pFPList->pPhysicalIfs, pTable);
}

STATUS muxTkSend(void* pCookie, M_BLK_ID pNBuff,char * arg3, USHORT arg4, void * arg5)
{
    ix_cc_stkdrv_vidd_ctrl* pViddCtrl;
    ix_cc_stkdrv_handler_module* pHandlerModule = g_pStkdrvCtrl->pHandlerList;

    _IX_CC_STKDRV_GET_HANDLER_MODULE(IX_CC_STKDRV_HANDLER_ID_LOCAL_DRIVER, pHandlerModule);

    pViddCtrl = (ix_cc_stkdrv_vidd_ctrl*)pHandlerModule->pHandler_func->pPktContext;

    return ix_cc_stkdrv_vidd_npt_send((END_OBJ*)pViddCtrl->pFps->pPhysicalIfs, pNBuff, arg3, arg4, arg5);
}

STATUS ifAddrDelete
    (
    char * interfaceName,     /* name of interface to delete addr from */
    char * interfaceAddress   /* Internet address to delete from interface */
    )
{
    return OK;
}

STATUS ifAddrAdd
    (
    char * interfaceName,     /* name of interface to configure */
    char * interfaceAddress,  /* Internet address to assign to interface */
    char * broadcastAddress,  /* broadcast address to assign to interface */
    int    subnetMask         /* subnetMask */
    )
{
    return OK;
}


        #endif /* (defined(IX_TARGET_SIMNTgnu_Debug) || defined(IX_TARGET_SIMNTgnu)) */
    #endif /* (_IX_OS_TYPE_ == _IX_OS_VXWORKS_) */
#endif /* (defined(MUX_STUB) && !defined(TEST_MUX_STUB)) */
