/*
/////////////////////////////////////////////////////////////////////////////////////
//
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
//
/////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: pkt_copier.h
//
//      Purpose: Packet replication  microblock definitions
//
//
/////////////////////////////////////////////////////////////////////////////////////
*/

/*
 * PKT COPIER HEADER
 */

#ifndef	_PKT_COPIER_H_
#define	_PKT_COPIER_H_



#define		PKT_COPIER_Q_BASE			0	/* byte address */
#define		PKT_COPIER_CTX_BASE			PKT_COPIER_Q_BASE		
#define		PKT_COPIER_Q_TSHLD			24	/* low watermark */
#define		PKT_COPIER_Q_MAX_ENTRIES	32	/* must be ateast 8 more than watermark */
#define		PKT_COPIER_Q_ENTRY_SIZE		64	/* 16 LW = 64 bytes */

#define_eval	PKT_COPIER_WRAP_MASK	((PKT_COPIER_Q_ENTRY_SIZE * PKT_COPIER_Q_MAX_ENTRIES) + PKT_COPIER_Q_BASE -1)	


/********************************************************
 * 
 * Misc. definitions
 *
 */
#define	EOP_BIT					30
#define	NEXT_HANDLE				0
#define	REQUEST_BIT				0
#define	PARENT_META_READ_BIT	1
#define	REF_CNT_BIT				0

/*
 * Next thread signal. Use to run threads in strict order. Can be
 * redefined to different value depending on the application.
 */
#ifndef	PKT_COPIER_NEXT_THD_SIGNAL
#define	PKT_COPIER_NEXT_THD_SIGNAL	6
#endif


/*
 * For easy reference to copy context
 *
 */

/* some short cuts for easy referencing */

#define		_REF_CNT			*l$index0[0]
#define		_FLAGS				_REF_CNT
#define		_SOP_EOP_SEG_CNT	_REF_CNT
#define		_PARENT_SOP_HANDLE	*l$index0[1]
#define		_PARENT_EOP_HANDLE	*l$index0[2]
#define		_CHILD_SOP_HANDLE	*l$index0[3]
#define		_CUR_PARENT_HANDLE	*l$index0[4]
#define		_CUR_CHILD_HANDLE	*l$index0[5]
#define		_PORT_MASK			*l$index0[6]
#define		_CNT				*l$index0[6]
#define		_CNT_PORT_MASK		_CNT
#define		_PACKET_SIZE_CLASS_ID	*l$index0[7]
#define		_PARENT_META_0		*l$index0[8]
#define		_PARENT_META_1		*l$index0[9]
#define		_PARENT_META_2		*l$index0[10]
#define		_PARENT_META_3		*l$index0[11]
#define		_PARENT_META_4		*l$index0[12]
#define		_PARENT_META_5		*l$index0[13]
#define		_PARENT_META_6		*l$index0[14]
#define		_PARENT_META_7		*l$index0[15]

/*
 * Queue Descriptor

	LW	Bits	Size	Description
	-----------------------------------------------------------------
	0	31:16	16		reserved
	0	15:0	16		Queue Count
	1	31:16	16		Reserved
	1	15:0	16		Queue Head
	2	31:16	16		Reserved.
	2	15:0	16		Queue Tail
	3	31:16	16		reserved
	3	15:0	16		Queue Threshold.
 *
 *
 */
#define	PKT_COPIER_QD_CNT		0
#define	PKT_COPIER_QD_HEAD		1
#define	PKT_COPIER_QD_TAIL		2
#define	PKT_COPIER_QD_TSHLD		3
#define	PKT_COPIER_QD_SIZE_MASK	4

.reg	@pkt_copier_qd[5]		/* QD is in absolute registers */

/* some short cuts for easy referencing */

#define	_QD_TSHLD		@pkt_copier_qd[PKT_COPIER_QD_TSHLD]
#define	_QD_CNT			@pkt_copier_qd[PKT_COPIER_QD_CNT]
#define	_QD_TAIL		@pkt_copier_qd[PKT_COPIER_QD_TAIL]
#define	_QD_HEAD		@pkt_copier_qd[PKT_COPIER_QD_HEAD]
#define	_QD_SIZE_MASK	@pkt_copier_qd[PKT_COPIER_QD_SIZE_MASK]


/*
 * Size of request message in LW
 */
#define	PKT_COPIER_REQUEST_SIZE		4

/*
 * Size of Response message in LW
 */
#define	PKT_COPIER_RESPONSE_SIZE	3

/*
 * Next thread chaining
 */

#define	NEXT_THREAD_OF_0			1
#define	NEXT_THREAD_OF_1			2
#define	NEXT_THREAD_OF_2			3
#define	NEXT_THREAD_OF_3			4
#define	NEXT_THREAD_OF_4			5
#define	NEXT_THREAD_OF_5			6
#define	NEXT_THREAD_OF_6			7
#define	NEXT_THREAD_OF_7			0


#endif	/* _PKT_COPIER_H_ */
