/////////////////////////////////////////////////////////////////////////////////////
//
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
//
/////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: freelist_manager_init.uc
//
//      Purpose: Initialization code for the freelist manager 
//
//      History:
//
//      Date            Comment                  				       By
//      ---------------------------------------------------------------------
//
//      08/03/03		Created 									  urn
//
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __FREELIST_MANAGER_INIT_UC__
#define __FREELIST_MANAGER_INIT_UC__

/////////////////////////////////////////////////////////////////////////////////////
// 
// _freelist_manager_initialize_debug_counters[]
//
// Description:
// 	
//		Initialize the debug counters in absolute registers to zeros.
// 
/////////////////////////////////////////////////////////////////////////////////////

#macro	_freelist_manager_initialize_debug_counters[]

#ifdef	_DEBUG_COUNTERS_

	immed32[@freelist_buffers_allocated,0x0]	
	immed32[@freelist_buffers_freed,0x0]
	immed32[@freelist_buffers_empty,0x0]
	immed32[@freelist_buffers_from_scr,0x0]
#endif

#endm

/////////////////////////////////////////////////////////////////////////////////////
// 
// _freelist_manager_initialize_bitmap[]
//
// Description:
// 	
//		Initialize the bit map in local memory 
// 
//
/////////////////////////////////////////////////////////////////////////////////////

#macro _freelist_manager_initialize_bitmap[]

.begin
	
	.reg	number_of_buffers
	.reg	minus_one
	.reg	minus_two
	.reg	freelist_level2_size
	.reg	freelist_level3_size
	.reg	lm_base
	.reg	level1_bitmask
	.reg	level2_bitmask
	.reg	level3_bitmask
	.reg	level2_remainder
	.reg	level3_remainder 
	.reg	i

	// Set up constants in registers 

	immed32[minus_one, 0xffffffff]
	immed32[minus_two, 0xfffffffe]

	// Calculate the number total number of buffers to be managed based on 
	// the size of SRAM allocated for buffers. 

	immed32[number_of_buffers, FREELIST_MANAGER_NUMBER_OF_BUFFERS]
	
	// We maintain a 3 level bit vector. The first level is kept in a global
	// register. Calculate the number of bits in level 1 

	alu[number_of_buffers, number_of_buffers, -, 1]
	alu[freelist_level2_size, --, B, number_of_buffers, >>10]

	// Set up the level one bit vector 

	alu[--, freelist_level2_size, OR, 0]
	alu[level1_bitmask, --, ~B, minus_two, <<indirect]
	alu[@global_level1_vector, --, B, level1_bitmask]

	// Set up the local memory base for the freelist bit map 

	immed32[lm_base, FREELIST_MANAGER_LM_BASE_LEVEL2]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_base, LM_HANDLE_0]

	nop
	nop
	nop

	// In a loop, set up the level 2 vector 

	alu[i, --, B, 0]
	.while (i < freelist_level2_size)
		
		alu[*l$index0++, --, B, minus_one]
		alu[i, i, +, 1]

	.endw

	// The last element in the level 2 vector may not be all 1. Compute the
	// number of bits in the last element 

	alu[level2_remainder, 0x1f, AND, number_of_buffers, >>5]

	alu[--, level2_remainder, OR, 0]
	alu[level2_bitmask, --, ~B, minus_two, <<indirect]
	alu[*l$index0++, --, B, level2_bitmask]


	// Set the rest of level two to be 0 

	.while (i < MAX_NUMBER_IN_LEVEL2)

		alu[*l$index0++, --, B, 0]
		alu[i, i, +, 1]

	.endw

	// Set up the local memory base for the freelist bit map 

	immed32[lm_base, FREELIST_MANAGER_LM_BASE_LEVEL3]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_base, LM_HANDLE_0]

	nop
	nop
	nop

	// Calculate the size of the level 3 vector 

	alu[freelist_level3_size, --, B, number_of_buffers, >>5]

	alu[i, --, B, 0]
	.while (i < freelist_level3_size)
		
		alu[*l$index0++, --, B, minus_one]
		alu[i, i, +, 1]

	.endw

	// The last element in the level 3 vector may not be all 1. Compute the 
	// number of bits in the last element
	
	alu[level3_remainder, 0x1f, AND, number_of_buffers]

	alu[--, level3_remainder, OR, 0]
	alu[level3_bitmask, --, ~B, minus_two, <<indirect]
	alu[*l$index0++, --, B, level3_bitmask]

	// Set the rest of level three to be 0 

	.while (i < MAX_NUMBER_IN_LEVEL3)

		alu[*l$index0++, --, B, 0]
		alu[i, i, +, 1]

	.endw

	// Buffer 0 is not a valid buffer. So allocate it. First buffer allocated
	// must always be buffer 0. Read it into dummy variable i.

	_freelist_manager_allocate_buffer(i, EXIT_INIT_BITMAP#)

EXIT_INIT_BITMAP#: 

.end
#endm


/////////////////////////////////////////////////////////////////////////////////////
// 
// freelist_manager_init]
//
// Description:
// 	
//		Initialization of the freelist manager service microblock
// 
//
/////////////////////////////////////////////////////////////////////////////////////

#macro freelist_manager_init[]

.begin

	.reg	ctx_enable
	.reg	next_thread_signal_value

	// Do some initialization only in the first thread of the freelist manager

	br!=ctx[FREELIST_MANAGER_FIRST_THREAD, INIT_COMPLETE#]

	// Read the ctx_enable register

	local_csr_rd[ctx_enables]
	immed[ctx_enable, 0]

	// Clear bits 18, 19 and 20 for NN ring initialization. Bit 20 is set to 0
	// to indicate that previous ME writes to this NN ring. Bits 18 and 19 are 
	// set to 0 to indicate that the ring empty threshold is 0. 

	alu_shf[ctx_enable, ctx_enable, AND~, 7, <<18]

	// Clear bits 16 and 17 to set local memory to thread local mode 

	alu_shf[ctx_enable, ctx_enable, AND~, 3, <<16]
	
	// Clear bit 31 to set the microengine in eight thread mode 

	alu_shf[ctx_enable, ctx_enable, AND~, 1, <<31]

	// Write the ctx_enable register

	local_csr_wr[ctx_enables, ctx_enable]

	// Set the NN ring put and get pointers to 0 

	local_csr_wr[nn_put, 0]
	local_csr_wr[nn_get, 0]	
	alu[--, --, b, 0]
	alu[--, --, b, 0]
	alu[--, --, b, 0]

	// Initialize buffer freelist 

	_freelist_manager_initialize_bitmap[]

	// Initialize the debug counters

	_freelist_manager_initialize_debug_counters[]
    
	// Wait for the global initialization complete signal

	ctx_arb[init_complete_signal] , br[SIGNAL_NEXT_THREAD#]


INIT_COMPLETE#:

	// wait for previous thread signal in all threads except the first 

	ctx_arb[next_thread_signal]


SIGNAL_NEXT_THREAD#:

	// Last thread does not signal. All other threads signal the next thread

	br=ctx[FREELIST_MANAGER_LAST_THREAD, PREFETCH_HANDLE#]

	// Now signal the next thread to wake up 

	alu[next_thread_signal_value, --, B, 0x80]
	alu_shf[next_thread_signal_value, next_thread_signal_value, OR, \
			&next_thread_signal, <<3]
	local_csr_wr[SAME_ME_SIGNAL, next_thread_signal_value]


PREFETCH_HANDLE#:

	// Prefetch a buffer handle

	alu[global_prefetch_buffer_handle, --, B, 0]
	_freelist_manager_allocate_buffer(global_prefetch_buffer_handle, EXIT#)

	
EXIT#:

.end

#endm  

/////////////////////////////////////////////////////////////////////////////////////

#endif 		//  __FREELIST_MANAGER_INIT_UC__

/////////////////////////////////////////////////////////////////////////////////////
