/////////////////////////////////////////////////////////////////////////////////////
//
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
//
/////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: freelist_manager.uc 
//
//      Purpose: Main processing code for the free list manager  
//
//      History:
//
//      Date            Comment                  				       By
//      ---------------------------------------------------------------------
//
//      08/03/03		Created 									  urn
//
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __FREELIST_MANAGER_UC__
#define __FREELIST_MANAGER_UC__

/////////////////////////////////////////////////////////////////////////////////////

#include <stdmac.uc>
#include <localmem.uc>
#include "dl_system.h"
#include "freelist_manager.h"
#include "freelist_manager_init.uc"




 
/////////////////////////////////////////////////////////////////////////////////////
// 
// _freelist_manager_allocate_buffer[buffer_handle]
//
// Description:
// 	
//		allocate a buffer (25 instructions worst case)
// 
/////////////////////////////////////////////////////////////////////////////////////

#macro	_freelist_manager_allocate_buffer[buffer_handle, ERROR_LABEL]

.begin 

	.reg	lm_level2_base 
	.reg	lm_level3_base
	.reg	level1_bit 
	.reg	level2_bit
	.reg	level3_bit
	.reg	level1_bitmask
	.reg	temp


	//dmeng fix it later
	move(temp, FREELIST_BUFFER_BASE)

	// Check if there is a bit set in the level 1 vector 

	ffs[level1_bit, @global_level1_vector]

	// If not jump to the error label 

	beq[ERROR_LABEL]

	// Otherwise compute which word in local memory holds the level 2 word

	alu[lm_level2_base, FREELIST_MANAGER_LM_BASE_LEVEL2, OR, level1_bit, <<2]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_level2_base, LM_HANDLE_0]

	// Start computing the level 3 offset. Each bit has 32 words assciated or 
	// 128 bytes (7 bits) associated with it

	alu[lm_level3_base, --, B, level1_bit, <<7]
	alu[lm_level3_base, FREELIST_MANAGER_LM_BASE_LEVEL3, +,  lm_level3_base]
	
	// Start computing the buffer handle (10 bits + 3 bits for 8 meta data LW)
		
	alu[buffer_handle, --, B, level1_bit, <<13]

	// Now there MUST be a bit set. Otherwise we would not have taken this path

	ffs[level2_bit, *l$index0]

	// Compute the word in local memory holding the level 3 word 

	alu[lm_level3_base, lm_level3_base, OR, level2_bit, <<2] 

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_level3_base, LM_HANDLE_1]

	// compute bitmask for level 1 vector 

	alu[--, level1_bit, OR, 0]
	alu[level1_bitmask, --, B, 1, <<indirect]
	
	// add to the buffer handle - 5 bits + 3 bits for 8 meta data LW 

	alu[buffer_handle, buffer_handle, OR, level2_bit, <<8]

	// Now get the actual bit for the buffer 

	ffs[level3_bit, *l$index1]

	// Now clear the bit 

	alu[--, level3_bit, OR, 0]
	alu[*l$index1, *l$index1, AND~, 1, <<indirect]

	// Now check if the whole word is 0

	bne [BUFFER_ALLOC_DONE#], defer [2]

		// Now compute the actual handle - 3 bits for 8 LW meta data 

		alu[buffer_handle, buffer_handle, OR, level3_bit, <<3]
		alu[buffer_handle, temp, +, buffer_handle]

	// Now clear the bit in level 2

	alu[--, level2_bit, OR, 0]
	alu[*l$index0, *l$index0, AND~, 1, <<indirect]

	// Now check if the whole word is 0

	bne [BUFFER_ALLOC_DONE#]

	// Otherwise clear the bit in the level 1 vector 

	alu[@global_level1_vector, @global_level1_vector, AND~, level1_bitmask]


BUFFER_ALLOC_DONE#:

.end

#endm

/////////////////////////////////////////////////////////////////////////////////////
// 
// _freelist_manager_free_buffer[]
//
// Description:
// 	
//		Initialize the bit map in local memory (17 instructions)
// 
//
/////////////////////////////////////////////////////////////////////////////////////

#macro _freelist_manager_free_buffer[buffer_handle]

.begin
	
	.reg	buffer_offset 
	.reg	level1_bit
	.reg	level2_bit
	.reg	level3_bit 
	.reg	lm_level2_base
	.reg	lm_level3_base
	.reg	level1_bitmask
	.reg	temp

	// Subtract the freelist buffer base to get an offset 

		//dmeng fix it later
	move(temp, FREELIST_BUFFER_BASE)

#ifdef	_DEBUG_COUNTERS_

	alu[@freelist_buffers_from_scr, @freelist_buffers_from_scr, +, 1]

#endif

	alu[buffer_offset, buffer_handle, -, temp]

	// Compute the level 1 bit, 10 bits + 3 bits for 8 LW meta data 

	alu[level1_bit, 0x1f, AND, buffer_offset, >>13]

	// Compute which word in local memory holds the level 2 word

	alu[lm_level2_base, FREELIST_MANAGER_LM_BASE_LEVEL2, OR, level1_bit, <<2]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_level2_base, LM_HANDLE_0]

	// Compute the level 2 bit, 5 bits + 3 bits for 8 LW meta data

	alu[level2_bit, 0x1f, AND, buffer_offset, >>8]

	// Compute the level 3 bit, remove 3 bits of 8 LW meta data 

	alu[level3_bit, 0x1f, AND, buffer_offset, >>3]

	// Compute the word in local memory holding the level 3 word 
	// 5 bits + 3 bits for 8 LW meta data = 8 bits. Then convert to byte offset
	// Mask off all but the low 10 bits (BUFFER_HANDLE_MASK is 0xcff)

	alu[lm_level3_base, BUFFER_HANDLE_MASK, AND, buffer_offset, >>8]
	alu[lm_level3_base, --, B, lm_level3_base, <<2] 
	alu[lm_level3_base, FREELIST_MANAGER_LM_BASE_LEVEL3, +, lm_level3_base]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_level3_base, LM_HANDLE_1]

	alu[--, level1_bit, OR, 0]
	alu[level1_bitmask, --, B, 1, <<indirect]

	// set the bit in the level 1 vector 

	alu[@global_level1_vector, @global_level1_vector, OR, level1_bitmask]

	// set the bit in the level 2 vector 

	alu[--, level2_bit, OR, 0]
	alu[*l$index0, *l$index0, OR, 1, <<indirect]

	// set the bit in the level 3 vector 

	alu[--, level3_bit, OR, 0]
	alu[*l$index1, *l$index1, OR, 1, <<indirect]

.end

#endm 


/////////////////////////////////////////////////////////////////////////////////////
// 
// freelist_manager_loop
//
// Description:
// 	
//		Main routine for the freelist manager 
// 
//
/////////////////////////////////////////////////////////////////////////////////////

#macro freelist_manager_loop[]

.begin
	
	.sig	sig_scratch_ring
	.reg	ring
	.reg	$buffer_handle
	.reg	buffer_handle
	.reg	BUFFER_HANDLE_MASK 

	// Constant stored in a register for optimization

	immed32[BUFFER_HANDLE_MASK, 0x3ff]

	// Read the drop buffer scratch ring. It should initially be empty 

	alu[ring, --, B, DROP_RING, <<2]	
	scratch[get, $buffer_handle, 0, ring, 1], ctx_swap[sig_scratch_ring]

loop#:
	
	// check if it is a valid buffer handle read from scratch ring 

	alu[buffer_handle, $buffer_handle, -, 0]
	beq[read_ring#]

	// free the buffer 

	_freelist_manager_free_buffer[buffer_handle]

read_ring#:

	// Read the drop buffer scratch ring

	alu[ring, --, B, DROP_RING, <<2]	
	scratch[get, $buffer_handle, 0, ring, 1], sig_done[sig_scratch_ring]

	// Check if the nn ring to packet rx is full 

	br_inp_state[NN_FULL, receive_ring_full#]

	// if not put a buffer on the ring 

	alu[*n$index++, global_prefetch_buffer_handle, OR, 0xc0, <<24]

	// check if the ring from transmit is empty, if it is not get a buffer

	br_inp_state[NN_EMPTY, transmit_ring_empty#]

	// if not get a buffer from the transmit ring 

	alu[global_prefetch_buffer_handle, *n$index++, AND~, 0xff, <<24]

	// wait for the scratch read to complete 

	ctx_arb[sig_scratch_ring] , br[loop#]

receive_ring_full#:

	// check if the ring from transmit is empty, if it is not get a buffer

	br_inp_state[NN_EMPTY, receive_full_transmit_empty#]

	// if not get a buffer from the transmit ring 

	alu[buffer_handle, *n$index++, AND~, 0xff, <<24]

	// free the buffer

	_freelist_manager_free_buffer[buffer_handle]

	// go to top of loop 

	ctx_arb[sig_scratch_ring], br[loop#]

receive_full_transmit_empty#:

	ctx_arb[sig_scratch_ring], br[loop#]

transmit_ring_empty#:

	// pre allocate a buffer for the next round  

	_freelist_manager_allocate_buffer[global_prefetch_buffer_handle, \
										buffer_list_empty#]

	// go to top of loop 

	ctx_arb[sig_scratch_ring], br[loop#]
	
buffer_list_empty#:

	#ifdef	_DEBUG_COUNTERS_
	alu[@freelist_buffers_empty, @freelist_buffers_empty, +, 1]
	#endif

 	// go to top of loop 

	ctx_arb[sig_scratch_ring]

	// check if it is a valid buffer handle read from scratch ring 

	alu[global_prefetch_buffer_handle, $buffer_handle, -, 0]
	bne[read_ring#]
 
	// Read the drop buffer scratch ring

	alu[ring, --, B, DROP_RING, <<2]	
	scratch[get, $buffer_handle, 0, ring, 1], sig_done[sig_scratch_ring]

	// check if the ring from transmit is empty, if it is not get a buffer

	br_inp_state[NN_EMPTY, buffer_list_empty#]

	// if not get a buffer from the transmit ring 

	alu[global_prefetch_buffer_handle, *n$index++, AND~, 0xff, <<24]

	// we have a prefetch handle now, so jump to top of loop 

	ctx_arb[sig_scratch_ring], br[loop#]

.end

#endm  

/////////////////////////////////////////////////////////////////////////////////////

// The main code starts here

main#:

	#ifdef	_DEBUG_COUNTERS_

	.reg @freelist_buffers_allocated
	.reg @freelist_buffers_freed
	.reg @freelist_buffers_empty
	.reg @freelist_buffers_from_scr
	#endif

	// Initialize the microblock

	freelist_manager_init[]

	// Start the microblock

	freelist_manager_loop[]

/////////////////////////////////////////////////////////////////////////////////////

#endif 		//  __FREELIST_MANAGER_UC__

/////////////////////////////////////////////////////////////////////////////////////
